<?php use Illuminate\Support\Str; ?>

<?php $__env->startSection('title', 'Latest Breaking News & Headlines | ' . config('app.name')); ?>
<?php $__env->startSection('description', 'Breaking news, business, politics, world and technology coverage updated daily.'); ?>

<?php $__env->startSection('content'); ?>
    <!-- 1st section -->
    <section class="news-section">
        <div class="news-container">

            <!-- COLUMN 1 : FEATURED ARTICLE -->
            <div class="col col-featured">
                <div class="featured-image-wrapper">

                    <a href="<?php echo e(route('news.show', [$featured->category->slug, $featured->encode_title])); ?>">
                        <img src="<?php echo e(url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $featured->photo)); ?>"
                            alt="<?php echo e($featured->news_title); ?>">
                    </a>

                    <span class="tag">
                        <?php echo e(strtoupper($featured->category->category_name)); ?>

                    </span>

                </div>
                <br>

                <h2>
                    <a href="<?php echo e(route('news.show', [$featured->category->slug, $featured->encode_title])); ?>">

                        <span class="highlight">Live Updates:</span>
                        <?php echo e($featured->news_title); ?>

                    </a>
                </h2>

                <p class="font">
                    <?php echo e(\Illuminate\Support\Str::limit($featured->news_content_short, 150)); ?>

                </p>
                <div class="article-meta">

                    <span class="article-author">
                        <?php if($featured->author): ?>
                            <a href="<?php echo e(route('author.show', $featured->author->slug)); ?>">
                                <?php echo e($featured->author->name); ?>

                            </a>
                        <?php else: ?>
                            Editorial Desk
                        <?php endif; ?>
                    </span>

                    <button class="bookmark-btn" data-id="<?php echo e($featured->news_id); ?>" aria-label="Save article">
                        <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                            <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                        </svg>
                    </button>

                </div>

            </div>


            <!-- COLUMN 2 : HEADLINES -->
            <div class="col col-headlines">
                <h3 class="section-title">Headlines</h3>

                <?php $__currentLoopData = $headlines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="headline">

                        <h4 class="headline-title">
                            <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>">
                                → <?php echo e($item->news_title); ?>

                            </a>
                        </h4>

                        <div class="article-meta">
                            <span class="article-author">
                                <?php if($item->author): ?>
                                    <a href="<?php echo e(route('author.show', $item->author->slug)); ?>">
                                        <?php echo e($item->author->name); ?>

                                    </a>
                                <?php else: ?>
                                    Editorial Desk
                                <?php endif; ?>
                            </span>

                            <button class="bookmark-btn" data-id="<?php echo e($item->news_id); ?>" aria-label="Save article">
                                <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                    <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                                </svg>
                            </button>
                        </div>

                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>

            <!-- COLUMN 3 : SIDEBAR -->
            <div class="col col-sidebar">
                <h3>About BuzzStream</h3>

                <p>
                    BuzzStream is an independent digital newsroom delivering breaking news, in-depth analysis, and opinion
                    coverage across politics, business, technology, and global affairs. Our editorial team focuses on
                    verified reporting, data-driven insights, and clear storytelling to help readers understand the events
                    shaping the world.
                    We publish daily updates, investigative features, and expert commentary designed to keep our audience
                    informed without noise or sensationalism.
                </p>

                <div class="social-grid">
                    <span>Facebook</span>
                    <span>X</span>
                    <span>Instagram</span>
                    <span>LinkedIn</span>
                    <span>Medium</span>
                    <span>Quora</span>
                </div>
            </div>

        </div>
    </section>
    <!-- <hr class="custom-line b"> -->
    <hr class="nav-divider">



    <!-- 2nd section -->
    <section class="most-read-section">

        <!-- Title -->
        <div class="section-title-container">
            <h2 class="section-title">Most Read This Week</h2>
        </div>

        <div class="most-read-container">

            <!-- Advertisement -->
            <div class="advertisement-box">
                <h2>BuzzStream</h2>
                <p>Live, Breaking News Theme</p>
                <img src="<?php echo e(asset('assets/images/foxiz.webp')); ?>" alt="Advertisement Image" class="ad-image">
                <a href="#" class="btn">Get It Now</a>
            </div>


            <!-- Right Column: Articles -->
            <div class="content-column">

                <?php if($spotlightMain): ?>
                    <!-- MAIN ARTICLE -->
                    <div class="main-article">

                        <div class="main-article-content">

                            <h3>
                                <a href="<?php echo e(route('news.show', [$spotlightMain->category->slug, $spotlightMain->encode_title])); ?>">
                                    <?php echo e($spotlightMain->news_title); ?>

                                </a>
                            </h3>

                            <p class="font">
                                <?php echo e(\Illuminate\Support\Str::limit(strip_tags($spotlightMain->news_content), 600)); ?>

                            </p>

                            <!-- META ROW -->
                            <div class="article-meta">
                                <span class="article-author">
                                    <?php if($spotlightMain->author): ?>
                                        <a href="<?php echo e(route('author.show', $spotlightMain->author->slug)); ?>">
                                            <?php echo e($spotlightMain->author->name); ?>

                                        </a>
                                    <?php else: ?>
                                        Editorial Desk
                                    <?php endif; ?>
                                </span>

                                <button class="bookmark-btn" data-id="<?php echo e($spotlightMain->news_id); ?>" aria-label="Save article">
                                    <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                        <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                                    </svg>
                                </button>
                            </div>

                        </div>

                        <a href="<?php echo e(route('news.show', [$spotlightMain->category->slug, $spotlightMain->encode_title])); ?>">
                            <img src="<?php echo e(url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $spotlightMain->photo)); ?>"
                                alt="<?php echo e($spotlightMain->news_title); ?>">
                        </a>

                    </div>
                <?php endif; ?>




                <!-- SIDE ARTICLES -->
                <div class="three-column">

                    <?php $__currentLoopData = $spotlightSide; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <article class="column">

                            <h4>
                                <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>">
                                    <?php echo e($item->news_title); ?>

                                </a>
                            </h4>

                            <p class="font">
                                <?php echo e(\Illuminate\Support\Str::limit($item->news_content_short, 90)); ?>

                            </p>

                            <!-- META -->
                            <div class="article-meta">

                                <span class="article-author">
                                    <?php if($item->author): ?>
                                        <a href="<?php echo e(route('author.show', $item->author->slug)); ?>">
                                            <?php echo e($item->author->name); ?>

                                        </a>
                                    <?php else: ?>
                                        Editorial Desk
                                    <?php endif; ?>
                                </span>

                                <button class="bookmark-btn" data-id="<?php echo e($item->news_id); ?>" aria-label="Save article">
                                    <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                        <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                                    </svg>
                                </button>

                            </div>

                        </article>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>

            </div>
        </div>
    </section>



    <!-- 3rd section -->
    <!-- JUST FOR YOU -->
    <section class="recommend-section">

        <div class="recommend-header">
            <h2>Just for You</h2>
        </div>

        <div class="four-column-container">
            <?php $__currentLoopData = $recommended; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <article class="recommend-card">
                    <div class="card-image">
                        <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>">
                            <img src="<?php echo e(url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $item->photo)); ?>"
                                alt="<?php echo e($item->news_title); ?>"></a>
                        <span class="card-tag"><?php echo e(strtoupper($item->category->category_name)); ?></span>
                    </div>
                    <h3>
                        <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>">
                            → <?php echo e($item->news_title); ?>

                        </a>
                    </h3>
                    <p class="card-desc font">
                        <?php echo e(Str::limit($item->news_content_short, 100)); ?>

                    </p>
                    <div class="card-meta">

                        <?php if($item->author): ?>
                            <span class="meta">
                                By
                                <a href="<?php echo e(route('author.show', $item->author->slug)); ?>">
                                    <strong><?php echo e($item->author->name); ?></strong>
                                </a>
                            </span>
                        <?php else: ?>
                            <span class="meta">
                                By Editorial Desk
                            </span>
                        <?php endif; ?>

                        <button class="bookmark-btn" aria-label="Save article">
                            <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                            </svg>
                        </button>
                    </div>
                </article>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </section>




    <!-- 4th section -->
    <!-- OPINION SECTION -->
    <section class="opinion-section">

        <div class="opinion-header">
            <h2>Opinion</h2>
            <a href="<?php echo e(route('category.show', 'opinion')); ?>" class="more-link">More Posts</a>
        </div>

        <div class="opinion-grid">

            <div class="opinion-column">

                <?php $__currentLoopData = $opinionsLeft; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <article class="opinion-card">
                        <div class="opinion-image">
                            <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>">
                                <img src="<?php echo e(url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $item->photo)); ?>"
                                    alt="<?php echo e($item->news_title); ?>"></a>
                            <span class="opinion-tag">
                                <?php echo e(strtoupper($item->category->category_name)); ?>

                            </span>
                        </div>

                        <div class="opinion-content">
                            <h3>
                                <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>">
                                    <?php echo e($item->news_title); ?>

                                </a>
                            </h3>

                            <p class="font">
                                <?php echo e(\Illuminate\Support\Str::limit($item->news_content_short, 120)); ?>

                            </p>

                            <div class="article-meta">

                                <span class="article-author">
                                    <?php if($item->author): ?>
                                        <a href="<?php echo e(route('author.show', $item->author->slug)); ?>">
                                            <?php echo e($item->author->name); ?>

                                        </a>
                                    <?php else: ?>
                                        Editorial Desk
                                    <?php endif; ?>
                                </span>

                                <button class="bookmark-btn" data-id="<?php echo e($item->news_id); ?>" aria-label="Save article">
                                    <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                        <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                                    </svg>
                                </button>

                            </div>
                        </div>

                    </article>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>


            <div class="opinion-column">

                <?php $__currentLoopData = $opinionsRight; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <article class="opinion-card">
                        <div class="opinion-image">
                            <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>">
                                <img src="<?php echo e(url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $item->photo)); ?>"
                                    alt="<?php echo e($item->news_title); ?>"></a>
                            <span class="opinion-tag">
                                <?php echo e(strtoupper($item->category->category_name)); ?>

                            </span>
                        </div>

                        <div class="opinion-content">
                            <h3>
                                <span class="live">Live Updates:</span>
                                <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>">
                                    <?php echo e($item->news_title); ?>

                                </a>
                            </h3>

                            <p class="font">
                                <?php echo e(\Illuminate\Support\Str::limit($item->news_content_short, 130)); ?>

                            </p>

                            <div class="article-meta">

                                <span class="article-author">
                                    <?php if($item->author): ?>
                                        <a href="<?php echo e(route('author.show', $item->author->slug)); ?>">
                                            <?php echo e($item->author->name); ?>

                                        </a>
                                    <?php else: ?>
                                        Editorial Desk
                                    <?php endif; ?>
                                </span>

                                <button class="bookmark-btn" data-id="<?php echo e($item->news_id); ?>" aria-label="Save article">
                                    <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                        <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                                    </svg>
                                </button>

                            </div>
                        </div>
                    </article>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>

        </div>

    </section>
    <hr class="custom-line">



    <!-- 5th section -->
    <!-- EDITORIAL HUB -->
    <section class="editorial-hub">

        <div class="editorial-grid">

            <!-- LEFT : TOP WRITERS -->
            <div class="editorial-column writers-column">
                <h3 class="column-title">Top Writers</h3>
                <?php $__empty_1 = true; $__currentLoopData = $topWriters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $writer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                    <div class="writer-card">

                        <a href="<?php echo e(route('author.show', $writer->slug)); ?>">
                            <img src="<?php echo e($writer->image ? asset('assets/images/authors/' . $writer->image) : asset('assets/images/no-image.webp')); ?>"
                                alt="<?php echo e($writer->name); ?>"></a>

                        <div>

                            <h4>
                                <a href="<?php echo e(route('author.show', $writer->slug)); ?>">
                                    <?php echo e($writer->name); ?>

                                </a>
                                <span>/<?php echo e($writer->news_count); ?> Articles</span>
                            </h4>

                            <p><?php echo e($writer->designation); ?></p>

                        </div>

                    </div>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <p style="padding:10px;">No writers yet.</p>
                <?php endif; ?>
            </div>


            <!-- MIDDLE : TECH -->
            <div class="editorial-column tech-column">
                <h3 class="column-title">Tech</h3>

                <?php
                    $featuredTech = $techNews->first();
                ?>

                <?php if($featuredTech): ?>
                    
                    <article class="featured-article">
                        <div class="featured-image-wrapper">
                            <a href="<?php echo e(route('news.show', [$featuredTech->category->slug, $featuredTech->encode_title])); ?>">
                                <img src="<?php echo e(url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $featuredTech->photo)); ?>"
                                    alt="<?php echo e($featuredTech->news_title); ?>">
                            </a>

                            <span class="card-tag">TECHNOLOGY</span>
                        </div>
                        <h4>
                            <a href="<?php echo e(route('news.show', [$featuredTech->category->slug, $featuredTech->encode_title])); ?>">
                                <?php echo e($featuredTech->news_title); ?>

                            </a>
                        </h4>

                        <div class="article-meta">

                            <span class="article-author">
                                <?php if($featuredTech->author): ?>
                                    <a href="<?php echo e(route('author.show', $featuredTech->author->slug)); ?>">
                                        <?php echo e($featuredTech->author->name); ?>

                                    </a>
                                <?php else: ?>
                                    Editorial Desk
                                <?php endif; ?>
                            </span>

                            <button class="bookmark-btn" data-id="<?php echo e($featuredTech->news_id); ?>" aria-label="Save article">
                                <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                    <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                                </svg>
                            </button>

                        </div>

                    </article>
                <?php endif; ?>




                
                <?php $__currentLoopData = $techNews->skip(1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <article class="text-article">

                        <h4>
                            <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>">
                                <?php echo e($item->news_title); ?>

                            </a>
                        </h4>

                        <div class="article-meta">

                            <span class="article-author">
                                <?php if($item->author): ?>
                                    <a href="<?php echo e(route('author.show', $item->author->slug)); ?>">
                                        <?php echo e($item->author->name); ?>

                                    </a>
                                <?php else: ?>
                                    Editorial Desk
                                <?php endif; ?>
                            </span>

                            <button class="bookmark-btn" data-id="<?php echo e($item->news_id); ?>" aria-label="Save article">
                                <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                    <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                                </svg>
                            </button>

                        </div>

                    </article>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>


            <!-- RIGHT : WORLD -->
            <div class="editorial-column world-column">
                <h3 class="column-title">World</h3>

                
                <?php $__currentLoopData = $worldNews->take(2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <article class="text-article">

                        <h4>
                            <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>">
                                <?php echo e($item->news_title); ?>

                            </a>
                        </h4>

                        <div class="article-meta">

                            <span class="article-author">
                                <?php if($item->author): ?>
                                    <a href="<?php echo e(route('author.show', $item->author->slug)); ?>">
                                        <?php echo e($item->author->name); ?>

                                    </a>
                                <?php else: ?>
                                    Editorial Desk
                                <?php endif; ?>
                            </span>

                            <button class="bookmark-btn" data-id="<?php echo e($item->news_id); ?>" aria-label="Save article">
                                <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                    <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                                </svg>
                            </button>

                        </div>

                    </article>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                
                <?php if($worldNews->count() > 2): ?>
                    <?php $featuredWorld = $worldNews[2]; ?>

                    <article class="featured-article small">
                        <div class="featured-image-wrapper">

                            <a href="<?php echo e(route('news.show', [$featuredWorld->category->slug, $featuredWorld->encode_title])); ?>">
                                <img src="<?php echo e(url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $featuredWorld->photo)); ?>"
                                    alt="<?php echo e($featuredWorld->news_title); ?>">
                            </a>

                            <span class="card-tag">WORLD</span>
                        </div>
                        <h4>
                            <a href="<?php echo e(route('news.show', [$featuredWorld->category->slug, $featuredWorld->encode_title])); ?>">
                                <?php echo e($featuredWorld->news_title); ?>

                            </a>
                        </h4>

                        <div class="article-meta">

                            <span class="article-author">
                                <?php if($featuredWorld->author): ?>
                                    <a href="<?php echo e(route('author.show', $featuredWorld->author->slug)); ?>">
                                        <?php echo e($featuredWorld->author->name); ?>

                                    </a>
                                <?php else: ?>
                                    Editorial Desk
                                <?php endif; ?>
                            </span>

                            <button class="bookmark-btn" data-id="<?php echo e($featuredWorld->news_id); ?>" aria-label="Save article">
                                <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                    <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                                </svg>
                            </button>

                        </div>

                    </article>
                <?php endif; ?>

            </div>


        </div>
    </section>



    <!-- 6th section -->
    <section class="subscription-box" id="subscribe-section">
        <div class="subscription-container">
            <!-- First Column: Image -->
            <div class="subscription-image">
                <img src="assets/images/logo.webp" alt="Subscription Image">
            </div>

            <!-- Second Column: Title and Paragraph -->
            <div class="subscription-title">
                <h2>Get the Daily Briefing in Your Inbox</h2>
                <p>Start your day with the most important stories in politics, business, technology, and world affairs.
                </p>
            </div>

            <!-- Third Column: Email Input, Subscribe Button, and Checkbox -->
            <div class="subscription-form">
                <input type="email" placeholder="Your email address" required>
                <button type="submit" class="sign-up-btn">Sign Up Now</button>
                <div class="terms-conditions">
                    <input type="checkbox" id="terms" name="terms">
                    <label for="terms">I have read and agree to the terms & conditions</label>
                </div>
            </div>
        </div>
    </section>



    <!-- 7th section -->
    <section class="recommend-section">

        <div class="recommend-header">
            <h2>Just for You</h2>
        </div>

        <div class="four-column-container">

            <?php $__currentLoopData = $secondRecommended; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <article class="recommend-card">

                    <div class="card-image">
                        <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>">
                            <img src="<?php echo e(url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $item->photo)); ?>"
                                alt="<?php echo e($item->news_title); ?>"></a>
                        <span class="card-tag">
                            <?php echo e(strtoupper($item->category->category_name)); ?>

                        </span>
                    </div>

                    <h3>
                        <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>">
                            <?php echo e($item->news_title); ?>

                        </a>
                    </h3>

                    <p class="card-desc">
                        <?php echo e(Str::limit($item->news_content_short, 110)); ?>

                    </p>

                    <div class="article-meta">

                        <span class="article-author">
                            <?php if($item->author): ?>
                                <a href="<?php echo e(route('author.show', $item->author->slug)); ?>">
                                    <?php echo e($item->author->name); ?>

                                </a>
                            <?php else: ?>
                                Editorial Desk
                            <?php endif; ?>
                        </span>

                        <button class="bookmark-btn" data-id="<?php echo e($item->news_id); ?>" aria-label="Save article">
                            <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                            </svg>
                        </button>

                    </div>

                </article>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>

    </section>



    <!-- 8th section -->
    <!-- FINANCE SECTION -->
    <section class="health-section">

        <div class="health-header">
            <h2>Finance</h2>
            <a href="<?php echo e(route('category.show', 'finance')); ?>" class="more-link">More Posts</a>
        </div>

        <div class="health-grid">

            <?php
                $featuredHealth = $healthNews->first();
            ?>

            
            <?php if($featuredHealth): ?>
                <article class="health-featured">
                    <div class="health-featured-image">

                        <span class="card-tag">
                            <?php echo e(strtoupper($featuredHealth->category->category_name)); ?>

                        </span>

                        <a href="<?php echo e(route('news.show', [$featuredHealth->category->slug, $featuredHealth->encode_title])); ?>">
                            <img src="<?php echo e(url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $featuredHealth->photo)); ?>"
                                alt="<?php echo e($featuredHealth->news_title); ?>">
                        </a>

                        <div class="health-overlay">

                            <h3>
                                <a href="<?php echo e(route('news.show', [$featuredHealth->category->slug, $featuredHealth->encode_title])); ?>">
                                    <?php echo e($featuredHealth->news_title); ?>

                                </a>
                            </h3>

                            <p class="font">
                                <?php echo e(Str::limit($featuredHealth->news_content_short, 150)); ?>

                            </p>

                            <div class="article-meta">

                                <span class="article-author">
                                    <?php if($featuredHealth->author): ?>
                                        <a href="<?php echo e(route('author.show', $featuredHealth->author->slug)); ?>">
                                            <?php echo e($featuredHealth->author->name); ?>

                                        </a>
                                    <?php else: ?>
                                        Editorial Desk
                                    <?php endif; ?>
                                </span>

                                <button class="bookmark-btn" data-id="<?php echo e($featuredHealth->news_id); ?>" aria-label="Save article">
                                    <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                        <path d="M6 3h12v18l-6-4-6 4z" stroke="#ffffff" />
                                    </svg>
                                </button>

                            </div>

                        </div>
                    </div>
                </article>
            <?php endif; ?>


            
            <div class="health-list">

                <?php $__currentLoopData = $healthNews->skip(1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <article class="health-item">

                        <h4>
                            <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>">
                                <?php echo e($item->news_title); ?>

                            </a>
                        </h4>

                        <p><?php echo e(Str::limit($item->news_content_short, 90)); ?></p>

                        <div class="article-meta">

                            <span class="article-author">
                                <?php if($item->author): ?>
                                    <a href="<?php echo e(route('author.show', $item->author->slug)); ?>">
                                        <?php echo e($item->author->name); ?>

                                    </a>
                                <?php else: ?>
                                    Editorial Desk
                                <?php endif; ?>
                            </span>

                            <button class="bookmark-btn" data-id="<?php echo e($item->news_id); ?>" aria-label="Save article">
                                <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                    <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                                </svg>
                            </button>

                        </div>

                    </article>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>

        </div>
    </section>

    <!-- 9th section -->
    <section class="travel-section">

        <div class="travel-header">
            <h2>Politics</h2>
            <a href="<?php echo e(route('category.show', 'politics')); ?>" class="more-link">More Posts</a>
        </div>

        <div class="travel-grid">

            <?php $__currentLoopData = $travelNews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <article class="travel-card">

                    <div class="travel-image">
                        <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>">
                            <img src="<?php echo e(url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $item->photo)); ?>"
                                alt="<?php echo e($item->news_title); ?>">
                        </a>
                    </div>

                    <h3>
                        <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>">
                            <?php echo e($item->news_title); ?>

                        </a>
                    </h3>

                    <p class="font">
                        <?php echo e(Str::limit($item->news_content_short, 110)); ?>

                    </p>

                    <!-- AUTHOR + BOOKMARK ROW -->
                    <div class="article-meta">

                        <span class="article-author">
                            <?php if($item->author): ?>
                                <a href="<?php echo e(route('author.show', $item->author->slug)); ?>">
                                    <?php echo e($item->author->name); ?>

                                </a>
                            <?php else: ?>
                                Editorial Desk
                            <?php endif; ?>
                        </span>

                        <button class="bookmark-btn" data-id="<?php echo e($item->news_id); ?>" aria-label="Save article">
                            <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                            </svg>
                        </button>

                    </div>

                </article>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>
    </section>



    <!-- 10th section -->
    <div class="black-box1">
        <div class="box1-content">

            <!-- IMAGE -->
            <div class="box1-image">
                <a href="<?php echo e(route('news.show', [$heroNews->category->slug, $heroNews->encode_title])); ?>">
                    <img src="<?php echo e(url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $heroNews->photo)); ?>"
                        alt="<?php echo e($heroNews->news_title); ?>">
                </a>

                <span class="hero-category">
                    <?php echo e(strtoupper($heroNews->category->category_name)); ?>

                </span>
            </div>

            <!-- TEXT -->
            <div class="box1-text">

                <h2 class="hero-title">
                    <a href="<?php echo e(route('news.show', [$heroNews->category->slug, $heroNews->encode_title])); ?>">
                        <span class="live-label">Live Updates:</span>
                        <?php echo e($heroNews->news_title); ?>

                    </a>
                </h2>

                <p class="hero-desc font">
                    <?php echo e(\Illuminate\Support\Str::limit(strip_tags($heroNews->news_content_short), 170)); ?>

                </p>

                <div class="hero-meta">

                    <div class="hero-meta-left">
                        <span class="author">
                            By
                            <?php if($heroNews->author): ?>
                                <a href="<?php echo e(route('author.show', $heroNews->author->slug)); ?>">
                                    <?php echo e($heroNews->author->name); ?>

                                </a>
                            <?php else: ?>
                                Editorial Desk
                            <?php endif; ?>
                        </span>

                        <span class="read-time">
                            • <?php echo e(ceil(str_word_count(strip_tags($heroNews->news_content)) / 200)); ?> Min Read
                        </span>
                    </div>

                    <!-- bookmark -->
                    <button class="bookmark-btn hero-bookmark" aria-label="Save article">
                        <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                            <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                        </svg>
                    </button>

                </div>

            </div>

        </div>
    </div>

    <!-- Section 2 - Circle Images with Titles -->
    <div class="circle-section">
        <div class="circle-container">
            <?php $__currentLoopData = $homeCircleCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="circle-item">

                    <a href="<?php echo e(route('category.show', $category->slug)); ?>">

                        <img src="<?php echo e($category->category_banner ? asset('assets/images/categories/' . $category->category_banner) : asset('assets/images/no-image.webp')); ?>"
                            alt="<?php echo e($category->category_name); ?>" class="circle-image">

                    </a>

                    <h3><?php echo e($category->category_name); ?></h3>

                    <p class="circle-count">
                        <?php echo e($category->news_count); ?> Articles
                    </p>

                </div>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>
    </div>
    <hr class="custom-line">



    <!--11th sectioin  -->
    <div class="scroll-container">
        <!-- Left Column -->
        <div class="left-column">

            <?php $__currentLoopData = $latestFeed; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="custom-article">
                    <div class="article-content">

                        <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>" class="article-thumb">
                            <img src="<?php echo e(url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $item->photo)); ?>"
                                alt="<?php echo e($item->news_title); ?>">
                        </a>
                        <div class="article-text">
                            <h2>
                                <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>">
                                    <?php echo e($item->news_title); ?>

                                </a>
                            </h2>

                            <p class="font">
                                <?php echo e(\Illuminate\Support\Str::limit($item->news_content_short, 120)); ?>

                            </p>

                            <div class="article-meta">

                                <span class="article-author">
                                    <?php if($item->author): ?>
                                        <a href="<?php echo e(route('author.show', $item->author->slug)); ?>">
                                            <?php echo e($item->author->name); ?>

                                        </a>
                                    <?php else: ?>
                                        Editorial Desk
                                    <?php endif; ?>
                                </span>

                                <button class="bookmark-btn" data-id="<?php echo e($item->news_id); ?>" aria-label="Save article">
                                    <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                        <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                                    </svg>
                                </button>

                            </div>



                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


        </div>


        <!-- Right Column -->
        <div class="right-column">
            <!-- Advertisement Box -->
            <div class="advertisement-box">
                <h2>BuzzStream</h2>
                <p>Live, Breaking News Theme</p>
                <img src="assets/images/foxiz.webp" alt="Advertisement Image" class="ad-image">
                <a href="#" class="btn">Get It Now</a>
            </div>

            <!-- First Article in the Right Column -->
            <?php $__currentLoopData = $sidebarFeed; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="custom-right-article">

                    <div class="right-article-text">
                        <h2>
                            <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>">
                                <?php echo e($item->news_title); ?>

                            </a>
                        </h2>

                        <p class="font">
                            <?php echo e(\Illuminate\Support\Str::limit($item->news_content_short, 70)); ?>

                        </p>
                    </div>
                    <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>">

                        <img src="<?php echo e(url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $item->photo)); ?>"
                            alt="<?php echo e($item->news_title); ?>" class="right-img">
                    </a>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>
    </div>

    </main>
    <hr class="custom-line">

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\progr\Downloads\current\foxiz\foxiz\resources\views/index.blade.php ENDPATH**/ ?>