<?php $__env->startSection('title','Personalized News Feed | '.config('app.name')); ?>
<?php $__env->startSection('description','Latest curated stories and recommended news articles.'); ?>
<?php $__env->startSection('content'); ?>
    <?php
        use Illuminate\Support\Str;
    ?>

    <!-- ================= JUST FOR YOU HEADER ================= -->
    <section class="recommend-section myfeed-section">

        <div class="recommend-header">
            <div>
                <h2>Just for You</h2>
                <p style="color:#666;font-size:14px">
                    The Latest News on Your Interests
                </p>
            </div>
        </div>


        <!-- ================= TOP 2 FEATURED ARTICLES ================= -->
        <div class="health-grid">

            
            <?php if($featuredLeft): ?>
                <article class="health-featured">
                    <div class="health-featured-image">

                        <span class="card-tag">
                            <?php echo e(strtoupper(optional($featuredLeft->category)->category_name)); ?>

                        </span>

                        <a href="<?php echo e(route('news.show', [$featuredLeft->category->slug, $featuredLeft->encode_title])); ?>">
                            <img src="<?php echo e(url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $featuredLeft->photo)); ?>"
                                alt="<?php echo e($featuredLeft->news_title); ?>">
                        </a>

                        <div class="health-overlay">

                            <h3>
                               <a href="<?php echo e(route('news.show', [$featuredLeft->category->slug, $featuredLeft->encode_title])); ?>">
                                    <?php echo e($featuredLeft->news_title); ?>

                                </a>
                            </h3>

                            <p class="font">
                                <?php echo e(Str::limit($featuredLeft->news_content_short, 150)); ?>

                            </p>

                            <div class="article-meta">

                                <span class="article-author">
                                    <?php if($featuredLeft->author): ?>
                                        <a href="<?php echo e(route('author.show', $featuredLeft->author->slug)); ?>">
                                            <?php echo e($featuredLeft->author->name); ?>

                                        </a>
                                    <?php else: ?>
                                        Editorial Desk
                                    <?php endif; ?>
                                </span>

                                <button class="bookmark-btn" data-id="<?php echo e($featuredLeft->news_id); ?>">
                                    <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                        <path d="M6 3h12v18l-6-4-6 4z" stroke="#ffffff" />
                                    </svg>
                                </button>

                            </div>

                        </div>
                    </div>
                </article>
            <?php endif; ?>



            
            <?php if($featuredRight): ?>
                <article class="health-featured">
                    <div class="health-featured-image">

                        <span class="card-tag">
                            <?php echo e(strtoupper(optional($featuredRight->category)->category_name)); ?>

                        </span>

                       <a href="<?php echo e(route('news.show', [$featuredRight->category->slug, $featuredRight->encode_title])); ?>">
                            <img src="<?php echo e(url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $featuredRight->photo)); ?>"
                                alt="<?php echo e($featuredRight->news_title); ?>">
                        </a>

                        <div class="health-overlay">

                            <h3>
                                <a href="<?php echo e(route('news.show', [$featuredRight->category->slug, $featuredRight->encode_title])); ?>">
                                    <?php echo e($featuredRight->news_title); ?>

                                </a>
                            </h3>

                            <p class="font">
                                <?php echo e(Str::limit($featuredRight->news_content_short, 150)); ?>

                            </p>

                            <div class="article-meta">

                                <span class="article-author">
                                    <?php if($featuredRight->author): ?>
                                        <a href="<?php echo e(route('author.show', $featuredRight->author->slug)); ?>">
                                            <?php echo e($featuredRight->author->name); ?>

                                        </a>
                                    <?php else: ?>
                                        Editorial Desk
                                    <?php endif; ?>
                                </span>

                                <button class="bookmark-btn" data-id="<?php echo e($featuredRight->news_id); ?>">
                                    <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                        <path d="M6 3h12v18l-6-4-6 4z" stroke="#ffffff" />
                                    </svg>
                                </button>

                            </div>

                        </div>
                    </div>
                </article>
            <?php endif; ?>

        </div>
<br>


        <!-- ================= FIRST 4 ARTICLE CARDS ================= -->
        <div class="four-column-container my-feed-section">

            <?php $__currentLoopData = $rowOne; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <article class="recommend-card my-feed-section">

                    <div class="card-image">
                        <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>">
                            <img src="<?php echo e(url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $item->photo)); ?>"
                                alt="<?php echo e($item->news_title); ?>">
                        </a>

                        <span class="card-tag">
                            <?php echo e(strtoupper(optional($item->category)->category_name)); ?>

                        </span>
                    </div>

                    <h3>
                        <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>">
                            <?php echo e($item->news_title); ?>

                        </a>
                    </h3>

                    <p class="card-desc">
                        <?php echo e(Str::limit($item->news_content_short, 110)); ?>

                    </p>

                    <div class="article-meta">

                        <span class="article-author">
                            <?php if($item->author): ?>
                                <a href="<?php echo e(route('author.show', $item->author->slug)); ?>">
                                    <?php echo e($item->author->name); ?>

                                </a>
                            <?php else: ?>
                                Editorial Desk
                            <?php endif; ?>
                        </span>

                        <button class="bookmark-btn" data-id="<?php echo e($item->news_id); ?>">
                            <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                            </svg>
                        </button>

                    </div>

                </article>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>


        <!-- ================= NEWSLETTER SUBSCRIBE ================= -->
        <section class="subscription-box" id="subscribe-section">

            <div class="subscription-container">

                <div class="subscription-image">
                    <img src="<?php echo e(asset('assets/images/logo.webp')); ?>" alt="logo">
                </div>

                <div class="subscription-title">
                    <h2>Unlock the Pulse of the Present</h2>
                    <p>Subscribe Now for Real-Time Updates on the Latest Stories!</p>
                </div>

                <form class="subscription-form" method="POST" action="#">
                    <?php echo csrf_field(); ?>

                    <input type="email" name="email" placeholder="Your email address" required>

                    <button class="sign-up-btn">Sign Up Now</button>

                    <div class="terms-conditions">
                        <input type="checkbox" required>
                        <label>I have read and agree to the terms & conditions</label>
                    </div>
                </form>

            </div>

        </section>



        <!-- ================= SECOND 4 ARTICLE CARDS ================= -->
        <div class="four-column-container">

            <?php $__currentLoopData = $rowTwo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <article class="recommend-card">

                    <div class="card-image">
                        <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>">
                            <img src="<?php echo e(url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $item->photo)); ?>"
                                alt="<?php echo e($item->news_title); ?>">
                        </a>

                        <span class="card-tag">
                            <?php echo e(strtoupper(optional($item->category)->category_name)); ?>

                        </span>
                    </div>

                    <h3>
                        <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>">
                            <?php echo e($item->news_title); ?>

                        </a>
                    </h3>

                    <p class="card-desc">
                        <?php echo e(Str::limit($item->news_content_short, 110)); ?>

                    </p>

                    <div class="article-meta">

                        <span class="article-author">
                            <?php if($item->author): ?>
                                <a href="<?php echo e(route('author.show', $item->author->slug)); ?>">
                                    <?php echo e($item->author->name); ?>

                                </a>
                            <?php else: ?>
                                Editorial Desk
                            <?php endif; ?>
                        </span>

                        <button class="bookmark-btn" data-id="<?php echo e($item->news_id); ?>">
                            <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                            </svg>
                        </button>

                    </div>

                </article>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>

    </section>
    <hr class="custom-line">
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\progr\Downloads\current\foxiz\foxiz\resources\views/myfeed.blade.php ENDPATH**/ ?>