<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">

<?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

    <?php
        $slug = (string) $post->encode_title;

        $isValid =
            !empty($slug) &&
            strlen($slug) <= 120 &&
            strpos($slug, ' ') === false &&
            preg_match('/^[a-z0-9\-]+$/', $slug);
    ?>

    <?php if($isValid && isset($post->category->slug)): ?>
    <url>
        <loc><?php echo e(htmlspecialchars(url($post->category->slug.'/'.$post->encode_title), ENT_XML1)); ?></loc>
        <lastmod><?php echo e(\Carbon\Carbon::parse($post->news_date)->toAtomString()); ?></lastmod>
        <changefreq>daily</changefreq>
        <priority>0.9</priority>
    </url>
    <?php endif; ?>

<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

    <?php if(!empty($category->slug)): ?>
    <url>
        <loc><?php echo e(url('category/'.$category->slug)); ?></loc>
        <lastmod><?php echo e(\Carbon\Carbon::now('UTC')->format('Y-m-d\TH:i:s\Z')); ?></lastmod>
        <changefreq>daily</changefreq>
        <priority>0.8</priority>
    </url>
    <?php endif; ?>

<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

</urlset>
<?php /**PATH /home/myapiusa/public_html/ramshad/foxiz/resources/views/sitemap.blade.php ENDPATH**/ ?>