<?php use Illuminate\Support\Str; ?>
<?php $__env->startSection('title', $author->name . ' | News Author'); ?>
<?php $__env->startSection('schema'); ?>
<?php
$authorSchema = [
    "@context" => "https://schema.org",
    "@type" => "Person",
    "name" => $author->name,
    "url" => route('author.show', $author->slug),
    "jobTitle" => $author->designation ?? 'Journalist',
    "description" => $author->bio ?? '',
    "image" => $author->image
        ? asset('assets/images/authors/' . $author->image)
        : asset('assets/images/no-image.webp')
];
?>

<script type="application/ld+json">
<?php echo json_encode($authorSchema, JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT); ?>

</script>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>

    <section class="author-section">
        <div class="author-container">
            <meta itemprop="url" content="<?php echo e(route('author.show',$author->slug)); ?>">

            <div class="author-info">

                <img src="<?php echo e($author->image ? asset('assets/images/authors/' . $author->image) : asset('assets/images/no-image.webp')); ?>"
                    alt="<?php echo e($author->name); ?>" class="author-image">

                <div class="author-details">

                    <div class="author-header">
                        <h1 class="author-name" itemprop="name"><?php echo e($author->name); ?></h1>
                        <button class="follow-btn">+ Follow</button>
                    </div>

                    <p class="author-bio">
                        <?php echo e($author->bio); ?>

                    </p>

                    <p class="author-title">
                        <?php echo e($author->designation); ?>

                    </p>

                </div>
            </div>
        </div>
    </section>

    <section class="travel-section">

        <div class="travel-grid">

            <?php $__empty_1 = true; $__currentLoopData = $articles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                <article class="travel-card">

                    <div class="travel-image">
                        <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>" title="<?php echo e($item->news_title); ?>">
                            <img src="<?php echo e(url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $item->photo)); ?>"
                                alt="<?php echo e($item->news_title); ?>">
                        </a>
                    </div>

                    <h3>

                        
                        <?php if($index % 5 == 0): ?>
                            <span class="live">Live Updates:</span>
                        <?php endif; ?>

                        <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>" title="<?php echo e($item->news_title); ?>">
                            <?php echo e($item->news_title); ?>

                        </a>
                    </h3>

                    <p>
                        <?php echo e(Str::limit(strip_tags($item->news_content_short), 120)); ?>

                    </p>

                    <div class="travel-meta">

                        <span class="meta">
                            By
                            <?php if($item->author): ?>
                                <a href="<?php echo e(route('author.show', $item->author->slug)); ?>" title="<?php echo e($item->author->name); ?>">
                                    <strong><?php echo e($item->author->name); ?></strong>
                                </a>
                            <?php else: ?>
                                Editorial Desk
                            <?php endif; ?>
                        </span>

                        <button class="bookmark-btn" data-id="<?php echo e($item->news_id); ?>" aria-label="Save article">
                            <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                            </svg>
                        </button>

                    </div>

                </article>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <p style="padding:20px;">No articles found for this author.</p>
            <?php endif; ?>

        </div>

        <div class="pagination-wrapper">
            <?php echo e($articles->links()); ?>

        </div>

    </section>

    <hr class="custom-line">

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/myapiusa/public_html/ramshad/foxiz/resources/views/author.blade.php ENDPATH**/ ?>