<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

<title><?php echo $__env->yieldContent('title', config('app.name')); ?></title>

<meta name="description"
    content="<?php echo $__env->yieldContent('description', 'Latest news, breaking stories, business, technology and world updates.'); ?>">

<meta name="keywords"
    content="<?php echo $__env->yieldContent('keywords', 'news, world news, business news, technology news'); ?>">

<meta name="robots" content="index, follow, max-image-preview:large">

<link rel="canonical" href="<?php echo $__env->yieldContent('canonical', url()->current()); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">
<meta property="og:updated_time" content="<?php echo $__env->yieldContent('og_updated_time'); ?>">
<meta property="og:type" content="article">
<meta property="og:site_name" content="<?php echo e(config('app.name')); ?>">
<meta property="og:locale" content="en_US">
<meta property="og:url" content="<?php echo $__env->yieldContent('canonical', url()->current()); ?>">
<meta property="og:title" content="<?php echo $__env->yieldContent('title', config('app.name')); ?>">
<meta property="og:description" content="<?php echo $__env->yieldContent('description'); ?>">
<meta property="og:image" content="<?php echo $__env->yieldContent('image', asset('assets/images/default.jpg')); ?>">
<meta property="og:image:width" content="1200">
<meta property="og:image:height" content="630">
<meta property="article:published_time" content="<?php echo $__env->yieldContent('published_time'); ?>">
<meta property="article:modified_time" content="<?php echo $__env->yieldContent('modified_time'); ?>">
<meta property="article:section" content="<?php echo $__env->yieldContent('section'); ?>">
<meta property="article:tag" content="<?php echo $__env->yieldContent('keywords'); ?>">

<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="<?php echo $__env->yieldContent('title'); ?>">
<meta name="twitter:description" content="<?php echo $__env->yieldContent('description'); ?>">
<meta name="twitter:image" content="<?php echo $__env->yieldContent('image', asset('assets/images/default.jpg')); ?>">
<link rel="icon" href="<?php echo e(asset('assets/images/favicon.ico')); ?>" type="image/x-icon">
<?php echo $__env->yieldContent('schema'); ?>


</head>

<body>

<?php echo $__env->make('partials.top-bar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('partials.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<main>
    <?php echo $__env->yieldContent('content'); ?>
</main>
<?php echo $__env->make('partials.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<script src="<?php echo e(asset('assets/js/script.js')); ?>"></script>

</body>
</html>
<?php /**PATH C:\Users\progr\Downloads\current\foxiz\foxiz\resources\views/layouts/app.blade.php ENDPATH**/ ?>