<?php use Illuminate\Support\Str; ?>

<?php $__env->startSection('robots','noindex,follow'); ?>
<?php $__env->startSection('canonical', url('/')); ?>
<?php $__env->startSection('content'); ?>

    <main class="search-page">

        <section class="search-header">

            <h1 class="search-title">
                Search Results for:
                <span>"<?php echo e($query); ?>"</span>
            </h1>

            <p class="search-count">
                Showing <?php echo e($results->total()); ?> results for your search
            </p>

            
            <form action="<?php echo e(route('search')); ?>" method="GET" class="search-again-form">
                <div class="search-again-box">

                    <img src="<?php echo e(asset('assets/images/search.webp')); ?>" id="searchToggle" class="search-icon" alt="Search">

                    <input type="text" name="q" value="<?php echo e($query); ?>" placeholder="Search Headlines, News..." required>

                    <button type="submit">Search</button>

                </div>
            </form>

        </section>



        <section class="recommend-section search-result-section">

            <div class="recommend-header">
                <h2>Articles</h2>
            </div>

            <div class="four-column-container">

                <?php $__empty_1 = true; $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                    <article class="recommend-card">

                        <div class="card-image">
                            <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>" title="<?php echo e($item->news_title); ?>">
                                <img src="<?php echo e(url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $item->photo)); ?>"
                                    alt="<?php echo e($item->news_title); ?>">
                            </a>

                            <span class="card-tag">
                                <?php echo e(strtoupper($item->category->category_name)); ?>

                            </span>
                        </div>

                        <h3>
                            <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>" title="<?php echo e($item->news_title); ?>">
                                → <?php echo e($item->news_title); ?>

                            </a>
                        </h3>

                        <p class="card-desc font">
                            <?php echo e(Str::limit(strip_tags($item->news_content_short), 110)); ?>

                        </p>

                        <div class="card-meta">

                            <?php if($item->author): ?>
                                <span class="meta">
                                    By
                                    <a href="<?php echo e(route('author.show', $item->author->slug)); ?>" title="<?php echo e($item->author->name); ?>">
                                        <strong><?php echo e($item->author->name); ?></strong>
                                    </a>
                                </span>
                            <?php else: ?>
                                <span class="meta">By Editorial Desk</span>
                            <?php endif; ?>

                            <button class="bookmark-btn" aria-label="Save article">
                                <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                    <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                                </svg>
                            </button>
                        </div>

                    </article>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                    <div class="no-results">
                        <h3>No articles found</h3>
                        <p>
                            Sorry, nothing matched your search terms.<br>
                            Try different or shorter keywords.
                        </p>
                    </div>

                <?php endif; ?>

            </div>

        </section>



        <div class="pagination-wrapper">
            <?php echo e($results->links()); ?>

        </div>

    </main>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/myapiusa/public_html/ramshad/foxiz/resources/views/search.blade.php ENDPATH**/ ?>