<?php use Illuminate\Support\Str; ?>
<?php $__env->startSection('title', $category->category_name . ' News'); ?>
<?php $__env->startSection('description', 'Latest ' . $category->name . ' news, updates, analysis and breaking stories.'); ?>
<?php $__env->startSection('schema'); ?>
<?php
$categorySchema = [
    "@context" => "https://schema.org",
    "@type" => "CollectionPage",
    "name" => $category->category_name . ' News',
    "url" => route('category.show', $category->slug),
    "description" => 'Latest ' . $category->category_name . ' news, updates and breaking stories.'
];
?>

<script type="application/ld+json">
<?php echo json_encode($categorySchema, JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT); ?>

</script>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>

    <section class="category-heading">
        <h1 itemprop="name">
            <a href="<?php echo e(route('category.show', $category->slug)); ?>" title="<?php echo e($category->category_name); ?> News">
                <?php echo e($category->category_name); ?>

            </a>
        </h1>
    </section>

    <section class="travel-section">

        <div class="travel-grid">

            <?php $__empty_1 = true; $__currentLoopData = $articles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                <article class="travel-card">

                    <!-- IMAGE -->
                    <div class="travel-image">
                        <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>" title="<?php echo e($item->news_title); ?>">
                            <img src="<?php echo e(url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $item->photo)); ?>"
                                alt="<?php echo e($item->news_title); ?>">
                        </a>
                    </div>

                    <!-- TITLE -->
                    <h3>
                        <?php
                            $position = $articles->firstItem() + $loop->index;
                        ?>

                        <?php if(($position - 1) % 5 == 0): ?>
                            <span class="live">Live Updates:</span>
                        <?php endif; ?>

                        <a href="<?php echo e(route('news.show', [$item->category->slug, $item->encode_title])); ?>" title="<?php echo e($item->news_title); ?>">
                            <?php echo e($item->news_title); ?>

                        </a>
                    </h3>

                    <!-- EXCERPT -->
                    <p>
                        <?php echo e(Str::limit(strip_tags($item->news_content_short), 120)); ?>

                    </p>

                    <!-- AUTHOR + BOOKMARK ROW -->
                    <div class="travel-meta">

                        <span class="meta">
                            By
                            <?php if($item->author): ?>
                                <a href="<?php echo e(route('author.show', $item->author->slug)); ?>" title="<?php echo e($item->author->name); ?>">
                                    <strong><?php echo e($item->author->name); ?></strong>
                                </a>
                            <?php else: ?>
                                Editorial Desk
                            <?php endif; ?>
                        </span>

                        <!-- IMPORTANT: data-id added -->
                        <button class="bookmark-btn" data-id="<?php echo e($item->news_id); ?>" aria-label="Save article">
                            <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                            </svg>
                        </button>

                    </div>

                </article>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <p style="padding:20px;">No articles found in this category.</p>
            <?php endif; ?>

        </div>

        <!-- Pagination -->
        <div class="pagination-wrapper">
            <?php echo e($articles->links()); ?>

        </div>

    </section>

    <hr class="custom-line">

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/myapiusa/public_html/ramshad/foxiz/resources/views/category.blade.php ENDPATH**/ ?>