<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\AuthorController;
use App\Http\Controllers\SitemapController;

Route::get('', function () {
    return redirect('/');
});
Route::get('/', [HomeController::class, 'index'])->name('index');

Route::get('/search', [HomeController::class, 'search'])->name('search');
Route::get('/my-feed', [HomeController::class, 'myfeed'])->name('myfeed');

Route::view('/about', 'about')->name('about');
Route::view('/privacy-policy', 'privacyPolicy')->name('privacyPolicy');

Route::get('/category/{slug}', [CategoryController::class, 'show'])->name('category.show');
Route::get('/author/{slug}', [AuthorController::class, 'show'])->name('author.show');
Route::get('/sitemap.xml', [SitemapController::class, 'index']);

Route::get('/{category}/{slug}', [HomeController::class, 'show'])->name('news.show');
