<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">

@foreach($posts as $post)

    @php
        $slug = (string) $post->encode_title;

        $isValid =
            !empty($slug) &&
            strlen($slug) <= 120 &&
            strpos($slug, ' ') === false &&
            preg_match('/^[a-z0-9\-]+$/', $slug);
    @endphp

    @if($isValid && isset($post->category->slug))
    <url>
        <loc>{{ htmlspecialchars(url($post->category->slug.'/'.$post->encode_title), ENT_XML1) }}</loc>
        <lastmod>{{ \Carbon\Carbon::parse($post->news_date)->toAtomString() }}</lastmod>
        <changefreq>daily</changefreq>
        <priority>0.9</priority>
    </url>
    @endif

@endforeach

@foreach($categories as $category)

    @if(!empty($category->slug))
    <url>
        <loc>{{ url('category/'.$category->slug) }}</loc>
        <lastmod>{{ \Carbon\Carbon::now('UTC')->format('Y-m-d\TH:i:s\Z') }}</lastmod>
        <changefreq>daily</changefreq>
        <priority>0.8</priority>
    </url>
    @endif

@endforeach

</urlset>
