@php use Illuminate\Support\Str; @endphp
@extends('layouts.app')
@section('robots','noindex,follow')
@section('canonical', url('/'))
@section('content')

    <main class="search-page">

        <section class="search-header">

            <h1 class="search-title">
                Search Results for:
                <span>"{{ $query }}"</span>
            </h1>

            <p class="search-count">
                Showing {{ $results->total() }} results for your search
            </p>

            {{-- search again --}}
            <form action="{{ route('search') }}" method="GET" class="search-again-form">
                <div class="search-again-box">

                    <img src="{{ asset('assets/images/search.webp') }}" id="searchToggle" class="search-icon" alt="Search">

                    <input type="text" name="q" value="{{ $query }}" placeholder="Search Headlines, News..." required>

                    <button type="submit">Search</button>

                </div>
            </form>

        </section>



        <section class="recommend-section search-result-section">

            <div class="recommend-header">
                <h2>Articles</h2>
            </div>

            <div class="four-column-container">

                @forelse($results as $item)

                    <article class="recommend-card">

                        <div class="card-image">
                            <a href="{{ route('news.show', [$item->category->slug, $item->encode_title]) }}" title="{{ $item->news_title }}">
                                <img src="{{ url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $item->photo) }}"
                                    alt="{{ $item->news_title }}">
                            </a>

                            <span class="card-tag">
                                {{ strtoupper($item->category->category_name) }}
                            </span>
                        </div>

                        <h3>
                            <a href="{{ route('news.show', [$item->category->slug, $item->encode_title]) }}" title="{{ $item->news_title }}">
                                → {{ $item->news_title }}
                            </a>
                        </h3>

                        <p class="card-desc font">
                            {{ Str::limit(strip_tags($item->news_content_short), 110) }}
                        </p>

                        <div class="card-meta">

                            @if($item->author)
                                <span class="meta">
                                    By
                                    <a href="{{ route('author.show', $item->author->slug) }}" title="{{ $item->author->name }}">
                                        <strong>{{ $item->author->name }}</strong>
                                    </a>
                                </span>
                            @else
                                <span class="meta">By Editorial Desk</span>
                            @endif

                            <button class="bookmark-btn" aria-label="Save article">
                                <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                    <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                                </svg>
                            </button>
                        </div>

                    </article>

                @empty

                    <div class="no-results">
                        <h3>No articles found</h3>
                        <p>
                            Sorry, nothing matched your search terms.<br>
                            Try different or shorter keywords.
                        </p>
                    </div>

                @endforelse

            </div>

        </section>



        <div class="pagination-wrapper">
            {{ $results->links() }}
        </div>

    </main>

@endsection
