@php use Illuminate\Support\Str; @endphp
@extends('layouts.app')

@section('title', $newsDetail->news_title . ' | ' . config('app.name'))
@section('description', Str::limit(strip_tags($newsDetail->news_content_short), 155))
@section('image', e(url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $newsDetail->photo)))
@section('canonical', route('news.show', [$newsDetail->category->slug, $newsDetail->encode_title]))
@section('modified_time', \Carbon\Carbon::parse($newsDetail->news_date)->toIso8601String())
@section('og_updated_time', \Carbon\Carbon::parse($newsDetail->updated_at ?? $newsDetail->news_date)->toIso8601String())

@php
    $schema = [
        "@context" => "https://schema.org",
        "@type" => "NewsArticle",
        "mainEntityOfPage" => [
            "@type" => "WebPage",
            "@id" => url()->current()
        ],
        "headline" => $newsDetail->news_title,
        "description" => Str::limit(strip_tags($newsDetail->news_content_short), 160),
        "image" => [
            'https://financial-journal.xyz/newspaper/cms/public/uploads/' . $newsDetail->photo
        ],
        "dateModified" => \Carbon\Carbon::parse($newsDetail->updated_at ?? $newsDetail->news_date)->toIso8601String(),
        "author" => [
            "@type" => "Person",
            "name" => optional($newsDetail->author)->name ?? 'Editorial Desk'
        ],
        "publisher" => [
            "@type" => "Organization",
            "name" => config('app.name'),
            "logo" => [
                "@type" => "ImageObject",
                "url" => url('assets/images/logo.webp')
            ]
        ]
    ];
@endphp
@section('schema')
    <script type="application/ld+json">
    {!! json_encode($schema, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT) !!}
    </script>
@endsection
@section('content')
    <article itemscope itemtype="https://schema.org/NewsArticle">
        <meta itemprop="mainEntityOfPage" content="{{ url()->current() }}">
        <section class="person-section">
            <div class="person-content"> <!-- First Column (Person Info) -->
                <div class="first-column">
                    <h1 class="person-name" itemprop="headline">
                        {{ $newsDetail->news_title }}
                    </h1>
                    <p class="bio-text"> {{ $newsDetail->news_content_short }}</p>

                    <div class="person-bio-container">

                        @if($newsDetail->author)

                                        <img src="{{ $newsDetail->author->image
                            ? asset('assets/images/authors/' . $newsDetail->author->image)
                            : asset('assets/images/authors/default.jpg') }}" alt="{{ $newsDetail->author->name }}"
                                            class="person-image">

                                        <div class="person-details">

                                            <p>
                                                <strong>
                                                    <span itemprop="author" itemscope itemtype="https://schema.org/Person">
                                                        <a href="{{ route('author.show', $newsDetail->author->slug) }}" itemprop="url" title="{{ $newsDetail->author->name }}">
                                                            <span itemprop="name">{{ $newsDetail->author->name }}</span>
                                                        </a>
                                                    </span>
                                                </strong>
                                                — {{ $newsDetail->author->designation ?? 'Staff Writer' }}
                                            </p>

                                            <br>

                                            <p>
                                                Last Updated:
                                                <time itemprop="dateModified"
                                                    datetime="{{ \Carbon\Carbon::parse($newsDetail->updated_at ?? $newsDetail->news_date)->toIso8601String() }}">
                                                    {{ \Carbon\Carbon::parse($newsDetail->updated_at ?? $newsDetail->news_date)->format('F d, Y') }}
                                                </time>
                                            </p>

                                        </div>

                        @else

                            <img src="{{ asset('assets/images/authors/default.jpg') }}" alt="Editorial Desk"
                                class="person-image">


                            <div class="person-details">
                                <p><strong>Editorial Desk</strong> — Staff Writer</p>
                                <p>
                                    Last Updated:
                                    <time itemprop="dateModified"
                                        datetime="{{ \Carbon\Carbon::parse($newsDetail->updated_at ?? $newsDetail->news_date)->toIso8601String() }}">
                                        {{ \Carbon\Carbon::parse($newsDetail->updated_at ?? $newsDetail->news_date)->format('F d, Y') }}
                                    </time>
                                </p>
                            </div>

                        @endif

                    </div>

                    @php
                        $shareUrl = url()->current();
                        $shareTitle = $newsDetail->news_title;
                    @endphp

                    <div class="share-buttons">
                        <a class="share-btn" href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode($shareUrl) }}"
                            target="_blank" title="facebook-share">
                            <img src="{{ asset('assets/images/facebook.webp') }}" alt="Share on Facebook">
                        </a>
                        <a class="share-btn"
                            href="https://twitter.com/intent/tweet?url={{ urlencode($shareUrl) }}&text={{ urlencode($shareTitle) }}"
                            target="_blank" title="twitter-share">
                            <img src="{{ asset('assets/images/twitter.webp') }}" alt="Share on Twitter">
                        </a>
                        <a class="share-btn"
                            href="https://api.whatsapp.com/send?text={{ urlencode($shareTitle . ' ' . $shareUrl) }}"
                            target="_blank" title="whatsapp-share">
                            <img src="{{ asset('assets/images/whatsapp.webp') }}" alt="Share on WhatsApp">
                        </a>
                        <a class="share-btn"
                            href="https://www.linkedin.com/sharing/share-offsite/?url={{ urlencode($shareUrl) }}"
                            target="_blank" title="linkedin-share">
                            <img src="{{ asset('assets/images/linkedin.webp') }}" alt="Share on LinkedIn">
                        </a>
                    </div>
                    <div class="large-image">
                        <img src="{{ url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $newsDetail->photo) }}"
                            alt="{{ $newsDetail->news_title }}">
                    </div>

                    <div class="two-column-section">
                        <div class="two-column-content">
                            <!-- Third Column (Small) - Post Button Vertically Aligned -->
                            <div class="third-column">
                                <div class="post-buttons-vertical">
                                    <a class="post"
                                        href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode($shareUrl) }}"
                                        target="_blank" rel="noopener" title="facebook-post">
                                        <img src="{{ asset('assets/images/facebook.webp') }}" alt="Share on Facebook">
                                    </a>
                                    <a class="post"
                                        href="https://twitter.com/intent/tweet?url={{ urlencode($shareUrl) }}&text={{ urlencode($shareTitle) }}"
                                        target="_blank" title="twitter-post">
                                        <img src="{{ asset('assets/images/twitter.webp') }}" alt="Share on Twitter">
                                    </a>
                                    <a class="post"
                                        href="https://api.whatsapp.com/send?text={{ urlencode($shareTitle . ' ' . $shareUrl) }}"
                                        target="_blank" rel="noopener" title="whatsapp-post">
                                        <img src="{{ asset('assets/images/whatsapp.webp') }}" alt="Share on WhatsApp">
                                    </a>
                                    <a class="post"
                                        href="https://www.linkedin.com/sharing/share-offsite/?url={{ urlencode($shareUrl) }}"
                                        target="_blank" rel="noopener" title="linkedin-post">
                                        <img src="{{ asset('assets/images/linkedin.webp') }}" alt="Share on LinkedIn">
                                    </a>
                                </div>
                            </div>

                            <!-- Fourth Column (Large) - Block with Title and Paragraph -->
                            <div class="fourth-column">

                                <div class="content-block">
                                    <h3 class="block-title">{{ $newsDetail->stitle }}</h3>

                                    <div class="block-para" itemprop="articleBody">
                                        {!! $newsDetail->news_content !!}
                                    </div>
                                    <div class="quote-container">
                                        <blockquote class="quote">"The only limit to our realization of tomorrow is our
                                            doubts
                                            of today."
                                        </blockquote>
                                        <p class="from">From - Franklin D. Roosevelt</p>
                                    </div>
                                </div>




                                <div class="horizontal-line"></div>
                                <div class="submit-container">
                                    <div class="submit-left">
                                        <!-- <img src="{{ asset('assets/images/send.webp') }}" alt="Image" class="submit-image"> -->
                                        <span class="submit-text">Share This Article</span>
                                    </div>
                                    @php
                                        $shareUrl = url()->current();
                                        $shareTitle = $newsDetail->news_title;
                                    @endphp
                                    <div class="submit-right">
                                        <a href="https://twitter.com/intent/tweet?url={{ urlencode($shareUrl) }}&text={{ urlencode($shareTitle) }}"
                                            target="_blank" rel="noopener" class="share-icon" title="twitter-share">
                                            <img src="{{ asset('assets/images/twitter.webp') }} " class="icon"
                                                alt="Share on Twitter">
                                        </a>
                                        <a href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode($shareUrl) }}"
                                            target="_blank" rel="noopener" class="share-icon" title="facebook-share">
                                            <img src="{{ asset('assets/images/facebook.webp') }}" class="icon"
                                                alt="Share on Facebook">
                                        </a>
                                        <a href="https://www.linkedin.com/sharing/share-offsite/?url={{ urlencode($shareUrl) }}"
                                            target="_blank" rel="noopener" class="share-icon" title="linkedin-share">
                                            <img src="{{ asset('assets/images/linkedin.webp') }}" class="icon"
                                                alt="Share on LinkedIn">
                                        </a>
                                        <a href="https://api.whatsapp.com/send?text={{ urlencode($shareTitle . ' ' . $shareUrl) }}"
                                            target="_blank" rel="noopener" class="share-icon" title="whatsapp-share">
                                            <img src="{{ asset('assets/images/whatsapp.webp') }}" class="icon"
                                                alt="Share on WhatsApp">
                                        </a>

                                    </div>
                                </div>
                                <div class="horizontal-line"></div>

                            </div>
                        </div>
                    </div>
                </div>




                <!-- Second Column (Sticky Sidebar) -->
                <div class="sidebar-column">
                    <div class="sidebar-box">
                        <h3 class="sidebar-title">Important Travel Tips</h3>
                        <p class="sidebar-para">Traveling solo requires careful planning, but the rewards are worth it. lo
                        </p>
                        <!-- 6 Buttons in the Sidebar -->
                        <div class="button-group">
                            <button class="btn">Tip 1</button>
                            <button class="btn">Tip 2</button>
                            <button class="btn">Tip 3</button>
                            <button class="btn">Tip 4</button>
                            <button class="btn">Tip 5</button>
                            <button class="btn">Tip 6</button>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Start of new section with a new div -->
        </section>


        <section class="comment-ad-section">
            <!-- Left Column - Leave a Comment -->
            <div class="comment-column">
                <h3>Leave a Comment</h3>
                <p class="info-text">Your email address will not be published. Required fields are marked *</p>

                <form action="#" class="comment-form">
                    <!-- <label for="comment">Leave a Comment</label> -->
                    <textarea id="comment" name="comment" placeholder="Write your comment here"></textarea>

                    <div class="input-fields">
                        <input type="text" id="name" name="name" placeholder="Your name" required>
                        <input type="email" id="email" name="email" placeholder="Your email" required>
                        <input type="url" id="website" name="website" placeholder="Your website">
                    </div>

                    <div class="save-info">
                        <input type="checkbox" id="save-info">
                        <label for="save-info">Save my name, email, and website in this browser for the next time I
                            comment.</label>
                    </div>

                    <button type="submit" class="submit-btn">Post Comment</button>
                </form>
            </div>

            <!-- Right Column - Advertisement -->
            <div class="ad-column">
                <div class="ad-box">
                    <h2>BuzzStream</h2>
                    <p>Live, Breaking News Theme</p>
                    <img src="image/foxiz.webp" alt="Advertisement Image" class="ad-image">
                    <a href="#" class="btn" title="ad">Get It Now</a>
                </div>
            </div>
        </section>


        <!-- JUST FOR YOU -->

        <section class="recommend-section">

            <div class="recommend-header">
                <h2>Just for You</h2>
            </div>

            <div class="four-column-container">

                @forelse($recommended as $item)

                    <article class="recommend-card">

                        <div class="card-image">
                            <a href="{{ route('news.show', [$item->category->slug, $item->encode_title]) }}" title="{{ $item->news_title }}">
                                <img src="{{ url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $item->photo) }}"
                                    alt="{{ $item->news_title }}">
                            </a>
                            <span class="card-tag">
                                {{ strtoupper($item->category->category_name) }}
                            </span>
                        </div>

                        <h3>
                            <a href="{{ route('news.show', [$item->category->slug, $item->encode_title]) }}" title="{{ $item->news_title }}">
                                {{ $item->news_title }}
                            </a>
                        </h3>

                        <p class="card-desc">
                            {{ Str::limit(strip_tags($item->news_content_short), 110) }}
                        </p>

                        <div class="article-meta">
                            <span class="article-author">
                                @if($item->author)
                                    <a href="{{ route('author.show', $item->author->slug) }}" title="{{ $item->author->name }}">
                                        {{ $item->author->name }}
                                    </a>
                                @else
                                    Editorial Desk
                                @endif
                            </span>

                            <button class="bookmark-btn" data-id="{{ $item->news_id }}" aria-label="Save article">
                                <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                    <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                                </svg>
                            </button>
                        </div>

                    </article>

                @empty
                    <p style="padding:20px">No articles available.</p>
                @endforelse
            </div>
        </section>

        <hr class="custom-line">
    </article>
@endsection
