<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

<title>@yield('title', 'Latest Breaking News & Headlines')</title>
<link rel="icon" href="{{ asset('favicon.ico') }}" type="image/x-icon">
<link rel="shortcut icon" href="{{ asset('favicon.ico') }}" type="image/x-icon">
<link rel="apple-touch-icon" href="{{ asset('favicon.ico') }}">
<meta name="msapplication-TileImage" content="{{ asset('favicon.ico') }}">

<meta name="description" content="@yield('description', 'Latest breaking news, world news, technology updates, politics and business headlines updated daily.')">

<meta name="keywords"
    content="@yield('keywords', 'news, world news, business news, technology news')">

<meta name="robots" content="@yield('robots', 'index,follow,max-image-preview:large')">
<meta name="googlebot" content="@yield('robots', 'index,follow,max-image-preview:large')">

<link rel="canonical" href="@yield('canonical', url()->current())">
<link rel="stylesheet" href="{{ asset('assets/css/style.css') }}">
<meta property="og:updated_time" content="@yield('og_updated_time')">
<meta property="og:type" content="@hasSection('published_time') article @else website @endif">
<meta property="og:site_name" content="{{ config('app.name') }}">
<meta property="og:locale" content="en_US">
<meta property="og:url" content="@yield('canonical', url()->current())">
<meta property="og:title" content="@yield('title', config('app.name'))">
<meta property="og:description" content="@yield('description')">
<meta property="og:image" content="@yield('image', asset('assets/images/default.jpg'))">
<meta property="og:image:width" content="1200">
<meta property="og:image:height" content="630">
<meta property="article:modified_time" content="@yield('modified_time')">
<meta property="article:section" content="@yield('section')">
<meta property="article:tag" content="@yield('keywords')">

<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="@yield('title')">
<meta name="twitter:description" content="@yield('description')">
<meta name="twitter:image" content="@yield('image', asset('assets/images/default.jpg'))">
@yield('schema')
@php
$schema = [
    "@context" => "https://schema.org",
    "@type" => "WebSite",
    "name" => config('app.name'),
    "url" => url('/'),
    "potentialAction" => [
        "@type" => "SearchAction",
        "target" => url('/search') . '?q={search_term_string}',
        "query-input" => "required name=search_term_string"
    ]
];
@endphp

<script type="application/ld+json">
{!! json_encode($schema, JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT) !!}
</script>


</head>

<body>

@include('partials.top-bar')
@include('partials.navbar')
<main>
    @yield('content')
</main>
@include('partials.footer')
<script src="{{ asset('assets/js/script.js') }}"></script>

</body>
</html>
