@php use Illuminate\Support\Str; @endphp
@section('schema')
@php
$orgSchema = [
    "@context" => "https://schema.org",
    "@type" => "NewsMediaOrganization",
    "name" => config('app.name'),
    "url" => url('/'),
    "logo" => [
        "@type" => "ImageObject",
        "url" => asset('assets/images/logo.webp')
    ],
    "sameAs" => [
        "https://www.facebook.com",
        "https://www.twitter.com",
        "https://www.linkedin.com"
    ]
];
@endphp

<script type="application/ld+json">
{!! json_encode($orgSchema, JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT) !!}
</script>
@endsection
@extends('layouts.app')
@section('title','Latest Breaking News & Headlines')
@section('description', 'Breaking news, business, politics, world and technology coverage updated daily.')

@section('content')
<h1 class="visually-hidden">
Latest Breaking News & Headlines
</h1>

<p class="visually-hidden">
Read the latest breaking news, world news, politics, business and technology headlines updated daily.
</p>
<div class="seo-intro visually-hidden">
    <p>
        Get the latest breaking news and top headlines covering business, politics,
        technology, world news, and trending stories updated daily. Our headlines
        span politics, finance, and world affairs. Our news platform provides
        reliable headlines, featured articles, and current affairs from around the world.
    </p>
</div>
    <!-- 1st section -->
    <section class="news-section">
        <div class="news-container">

            <!-- COLUMN 1 : FEATURED ARTICLE -->
            <div class="col col-featured">
                <div class="featured-image-wrapper">

                    <a href="{{ route('news.show', [$featured->category->slug, $featured->encode_title]) }}" title="{{ $featured->news_title }}">
                        <img src="{{ url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $featured->photo) }}"
                            alt="{{ $featured->news_title }}">
                    </a>

                    <span class="tag">
                        {{ strtoupper($featured->category->category_name) }}
                    </span>

                </div>
                <br>

                <h2>
                    <a href="{{ route('news.show', [$featured->category->slug, $featured->encode_title]) }}" title="{{ $featured->news_title }}">

                        <span class="highlight">Live Updates:</span>
                        {{ $featured->news_title }}
                    </a>
                </h2>

                <p class="font">
                    {{ \Illuminate\Support\Str::limit($featured->news_content_short, 150) }}
                </p>
                <div class="article-meta">

                    <span class="article-author">
                        @if($featured->author)
                            <a href="{{ route('author.show', $featured->author->slug) }}" title="{{ $featured->author->name }}">
                                {{ $featured->author->name }}
                            </a>
                        @else
                            Editorial Desk
                        @endif
                    </span>

                    <button class="bookmark-btn" data-id="{{ $featured->news_id }}" aria-label="Save article">
                        <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                            <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                        </svg>
                    </button>

                </div>

            </div>


            <!-- COLUMN 2 : HEADLINES -->
            <div class="col col-headlines">
                <h3 class="section-title">Top Headlines</h3>

                @foreach($headlines as $item)
                    <div class="headline">

                        <h4 class="headline-title">
                            <a href="{{ route('news.show', [$item->category->slug, $item->encode_title]) }}" title="{{ $item->news_title }}">
                                → {{ $item->news_title }}
                            </a>
                        </h4>

                        <div class="article-meta">
                            <span class="article-author">
                                @if($item->author)
                                     <a href="{{ route('author.show', $item->author->slug) }}" title="{{ $item->author->name }}">
                                        {{ $item->author->name }}
                                    </a>
                                @else
                                    Editorial Desk
                                @endif
                            </span>

                            <button class="bookmark-btn" data-id="{{ $item->news_id }}" aria-label="Save article">
                                <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                    <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                                </svg>
                            </button>
                        </div>

                    </div>
                @endforeach

            </div>

            <!-- COLUMN 3 : SIDEBAR -->
            <div class="col col-sidebar">
                <h3>About BuzzStream</h3>

                <p>
                    BuzzStream is an independent digital newsroom delivering breaking news, in-depth analysis, and opinion
                    coverage across politics, business, technology, and global affairs. Our editorial team focuses on
                    verified reporting, data-driven insights, and clear storytelling to help readers understand the events
                    shaping the world.
                    We publish daily updates, investigative features, and expert commentary designed to keep our audience
                    informed without noise or sensationalism.
                </p>

                <div class="social-grid">
                    <span>Facebook</span>
                    <span>X</span>
                    <span>Instagram</span>
                    <span>LinkedIn</span>
                    <span>Medium</span>
                    <span>Quora</span>
                </div>
            </div>

        </div>
    </section>
    <!-- <hr class="custom-line b"> -->
    <hr class="nav-divider">



    <!-- 2nd section -->
    <section class="most-read-section">

        <!-- Title -->
        <div class="section-title-container">
            <h2 class="section-title">Most Read This Week</h2>
        </div>

        <div class="most-read-container">

            <!-- Advertisement -->
            <div class="advertisement-box">
                <p class="ad-title">BuzzStream</p>
                <p>Live, Breaking News Theme</p>
                <img src="{{ asset('assets/images/foxiz.webp') }}" alt="Advertisement Image" class="ad-image">
                <a href="#" class="btn" title="ad">Get It Now</a>
            </div>


            <!-- Right Column: Articles -->
            <div class="content-column">

                @if($spotlightMain)
                    <!-- MAIN ARTICLE -->
                    <div class="main-article">

                        <div class="main-article-content">

                            <h3>
                                <a href="{{ route('news.show', [$spotlightMain->category->slug, $spotlightMain->encode_title]) }}" title="{{ $spotlightMain->news_title }}">
                                    {{ $spotlightMain->news_title }}
                                </a>
                            </h3>

                            <p class="font">
                                {{ \Illuminate\Support\Str::limit(strip_tags($spotlightMain->news_content), 600) }}
                            </p>

                            <!-- META ROW -->
                            <div class="article-meta">
                                <span class="article-author">
                                    @if($spotlightMain->author)
                                        <a href="{{ route('author.show', $spotlightMain->author->slug) }}" title="{{ $spotlightMain->author->name }}">
                                            {{ $spotlightMain->author->name }}
                                        </a>
                                    @else
                                        Editorial Desk
                                    @endif
                                </span>

                                <button class="bookmark-btn" data-id="{{ $spotlightMain->news_id }}" aria-label="Save article">
                                    <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                        <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                                    </svg>
                                </button>
                            </div>

                        </div>

                        <a href="{{ route('news.show', [$spotlightMain->category->slug, $spotlightMain->encode_title]) }}" title="{{ $spotlightMain->news_title }}">
                            <img src="{{ url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $spotlightMain->photo) }}"
                                alt="{{ $spotlightMain->news_title }}">
                        </a>

                    </div>
                @endif




                <!-- SIDE ARTICLES -->
                <div class="three-column">

                    @foreach($spotlightSide as $item)
                        <article class="column">

                            <h4>
                                <a href="{{ route('news.show', [$item->category->slug, $item->encode_title]) }}" title="{{ $item->news_title }}">
                                    {{ $item->news_title }}
                                </a>
                            </h4>

                            <p class="font">
                                {{ \Illuminate\Support\Str::limit($item->news_content_short, 90) }}
                            </p>

                            <!-- META -->
                            <div class="article-meta">

                                <span class="article-author">
                                    @if($item->author)
                                         <a href="{{ route('author.show', $item->author->slug) }}" title="{{ $item->author->name }}">
                                            {{ $item->author->name }}
                                        </a>
                                    @else
                                        Editorial Desk
                                    @endif
                                </span>

                                <button class="bookmark-btn" data-id="{{ $item->news_id }}" aria-label="Save article">
                                    <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                        <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                                    </svg>
                                </button>

                            </div>

                        </article>
                    @endforeach

                </div>

            </div>
        </div>
    </section>



    <!-- 3rd section -->
    <!-- JUST FOR YOU -->
    <section class="recommend-section">

        <div class="recommend-header">
            <h2>Just for You</h2>
        </div>

        <div class="four-column-container">
            @foreach($recommended as $item)
                <article class="recommend-card">
                    <div class="card-image">
                        <a href="{{ route('news.show', [$item->category->slug, $item->encode_title]) }}" title="{{ $item->news_title }}">
                            <img src="{{ url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $item->photo) }}"
                                alt="{{ $item->news_title }}"></a>
                        <span class="card-tag">{{ strtoupper($item->category->category_name) }}</span>
                    </div>
                    <h3>
                        <a href="{{ route('news.show', [$item->category->slug, $item->encode_title]) }}" title="{{ $item->news_title }}">
                            → {{ $item->news_title }}
                        </a>
                    </h3>
                    <p class="card-desc font">
                        {{ Str::limit($item->news_content_short, 100) }}
                    </p>
                    <div class="card-meta">

                        @if($item->author)
                            <span class="meta">
                                By
                                 <a href="{{ route('author.show', $item->author->slug) }}" title="{{ $item->author->name }}">
                                    <strong>{{ $item->author->name }}</strong>
                                </a>
                            </span>
                        @else
                            <span class="meta">
                                By Editorial Desk
                            </span>
                        @endif

                        <button class="bookmark-btn" aria-label="Save article">
                            <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                            </svg>
                        </button>
                    </div>
                </article>
            @endforeach
        </div>
    </section>




    <!-- 4th section -->
    <!-- OPINION SECTION -->
    <section class="opinion-section">

        <div class="opinion-header">
            <h2>Opinion</h2>
            <a href="{{ route('category.show', 'opinion') }}" title="Opinion News" class="more-link">More Posts</a>
        </div>

        <div class="opinion-grid">

            <div class="opinion-column">

                @foreach($opinionsLeft as $item)
                    <article class="opinion-card">
                        <div class="opinion-image">
                            <a href="{{ route('news.show', [$item->category->slug, $item->encode_title]) }}" title="{{ $item->news_title }}">
                                <img src="{{ url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $item->photo) }}"
                                    alt="{{ $item->news_title }}"></a>
                            <span class="opinion-tag">
                                {{ strtoupper($item->category->category_name) }}
                            </span>
                        </div>

                        <div class="opinion-content">
                            <h3>
                                <a href="{{ route('news.show', [$item->category->slug, $item->encode_title]) }}" title="{{ $item->news_title }}">
                                    {{ $item->news_title }}
                                </a>
                            </h3>

                            <p class="font">
                                {{ \Illuminate\Support\Str::limit($item->news_content_short, 120) }}
                            </p>

                            <div class="article-meta">

                                <span class="article-author">
                                    @if($item->author)
                                         <a href="{{ route('author.show', $item->author->slug) }}" title="{{ $item->author->name }}">
                                            {{ $item->author->name }}
                                        </a>
                                    @else
                                        Editorial Desk
                                    @endif
                                </span>

                                <button class="bookmark-btn" data-id="{{ $item->news_id }}" aria-label="Save article">
                                    <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                        <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                                    </svg>
                                </button>

                            </div>
                        </div>

                    </article>
                @endforeach

            </div>


            <div class="opinion-column">

                @foreach($opinionsRight as $item)
                    <article class="opinion-card">
                        <div class="opinion-image">
                            <a href="{{ route('news.show', [$item->category->slug, $item->encode_title]) }}" title="{{ $item->news_title }}">
                                <img src="{{ url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $item->photo) }}"
                                    alt="{{ $item->news_title }}"></a>
                            <span class="opinion-tag">
                                {{ strtoupper($item->category->category_name) }}
                            </span>
                        </div>

                        <div class="opinion-content">
                            <h3>
                                <span class="live">Live Updates:</span>
                                <a href="{{ route('news.show', [$item->category->slug, $item->encode_title]) }}" title="{{ $item->news_title }}">
                                    {{ $item->news_title }}
                                </a>
                            </h3>

                            <p class="font">
                                {{ \Illuminate\Support\Str::limit($item->news_content_short, 130) }}
                            </p>

                            <div class="article-meta">

                                <span class="article-author">
                                    @if($item->author)
                                         <a href="{{ route('author.show', $item->author->slug) }}" title="{{ $item->author->name }}">
                                            {{ $item->author->name }}
                                        </a>
                                    @else
                                        Editorial Desk
                                    @endif
                                </span>

                                <button class="bookmark-btn" data-id="{{ $item->news_id }}" aria-label="Save article">
                                    <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                        <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                                    </svg>
                                </button>

                            </div>
                        </div>
                    </article>
                @endforeach

            </div>

        </div>

    </section>
    <hr class="custom-line">



    <!-- 5th section -->
    <!-- EDITORIAL HUB -->
    <section class="editorial-hub">

        <div class="editorial-grid">

            <!-- LEFT : TOP WRITERS -->
            <div class="editorial-column writers-column">
                <h3 class="column-title">Top Writers</h3>
                @forelse($topWriters as $writer)

                    <div class="writer-card">

                        <a href="{{ route('author.show', $writer->slug) }}" title="{{ $writer->name }}">
                            <img src="{{ $writer->image ? asset('assets/images/authors/' . $writer->image) : asset('assets/images/no-image.webp') }}"
                                alt="{{ $writer->name }}"></a>

                        <div>

                            <h3>
                                <a href="{{ route('author.show', $writer->slug) }}" title="{{ $writer->name }}">
                                    {{ $writer->name }}
                                </a>
                                <span> / {{ $writer->news_count }} Articles</span>
                            </h3>

                            <p>{{ $writer->designation }}</p>

                        </div>

                    </div>

                @empty
                    <p style="padding:10px;">No writers yet.</p>
                @endforelse
            </div>


            <!-- MIDDLE : TECH -->
            <div class="editorial-column tech-column">
                <h3 class="column-title">Tech</h3>

                @php
                    $featuredTech = $techNews->first();
                @endphp

                @if($featuredTech)
                    {{-- Featured Tech --}}
                    <article class="featured-article">
                        <div class="featured-image-wrapper">
                            <a href="{{ route('news.show', [$featuredTech->category->slug, $featuredTech->encode_title]) }}" title="{{ $featuredTech->news_title }}">
                                <img src="{{ url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $featuredTech->photo) }}"
                                    alt="{{ $featuredTech->news_title }}">
                            </a>

                            <span class="card-tag">TECHNOLOGY</span>
                        </div>
                        <h3>
                            <a href="{{ route('news.show', [$featuredTech->category->slug, $featuredTech->encode_title]) }}" title="{{ $featuredTech->news_title }}">
                                {{ $featuredTech->news_title }}
                            </a>
                        </h3>

                        <div class="article-meta">

                            <span class="article-author">
                                @if($featuredTech->author)
                                    <a href="{{ route('author.show', $featuredTech->author->slug) }}" title="{{ $featuredTech->author->name }}">
                                        {{ $featuredTech->author->name }}
                                    </a>
                                @else
                                    Editorial Desk
                                @endif
                            </span>

                            <button class="bookmark-btn" data-id="{{ $featuredTech->news_id }}" aria-label="Save article">
                                <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                    <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                                </svg>
                            </button>

                        </div>

                    </article>
                @endif




                {{-- Small Tech Articles --}}
                @foreach($techNews->skip(1) as $item)

                    <article class="text-article">

                        <h4>
                            <a href="{{ route('news.show', [$item->category->slug, $item->encode_title]) }}" title="{{ $item->news_title }}">
                                {{ $item->news_title }}
                            </a>
                        </h4>

                        <div class="article-meta">

                            <span class="article-author">
                                @if($item->author)
                                     <a href="{{ route('author.show', $item->author->slug) }}" title="{{ $item->author->name }}">
                                        {{ $item->author->name }}
                                    </a>
                                @else
                                    Editorial Desk
                                @endif
                            </span>

                            <button class="bookmark-btn" data-id="{{ $item->news_id }}" aria-label="Save article">
                                <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                    <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                                </svg>
                            </button>

                        </div>

                    </article>

                @endforeach

            </div>


            <!-- RIGHT : WORLD -->
            <div class="editorial-column world-column">
                <h3 class="column-title">World</h3>

                {{-- First 2 small articles --}}
                @foreach($worldNews->take(2) as $item)
                    <article class="text-article">

                        <h4>
                            <a href="{{ route('news.show', [$item->category->slug, $item->encode_title]) }}" title="{{ $item->news_title }}">
                                {{ $item->news_title }}
                            </a>
                        </h4>

                        <div class="article-meta">

                            <span class="article-author">
                                @if($item->author)
                                     <a href="{{ route('author.show', $item->author->slug) }}" title="{{ $item->author->name }}">
                                        {{ $item->author->name }}
                                    </a>
                                @else
                                    Editorial Desk
                                @endif
                            </span>

                            <button class="bookmark-btn" data-id="{{ $item->news_id }}" aria-label="Save article">
                                <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                    <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                                </svg>
                            </button>

                        </div>

                    </article>
                @endforeach


                {{-- Featured third article --}}
                @if($worldNews->count() > 2)
                    @php $featuredWorld = $worldNews[2]; @endphp

                    <article class="featured-article small">
                        <div class="featured-image-wrapper">

                            <a href="{{ route('news.show', [$featuredWorld->category->slug, $featuredWorld->encode_title]) }}" title="{{ $featuredWorld->news_title }}">
                                <img src="{{ url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $featuredWorld->photo) }}"
                                    alt="{{ $featuredWorld->news_title }}">
                            </a>

                            <span class="card-tag">WORLD</span>
                        </div>
                        <h4>
                            <a href="{{ route('news.show', [$featuredWorld->category->slug, $featuredWorld->encode_title]) }}" title="{{ $featuredWorld->news_title }}">
                                {{ $featuredWorld->news_title }}
                            </a>
                        </h4>

                        <div class="article-meta">

                            <span class="article-author">
                                @if($featuredWorld->author)
                                    <a href="{{ route('author.show', $featuredWorld->author->slug) }}" title="{{ $featuredWorld->author->name }}">
                                        {{ $featuredWorld->author->name }}
                                    </a>
                                @else
                                    Editorial Desk
                                @endif
                            </span>

                            <button class="bookmark-btn" data-id="{{ $featuredWorld->news_id }}" aria-label="Save article">
                                <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                    <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                                </svg>
                            </button>

                        </div>

                    </article>
                @endif

            </div>


        </div>
    </section>



    <!-- 6th section -->
    <section class="subscription-box" id="subscribe-section">
        <div class="subscription-container">
            <!-- First Column: Image -->
            <div class="subscription-image">
                <img src="assets/images/logo.webp" alt="Subscription Image">
            </div>

            <!-- Second Column: Title and Paragraph -->
            <div class="subscription-title">
                <h2>Get the Daily Briefing in Your Inbox</h2>
                <p>Start your day with the most important stories in politics, business, technology, and world affairs.
                </p>
            </div>

            <!-- Third Column: Email Input, Subscribe Button, and Checkbox -->
            <div class="subscription-form">
                <input type="email" placeholder="Your email address" required>
                <button type="submit" class="sign-up-btn">Sign Up Now</button>
                <div class="terms-conditions">
                    <input type="checkbox" id="terms" name="terms">
                    <label for="terms">I have read and agree to the terms & conditions</label>
                </div>
            </div>
        </div>
    </section>



    <!-- 7th section -->
    <section class="recommend-section">

        <div class="recommend-header">
            <h2>More Stories for You</h2>
        </div>

        <div class="four-column-container">

            @foreach($secondRecommended as $item)
                <article class="recommend-card">

                    <div class="card-image">
                        <a href="{{ route('news.show', [$item->category->slug, $item->encode_title]) }}" title="{{ $item->news_title }}">
                            <img src="{{ url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $item->photo) }}"
                                alt="{{ $item->news_title }}"></a>
                        <span class="card-tag">
                            {{ strtoupper($item->category->category_name) }}
                        </span>
                    </div>

                    <h3>
                        <a href="{{ route('news.show', [$item->category->slug, $item->encode_title]) }}" title="{{ $item->news_title }}">
                            {{ $item->news_title }}
                        </a>
                    </h3>

                    <p class="card-desc">
                        {{ Str::limit($item->news_content_short, 110) }}
                    </p>

                    <div class="article-meta">

                        <span class="article-author">
                            @if($item->author)
                                 <a href="{{ route('author.show', $item->author->slug) }}" title="{{ $item->author->name }}">
                                    {{ $item->author->name }}
                                </a>
                            @else
                                Editorial Desk
                            @endif
                        </span>

                        <button class="bookmark-btn" data-id="{{ $item->news_id }}" aria-label="Save article">
                            <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                            </svg>
                        </button>

                    </div>

                </article>
            @endforeach

        </div>

    </section>



    <!-- 8th section -->
    <!-- FINANCE SECTION -->
    <section class="health-section">

        <div class="health-header">
            <h2>Finance</h2>
            <a href="{{ route('category.show', 'finance') }}" title="Finance News" class="more-link">More Posts</a>
        </div>

        <div class="health-grid">

            @php
                $featuredHealth = $healthNews->first();
            @endphp

            {{-- Featured Article --}}
            @if($featuredHealth)
                <article class="health-featured">
                    <div class="health-featured-image">

                        <span class="card-tag">
                            {{ strtoupper($featuredHealth->category->category_name) }}
                        </span>

                        <a href="{{ route('news.show', [$featuredHealth->category->slug, $featuredHealth->encode_title]) }}" title="{{ $featuredHealth->news_title }}">
                            <img src="{{ url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $featuredHealth->photo) }}"
                                alt="{{ $featuredHealth->news_title }}">
                        </a>

                        <div class="health-overlay">

                            <h3>
                                <a href="{{ route('news.show', [$featuredHealth->category->slug, $featuredHealth->encode_title]) }}" title="{{ $featuredHealth->news_title }}">
                                    {{ $featuredHealth->news_title }}
                                </a>
                            </h3>

                            <p class="font">
                                {{ Str::limit($featuredHealth->news_content_short, 150) }}
                            </p>

                            <div class="article-meta">

                                <span class="article-author">
                                    @if($featuredHealth->author)
                                        <a href="{{ route('author.show', $featuredHealth->author->slug) }}" title="{{ $featuredHealth->author->name }}">
                                            {{ $featuredHealth->author->name }}
                                        </a>
                                    @else
                                        Editorial Desk
                                    @endif
                                </span>

                                <button class="bookmark-btn" data-id="{{ $featuredHealth->news_id }}" aria-label="Save article">
                                    <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                        <path d="M6 3h12v18l-6-4-6 4z" stroke="#ffffff" />
                                    </svg>
                                </button>

                            </div>

                        </div>
                    </div>
                </article>
            @endif


            {{-- List Articles --}}
            <div class="health-list">

                @foreach($healthNews->skip(1) as $item)
                    <article class="health-item">

                        <h4>
                            <a href="{{ route('news.show', [$item->category->slug, $item->encode_title]) }}" title="{{ $item->news_title }}">
                                {{ $item->news_title }}
                            </a>
                        </h4>

                        <p>{{ Str::limit($item->news_content_short, 90) }}</p>

                        <div class="article-meta">

                            <span class="article-author">
                                @if($item->author)
                                     <a href="{{ route('author.show', $item->author->slug) }}" title="{{ $item->author->name }}">
                                        {{ $item->author->name }}
                                    </a>
                                @else
                                    Editorial Desk
                                @endif
                            </span>

                            <button class="bookmark-btn" data-id="{{ $item->news_id }}" aria-label="Save article">
                                <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                    <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                                </svg>
                            </button>

                        </div>

                    </article>
                @endforeach

            </div>

        </div>
    </section>

    <!-- 9th section -->
    <section class="travel-section">

        <div class="travel-header">
            <h2>Politics</h2>
            <a href="{{ route('category.show', 'politics') }}" title="Politics News" class="more-link">More Posts</a>
        </div>

        <div class="travel-grid">

            @foreach($travelNews as $item)
                <article class="travel-card">

                    <div class="travel-image">
                        <a href="{{ route('news.show', [$item->category->slug, $item->encode_title]) }}" title="{{ $item->news_title }}">
                            <img src="{{ url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $item->photo) }}"
                                alt="{{ $item->news_title }}">
                        </a>
                    </div>

                    <h3>
                        <a href="{{ route('news.show', [$item->category->slug, $item->encode_title]) }}" title="{{ $item->news_title }}">
                            {{ $item->news_title }}
                        </a>
                    </h3>

                    <p class="font">
                        {{ Str::limit($item->news_content_short, 110) }}
                    </p>

                    <!-- AUTHOR + BOOKMARK ROW -->
                    <div class="article-meta">

                        <span class="article-author">
                            @if($item->author)
                                 <a href="{{ route('author.show', $item->author->slug) }}" title="{{ $item->author->name }}">
                                    {{ $item->author->name }}
                                </a>
                            @else
                                Editorial Desk
                            @endif
                        </span>

                        <button class="bookmark-btn" data-id="{{ $item->news_id }}" aria-label="Save article">
                            <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                            </svg>
                        </button>

                    </div>

                </article>
            @endforeach

        </div>
    </section>



    <!-- 10th section -->
    <div class="black-box1">
        <div class="box1-content">

            <!-- IMAGE -->
            <div class="box1-image">
                <a href="{{ route('news.show', [$heroNews->category->slug, $heroNews->encode_title]) }}" title="{{ $heroNews->news_title }}">
                    <img src="{{ url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $heroNews->photo) }}"
                        alt="{{ $heroNews->news_title }}">
                </a>

                <span class="hero-category">
                    {{ strtoupper($heroNews->category->category_name) }}
                </span>
            </div>

            <!-- TEXT -->
            <div class="box1-text">

                <h2 class="hero-title">
                    <a href="{{ route('news.show', [$heroNews->category->slug, $heroNews->encode_title]) }}" title="{{ $heroNews->news_title }}">
                        <span class="live-label">Live Updates:</span>
                        {{ $heroNews->news_title }}
                    </a>
                </h2>

                <p class="hero-desc font">
                    {{ \Illuminate\Support\Str::limit(strip_tags($heroNews->news_content_short), 170) }}
                </p>

                <div class="hero-meta">

                    <div class="hero-meta-left">
                        <span class="author">
                            By
                            @if($heroNews->author)
                                <a href="{{ route('author.show', $heroNews->author->slug) }}" title="{{ $heroNews->author->name }}">
                                    {{ $heroNews->author->name }}
                                </a>
                            @else
                                Editorial Desk
                            @endif
                        </span>

                        <span class="read-time">
                            • {{ ceil(str_word_count(strip_tags($heroNews->news_content)) / 200) }} Min Read
                        </span>
                    </div>

                    <!-- bookmark -->
                    <button class="bookmark-btn hero-bookmark" aria-label="Save article">
                        <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                            <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                        </svg>
                    </button>

                </div>

            </div>

        </div>
    </div>

    <!-- Section 2 - Circle Images with Titles -->
    <div class="circle-section">
        <div class="circle-container">
            @foreach($homeCircleCategories as $category)
                <div class="circle-item">

                    <a href="{{ route('category.show', $category->slug) }}" title="{{ $category->category_name }}">

                        <img src="{{ $category->category_banner ? asset('assets/images/categories/' . $category->category_banner) : asset('assets/images/no-image.webp') }}"
                            alt="{{ $category->category_name }}" class="circle-image">

                    </a>

                    <h3>{{ $category->category_name }}</h3>

                    <p class="circle-count">
                        {{ $category->news_count }} Articles
                    </p>

                </div>

            @endforeach

        </div>
    </div>
    <hr class="custom-line">



    <!--11th sectioin  -->
    <div class="scroll-container">
        <!-- Left Column -->
        <div class="left-column">

            @foreach($latestFeed as $item)
                <div class="custom-article">
                    <div class="article-content">

                        <a href="{{ route('news.show', [$item->category->slug, $item->encode_title]) }}" class="article-thumb" title="{{ $item->news_title }}">
                            <img src="{{ url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $item->photo) }}"
                                alt="{{ $item->news_title }}">
                        </a>
                        <div class="article-text">
                            <h3>
                                <a href="{{ route('news.show', [$item->category->slug, $item->encode_title]) }}" title="{{ $item->news_title }}">
                                    {{ $item->news_title }}
                                </a>
                            </h3>

                            <p class="font">
                                {{ \Illuminate\Support\Str::limit($item->news_content_short, 120) }}
                            </p>

                            <div class="article-meta">

                                <span class="article-author">
                                    @if($item->author)
                                         <a href="{{ route('author.show', $item->author->slug) }}" title="{{ $item->author->name }}">
                                            {{ $item->author->name }}
                                        </a>
                                    @else
                                        Editorial Desk
                                    @endif
                                </span>

                                <button class="bookmark-btn" data-id="{{ $item->news_id }}" aria-label="Save article">
                                    <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                        <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                                    </svg>
                                </button>

                            </div>



                        </div>
                    </div>
                </div>
            @endforeach


        </div>


        <!-- Right Column -->
        <div class="right-column">
            <!-- Advertisement Box -->
            <div class="advertisement-box">
                <p class="ad-title">BuzzStream</p>
                <p>Live, Breaking News Theme</p>
                <img src="assets/images/foxiz.webp" alt="Advertisement Image" class="ad-image">
                <a href="#" class="btn" title="ad">Get It Now</a>
            </div>

            <!-- First Article in the Right Column -->
            @foreach($sidebarFeed as $item)
                <div class="custom-right-article">

                    <div class="right-article-text">
                        <h3>
                            <a href="{{ route('news.show', [$item->category->slug, $item->encode_title]) }}" title="{{ $item->news_title }}">

                                {{ $item->news_title }}
                            </a>
                        </h3>

                        <p class="font">
                            {{ \Illuminate\Support\Str::limit($item->news_content_short, 70) }}
                        </p>
                    </div>
                    <a href="{{ route('news.show', [$item->category->slug, $item->encode_title]) }}" title="{{ $item->news_title }}">

                        <img src="{{ url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $item->photo) }}"
                            alt="{{ $item->news_title }}" class="right-img">
                    </a>
                </div>
            @endforeach

        </div>
    </div>

    </main>
    <hr class="custom-line">

@endsection
