@php use Illuminate\Support\Str; @endphp
@section('title', $category->category_name . ' News')
@section('description', 'Latest ' . $category->name . ' news, updates, analysis and breaking stories.')
@section('schema')
@php
$categorySchema = [
    "@context" => "https://schema.org",
    "@type" => "CollectionPage",
    "name" => $category->category_name . ' News',
    "url" => route('category.show', $category->slug),
    "description" => 'Latest ' . $category->category_name . ' news, updates and breaking stories.'
];
@endphp

<script type="application/ld+json">
{!! json_encode($categorySchema, JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT) !!}
</script>
@endsection
@extends('layouts.app')

@section('content')

    <section class="category-heading">
        <h1 itemprop="name">
            <a href="{{ route('category.show', $category->slug) }}" title="{{ $category->category_name }} News">
                {{ $category->category_name }}
            </a>
        </h1>
    </section>

    <section class="travel-section">

        <div class="travel-grid">

            @forelse($articles as $item)

                <article class="travel-card">

                    <!-- IMAGE -->
                    <div class="travel-image">
                        <a href="{{ route('news.show', [$item->category->slug, $item->encode_title]) }}" title="{{ $item->news_title }}">
                            <img src="{{ url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $item->photo) }}"
                                alt="{{ $item->news_title }}">
                        </a>
                    </div>

                    <!-- TITLE -->
                    <h3>
                        @php
                            $position = $articles->firstItem() + $loop->index;
                        @endphp

                        @if(($position - 1) % 5 == 0)
                            <span class="live">Live Updates:</span>
                        @endif

                        <a href="{{ route('news.show', [$item->category->slug, $item->encode_title]) }}" title="{{ $item->news_title }}">
                            {{ $item->news_title }}
                        </a>
                    </h3>

                    <!-- EXCERPT -->
                    <p>
                        {{ Str::limit(strip_tags($item->news_content_short), 120) }}
                    </p>

                    <!-- AUTHOR + BOOKMARK ROW -->
                    <div class="travel-meta">

                        <span class="meta">
                            By
                            @if($item->author)
                                <a href="{{ route('author.show', $item->author->slug) }}" title="{{ $item->author->name }}">
                                    <strong>{{ $item->author->name }}</strong>
                                </a>
                            @else
                                Editorial Desk
                            @endif
                        </span>

                        <!-- IMPORTANT: data-id added -->
                        <button class="bookmark-btn" data-id="{{ $item->news_id }}" aria-label="Save article">
                            <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                            </svg>
                        </button>

                    </div>

                </article>

            @empty
                <p style="padding:20px;">No articles found in this category.</p>
            @endforelse

        </div>

        <!-- Pagination -->
        <div class="pagination-wrapper">
            {{ $articles->links() }}
        </div>

    </section>

    <hr class="custom-line">

@endsection
