@php use Illuminate\Support\Str; @endphp
@section('title', $author->name . ' | News Author')
@section('schema')
@php
$authorSchema = [
    "@context" => "https://schema.org",
    "@type" => "Person",
    "name" => $author->name,
    "url" => route('author.show', $author->slug),
    "jobTitle" => $author->designation ?? 'Journalist',
    "description" => $author->bio ?? '',
    "image" => $author->image
        ? asset('assets/images/authors/' . $author->image)
        : asset('assets/images/no-image.webp')
];
@endphp

<script type="application/ld+json">
{!! json_encode($authorSchema, JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT) !!}
</script>
@endsection
@extends('layouts.app')

@section('content')

    <section class="author-section">
        <div class="author-container">
            <meta itemprop="url" content="{{ route('author.show',$author->slug) }}">

            <div class="author-info">

                <img src="{{ $author->image ? asset('assets/images/authors/' . $author->image) : asset('assets/images/no-image.webp') }}"
                    alt="{{ $author->name }}" class="author-image">

                <div class="author-details">

                    <div class="author-header">
                        <h1 class="author-name" itemprop="name">{{ $author->name }}</h1>
                        <button class="follow-btn">+ Follow</button>
                    </div>

                    <p class="author-bio">
                        {{ $author->bio }}
                    </p>

                    <p class="author-title">
                        {{ $author->designation }}
                    </p>

                </div>
            </div>
        </div>
    </section>

    <section class="travel-section">

        <div class="travel-grid">

            @forelse($articles as $index => $item)

                <article class="travel-card">

                    <div class="travel-image">
                        <a href="{{ route('news.show', [$item->category->slug, $item->encode_title]) }}" title="{{ $item->news_title }}">
                            <img src="{{ url('https://financial-journal.xyz/newspaper/cms/public/uploads/' . $item->photo) }}"
                                alt="{{ $item->news_title }}">
                        </a>
                    </div>

                    <h3>

                        {{-- every 5th article live label --}}
                        @if($index % 5 == 0)
                            <span class="live">Live Updates:</span>
                        @endif

                        <a href="{{ route('news.show', [$item->category->slug, $item->encode_title]) }}" title="{{ $item->news_title }}">
                            {{ $item->news_title }}
                        </a>
                    </h3>

                    <p>
                        {{ Str::limit(strip_tags($item->news_content_short), 120) }}
                    </p>

                    <div class="travel-meta">

                        <span class="meta">
                            By
                            @if($item->author)
                                <a href="{{ route('author.show', $item->author->slug) }}" title="{{ $item->author->name }}">
                                    <strong>{{ $item->author->name }}</strong>
                                </a>
                            @else
                                Editorial Desk
                            @endif
                        </span>

                        <button class="bookmark-btn" data-id="{{ $item->news_id }}" aria-label="Save article">
                            <svg class="bookmark-icon" viewBox="0 0 24 24" fill="none" stroke-width="2">
                                <path d="M6 3h12v18l-6-4-6 4z" stroke="currentColor" />
                            </svg>
                        </button>

                    </div>

                </article>

            @empty
                <p style="padding:20px;">No articles found for this author.</p>
            @endforelse

        </div>

        <div class="pagination-wrapper">
            {{ $articles->links() }}
        </div>

    </section>

    <hr class="custom-line">

@endsection
