<?php

namespace App\Providers;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use App\Models\Category;
use Illuminate\Pagination\Paginator;

class AppServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        //
    }

    public function boot(): void
    {
        if (!app()->environment('local')) {
        URL::forceScheme('https');
        }
    
        URL::forceRootUrl(config('app.url'));
    
            Paginator::useBootstrap();

            View::composer('*', function ($view) {

            $categories = Category::orderBy('category_id')->get();

            $view->with([
                'navCategories' => $categories->take(4),
                'otherCategories' => $categories->skip(4),
                'circleCategories' => $categories
            ]);
        });
    }
}
