<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Category extends Model
{
    protected $table = 'tbl_category';
    protected $primaryKey = 'category_id';
    public $timestamps = false;

    public $incrementing = true;
    protected $keyType = 'int';

    protected $guarded = [];

    public function news()
    {
        return $this->hasMany(
            \App\Models\News::class,
            'category_id',
            $this->getKeyName()
        );
    }
    public function newsCount()
    {
        return $this->hasMany(\App\Models\News::class, 'category_id', 'category_id');
    }
    public function getSlugAttribute()
    {
        return Str::slug($this->category_name);
    }
}
