<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\News;
use App\Models\Category;

class SitemapController extends Controller
{
    public function index()
    {
        $posts = News::with(['category' => function ($q) {
        $q->select('category_id','slug');
            }])
            ->whereNotNull('encode_title')
            ->whereHas('category')
            ->orderByDesc('news_date')
            ->limit(100)
            ->get();
    
        $categories = Category::select('slug')->get();
    
        $data = [
            'posts' => $posts,
            'categories' => $categories
        ];
    
        $content = view('sitemap', $data)->render();

        return response($content, 200)
                ->header('Content-Type', 'text/xml; charset=UTF-8');
    }
}
