<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\News;

class CategoryController extends Controller
{
    public function show($slug)
    {
        $category = Category::where('slug', $slug)->firstOrFail();

        $articles = News::with(['category','author'])
            ->where('category_id', $category->category_id)
            ->orderBy('published_at','desc')
            ->orderBy('news_id','desc')
            ->paginate(10);

        return view('category', compact('category','articles'));
    }
}
