
// Swap the image src if data-src is present (lazy load)
document.querySelectorAll('.image-frame img[data-src]').forEach(img => {
  const swap = () => { img.src = img.dataset.src; img.removeAttribute('data-src'); };
  if ('IntersectionObserver' in window) {
    const io = new IntersectionObserver((entries) => {
      entries.forEach(e => { if (e.isIntersecting) { swap(); io.disconnect(); } });
    });
    io.observe(img);
  } else { swap(); }
});
// 
