<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Terms and Conditions - Read our terms of service for accessing and using our news website and content.">
    <meta name="keywords" content="terms and conditions, terms of service, news website terms, content usage">
    <link rel="stylesheet" href="css/style.css">
    <title>Terms and Conditions</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f8f9fa;
        }

        header {
            color: black;
            padding: 2rem 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }

         h1 {
            font-size: 2.5rem;
            margin-bottom: 0.5rem;
            font-weight: 700;
            color:black;
        }

        .last-updated {
            font-size: 0.9rem;
            opacity: 0.9;
            margin-top: 0.5rem;
        }

        .content {
            background: white;
            margin: 3rem auto;
            padding: 3rem;
            border-radius: 10px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.08);
            max-width: 1000px;
        }

        h2 {
            color: #000000ff;
            margin: 2rem 0 1rem;
            font-size: 1.8rem;
            padding-bottom: 0.5rem;
            border-bottom: 3px solid #000000ff;
        }

        h3 {
            color: #555;
            margin: 1.5rem 0 0.8rem;
            font-size: 1.3rem;
        }

        p {
            margin-bottom: 1rem;
            text-align: justify;
        }

        ul, ol {
            margin: 1rem 0 1rem 2rem;
        }

        li {
            margin-bottom: 0.5rem;
        }

        .intro {
            background: #f3f3f3ff;
            padding: 1.5rem;
            border-left: 4px solid #3b3b3bff;
            margin-bottom: 2rem;
            border-radius: 5px;
        }

        .important-note {
            background: #f3f3f3ff;
            border-left: 4px solid #3b3b3bff;
            padding: 1.5rem;
            margin: 1.5rem 0;
            border-radius: 5px;
        }

      
        strong {
            color: #555;
        }

        @media (max-width: 768px) {
             h1 {
                font-size: 2rem;
            }

            .content {
                padding: 1.5rem;
                margin: 1.5rem 10px;
            }

            h2 {
                font-size: 1.5rem;
            }

            h3 {
                font-size: 1.2rem;
            }
        }

        @media (max-width: 480px) {
            header h1 {
                font-size: 1.5rem;
            }

            .content {
                padding: 1rem;
            }

            ul, ol {
                margin-left: 1.5rem;
            }
        }
    </style>
</head>
<body>
<div class="top-bar">
        <div class="top-left">

            <img class="menu-togg menu-toggle" src="image/menu.png" alt="menu" width="16" height="16">
            <a title="Logo" href="main.php"> <img class="main-logo" src="image/policynow-logo.png" alt="Logo"></a>
            <!-- <img id="darkModeToggle" src="image/dark-mode.svg" alt="image" width="15" height="15"> -->
        </div>
        <div class="sidebar-overlay" id="sidebarOverlay"></div>
        <div class="sidebar" id="sidebar">

            <nav class="sidebar-nav">
                <div class="nav-section">
                    <div class="nav-grid">
                        <a title="Politics &amp; Policy" href="./politics-and-policy.php" class="nav-item">Politics &amp; Policy</a>
                        <a title="Business &amp; Economy" href="./business-and-innovation.php" class="nav-item">Business &amp; Economy</a>
                        <a title="Global Affairs" href="./global-affairs.php" class="nav-item">Global Affairs</a>
                        <a title="Technology &amp; Innovation" href="./technology-and-innovation.php" class="nav-item">Technology &amp; Innovation</a>
                        <a title="Finance &amp; Markets" href="./finance-and-markets.php" class="nav-item">Finance &amp; Markets</a>
                        <a title="Authors" href="./author.php" class="nav-item">Authors</a>
                    </div>
                </div>

                <div class="social-section">
                    <div class="social-icons">
                        <a title="facebook" href="#" class="social-icon">
                            <img class="menu-toggle" src="image/facebook.png" alt="facebook" width="16" height="16">
                        </a>
                        <a title="twitter" href="#" class="social-icon">
                            <img class="menu-toggle" src="image/twitter.png" alt="twitter" width="16" height="16">
                        </a>

                        <a title="youtube" href="#" class="social-icon">
                            <img class="menu-toggle" src="image/youtube.png" alt="youtube" width="16" height="16">
                        </a>

                    </div>
                </div>
            </nav>
        </div>

    </div>
  <div class="main-container">
    
              <div class="date-row">
            <div class="day">
                <strong><?php echo date("l, F j, Y"); ?></strong>
            </div>
            <div class="top-center">
                <a href="main.php"><img src="image/policynow-logo.png" alt="Logo"></a>
            </div>
            <div class="top-right">
                <img src="image/search.png" class="menu-toggle" alt="search" width="16" height="16">
                <div class="search-box" id="searchBox">
                    <input type="text" placeholder="Type & hit enter">
                    <img src="image/search.png" class="menu-toggle1" alt="search" width="16" height="16">
                </div>
                <img class="menu-toggle" src="image/facebook.png" alt="facebook" width="16" height="16">
                <img class="menu-toggle" src="image/twitter.png" alt="twitter" width="16" height="16">
                <img class="menu-toggle" src="image/youtube.png" alt="youtube" width="16" height="16">
            </div>
        </div>
        <nav class="main-nav1">
             <a title="Politics & Policy" class="nav-l" href="politics-and-policy.php">Politics & Policy</a>
            <a title="Business & Economy" class="nav-l" href="business-and-economy.php">Business & Economy</a>
            <a title="Global Affairs" class="nav-l" href="global-affairs.php">Global Affairs</a>
            <a title="Technology & Innovation" class="nav-l" href="technology-and-innovation.php">Technology & Innovation</a>
            <a title="Finance & Markets" class="nav-l" href="finance-and-markets.php">Finance & Markets</a>
            <a title="Featured PR" class="nav-l" href="featured-pr.php">Featured PR</a>
            <a title="Authors" class="nav-l" href="author.php">Authors</a>
        </nav>
    <main class="container">
      <h1>Terms and conditions</h1>
        <div class="content">
            
            <div class="intro">
                <p><strong>Welcome to our news website.</strong> These Terms and Conditions govern your access to and use of our news content, articles, and services. By accessing or using our website, you agree to be bound by these terms. If you disagree with any part of these terms, please do not use our website.</p>
            </div>

            <h2>1. Acceptance of Terms</h2>
            <p>By accessing and using this news website, you accept and agree to be bound by these terms and conditions. These terms apply to all visitors, readers, and others who access or use our news service.</p>

            <h2>2. Content Usage and Copyright</h2>
            <h3>Our Content Rights</h3>
            <p>All news articles, photographs, videos, graphics, and other content published on this website are protected by copyright laws and are owned by us or our content contributors. Unauthorized reproduction, distribution, or modification of our content is strictly prohibited.</p>
            
            <h3>Personal Use License</h3>
            <p>You may access and read our news content for personal, non-commercial purposes. This limited license allows you to:</p>
            <ul>
                <li>Read and view articles on your personal devices</li>
                <li>Share articles using our designated sharing tools</li>
                <li>Print articles for personal reference</li>
            </ul>
            <p>You may NOT:</p>
            <ul>
                <li>Reproduce, republish, or redistribute our content without permission</li>
                <li>Use our content for commercial purposes</li>
                <li>Remove copyright notices or attributions</li>
                <li>Create derivative works from our content</li>
                <li>Use automated tools to scrape or download content</li>
            </ul>

            <h2>3. User Registration and Accounts</h2>
            <p>Some features of our website may require registration. When creating an account, you agree to:</p>
            <ul>
                <li>Provide accurate, current, and complete information</li>
                <li>Maintain and update your information to keep it accurate</li>
                <li>Maintain the security and confidentiality of your password</li>
                <li>Accept responsibility for all activities under your account</li>
                <li>Notify us immediately of any unauthorized use of your account</li>
            </ul>
            <p>We reserve the right to suspend or terminate accounts that violate these terms or engage in prohibited activities.</p>

            <h2>4. User Comments and Submissions</h2>
            <h3>Comment Policy</h3>
            <p>We welcome reader comments and discussions. By posting comments, you agree that:</p>
            <ul>
                <li>Your comments do not contain illegal, defamatory, or offensive content</li>
                <li>You will not impersonate others or misrepresent your affiliation</li>
                <li>You grant us a non-exclusive license to use, modify, and display your comments</li>
                <li>You are responsible for the content of your submissions</li>
            </ul>
            
            <h3>Prohibited Content</h3>
            <p>Comments and submissions must not contain:</p>
            <ul>
                <li>Hate speech, harassment, or discriminatory content</li>
                <li>False or misleading information</li>
                <li>Spam, advertising, or promotional content</li>
                <li>Personal attacks or abusive language</li>
                <li>Violations of privacy or confidentiality</li>
                <li>Content that infringes intellectual property rights</li>
            </ul>
            <p>We reserve the right to remove any comments that violate this policy without notice.</p>

            <h2>5. Journalistic Standards and Accuracy</h2>
            <p>We strive to provide accurate, fair, and balanced news coverage. However:</p>
            <ul>
                <li>News content may be updated or corrected as new information becomes available</li>
                <li>Opinions expressed in opinion pieces are those of the authors, not necessarily the website</li>
                <li>We make reasonable efforts to verify information but cannot guarantee absolute accuracy</li>
                <li>Breaking news may contain preliminary information subject to change</li>
            </ul>

            <div class="important-note">
                <strong>Corrections Policy:</strong> If you believe we have published inaccurate information, please contact our editorial team. We take accuracy seriously and will investigate and correct errors promptly.
            </div>

            <h2>6. Third-Party Content and Links</h2>
            <p>Our website may contain links to third-party websites, advertisements, or embedded content. We are not responsible for:</p>
            <ul>
                <li>The content, accuracy, or opinions expressed in third-party materials</li>
                <li>The privacy practices of external websites</li>
                <li>Products or services advertised by third parties</li>
            </ul>
            <p>Links to external sites do not constitute endorsement of those sites or their content.</p>

            <h2>7. Advertising and Sponsored Content</h2>
            <p>Our website may display advertisements and sponsored content. We maintain editorial independence, and advertising does not influence our news coverage. Sponsored content will be clearly labeled as such.</p>
            <p>We are not responsible for the claims made in advertisements or the quality of advertised products and services.</p>

            <h2>8. Newsletter and Email Communications</h2>
            <p>If you subscribe to our newsletter or email alerts:</p>
            <ul>
                <li>You consent to receive email communications from us</li>
                <li>You can unsubscribe at any time using the link in our emails</li>
                <li>We will not share your email address with third parties without consent</li>
                <li>We may send service-related announcements when necessary</li>
            </ul>

            <h2>9. Intellectual Property Rights</h2>
            <p>Our website name, logo, design, and branding are our trademarks. You may not use our trademarks without prior written permission. All intellectual property rights in our content remain with us or our licensors.</p>

            <h2>10. News Alerts and Notifications</h2>
            <p>We may offer breaking news alerts and push notifications. By enabling these features:</p>
            <ul>
                <li>You consent to receive time-sensitive news notifications</li>
                <li>You can disable notifications in your device or browser settings</li>
                <li>We will use notifications responsibly and avoid spam</li>
            </ul>

            <h2>11. Prohibited Activities</h2>
            <p>You agree not to:</p>
            <ul>
                <li>Interfere with or disrupt the website's operation</li>
                <li>Attempt to gain unauthorized access to our systems</li>
                <li>Use automated tools or bots without permission</li>
                <li>Collect user information without consent</li>
                <li>Engage in any activity that violates applicable laws</li>
                <li>Upload viruses or malicious code</li>
                <li>Impersonate our staff or other users</li>
            </ul>

            <h2>12. Disclaimer of Warranties</h2>
            <p>Our news website and content are provided "as is" without warranties of any kind. We do not warrant that:</p>
            <ul>
                <li>The website will be uninterrupted or error-free</li>
                <li>All content is completely accurate or current</li>
                <li>The website is free from viruses or harmful components</li>
                <li>Defects will be corrected immediately</li>
            </ul>

            <h2>13. Limitation of Liability</h2>
            <p>To the fullest extent permitted by law, we shall not be liable for any damages arising from:</p>
            <ul>
                <li>Use of or inability to use our website</li>
                <li>Reliance on any content published on our website</li>
                <li>Errors, omissions, or inaccuracies in our content</li>
                <li>Unauthorized access to your account or data</li>
                <li>Third-party content or advertisements</li>
            </ul>

            <h2>14. Indemnification</h2>
            <p>You agree to indemnify and hold us harmless from any claims, damages, or expenses arising from:</p>
            <ul>
                <li>Your violation of these Terms and Conditions</li>
                <li>Your comments or submissions on our website</li>
                <li>Your violation of any third-party rights</li>
                <li>Your use of our website in violation of applicable laws</li>
            </ul>

            <h2>15. Age Restrictions</h2>
            <p>Our website is intended for general audiences. Some content may not be suitable for children. Parents and guardians are responsible for monitoring their children's internet usage. We do not knowingly collect information from children under 13.</p>

            <h2>16. Governing Law and Jurisdiction</h2>
            <p>These Terms and Conditions are governed by the laws of the jurisdiction where our news organization is registered. Any disputes shall be resolved in the courts of that jurisdiction.</p>

            <h2>17. Changes to Content and Services</h2>
            <p>We reserve the right to:</p>
            <ul>
                <li>Modify, suspend, or discontinue any aspect of our website</li>
                <li>Update, correct, or remove content at any time</li>
                <li>Change our website design, features, or functionality</li>
                <li>Introduce new services or features</li>
            </ul>

            <h2>18. Termination</h2>
            <p>We may terminate or suspend your access to our website immediately, without prior notice, if you breach these terms. Upon termination, your right to use the website will cease immediately.</p>

            <h2>19. Severability</h2>
            <p>If any provision of these terms is found to be invalid or unenforceable, the remaining provisions shall continue in full force and effect.</p>

            <h2>20. Changes to Terms</h2>
            <p>We reserve the right to modify these Terms and Conditions at any time. Changes will be posted on this page with an updated "Last Updated" date. Your continued use of the website after changes are posted constitutes acceptance of the modified terms.</p>

           
        </div>
                <footer class="footer-wrapper">
            <div class="footer-grid-layout">

                <!-- Brand & About -->
                <div>
                    <div class="footer-brand-title">
                        <a href="main.php"><img src="image/policynow-logo.png" width="230" height="48" alt="Image"></a>
                    </div>
                    <div class="footer-desc-text">
                        Blending policy analysis + reputation management + PR storytelling — positioning it as a credible publication for thought leaders, policymakers, and business strategists
                    </div>
                   
                </div>

                <!-- Categories -->
                <div>
                    <div class="footer-column-title">CATEGORIES</div>
                    <div class="footer-links">
                        <a title="Politics & Policy" href="../politics-and-policy.php">Politics & Policy</a>
                        <a title="Business & Economy" href="../business-and-economy.php">Business & Economy</a>
                        <a title="Global Affairs" href="../global-affairs.php">Global Affairs</a>
                        <a title="Technology & Innovation" href="../technology-and-innovation.php">Technology & Innovation</a>
                        
                    </div>
                </div>

                <!-- Links -->
                <div>
                    <div class="footer-links">
                        <div class="footer-column-title"></div>
                        <a title="Finance & Markets" href="../finance-and-markets.php">Finance & Markets</a>
                        <a title="Featured PR" href="../featured-pr.php">Featured PR</a>
                        <a title="Authors" href="../author.php">Authors</a>
                    </div>
                </div>

                <!-- About Us -->
                <div>
                    <div class="footer-column-title">ABOUT US</div>
                    <div class="footer-links">
                        <a title="Privacy policy" href="privacy-policy.php">Privacy policy</a>
                        <a title="Terms and Conditions" href="terms-and-conditions.php">Terms and Conditions</a>
                    </div>
                </div>

            </div>

            <!-- Bottom Bar -->
            <div class="footer-bottom-bar">
                © 2025 Policynow. All rights reserved.
            </div>
        </footer>
    </main>
  </div>

</body>
</html>