<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>US government allowed and even helped US firms sell tech used for surveillance in China</title>
    <link rel="stylesheet" href="../css/style.css">
        <meta name="description"
        content="The U.S. government permitted and at times assisted American companies in selling technology later used for surveillance operations inside China">
    <meta property="og:title" content="US government allowed and even helped US firms sell tech used for surveillance in China, AP finds">
    <meta property="og:description"
        content="The U.S. government permitted and at times assisted American companies in selling technology later used for surveillance operations inside China">
    <meta name="keywords" content="US surveillance tech">
    <meta property="og:url" content="https://www.policynow.org/us-government-allowed-and-even-helped-us-firms-sell-tech-used-for-surveillance-in-china">
    <meta property="og:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta property="og:site_name" content="">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_US">
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="US government allowed and even helped US firms sell tech used for surveillance in China, AP finds">
    <meta name="twitter:description"
        content="The U.S. government permitted and at times assisted American companies in selling technology later used for surveillance operations inside China">
    <meta name="twitter:url" content="https://www.policynow.org/us-government-allowed-and-even-helped-us-firms-sell-tech-used-for-surveillance-in-china">
    <meta name="twitter:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta name="twitter:site" content="@policynow">
    <meta name="twitter:creator" content="@policynow">
    <link rel="icon" type="image/x-icon" href="https://www.policynow.org/image/favicon.png">
    <link rel="canonical" href="https://www.policynow.org/us-government-allowed-and-even-helped-us-firms-sell-tech-used-for-surveillance-in-china">
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "NewsArticle",
  "mainEntityOfPage": {
    "@id": "https://www.policynow.org/us-government-allowed-and-even-helped-us-firms-sell-tech-used-for-surveillance-in-china"
  },
  "headline": "US government allowed and even helped US firms sell tech used for surveillance in China, AP finds",
  "image": [
    "https://www.policynow.org/image/twitter-card.png"
  ],
  "datePublished": "2025-11-17T08:28:00-04:00",
  "dateModified": "2025-11-17T08:28:00-04:00",
  "description": "The U.S. government permitted and at times assisted American companies in selling technology later used for surveillance operations inside China",
  "author": {
    "@type": "Person",
    "name": "Editorial Board"
  },
  "publisher": {
    "@type": "Organization",
    "name": "policynow",
    "logo": {
      "@type": "ImageObject",
      "url": "https://www.policynow.org/image/policynow-logo.png"
    }
  },
  "keywords": ["American tech exports",
"China surveillance",
"government involvement",
"US-China technology",
"export oversight",
"surveillance concerns",
"tech accountability",
"AP findings",
"human rights issues"]

}
</script>
</head>

<body class="light-mode">
<?php include '../header.php'; ?>

    <div class="main-container">
        <div class="date-row">
            <div class="day">
                <strong><?php
echo date("l, F j, Y"); 
?></strong>
            </div>

            <div class="top-center">
                <a href="../main.php"><img src="../image/policynow-logo.png"
                    alt="Logo"></a>
            </div>
            <div class="top-right"> 
                <img src="../image/search.png" class="menu-toggle" alt="search" width="16" height="16">
                <div  class="search-box" id="searchBox">
                    <input type="text" placeholder="Type & hit enter">
                     <img  src="../image/search.png" class="menu-toggle1" alt="search" width="16" height="16">
                </div>
                <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                 <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
            </div>
        </div>
        <nav class="main-nav1">
            <a title="Politics & Policy" class="nav-H" href="../politics-and-policy.php">Politics & Policy</a>
            <a title="Business & Economy" class="nav-l" href="../business-and-economy.php">Business & Economy</a>
            <a title="Global Affairs" class="nav-l" href="../global-affairs.php">Global Affairs</a>
            <a title="Technology & Innovation" class="nav-l" href="../technology-and-innovation.php">Technology & Innovation</a>
            <a title="Finance & Markets" class="nav-l" href="../finance-and-markets.php">Finance & Markets</a>
            <a title="Featured PR" class="nav-l" href="../featured-pr.php">Featured PR</a>
            <a title="Author" class="nav-l" href="../author.php">Authors</a>
        </nav>

    </div>
      <div class="main">
          <section class="highlight-news">
            <div class="highlight-category">
                <a title="Technology & Innovation" href="#">Technology & Innovation</a>
            </div>
            <div class="live-sect">
                <span class="live-status">
                    <span class="dot"></span>

                </span>
                <p> <span class="live-badge">LIVE</span>
                    7 days ago</p>
            </div>
            <h1 class="highlight-title">US government allowed and even helped US firms sell tech used for surveillance in China</h1>
            <p class="content-para">U.S. lawmakers have tried four times since September last year to close what they called a glaring loophole: China is getting around export bans on the sale of powerful American AI chips by renting them through U.S. cloud services instead.</p>

            <div class="highlight-footer">
                <div class="author-blocks">
                    <div class="author-card">
                        <img src="../image/joel-j-zarate.jpg"
                            alt="Joel J. Zarate">
                        <div class="author-info">
                            <a title="Joel J. Zarate" href="author.php">Joel J. Zarate</a>
                            <span>NOVEMBER 06, 2025</span>
                        </div>
                    </div>
                    
                </div>

                <div class="share-block">
                    <span>Share this</span>
                    <div class="share-icons">
                        <a title="facebook" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                        </a>
                        <a title="twitter" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                        </a>

                        <a title="youtube" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
                        </a>
                    </div>
                    <div class="share-single">
                        <button>
                            <a title="more" href="#"><i class="fa-solid fa-share-nodes"></i></a>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <div class="img-section">
            <img src="../image/us-government-allowed-and-even-helped.webp"
                alt="US government allowed and even helped">
        </div>

        <div class="second-sec">
<p class="content-para">But the proposals prompted a flurry of activity from more than 100 lobbyists from tech companies and their trade associations trying to weigh in, according to disclosure reports.</p>

<p class="content-para">The result: All four times, the proposal failed, including just last month.</p>

<p class="content-para">Following a long-heralded meeting between leaders Donald Trump and Xi Jinping, the sale of U.S. technology to China remains among the thorniest issues the U.S. faces, with billions of dollars and the future of tech dominance at stake. But the tough talk about China obscures a deeper story: Even while warning about national security and human rights abuse, the U.S. government across five Republican and Democratic administrations has repeatedly allowed and even actively helped American firms to sell technology to Chinese police, government agencies and surveillance companies, an Associated Press investigation has found.</p>

<p class="content-para">And time after time, despite bipartisan attempts, Congress has turned a blind eye to loopholes that allow China to work around its own rules, such as cloud services, third-party resellers, and holes in sanctions passed after the Tiananmen massacre. For example, despite U.S. export rules around advanced chips, China bought $20.7 billion worth of chipmaking equipment from U.S. companies in 2024 to bolster its homegrown industry, a report from a congressional committee this month warned.</p>

<p class="content-para">This reluctance to act reflects the tremendous wealth and power of the tech industry, which is more visible than ever under the Trump administration. And in recent months, the president himself has struck grand deals with Silicon Valley firms that even more closely tie the U.S. economy to tech exports to China, giving taxpayers a direct stake in the profits for the first time.</p>

<p class="content-para">In August, Trump announced a deal with chipmakers Nvidia and AMD to lift export controls on sales of advanced chips to China in exchange for a 15% cut of the revenue, despite concerns from national security experts that such chips will end up in the hands of Chinese military and intelligence services. Trump said after Thursday’s meeting with Xi that China would follow up with Nvidia on the sales of chips but did not announce any resolution. Trump also has announced that the U.S. government has taken a 10 percent stake in Intel worth around $11 billion.</p>

<p class="content-para">Longtime Chinese activist Zhou Fengsuo said the U.S. government is letting American companies set the agenda and ignoring how they help Beijing surveil and censor its own people. In 1989, Zhou was a student leader during the Tiananmen protests, where hundreds and possibly thousands were shot and killed by the Chinese government. Zhou was arrested and imprisoned.</p>

<p class="content-para">Now a U.S. citizen, Zhou testified before Congress in 2024, calling on Washington to investigate the involvement of American tech companies in Chinese surveillance. An AP investigation in September found that American companies to a large degree designed and built China’s surveillance state, playing a far greater role in enabling human rights abuses than previously known.</p>

<p class="content-para">“It’s driven by profit, and that’s why these strategic discussions have been silenced or delayed,” Zhou said. “I’m extremely disappointed. … this is a strategic failure by the United States.”</p>

<p class="content-para"><strong>Hundreds of millions in lobbying</strong></p>

<p class="content-para">The sale of technology to China is contentious among both Republicans and Democrats, with some arguing for a harder stance.</p>

<p class="content-para">They are fighting a powerful opponent. An AP analysis of lobbying filings showed U.S. tech and telecom companies, as well as their trade associations, spent hundreds of millions of dollars over the past two decades on lobbyists who listed key bills impacting China-related trade on their quarterly disclosure reports, among other issues.</p>

<p class="content-para">Tech companies argue that further export restrictions will push China to develop its own domestic supply and strengthen its position in the global race for leadership in artificial intelligence.</p>

<p class="content-para">“Continuing to ban U.S. computing from commercial markets only benefits foreign competition and undercuts President Trump’s efforts to create jobs, reduce the trade deficit, and grow the economy,” Nvidia said in a statement.</p>

<p class="content-para">Nvidia has also said that it does not make surveillance systems or software, does not work with police in China and has not designed its H20 AI chip for police surveillance.</p>

<p class="content-para">Intel, which partnered with a Chinese fingerprinting company as recently as last year, has said the company follows export control policies, and did not address details of its deal with the U.S. government.</p>

<p class="content-para">“The U.S. government’s investment is a passive ownership, with no board representation, governance or information rights,” Intel said in a statement.</p>

<p class="content-para">AMD did not respond. The White House and the Commerce and State departments also did not respond to multiple requests for comment.</p>

<p class="content-para">The AP investigation was based on dozens of open record requests, hundreds of pages of congressional testimony, lobbying disclosures and dozens of interviews with current and former Chinese and American executives, politicians, and former federal officials.</p>

<p class="content-para">Under the cloud services loophole, Chinese companies barred from accessing cutting-edge chips can use Microsoft Azure or Amazon Web Services overseas instead to train their AI models. Microsoft and AWS also both advertise the capacity to store video surveillance footage on their cloud services for Chinese customers.</p>

<p class="content-para">For example, SDIC Contech, a state-owned tech company that works with AI, sought access to AWS and Microsoft Azure big data analytics services, procurement bids show. And Shanghai Qi Zhi Institute, a government-backed research institute working on sensitive technologies such as encryption, sought access to $280,000 worth of Azure OpenAI cloud services from Microsoft.</p>

<p class="content-para">Even sanctioned Chinese companies can use AWS and Microsoft Azure to offer surveillance abilities to customers overseas. For example, despite U.S. sanctions over human rights abuses in Xinjiang in 2019, Dahua and Hikvision, China’s two largest surveillance companies, use AWS to offer networked surveillance abroad, according to marketing material on the company websites. Hikvision markets a video surveillance platform called “HikCentral” to private companies overseas, which can be also deployed on Azure, according to a post on Hikvision’s website this year.</p>

<p class="content-para">Microsoft denied providing services to Hikvision or partnering with them to provide services to others. OpenAI, which provides its advanced AI models through Microsoft’s Azure cloud platform, said it was subject to Microsoft’s policies and doesn’t support China’s access to its services. AWS did not respond on the record to questions about the cloud services loophole.</p>

<p class="content-para">Another enduring loophole is in the restrictions passed after the Tiananmen massacre that didn’t include newer policing technologies, such as security cameras, surveillance drives, or facial recognition systems. In 2006, 2007, 2009, 2011 and 2013, lawmakers introduced bills to try and close the loophole. All failed.</p>

<p class="content-para">The U.S. government under both Republican and Democratic presidents has made other attempts to regulate tech surveillance exports to China. In 2008, the Department of Commerce asked for comment on whether to include “biometric devices” and “integrated security systems” under controlled exports, but ran out of time before the next administration came in. In 2014 and 2015, it tried to tighten controls on surveillance products, but most fell through. In 2024, it sought to restrict exports of face-recognition systems and bar many more military, police, and intelligence end users from receiving U.S. goods, with no success.</p>

<p class="content-para">Some politicians on both sides of the aisle blame the failures in part on the money and political influence of tech companies.</p>

<p class="content-para">“I think we’ve been naive or complicit in the extreme,” said New Jersey GOP Rep. Chris Smith. The U.S., he said, has been “selling and conveying to a malevolent power the ability to destroy us and destroy like-minded Western democracies.”</p>

<p class="content-para">“What do all those companies all have in common? A big wallet,” said Ron Wyden, a Democratic senator from Oregon. “That is as much as anything is what’s behind the fact we haven’t made as much progress.”</p>

<p class="content-para"><strong>A history of failures to close loopholes</strong></p>

<p class="content-para">The first round of U.S. prohibitions on Chinese police came after the Tiananmen massacre and applied to “crime control and detection” equipment. They largely stopped U.S. companies from exporting goods to Chinese entities such as restraints, helmets, shields and batons.</p>

<p class="content-para">But the controls were narrowly confined to largely low-tech goods, leaving out advanced technologies that could be used by police and leading at times to puzzling priorities. U.S. regulators warned sex shops against shipping novelty gold handcuffs to China. At the same time, they broadly permitted Silicon Valley companies to sell routers, servers, software, and more recently, AI-powered surveillance systems to Chinese police.</p>

<p class="content-para">For example, despite explicit restrictions on fingerprint recognition systems, U.S. companies still were able to sell gear to process, store and compare fingerprints.</p>

<p class="content-para">In 2006, with bipartisan support, Smith introduced the Global Online Freedom Act to curtail the involvement of American tech companies in Chinese surveillance. Smith drew parallels with IBM’s sale of computing gear to Nazi Germany, which has been well documented by historians. IBM told AP in a follow-up statement that the claim that IBM knowingly collaborated with Nazi Germany was “false and has been rejected by credible historians.”</p>

<p class="content-para">Associations representing the tech and telecommunications industries and dozens of companies stepped up their lobbying against Smith’s proposal, disclosures show. The companies argued the computers, servers and routers they sold in China were no different from what they sold to other countries. Industry groups and individual companies also submitted hundreds of comments to regulators, hoping to influence China-related export regulations.</p>

<p class="content-para">Smith’s bill went nowhere.</p>

<p class="content-para">“Money talks … When they flood certain members on strategic committees with the money, PAC money and the like, how much easier it is to listen to their narrative that somehow they’re part of the reform?” said Smith.</p>

<p class="content-para">Tech sales to China continued, sometimes with direct government support. Numerous archived webpages show that the U.S. Commercial Service, the export-promoting arm of the Commerce Department, played a crucial role for more than a decade in connecting U.S. vendors to Chinese security agencies and key government officials, including through its marquee Gold Key Matching service.</p>

<p class="content-para">In 2004, the Commercial Service invited American companies selling security technologies and equipment to show off their products at a Chinese security exposition. Two years later, it advertised opportunities for American firms in the “safety and security” market, followed by another publication later describing market opportunities for foreign security products such as inspection control and guard communication systems. Archived webpages also show that under both the George W. Bush and Obama administrations, the Commercial Service steadily promoted U.S. participation in policing trade shows, even those that showcased “biological identification technologies” or were initiated by the Chinese Communist Party.</p>

<p class="content-para">Under Bush, the Commerce Department in 2007 hosted a webinar about how to sell to the Chinese security market and promote surveillance tools to China’s public sector. For just $35, the federal agency could offer attendees “market entry-strategies and long-term market penetration plans,” an archived webpage shows.</p>

<p class="content-para">Jeanette Chu, who then worked at the U.S. Embassy in Beijing and helped give the 2007 webinar, recalled sometimes having concerns.</p>

<p class="content-para">“I used to ask myself all the time, ‘what is the scary potential of each item?’” said Chu, now a national security and trade expert advising industry.</p>

<p class="content-para">Despite promises to nail shut Washington’s revolving door, President Barack Obama — like presidents before and after him — gave former industry lobbyists and allies top jobs, including Eric Hirschhorn in the Commerce Department, who represented a trade group that lobbied for tech companies exporting abroad. Hirschhorn wrote that Beijing’s surveillance abilities were nothing compared to the half-million surveillance cameras blanketing London. He was put in charge of the office that administers U.S. export controls.</p>

        </div>
      </div>

    <!-- Blog Section -->
    <section class="latest-blog-wrapper">
        <h2 class="latest-blog-title">LATEST FROM BLOG</h2>

        <div class="latest-blog-grid">
            <!-- Blog Item 1 -->
            <a title="more" href="../technology-and-innovation/first-major-attempts-to-regulate-ai-face-headwinds-from-all-sides.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/first-major-attempts-to-regulate-ai-face.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">First major attempts to regulate AI face headwinds from all sides</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 2 -->
            <a title="more" href="../technology-and-innovation/massachusetts-official-warns-ai-systems-subject-to-consumer-protection-anti-bias-laws.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/massachusetts-official-warns-ai-systems.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Massachusetts official warns AI systems subject to consumer protection, anti-bias laws</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 3 -->
            <a title="more" href="../technology-and-innovation/tech-industry-tried-reducing-ais-pervasive-bias-now-trump-wants-to-end-its-woke-ai-efforts.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/tech-industry-tried-reducing-ais-pervasive-bias.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Tech industry tried reducing AI’s pervasive bias. Now Trump wants to end its ‘woke AI’ efforts</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 4 -->
            <a title="more" href="../technology-and-innovation/u-s-civil-rights-enforcers-warn-employers-against-biased-ai.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/u-s-civil-rights-enforcers-warn-employers.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">U.S. civil rights enforcers warn employers against biased AI</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 5 -->
            <a title="more" href="../technology-and-innovation/congress-eyes-new-rules-for-tech-whats-under-consideration.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/congress-eyes-new-rules.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Congress eyes new rules for tech: What’s under consideration</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>


        </div>
<?php include '../footer.php'; ?>
    </section>

    <script defer src="../js/style.js" ></script>
</body>

</html>