<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>U.S. civil rights enforcers warn employers against biased AI</title>
    <link rel="stylesheet" href="../css/style.css">
        <meta name="description"
        content="U.S. civil rights officials warn employers that using biased AI in hiring or management could violate federal laws, urging stronger safeguards and oversight">
    <meta property="og:title" content="U.S. civil rights enforcers warn employers against biased AI">
    <meta property="og:description"
        content="U.S. civil rights officials warn employers that using biased AI in hiring or management could violate federal laws, urging stronger safeguards and oversight">
    <meta name="keywords" content="biased AI warning">
    <meta property="og:url" content="https://www.policynow.org/u-s-civil-rights-enforcers-warn-employers-against-biased-ai">
    <meta property="og:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta property="og:site_name" content="">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_US">
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="U.S. civil rights enforcers warn employers against biased AI">
    <meta name="twitter:description"
        content="U.S. civil rights officials warn employers that using biased AI in hiring or management could violate federal laws, urging stronger safeguards and oversight">
    <meta name="twitter:url" content="https://www.policynow.org/u-s-civil-rights-enforcers-warn-employers-against-biased-ai">
    <meta name="twitter:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta name="twitter:site" content="@policynow">
    <meta name="twitter:creator" content="@policynow">
    <link rel="icon" type="image/x-icon" href="https://www.policynow.org/image/favicon.png">
    <link rel="canonical" href="https://www.policynow.org/u-s-civil-rights-enforcers-warn-employers-against-biased-ai">
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "NewsArticle",
  "mainEntityOfPage": {
    "@id": "https://www.policynow.org/u-s-civil-rights-enforcers-warn-employers-against-biased-ai"
  },
  "headline": "U.S. civil rights enforcers warn employers against biased AI",
  "image": [
    "https://www.policynow.org/image/twitter-card.png"
  ],
  "datePublished": "2025-11-17T08:28:00-04:00",
  "dateModified": "2025-11-17T08:28:00-04:00",
  "description": "U.S. civil rights officials warn employers that using biased AI in hiring or management could violate federal laws, urging stronger safeguards and oversight",
  "author": {
    "@type": "Person",
    "name": "Editorial Board"
  },
  "publisher": {
    "@type": "Organization",
    "name": "policynow",
    "logo": {
      "@type": "ImageObject",
      "url": "https://www.policynow.org/image/policynow-logo.png"
    }
  },
  "keywords": ["US civil rights enforcement",
"AI hiring discrimination",
"employer AI compliance",
"AI bias regulations",
"workplace technology oversight",
"federal civil rights laws",
"AI accountability",
"fair hiring practices",
"AI governance"]

}
</script>
</head>

<body class="light-mode">
<?php include '../header.php'; ?>

    <div class="main-container">
        <div class="date-row">
            <div class="day">
                <strong><?php
echo date("l, F j, Y"); 
?></strong>
            </div>

            <div class="top-center">
                <a href="../main.php"><img src="../image/policynow-logo.png"
                    alt="Logo"></a>
            </div>
            <div class="top-right"> 
                <img src="../image/search.png" class="menu-toggle" alt="search" width="16" height="16">
                <div  class="search-box" id="searchBox">
                    <input type="text" placeholder="Type & hit enter">
                     <img  src="../image/search.png" class="menu-toggle1" alt="search" width="16" height="16">
                </div>
                <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                 <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
            </div>
        </div>
        <nav class="main-nav1">
            <a title="Politics & Policy" class="nav-H" href="../politics-and-policy.php">Politics & Policy</a>
            <a title="Business & Economy" class="nav-l" href="../business-and-economy.php">Business & Economy</a>
            <a title="Global Affairs" class="nav-l" href="../global-affairs.php">Global Affairs</a>
            <a title="Technology & Innovation" class="nav-l" href="../technology-and-innovation.php">Technology & Innovation</a>
            <a title="Finance & Markets" class="nav-l" href="../finance-and-markets.php">Finance & Markets</a>
            <a title="Featured PR" class="nav-l" href="../featured-pr.php">Featured PR</a>
            <a title="Author" class="nav-l" href="../author.php">Authors</a>
        </nav>

    </div>
      <div class="main">
          <section class="highlight-news">
            <div class="highlight-category">
                <a title="Technology & Innovation" href="#">Technology & Innovation</a>
            </div>
            <div class="live-sect">
                <span class="live-status">
                    <span class="dot"></span>

                </span>
                <p> <span class="live-badge">LIVE</span>
                    7 days ago</p>
            </div>
            <h1 class="highlight-title">U.S. civil rights enforcers warn employers against biased AI</h1>
<p class="content-para">The federal government said Thursday that artificial intelligence technology to screen new job candidates or monitor worker productivity can unfairly discriminate against people with disabilities, sending a warning to employers that the commonly used hiring tools could violate civil rights laws.</p>


            <div class="highlight-footer">
                <div class="author-blocks">
                    <div class="author-card">
                        <img src="../image/joel-j-zarate.jpg"
                            alt="Joel J. Zarate">
                        <div class="author-info">
                            <a title="Joel J. Zarate" href="author.php">Joel J. Zarate</a>
                            <span>NOVEMBER 05, 2025</span>
                        </div>
                    </div>
                    
                </div>

                <div class="share-block">
                    <span>Share this</span>
                    <div class="share-icons">
                        <a title="facebook" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                        </a>
                        <a title="twitter" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                        </a>

                        <a title="youtube" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
                        </a>
                    </div>
                    <div class="share-single">
                        <button>
                            <a title="more" href="#"><i class="fa-solid fa-share-nodes"></i></a>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <div class="img-section">
            <img src="../image/u-s-civil-rights-enforcers-warn-employers.webp"
                alt="First major attempts to regulate AI face">
        </div>

        <div class="second-sec">

       <p class="content-para">The U.S. Justice Department and the Equal Employment Opportunity Commission jointly issued guidance to employers to take care before using popular algorithmic tools meant to streamline the work of evaluating employees and job prospects — but which could also potentially run afoul of the Americans with Disabilities Act.</p>

<p class="content-para">“We are sounding an alarm regarding the dangers tied to blind reliance on AI and other technologies that we are seeing increasingly used by employers,” Assistant Attorney General Kristen Clarke of the department’s Civil Rights Division told reporters Thursday. “The use of AI is compounding the longstanding discrimination that jobseekers with disabilities face.”</p>

<p class="content-para">Among the examples given of popular work-related AI tools were resume scanners, employee monitoring software that ranks workers based on keystrokes, game-like online tests to assess job skills and video interviewing software that measures a person’s speech patterns or facial expressions.</p>

<p class="content-para">Such technology could potentially screen out people with speech impediments, severe arthritis that slows typing or a range of other physical or mental impairments, the officials said.</p>

<p class="content-para">Tools built to automatically analyze workplace behavior can also overlook on-the-job accommodations — such as a quiet workstation for someone with post-traumatic stress disorder or more frequent breaks for a pregnancy-related disability — that enable employees to modify their work conditions to perform their jobs successfully.</p>

<p class="content-para">Experts have long warned that AI-based recruitment tools — while often pitched as a way of eliminating human bias — can actually entrench bias if they’re taking cues from industries where racial and gender disparities are already prevalent.</p>

<p class="content-para">The move to crack down on the harms they can bring to people with disabilities reflects a broader push by President Joe Biden’s administration to foster positive advancements in AI technology while reining in opaque and largely unregulated AI tools that are being used to make important decisions about people’s lives.</p>

<p class="content-para">“We totally recognize that there’s enormous potential to streamline things,” said Charlotte Burrows, chair of the EEOC, which is responsible for enforcing laws against workplace discrimination. “But we cannot let these tools become a high-tech path to discrimination.”</p>

<p class="content-para">A scholar who has researched bias in AI hiring tools said holding employers accountable for the tools they use is a “great first step,” but added that more work is needed to rein in the vendors that make these tools. Doing so would likely be a job for another agency, such as the Federal Trade Commission, said Ifeoma Ajunwa, a University of North Carolina law professor and founding director of its AI Decision-Making Research Program.</p>

<p class="content-para">“There is now a recognition of how these tools, which are usually deployed as an anti-bias intervention, might actually result in more bias – while also obfuscating it,” Ajunwa said.</p>

<p class="content-para">A Utah company that runs one of the best-known AI-based hiring tools – video interviewing service HireVue – said Thursday that it welcomes the new effort to educate workers, employers and vendors and highlighted its own work in studying how autistic applicants perform on its skills assessments.</p>

<p class="content-para">“We agree with the EEOC and DOJ that employers should have accommodations for candidates with disabilities, including the ability to request an alternate path by which to be assessed,” said the statement from HireVue CEO Anthony Reynolds.</p>

        </div>
      </div>

    <!-- Blog Section -->
    <section class="latest-blog-wrapper">
        <h2 class="latest-blog-title">LATEST FROM BLOG</h2>

                <div class="latest-blog-grid">
            <!-- Blog Item 1 -->
            <a title="more" href="../technology-and-innovation/first-major-attempts-to-regulate-ai-face-headwinds-from-all-sides.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/first-major-attempts-to-regulate-ai-face.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">First major attempts to regulate AI face headwinds from all sides</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 2 -->
            <a title="more" href="../technology-and-innovation/massachusetts-official-warns-ai-systems-subject-to-consumer-protection-anti-bias-laws.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/massachusetts-official-warns-ai-systems.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Massachusetts official warns AI systems subject to consumer protection, anti-bias laws</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 3 -->
            <a title="more" href="../technology-and-innovation/tech-industry-tried-reducing-ais-pervasive-bias-now-trump-wants-to-end-its-woke-ai-efforts.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/tech-industry-tried-reducing-ais-pervasive-bias.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Tech industry tried reducing AI’s pervasive bias. Now Trump wants to end its ‘woke AI’ efforts</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 4 -->
            <a title="more" href="../technology-and-innovation/chatgpt-chief-says-artificial-intelligence-should-be-regulated-by-a-us-or-global-agency.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/chatgpt-chief-says-artificial-intelligence.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">ChatGPT chief says artificial intelligence should be regulated by a US or global agency</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 5 -->
            <a title="more" href="../technology-and-innovation/congress-eyes-new-rules-for-tech-whats-under-consideration.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/congress-eyes-new-rules.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Congress eyes new rules for tech: What’s under consideration</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>


        </div>
<?php include '../footer.php'; ?>
    </section>

    <script defer src="../js/style.js" ></script>
</body>

</html>