<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tech industry tried reducing AI’s pervasive bias. Now Trump wants to end its ‘woke AI’ efforts</title>
    <link rel="stylesheet" href="../css/style.css">
        <meta name="description"
        content="The tech industry has worked to reduce AI bias, but Trump’s new push to end what he calls “woke AI” efforts could undermine safeguards designed to ensure fairness">
    <meta property="og:title" content="Tech industry tried reducing AI’s pervasive bias. Now Trump wants to end its ‘woke AI’ efforts">
    <meta property="og:description"
        content="The tech industry has worked to reduce AI bias, but Trump’s new push to end what he calls “woke AI” efforts could undermine safeguards designed to ensure fairness">
    <meta name="keywords" content="AI bias">
    <meta property="og:url" content="https://www.policynow.org/tech-industry-tried-reducing-ais-pervasive-bias-now-trump-wants-to-end-its-woke-ai-efforts">
    <meta property="og:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta property="og:site_name" content="">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_US">
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Tech industry tried reducing AI’s pervasive bias. Now Trump wants to end its ‘woke AI’ efforts">
    <meta name="twitter:description"
        content="The tech industry has worked to reduce AI bias, but Trump’s new push to end what he calls “woke AI” efforts could undermine safeguards designed to ensure fairness">
    <meta name="twitter:url" content="https://www.policynow.org/tech-industry-tried-reducing-ais-pervasive-bias-now-trump-wants-to-end-its-woke-ai-efforts">
    <meta name="twitter:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta name="twitter:site" content="@policynow">
    <meta name="twitter:creator" content="@policynow">
    <link rel="icon" type="image/x-icon" href="https://www.policynow.org/image/favicon.png">
    <link rel="canonical" href="https://www.policynow.org/tech-industry-tried-reducing-ais-pervasive-bias-now-trump-wants-to-end-its-woke-ai-efforts">
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "NewsArticle",
  "mainEntityOfPage": {
    "@id": "https://www.policynow.org/tech-industry-tried-reducing-ais-pervasive-bias-now-trump-wants-to-end-its-woke-ai-efforts"
  },
  "headline": "Tech industry tried reducing AI’s pervasive bias. Now Trump wants to end its ‘woke AI’ efforts",
  "image": [
    "https://www.policynow.org/image/twitter-card.png"
  ],
  "datePublished": "2025-11-17T08:28:00-04:00",
  "dateModified": "2025-11-17T08:28:00-04:00",
  "description": "The tech industry has worked to reduce AI bias, but Trump’s new push to end what he calls “woke AI” efforts could undermine safeguards designed to ensure fairness",
  "author": {
    "@type": "Person",
    "name": "Editorial Board"
  },
  "publisher": {
    "@type": "Organization",
    "name": "policynow",
    "logo": {
      "@type": "ImageObject",
      "url": "https://www.policynow.org/image/policynow-logo.png"
    }
  },
  "keywords": ["woke AI debate",
"Trump AI policy",
"tech industry bias efforts",
"AI fairness",
"ethical AI",
"AI regulation",
"political impact on AI",
"responsible AI development",
"AI governance"]

}
</script>
</head>

<body class="light-mode">
<?php include '../header.php'; ?>

    <div class="main-container">
        <div class="date-row">
            <div class="day">
                <strong><?php
echo date("l, F j, Y"); 
?></strong>
            </div>

            <div class="top-center">
                <a href="../main.php"><img src="../image/policynow-logo.png"
                    alt="Logo"></a>
            </div>
            <div class="top-right"> 
                <img src="../image/search.png" class="menu-toggle" alt="search" width="16" height="16">
                <div  class="search-box" id="searchBox">
                    <input type="text" placeholder="Type & hit enter">
                     <img  src="../image/search.png" class="menu-toggle1" alt="search" width="16" height="16">
                </div>
                <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                 <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
            </div>
        </div>
        <nav class="main-nav1">
            <a title="Politics & Policy" class="nav-H" href="../politics-and-policy.php">Politics & Policy</a>
            <a title="Business & Economy" class="nav-l" href="../business-and-economy.php">Business & Economy</a>
            <a title="Global Affairs" class="nav-l" href="../global-affairs.php">Global Affairs</a>
            <a title="Technology & Innovation" class="nav-l" href="../technology-and-innovation.php">Technology & Innovation</a>
            <a title="Finance & Markets" class="nav-l" href="../finance-and-markets.php">Finance & Markets</a>
            <a title="Featured PR" class="nav-l" href="../featured-pr.php">Featured PR</a>
            <a title="Author" class="nav-l" href="../author.php">Authors</a>
        </nav>

    </div>
      <div class="main">
          <section class="highlight-news">
            <div class="highlight-category">
                <a title="Technology & Innovation" href="#">Technology & Innovation</a>
            </div>
            <div class="live-sect">
                <span class="live-status">
                    <span class="dot"></span>

                </span>
                <p> <span class="live-badge">LIVE</span>
                    7 days ago</p>
            </div>
            <h1 class="highlight-title">Tech industry tried reducing AI’s pervasive bias. Now Trump wants to end its ‘woke AI’ efforts</h1>
<p class="content-para">After retreating from their workplace diversity, equity and inclusion programs, tech companies could now face a second reckoning over their DEI work in AI products.</p>


            <div class="highlight-footer">
                <div class="author-blocks">
                    <div class="author-card">
                        <img src="../image/joel-j-zarate.jpg"
                            alt="Joel J. Zarate">
                        <div class="author-info">
                            <a title="Joel J. Zarate" href="author.php">Joel J. Zarate</a>
                            <span>NOVEMBER 06, 2025</span>
                        </div>
                    </div>
                    
                </div>

                <div class="share-block">
                    <span>Share this</span>
                    <div class="share-icons">
                        <a title="facebook" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                        </a>
                        <a title="twitter" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                        </a>

                        <a title="youtube" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
                        </a>
                    </div>
                    <div class="share-single">
                        <button>
                            <a title="more" href="#"><i class="fa-solid fa-share-nodes"></i></a>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <div class="img-section">
            <img src="../image/tech-industry-tried-reducing-ais-pervasive-bias.webp"
                alt="First major attempts to regulate AI face">
        </div>

        <div class="second-sec">

       <p class="content-para">In the White House and the Republican-led Congress, “woke AI” has replaced harmful algorithmic discrimination as a problem that needs fixing. Past efforts to “advance equity” in AI development and curb the production of “harmful and biased outputs” are a target of investigation, according to subpoenas sent to Amazon, Google, Meta, Microsoft, OpenAI and 10 other tech companies last month by the House Judiciary Committee.</p>

<p class="content-para">And the standard-setting branch of the U.S. Commerce Department has deleted mentions of AI fairness, safety and “responsible AI” in its appeal for collaboration with outside researchers. It is instead instructing scientists to focus on “reducing ideological bias” in a way that will “enable human flourishing and economic competitiveness,” according to a copy of the document obtained by The Associated Press.</p>

<p class="content-para">In some ways, tech workers are used to a whiplash of Washington-driven priorities affecting their work. But the latest shift has raised concerns among experts in the field, including Harvard University sociologist Ellis Monk, who several years ago was approached by Google to help make its AI products more inclusive.</p>

<p class="content-para">Back then, the tech industry already knew it had a problem with the branch of AI that trains machines to “see” and understand images. Computer vision held great commercial promise but echoed the historical biases found in earlier camera technologies that portrayed Black and brown people in an unflattering light.</p>

<p class="content-para">“Black people or darker skinned people would come in the picture and we’d look ridiculous sometimes,” said Monk, a scholar of colorism, a form of discrimination based on people’s skin tones and other features.</p>

<p class="content-para">Google adopted a color scale invented by Monk that improved how its AI image tools portray the diversity of human skin tones, replacing a decades-old standard originally designed for doctors treating white dermatology patients.</p>

<p class="content-para">“Consumers definitely had a huge positive response to the changes,” he said.</p>

<p class="content-para">Now Monk wonders whether such efforts will continue in the future. While he doesn’t believe that his Monk Skin Tone Scale is threatened because it’s already baked into dozens of products at Google and elsewhere — including camera phones, video games, AI image generators — he and other researchers worry that the new mood is chilling future initiatives and funding to make technology work better for everyone.</p>

<p class="content-para">“Google wants their products to work for everybody, in India, China, Africa, et cetera. That part is kind of DEI-immune,” Monk said. “But could future funding for those kinds of projects be lowered? Absolutely, when the political mood shifts and when there’s a lot of pressure to get to market very quickly.”</p>

<p class="content-para">Trump has cut hundreds of science, technology and health funding grants touching on DEI themes, but its influence on commercial development of chatbots and other AI products is more indirect. In investigating AI companies, Republican Rep. Jim Jordan, chair of the judiciary committee, said he wants to find out whether former President Joe Biden’s administration “coerced or colluded with” them to censor lawful speech.</p>

<p class="content-para">Michael Kratsios, director of the White House’s Office of Science and Technology Policy, said at a Texas event this month that Biden’s AI policies were “promoting social divisions and redistribution in the name of equity.”</p>

<p class="content-para">The Trump administration declined to make Kratsios available for an interview but quoted several examples of what he meant. One was a line from a Biden-era AI research strategy that said: “Without proper controls, AI systems can amplify, perpetuate, or exacerbate inequitable or undesirable outcomes for individuals and communities.”</p>

<p class="content-para">Even before Biden took office, a growing body of research and personal anecdotes was attracting attention to the harms of AI bias.</p>

<p class="content-para">One study showed self-driving car technology has a hard time detecting darker-skinned pedestrians, putting them in greater danger of getting run over. Another study asking popular AI text-to-image generators to make a picture of a surgeon found they produced a white man about 98% percent of the time, far higher than the real proportions even in a heavily male-dominated field.</p>

<p class="content-para">Face-matching software for unlocking phones misidentified Asian faces. Police in U.S. cities wrongfully arrested Black men based on false face recognition matches. And a decade ago, Google’s own photos app sorted a picture of two Black people into a category labeled as “gorillas.”</p>

<p class="content-para">Even government scientists in the first Trump administration concluded in 2019 that facial recognition technology was performing unevenly based on race, gender or age.</p>

<p class="content-para">Biden’s election propelled some tech companies to accelerate their focus on AI fairness. The 2022 arrival of OpenAI’s ChatGPT added new priorities, sparking a commercial boom in new AI applications for composing documents and generating images, pressuring companies like Google to ease its caution and catch up.</p>

<p class="content-para">Then came Google’s Gemini AI chatbot — and a flawed product rollout last year that would make it the symbol of “woke AI” that conservatives hoped to unravel. Left to their own devices, AI tools that generate images from a written prompt are prone to perpetuating the stereotypes accumulated from all the visual data they were trained on.</p>

<p class="content-para">Google’s was no different, and when asked to depict people in various professions, it was more likely to favor lighter-skinned faces and men, and, when women were chosen, younger women, according to the company’s own public research.</p>

<p class="content-para">Google tried to place technical guardrails to reduce those disparities before rolling out Gemini’s AI image generator just over a year ago. It ended up overcompensating for the bias, placing people of color and women in inaccurate historical settings, such as answering a request for American founding fathers with images of men in 18th century attire who appeared to be Black, Asian and Native American. Google quickly apologized and temporarily pulled the plug on the feature, but the outrage became a rallying cry taken up by the political right.</p>

<p class="content-para">With Google CEO Sundar Pichai sitting nearby, Vice President JD Vance used an AI summit in Paris in February to decry the advancement of “downright ahistorical social agendas through AI,” naming the moment when Google’s AI image generator was “trying to tell us that George Washington was Black, or that America’s doughboys in World War I were, in fact, women.”</p>

<p class="content-para">“We have to remember the lessons from that ridiculous moment,” Vance declared at the gathering. “And what we take from it is that the Trump administration will ensure that AI systems developed in America are free from ideological bias and never restrict our citizens’ right to free speech.”</p>

<p class="content-para">A former Biden science adviser who attended that speech, Alondra Nelson, said the Trump administration’s new focus on AI’s “ideological bias” is in some ways a recognition of years of work to address algorithmic bias that can affect housing, mortgages, health care and other aspects of people’s lives.</p>

<p class="content-para">“Fundamentally, to say that AI systems are ideologically biased is to say that you identify, recognize and are concerned about the problem of algorithmic bias, which is the problem that many of us have been worried about for a long time,” said Nelson, the former acting director of the White House’s Office of Science and Technology Policy who co-authored a set of principles to protect civil rights and civil liberties in AI applications.</p>

<p class="content-para">But Nelson doesn’t see much room for collaboration amid the denigration of equitable AI initiatives.</p>

<p class="content-para">“I think in this political space, unfortunately, that is quite unlikely,” she said. “Problems that have been differently named — algorithmic discrimination or algorithmic bias on the one hand, and ideological bias on the other —- will be regrettably seen as two different problems.”</p>

        </div>
      </div>

    <!-- Blog Section -->
    <section class="latest-blog-wrapper">
        <h2 class="latest-blog-title">LATEST FROM BLOG</h2>

        <div class="latest-blog-grid">
            <!-- Blog Item 1 -->
            <a title="more" href="../technology-and-innovation/first-major-attempts-to-regulate-ai-face-headwinds-from-all-sides.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/first-major-attempts-to-regulate-ai-face.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">First major attempts to regulate AI face headwinds from all sides</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 2 -->
            <a title="more" href="../technology-and-innovation/massachusetts-official-warns-ai-systems-subject-to-consumer-protection-anti-bias-laws.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/massachusetts-official-warns-ai-systems.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Massachusetts official warns AI systems subject to consumer protection, anti-bias laws</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 3 -->
            <a title="more" href="../technology-and-innovation/chatgpt-chief-says-artificial-intelligence-should-be-regulated-by-a-us-or-global-agency.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/chatgpt-chief-says-artificial-intelligence.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">ChatGPT chief says artificial intelligence should be regulated by a US or global agency</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 4 -->
            <a title="more" href="../technology-and-innovation/u-s-civil-rights-enforcers-warn-employers-against-biased-ai.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/u-s-civil-rights-enforcers-warn-employers.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">U.S. civil rights enforcers warn employers against biased AI</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 5 -->
            <a title="more" href="../technology-and-innovation/congress-eyes-new-rules-for-tech-whats-under-consideration.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/congress-eyes-new-rules.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Congress eyes new rules for tech: What’s under consideration</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>


        </div>
<?php include '../footer.php'; ?>
    </section>

    <script defer src="../js/style.js" ></script>
</body>

</html>