<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>First major attempts to regulate AI face headwinds from all sides</title>
    <link rel="stylesheet" href="../css/style.css">
        <meta name="description"
        content="Early efforts to regulate artificial intelligence are running into resistance from industry, lawmakers, and advocacy groups, slowing progress on national rules">
    <meta property="og:title" content="First major attempts to regulate AI face headwinds from all sides">
    <meta property="og:description"
        content="Early efforts to regulate artificial intelligence are running into resistance from industry, lawmakers, and advocacy groups, slowing progress on national rules">
    <meta name="keywords" content="AI regulation challenges">
    <meta property="og:url" content="https://www.policynow.org/first-major-attempts-to-regulate-ai-face-headwinds-from-all-sides">
    <meta property="og:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta property="og:site_name" content="">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_US">
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="First major attempts to regulate AI face headwinds from all sides">
    <meta name="twitter:description"
        content="Early efforts to regulate artificial intelligence are running into resistance from industry, lawmakers, and advocacy groups, slowing progress on national rules">
    <meta name="twitter:url" content="https://www.policynow.org/first-major-attempts-to-regulate-ai-face-headwinds-from-all-sides">
    <meta name="twitter:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta name="twitter:site" content="@policynow">
    <meta name="twitter:creator" content="@policynow">
    <link rel="icon" type="image/x-icon" href="https://www.policynow.org/image/favicon.png">
    <link rel="canonical" href="https://www.policynow.org/first-major-attempts-to-regulate-ai-face-headwinds-from-all-sides">
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "NewsArticle",
  "mainEntityOfPage": {
    "@id": "https://www.policynow.org/first-major-attempts-to-regulate-ai-face-headwinds-from-all-sides"
  },
  "headline": "First major attempts to regulate AI face headwinds from all sides",
  "image": [
    "https://www.policynow.org/image/twitter-card.png"
  ],
  "datePublished": "2025-11-17T08:28:00-04:00",
  "dateModified": "2025-11-17T08:28:00-04:00",
  "description": "Early efforts to regulate artificial intelligence are running into resistance from industry, lawmakers, and advocacy groups, slowing progress on national rules",
  "author": {
    "@type": "Person",
    "name": "Editorial Board"
  },
  "publisher": {
    "@type": "Organization",
    "name": "policynow",
    "logo": {
      "@type": "ImageObject",
      "url": "https://www.policynow.org/image/policynow-logo.png"
    }
  },
  "keywords": ["US AI policy",
"artificial intelligence laws",
"tech industry resistance",
"lawmakers debate AI",
"AI governance issues",
"federal AI rules",
"regulatory headwinds",
"AI oversight efforts",
"emerging tech legislation"]

}
</script>
</head>

<body class="light-mode">
<?php include '../header.php'; ?>

    <div class="main-container">
        <div class="date-row">
            <div class="day">
                <strong><?php
echo date("l, F j, Y"); 
?></strong>
            </div>

            <div class="top-center">
                <a href="../main.php"><img src="../image/policynow-logo.png"
                    alt="Logo"></a>
            </div>
            <div class="top-right"> 
                <img src="../image/search.png" class="menu-toggle" alt="search" width="16" height="16">
                <div  class="search-box" id="searchBox">
                    <input type="text" placeholder="Type & hit enter">
                     <img  src="../image/search.png" class="menu-toggle1" alt="search" width="16" height="16">
                </div>
                <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                 <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
            </div>
        </div>
        <nav class="main-nav1">
            <a title="Politics & Policy" class="nav-H" href="../politics-and-policy.php">Politics & Policy</a>
            <a title="Business & Economy" class="nav-l" href="../business-and-economy.php">Business & Economy</a>
            <a title="Global Affairs" class="nav-l" href="../global-affairs.php">Global Affairs</a>
            <a title="Technology & Innovation" class="nav-l" href="../technology-and-innovation.php">Technology & Innovation</a>
            <a title="Finance & Markets" class="nav-l" href="../finance-and-markets.php">Finance & Markets</a>
            <a title="Featured PR" class="nav-l" href="../featured-pr.php">Featured PR</a>
            <a title="Author" class="nav-l" href="../author.php">Authors</a>
        </nav>

    </div>
      <div class="main">
          <section class="highlight-news">
            <div class="highlight-category">
                <a title="Technology & Innovation" href="#">Technology & Innovation</a>
            </div>
            <div class="live-sect">
                <span class="live-status">
                    <span class="dot"></span>

                </span>
                <p> <span class="live-badge">LIVE</span>
                    7 days ago</p>
            </div>
            <h1 class="highlight-title">First major attempts to regulate AI face headwinds from all sides</h1>
<p class="content-para">Artificial intelligence is helping decide which Americans get the job interview, the apartment, even medical care, but the first major proposals to reign in bias in AI decision making are facing headwinds from every direction.</p>


            <div class="highlight-footer">
                <div class="author-blocks">
                    <div class="author-card">
                        <img src="../image/joel-j-zarate.jpg"
                            alt="Claire Payne">
                        <div class="author-info">
                            <a title="Joel J. Zarate" href="author.php">Joel J. Zarate</a>
                            <span>NOVEMBER 05, 2025</span>
                        </div>
                    </div>
                    
                </div>

                <div class="share-block">
                    <span>Share this</span>
                    <div class="share-icons">
                        <a title="facebook" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                        </a>
                        <a title="twitter" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                        </a>

                        <a title="youtube" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
                        </a>
                    </div>
                    <div class="share-single">
                        <button>
                            <a title="more" href="#"><i class="fa-solid fa-share-nodes"></i></a>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <div class="img-section">
            <img src="../image/first-major-attempts-to-regulate-ai-face.webp"
                alt="First major attempts to regulate AI face">
        </div>

        <div class="second-sec">

       <p class="content-para">Lawmakers working on these bills, in states including Colorado, Connecticut and Texas, came together Thursday to argue the case for their proposals as civil rights-oriented groups and the industry play tug-of-war with core components of the legislation.</p>

<p class="content-para">“Every bill we run is going to end the world as we know it. That’s a common thread you hear when you run policies,” Colorado’s Democratic Senate Majority Leader Robert Rodriguez said Thursday. “We’re here with a policy that’s not been done anywhere to the extent that we’ve done it, and it’s a glass ceiling we’re breaking trying to do good policy.”</p>

<p class="content-para">Organizations including labor unions and consumer advocacy groups are pulling for more transparency from companies and greater legal recourse for citizens to sue over AI discrimination. The industry is offering tentative support but digging in its heels over those accountability measures.</p>

<p class="content-para">The group of bipartisan lawmakers caught in the middle — including those from Alaska, Georgia and Virginia — has been working on AI legislation together in the face of federal inaction. On Thursday, they highlighted their work across states and stakeholders, emphasizing the need for AI legislation and reinforcing the importance for collaboration and compromise to avoid regulatory inconsistencies across state lines. They also argued the bills are a first step that can be built on going forward.</p>

<p class="content-para">“It’s a new frontier and in a way, a bit of a wild, wild West,” Alaska’s Republican Sen. Shelley Hughes said at the news conference. “But it is a good reminder that legislation that passed, it’s not in stone, it can be tweaked over time.”</p>

<p class="content-para">While over 400 AI-related bills are being debated this year in statehouses nationwide, most target one industry or just a piece of the technology — such as deepfakes used in elections or to make pornographic images.</p>

<p class="content-para">The biggest bills this team of lawmakers has put forward offer a broad framework for oversight, particularly around one of the technology’s most perverse dilemmas: AI discrimination. Examples include an AI that failed to accurately assess Black medical patients and another that downgraded women’s resumes as it filtered job applications.</p>

<p class="content-para">Still, up to 83% of employers use algorithms to help in hiring, according to estimates from the Equal Employment Opportunity Commission.</p>

<p class="content-para">If nothing is done, there will almost always be bias in these AI systems, explained Suresh Venkatasubramanian, a Brown University computer and data science professor who’s teaching a class on mitigating bias in the design of these algorithms.</p>

<p class="content-para">“You have to do something explicit to not be biased in the first place,” he said.</p>

<p class="content-para">These proposals, mainly in Colorado and Connecticut, are complex, but the core thrust is that companies would be required to perform “impact assessments” for AI systems that play a large role in making decisions for those in the U.S. Those reports would include descriptions of how AI figures into a decision, the data collected and an analysis of the risks of discrimination, along with an explanation of the company’s safeguards.</p>

<p class="content-para">Requiring greater access to information on the AI systems means more accountability and safety for the public. But companies worry it also raises the risk of lawsuits and the revelation of trade secrets.</p>

<p class="content-para">David Edmonson, of TechNet, a bipartisan network of technology CEOs and senior executives that lobbies on AI bills, said in a statement that the organization works with lawmakers to “ensure any legislation addresses AI’s risk while allowing innovation to flourish.”</p>

<p class="content-para">Under bills in Colorado and Connecticut, companies that use AI wouldn’t have to routinely submit impact assessments to the government. Instead, they would be required to disclose to the attorney general if they found discrimination — a government or independent organization wouldn’t be testing these AI systems for bias.</p>

<p class="content-para">Labor unions and academics worry that over reliance on companies self-reporting imperils the public or government’s ability to catch AI discrimination before it’s done harm.</p>

<p class="content-para">“It’s already hard when you have these huge companies with billions of dollars,” said Kjersten Forseth, who represents the Colorado’s AFL-CIO, a federation of labor unions that opposes Colorado’s bill. “Essentially you are giving them an extra boot to push down on a worker or consumer.”</p>

<p class="content-para">The California Chamber of Commerce opposes that state’s bill, concerned that impact assessments could be made public in litigation.</p>

<p class="content-para">Another contentious component of the bills is who can file a lawsuit under the legislation, which the bills generally limit to state attorney generals and other public attorneys — not citizens.</p>

<p class="content-para">After a provision in California’s bill that allowed citizens to sue was stripped out, Workday, a finance and HR software company, endorsed the proposal. Workday argues that civil actions from citizens would leave the decisions up to judges, many of whom are not tech experts, and could result in an inconsistent approach to regulation.</p>

<p class="content-para">Sorelle Friedler, a professor who focuses on AI bias at Haverford College, pushes back.</p>

<p class="content-para">“That’s generally how American society asserts our rights, is by suing,” said Friedler.</p>

<p class="content-para">Connecticut’s Democratic state Sen. James Maroney said there’s been pushback in articles that claim he and Rep. Giovanni Capriglione, R-Texas, have been “pedaling industry-written bills” despite all of the money being spent by the industry to lobby against the legislation.</p>

<p class="content-para">Maroney pointed out one industry group, Consumer Technology Association, has taken out ads and built a website, urging lawmakers to defeat the legislation.</p>

<p class="content-para">“I believe that we are on the right path. We’ve worked together with people from industry, from academia, from civil society,” he said.</p>

<p class="content-para">“Everyone wants to feel safe, and we’re creating regulations that will allow for safe and trustworthy AI,” he added.</p>

        </div>
      </div>

    <!-- Blog Section -->
    <section class="latest-blog-wrapper">
        <h2 class="latest-blog-title">LATEST FROM BLOG</h2>

        <div class="latest-blog-grid">
            <!-- Blog Item 1 -->
            <a title="more" href="../technology-and-innovation/chatgpt-chief-says-artificial-intelligence-should-be-regulated-by-a-us-or-global-agency.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/chatgpt-chief-says-artificial-intelligence.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">ChatGPT chief says artificial intelligence should be regulated by a US or global agency</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 2 -->
            <a title="more" href="../technology-and-innovation/massachusetts-official-warns-ai-systems-subject-to-consumer-protection-anti-bias-laws.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/massachusetts-official-warns-ai-systems.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Massachusetts official warns AI systems subject to consumer protection, anti-bias laws</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 3 -->
            <a title="more" href="../technology-and-innovation/tech-industry-tried-reducing-ais-pervasive-bias-now-trump-wants-to-end-its-woke-ai-efforts.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/tech-industry-tried-reducing-ais-pervasive-bias.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Tech industry tried reducing AI’s pervasive bias. Now Trump wants to end its ‘woke AI’ efforts</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 4 -->
            <a title="more" href="../technology-and-innovation/u-s-civil-rights-enforcers-warn-employers-against-biased-ai.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/u-s-civil-rights-enforcers-warn-employers.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">U.S. civil rights enforcers warn employers against biased AI</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 5 -->
            <a title="more" href="../technology-and-innovation/congress-eyes-new-rules-for-tech-whats-under-consideration.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/congress-eyes-new-rules.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Congress eyes new rules for tech: What’s under consideration</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>


        </div>
<?php include '../footer.php'; ?>
    </section>

    <script defer src="../js/style.js" ></script>
</body>

</html>