<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Congress eyes new rules for tech: What’s under consideration</title>
    <link rel="stylesheet" href="../css/style.css">
        <meta name="description"
        content="Congress is weighing new technology regulations as lawmakers consider proposals on AI, data privacy, online safety, and industry accountability">
    <meta property="og:title" content="Congress eyes new rules for tech: What’s under consideration">
    <meta property="og:description"
        content="Congress is weighing new technology regulations as lawmakers consider proposals on AI, data privacy, online safety, and industry accountability">
    <meta name="keywords" content="Congress tech rules">
    <meta property="og:url" content="https://www.policynow.org/congress-eyes-new-rules-for-tech-whats-under-consideration">
    <meta property="og:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta property="og:site_name" content="">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_US">
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Congress eyes new rules for tech: What’s under consideration">
    <meta name="twitter:description"
        content="Congress is weighing new technology regulations as lawmakers consider proposals on AI, data privacy, online safety, and industry accountability">
    <meta name="twitter:url" content="https://www.policynow.org/congress-eyes-new-rules-for-tech-whats-under-consideration">
    <meta name="twitter:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta name="twitter:site" content="@policynow">
    <meta name="twitter:creator" content="@policynow">
    <link rel="icon" type="image/x-icon" href="https://www.policynow.org/image/favicon.png">
    <link rel="canonical" href="https://www.policynow.org/congress-eyes-new-rules-for-tech-whats-under-consideration">
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "NewsArticle",
  "mainEntityOfPage": {
    "@id": "https://www.policynow.org/congress-eyes-new-rules-for-tech-whats-under-consideration"
  },
  "headline": "Congress eyes new rules for tech: What’s under consideration",
  "image": [
    "https://www.policynow.org/image/twitter-card.png"
  ],
  "datePublished": "2025-11-17T08:28:00-04:00",
  "dateModified": "2025-11-17T08:28:00-04:00",
  "description": "Congress is weighing new technology regulations as lawmakers consider proposals on AI, data privacy, online safety, and industry accountability",
  "author": {
    "@type": "Person",
    "name": "Editorial Board"
  },
  "publisher": {
    "@type": "Organization",
    "name": "policynow",
    "logo": {
      "@type": "ImageObject",
      "url": "https://www.policynow.org/image/policynow-logo.png"
    }
  },
  "keywords": ["US technology regulation",
"AI legislation",
"data privacy laws",
"online safety policy",
"tech industry oversight",
"government regulation",
"lawmakers review tech",
"federal tech proposals",
"policy reform"]

}
</script>
</head>

<body class="light-mode">
<?php include '../header.php'; ?>

    <div class="main-container">
        <div class="date-row">
            <div class="day">
                <strong><?php
echo date("l, F j, Y"); 
?></strong>
            </div>

            <div class="top-center">
                <a href="../main.php"><img src="../image/policynow-logo.png"
                    alt="Logo"></a>
            </div>
            <div class="top-right"> 
                <img src="../image/search.png" class="menu-toggle" alt="search" width="16" height="16">
                <div  class="search-box" id="searchBox">
                    <input type="text" placeholder="Type & hit enter">
                     <img  src="../image/search.png" class="menu-toggle1" alt="search" width="16" height="16">
                </div>
                <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                 <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
            </div>
        </div>
        <nav class="main-nav1">
            <a title="Politics & Policy" class="nav-H" href="../politics-and-policy.php">Politics & Policy</a>
            <a title="Business & Economy" class="nav-l" href="../business-and-economy.php">Business & Economy</a>
            <a title="Global Affairs" class="nav-l" href="../global-affairs.php">Global Affairs</a>
            <a title="Technology & Innovation" class="nav-l" href="../technology-and-innovation.php">Technology & Innovation</a>
            <a title="Finance & Markets" class="nav-l" href="../finance-and-markets.php">Finance & Markets</a>
            <a title="Featured PR" class="nav-l" href="../featured-pr.php">Featured PR</a>
            <a title="Author" class="nav-l" href="../author.php">Authors</a>
        </nav>

    </div>
      <div class="main">
          <section class="highlight-news">
            <div class="highlight-category">
                <a title="Technology & Innovation" href="#">Technology & Innovation</a>
            </div>
            <div class="live-sect">
                <span class="live-status">
                    <span class="dot"></span>

                </span>
                <p> <span class="live-badge">LIVE</span>
                    7 days ago</p>
            </div>
            <h1 class="highlight-title">Congress eyes new rules for tech: What’s under consideration</h1>
<p class="content-para">Most Democrats and Republicans agree that the federal government should better regulate the biggest technology companies, particularly social media platforms. But there is very little consensus on how it should be done.</p>


            <div class="highlight-footer">
                <div class="author-blocks">
                    <div class="author-card">
                        <img src="../image/joel-j-zarate.jpg"
                            alt="Joel J. Zarate">
                        <div class="author-info">
                            <a title="Joel J. Zarate" href="author.php">Joel J. Zarate</a>
                            <span>NOVEMBER 06, 2025</span>
                        </div>
                    </div>
                    
                </div>

                <div class="share-block">
                    <span>Share this</span>
                    <div class="share-icons">
                        <a title="facebook" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                        </a>
                        <a title="twitter" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                        </a>

                        <a title="youtube" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
                        </a>
                    </div>
                    <div class="share-single">
                        <button>
                            <a title="more" href="#"><i class="fa-solid fa-share-nodes"></i></a>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <div class="img-section">
            <img src="../image/congress-eyes-new-rules.webp"
                alt="Congress eyes new rules">
        </div>

        <div class="second-sec">

      <p class="content-para">Should TikTok be banned? Should younger children be kept off social media? Can the government make sure private information is secure? What about brand new artificial intelligence interfaces? Or should users be regulating themselves, leaving the government out of it?</p>

<p class="content-para">Tech regulation is gathering momentum on Capitol Hill as concerns skyrocket about China’s ownership of TikTok and as parents navigating a post-pandemic mental health crisis have grown increasingly worried about what their children are seeing online. Lawmakers have introduced a slew of bipartisan bills, boosting hopes of compromise. But any effort to regulate the mammoth industry would face major obstacles as technology companies have fought interference.</p>

<p class="content-para">Noting that many young people are struggling, President Joe Biden said in his February State of the Union speech that “it’s time” to pass bipartisan legislation to impose stricter limits on the collection of personal data and ban targeted advertising to children.</p>

<p class="content-para">“We must finally hold social media companies accountable for the experiment they are running on our children for profit,” Biden said.</p>

<p class="content-para">Tech companies have aggressively fought any federal interference, and they have operated for decades now without strict federal oversight, making any new rules or guidelines that much more complicated. A look at some of the areas of potential regulation:</p>

<p class="content-para"><strong>CHILDREN’S SAFETY</strong></p>

<p class="content-para">Several House and Senate bills would try to make social media, and the internet in general, safer for children who will inevitably be online. Lawmakers cite numerous examples of teenagers who have taken their own lives after cyberbullying or died engaging in dangerous behavior encouraged on social media.</p>

<p class="content-para">In the Senate, at least two competing bills are focused on children’s online safety. Legislation by Sens. Richard Blumenthal, D-Conn., and Marsha Blackburn, R-Tenn., approved by the Senate Commerce Committee last year would require social media companies to be more transparent about their operations and enable child safety settings by default. Minors would have the option to disable addictive product features and algorithms that push certain content.</p>

<p class="content-para">The idea, the senators say, is that platforms should be “safe by design.” The legislation, which Blumenthal and Blackburn reintroduced last week, would also obligate social media companies to prevent certain dangers to minors — including promotion of suicide, disordered eating, substance abuse, sexual exploitation and other illegal behaviors.</p>

<p class="content-para">A second bill introduced last month by four senators — Democratic Sens. Brian Schatz of Hawaii and Chris Murphy of Connecticut and Republican Sens. Tom Cotton of Arkansas and Katie Britt of Alabama — would take a more aggressive approach, prohibiting children under the age of 13 from using social media platforms and requiring parental consent for teenagers. It would also prohibit the companies from recommending content through algorithms for users under the age of 18. Senate Majority Leader Chuck Schumer, D-N.Y., has not weighed in on specific legislation but told reporters last week, “I believe we need some kind of child protections” on the internet.</p>

<p class="content-para">Critics of the bills, including some civil rights groups and advocacy groups aligned with tech companies, say the proposals could threaten teens’ online privacy and prevent them from accessing content that could help them, such as resources for those considering suicide or grappling with their sexual and gender identity.</p>

<p class="content-para">“Lawmakers should focus on educating and empowering families to control their online experience,” said Carl Szabo of NetChoice, a group aligned with Meta, TikTok, Google and Amazon, among other companies.</p>

<p class="content-para"><strong>DATA PRIVACY</strong></p>

<p class="content-para">Biden’s State of the Union remarks appeared to be a nod toward legislation by Sens. Ed Markey, D-Mass., and Bill Cassidy, R-La., that would expand child privacy protections online, prohibiting companies from collecting personal data from younger teenagers and banning targeted advertising to children and teens. The bill, also reintroduced last week, would create a so-called “eraser button” allowing parents and kids to eliminate personal data, when possible.</p>

<p class="content-para">A broader House effort would attempt to give adults as well as children more control over their data with what lawmakers call a “national privacy standard.” Legislation that passed the House Energy and Commerce Committee with wide bipartisan support last year would try to minimize data collected and make it illegal to target ads to children, usurping state laws that have tried to put privacy restrictions in place. But the bill, which would have also given consumers more rights to file lawsuits over privacy violations, never reached the House floor.</p>

<p class="content-para">Prospects for the House legislation are unclear now that Republicans have the majority. House Energy and Commerce Chairwoman Cathy McMorris Rodgers, R-Wash., has made the issue a priority, holding several hearings on data privacy. But the committee has not yet moved forward with a new bill.</p>

<p class="content-para"><strong>TIKTOK BAN/CHINA</strong></p>

<p class="content-para">Lawmakers introduced a raft of bills to either ban TikTok or make it easier to ban it after a combative March House hearing in which lawmakers from both parties grilled TikTok CEO Shou Zi Chew over his company’s ties to China’s communist government, data security and harmful content on the app.</p>

<p class="content-para">Chew attempted to assure lawmakers that the hugely popular video-sharing app prioritizes user safety and should not be banned due to its Chinese connections. But the testimony gave new momentum to the efforts.</p>

<p class="content-para">Soon after the hearing, Missouri Sen. Josh Hawley, a Republican, tried to force a Senate vote on legislation that would ban TikTok from operating in the United States. But he was blocked by a fellow Republican, Kentucky Sen. Rand Paul, who said that a ban would violate the Constitution and anger the millions of voters who use the app.</p>

<p class="content-para">Another bill sponsored by Republican Sen. Marco Rubio of Florida would, like Hawley’s bill, ban U.S. economic transactions with TikTok, but it would also create a new framework for the executive branch to block any foreign apps deemed hostile. His bill is cosponsored by Reps. Raja Krishnamoorthi, D-Ill., and Mike Gallagher, R-Wis.</p>

<p class="content-para">There is broad Senate support for bipartisan legislation sponsored by Senate Intelligence Committee Chairman Mark Warner, D-Va., and South Dakota Sen. John Thune, the No. 2 Senate Republican, that does not specifically call out TikTok but would give the Commerce Department power to review and potentially restrict foreign threats to technology platforms.</p>

<p class="content-para">The White House has signaled it would back that bill, but it is unclear if it will be brought up in the Senate or if it could garner support among House Republicans.</p>

<p class="content-para">TikTok has launched an extensive lobbying campaign for its survival, including by harnessing influencers and young voters to argue that the app isn’t harmful.</p>

<p class="content-para"><strong>ARTIFICIAL INTELLIGENCE</strong></p>

<p class="content-para">A newer question for Congress is whether lawmakers should move to regulate artificial intelligence as rapidly developing and potentially revolutionary products like AI chatbot ChatGPT begin to enter the marketplace and can in many ways mimic human behavior.</p>

<p class="content-para">Senate leader Schumer has made the emerging technology a priority, arguing that the United States needs to stay ahead of China and other countries that are eyeing regulations on AI products. He has been working with AI experts and has released a general framework of what regulation could look like, including increased disclosure of the people and data involved in developing the technology, more transparency and explanation for how the bots arrive at responses.</p>

<p class="content-para">Schumer has said that any eventual regulation should “prevent potentially catastrophic damage to our country while simultaneously making sure the U.S. advances and leads in this transformative technology.”</p>

<p class="content-para">The White House has been focused on the issue as well, with a recent announcement of a $140 million investment to establish seven new AI research institutes. Vice President Kamala Harris met Thursday with the heads of Google, Microsoft and other companies developing AI products.</p>
        </div>
      </div>

    <!-- Blog Section -->
    <section class="latest-blog-wrapper">
        <h2 class="latest-blog-title">LATEST FROM BLOG</h2>

        <div class="latest-blog-grid">
            <!-- Blog Item 1 -->
            <a title="more" href="../technology-and-innovation/first-major-attempts-to-regulate-ai-face-headwinds-from-all-sides.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/first-major-attempts-to-regulate-ai-face.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">First major attempts to regulate AI face headwinds from all sides</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 2 -->
            <a title="more" href="../technology-and-innovation/massachusetts-official-warns-ai-systems-subject-to-consumer-protection-anti-bias-laws.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/massachusetts-official-warns-ai-systems.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Massachusetts official warns AI systems subject to consumer protection, anti-bias laws</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 3 -->
            <a title="more" href="../technology-and-innovation/tech-industry-tried-reducing-ais-pervasive-bias-now-trump-wants-to-end-its-woke-ai-efforts.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/tech-industry-tried-reducing-ais-pervasive-bias.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Tech industry tried reducing AI’s pervasive bias. Now Trump wants to end its ‘woke AI’ efforts</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 4 -->
            <a title="more" href="../technology-and-innovation/u-s-civil-rights-enforcers-warn-employers-against-biased-ai.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/u-s-civil-rights-enforcers-warn-employers.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">U.S. civil rights enforcers warn employers against biased AI</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 5 -->
            <a title="more" href="../technology-and-innovation/chatgpt-chief-says-artificial-intelligence-should-be-regulated-by-a-us-or-global-agency.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/chatgpt-chief-says-artificial-intelligence.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">ChatGPT chief says artificial intelligence should be regulated by a US or global agency</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>


        </div>
<?php include '../footer.php'; ?>
    </section>

    <script defer src="../js/style.js" ></script>
</body>

</html>