<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ChatGPT chief says artificial intelligence should be regulated by a US or global agency</title>
    <link rel="stylesheet" href="../css/style.css">
        <meta name="description"
        content="The ChatGPT chief urges the creation of a US or global agency to regulate artificial intelligence, highlighting the need for oversight as AI rapidly expands">
    <meta property="og:title" content="A top Federal Reserve official says dour jobs data backs the case for 3 rate cuts">
    <meta property="og:description"
        content="The ChatGPT chief urges the creation of a US or global agency to regulate artificial intelligence, highlighting the need for oversight as AI rapidly expands">
    <meta name="keywords" content="ChatGPT chief">
    <meta property="og:url" content="https://www.policynow.org/chatgpt-chief-says-artificial-intelligence-should-be-regulated-by-a-us-or-global-agency">
    <meta property="og:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta property="og:site_name" content="">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_US">
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="A top Federal Reserve official says dour jobs data backs the case for 3 rate cuts">
    <meta name="twitter:description"
        content="The ChatGPT chief urges the creation of a US or global agency to regulate artificial intelligence, highlighting the need for oversight as AI rapidly expands">
    <meta name="twitter:url" content="https://www.policynow.org/chatgpt-chief-says-artificial-intelligence-should-be-regulated-by-a-us-or-global-agency">
    <meta name="twitter:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta name="twitter:site" content="@policynow">
    <meta name="twitter:creator" content="@policynow">
    <link rel="icon" type="image/x-icon" href="https://www.policynow.org/image/favicon.png">
    <link rel="canonical" href="https://www.policynow.org/chatgpt-chief-says-artificial-intelligence-should-be-regulated-by-a-us-or-global-agency">
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "NewsArticle",
  "mainEntityOfPage": {
    "@id": "https://www.policynow.org/chatgpt-chief-says-artificial-intelligence-should-be-regulated-by-a-us-or-global-agency"
  },
  "headline": "A top Federal Reserve official says dour jobs data backs the case for 3 rate cuts",
  "image": [
    "https://www.policynow.org/image/twitter-card.png"
  ],
  "datePublished": "2025-11-17T08:28:00-04:00",
  "dateModified": "2025-11-17T08:28:00-04:00",
  "description": "The ChatGPT chief urges the creation of a US or global agency to regulate artificial intelligence, highlighting the need for oversight as AI rapidly expands",
  "author": {
    "@type": "Person",
    "name": "Editorial Board"
  },
  "publisher": {
    "@type": "Organization",
    "name": "policynow",
    "logo": {
      "@type": "ImageObject",
      "url": "https://www.policynow.org/image/policynow-logo.png"
    }
  },
  "keywords": ["AI regulation" ,
"global AI agency" ,
"US AI oversight" ,
"artificial intelligence policy" ,
"AI governance" ,
"tech regulation" ,
"AI oversight agency" ,
"AI safety" ,
"AI industry standards"]

}
</script>
</head>

<body class="light-mode">
<?php include '../header.php'; ?>

    <div class="main-container">
        <div class="date-row">
            <div class="day">
                <strong><?php
echo date("l, F j, Y"); 
?></strong>
            </div>

            <div class="top-center">
                <a href="../main.php"><img src="../image/policynow-logo.png"
                    alt="Logo"></a>
            </div>
            <div class="top-right"> 
                <img src="../image/search.png" class="menu-toggle" alt="search" width="16" height="16">
                <div  class="search-box" id="searchBox">
                    <input type="text" placeholder="Type & hit enter">
                     <img  src="../image/search.png" class="menu-toggle1" alt="search" width="16" height="16">
                </div>
                <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                 <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
            </div>
        </div>
        <nav class="main-nav1">
            <a title="Politics & Policy" class="nav-H" href="../politics-and-policy.php">Politics & Policy</a>
            <a title="Business & Economy" class="nav-l" href="../business-and-economy.php">Business & Economy</a>
            <a title="Global Affairs" class="nav-l" href="../global-affairs.php">Global Affairs</a>
            <a title="Technology & Innovation" class="nav-l" href="../technology-and-innovation.php">Technology & Innovation</a>
            <a title="Finance & Markets" class="nav-l" href="../finance-and-markets.php">Finance & Markets</a>
            <a title="Featured PR" class="nav-l" href="../featured-pr.php">Featured PR</a>
            <a title="Author" class="nav-l" href="../author.php">Authors</a>
        </nav>

    </div>
      <div class="main">
          <section class="highlight-news">
            <div class="highlight-category">
                <a title="
Technology & Innovation" href="#">
Technology & Innovation</a>
            </div>
            <div class="live-sect">
                <span class="live-status">
                    <span class="dot"></span>

                </span>
                <p> <span class="live-badge">LIVE</span>
                    7 days ago</p>
            </div>
            <h1 class="highlight-title">ChatGPT chief says artificial intelligence should be regulated by a US or global agency</h1>
<p class="content-para">The head of the artificial intelligence company that makes ChatGPT told Congress on Tuesday that government intervention will be critical to mitigating the risks of increasingly powerful AI systems.</p>


            <div class="highlight-footer">
                <div class="author-blocks">
                    <div class="author-card">
                        <img src="../image/joel-j-zarate.jpg"
                            alt="Joel J. Zarate">
                        <div class="author-info">
                            <a title="CLAIRE PAYNE" href="author..jpg">Joel J. Zarate</a>
                            <span>NOVEMBER 05, 2025</span>
                        </div>
                    </div>
                    
                </div>

                <div class="share-block">
                    <span>Share this</span>
                    <div class="share-icons">
                        <a title="facebook" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                        </a>
                        <a title="twitter" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                        </a>

                        <a title="youtube" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
                        </a>
                    </div>
                    <div class="share-single">
                        <button>
                            <a title="more" href="#"><i class="fa-solid fa-share-nodes"></i></a>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <div class="img-section">
            <img src="../image/chatgpt-chief-says-artificial-intelligence.webp"
                alt="ChatGPT chief says artificial intelligence">
        </div>

        <div class="second-sec">

      <p class="content-para">“As this technology advances, we understand that people are anxious about how it could change the way we live. We are too,” OpenAI CEO Sam Altman said at a Senate hearing.</p>

<p class="content-para">Altman proposed the formation of a U.S. or global agency that would license the most powerful AI systems and have the authority to “take that license away and ensure compliance with safety standards.”</p>

<p class="content-para">His San Francisco-based startup rocketed to public attention after it released ChatGPT late last year. The free chatbot tool answers questions with convincingly human-like responses.</p>

<p class="content-para">What started out as a panic among educators about ChatGPT’s use to cheat on homework assignments has expanded to broader concerns about the ability of the latest crop of “generative AI” tools to mislead people, spread falsehoods, violate copyright protections and upend some jobs.</p>

<p class="content-para">And while there’s no immediate sign Congress will craft sweeping new AI rules, as European lawmakers are doing, the societal concerns brought Altman and other tech CEOs to the White House earlier this month and have led U.S. agencies to promise to crack down on harmful AI products that break existing civil rights and consumer protection laws.</p>

<p class="content-para">Sen. Richard Blumenthal, the Connecticut Democrat who chairs the Senate Judiciary Committee’s subcommittee on privacy, technology and the law, opened the hearing with a recorded speech that sounded like the senator, but was actually a voice clone trained on Blumenthal’s floor speeches and reciting ChatGPT-written opening remarks.</p>

<p class="content-para">The result was impressive, said Blumenthal, but he added, “What if I had asked it, and what if it had provided, an endorsement of Ukraine surrendering or (Russian President) Vladimir Putin’s leadership?”</p>

<p class="content-para">The overall tone of senators’ questioning was polite Tuesday, a contrast to past congressional hearings in which tech and social media executives faced tough grillings over the industry’s failures to manage data privacy or counter harmful misinformation. In part, that was because both Democrats and Republicans said they were interested in seeking Altman’s expertise on averting problems that haven’t yet occurred.</p>

<p class="content-para">Blumenthal said AI companies ought to be required to test their systems and disclose known risks before releasing them, and expressed particular concern about how future AI systems could destabilize the job market. Altman was largely in agreement, though had a more optimistic take on the future of work.</p>

<p class="content-para">Pressed on his own worst fear about AI, Altman mostly avoided specifics, except to say that the industry could cause “significant harm to the world” and that “if this technology goes wrong, it can go quite wrong.”</p>

<p class="content-para">But he later proposed that a new regulatory agency should impose safeguards that would block AI models that could “self-replicate and self-exfiltrate into the wild” — hinting at futuristic concerns about advanced AI systems that could manipulate humans into ceding control.</p>

<p class="content-para">That focus on a far-off “science fiction trope” of super-powerful AI could make it harder to take action against already existing harms that require regulators to dig deep on data transparency, discriminatory behavior and potential for trickery and disinformation, said a former Biden administration official who co-authored its plan for an AI bill of rights.</p>

<p class="content-para">“It’s the fear of these (super-powerful) systems and our lack of understanding of them that is making everyone have a collective freak-out,” said Suresh Venkatasubramanian, a Brown University computer scientist who was assistant director for science and justice at the White House Office of Science and Technology Policy. “This fear, which is very unfounded, is a distraction from all the concerns we’re dealing with right now.”</p>

<p class="content-para">OpenAI has expressed those existential concerns since its inception. Co-founded by Altman in 2015 with backing from tech billionaire Elon Musk, the startup has evolved from a nonprofit research lab with a safety-focused mission into a business. Its other popular AI products include the image-maker DALL-E. Microsoft has invested billions of dollars into the startup and has integrated its technology into its own products, including its search engine Bing.</p>

<p class="content-para">Altman is also planning to embark on a worldwide tour this month to national capitals and major cities across six continents to talk about the technology with policymakers and the public. On the eve of his Senate testimony, he dined with dozens of U.S. lawmakers, several of whom told CNBC they were impressed by his comments.</p>

<p class="content-para">Also testifying were IBM’s chief privacy and trust officer, Christina Montgomery, and Gary Marcus, a professor emeritus at New York University who was among a group of AI experts who called on OpenAI and other tech firms to pause their development of more powerful AI models for six months to give society more time to consider the risks. The letter was a response to the March release of OpenAI’s latest model, GPT-4, described as more powerful than ChatGPT.</p>

<p class="content-para">The panel’s ranking Republican, Sen. Josh Hawley of Missouri, said the technology has big implications for elections, jobs and national security. He said Tuesday’s hearing marked “a critical first step towards understanding what Congress should do.”</p>

<p class="content-para">A number of tech industry leaders have said they welcome some form of AI oversight but have cautioned against what they see as overly heavy-handed rules. Altman and Marcus both called for an AI-focused regulator, preferably an international one, with Altman citing the precedent of the U.N.’s nuclear agency and Marcus comparing it to the U.S. Food and Drug Administration. But IBM’s Montgomery instead asked Congress to take a “precision regulation” approach.</p>

<p class="content-para">“We think that AI should be regulated at the point of risk, essentially,” Montgomery said, by establishing rules that govern the deployment of specific uses of AI rather than the technology itself.</p>
        </div>
      </div>

    <!-- Blog Section -->
    <section class="latest-blog-wrapper">
        <h2 class="latest-blog-title">LATEST FROM BLOG</h2>

        <div class="latest-blog-grid">
            <!-- Blog Item 1 -->
            <a title="more" href="../technology-and-innovation/first-major-attempts-to-regulate-ai-face-headwinds-from-all-sides.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/first-major-attempts-to-regulate-ai-face.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">First major attempts to regulate AI face headwinds from all sides</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 2 -->
            <a title="more" href="../technology-and-innovation/massachusetts-official-warns-ai-systems-subject-to-consumer-protection-anti-bias-laws.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/massachusetts-official-warns-ai-systems.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Massachusetts official warns AI systems subject to consumer protection, anti-bias laws</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 3 -->
            <a title="more" href="../technology-and-innovation/tech-industry-tried-reducing-ais-pervasive-bias-now-trump-wants-to-end-its-woke-ai-efforts.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/tech-industry-tried-reducing-ais-pervasive-bias.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Tech industry tried reducing AI’s pervasive bias. Now Trump wants to end its ‘woke AI’ efforts</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 4 -->
            <a title="more" href="../technology-and-innovation/u-s-civil-rights-enforcers-warn-employers-against-biased-ai.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/u-s-civil-rights-enforcers-warn-employers.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">U.S. civil rights enforcers warn employers against biased AI</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 5 -->
            <a title="more" href="../technology-and-innovation/congress-eyes-new-rules-for-tech-whats-under-consideration.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/congress-eyes-new-rules.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Congress eyes new rules for tech: What’s under consideration</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>


        </div>
<?php include '../footer.php'; ?>
    </section>

    <script defer src="../js/style.js" ></script>
</body>

</html>