<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Privacy Policy - Learn how we collect, use, and protect your personal information.">
    <meta name="keywords" content="privacy policy, data protection, personal information, GDPR">
    <title>Privacy Policy</title>
    <link rel="stylesheet" href="css/style.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f8f9fa;
        }

       
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }

        h1{
            color:black;
        }

        .last-updated {
            font-size: 0.9rem;
            opacity: 0.9;
            margin-top: 0.5rem;
        }

        .content {
            background: white;
            margin: 3rem auto;
            padding: 3rem;
            border-radius: 10px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.08);
            max-width: 1000px;
        }

        h2 {
            color: #000000ff;
            margin: 2rem 0 1rem;
            font-size: 1.8rem;
            padding-bottom: 0.5rem;
            border-bottom: 3px solid #000000ff;
        }

        h3 {
            color: #555;
            margin: 1.5rem 0 0.8rem;
            font-size: 1.3rem;
        }

        p {
            margin-bottom: 1rem;
            text-align: justify;
        }

        ul {
            margin: 1rem 0 1rem 2rem;
        }

        li {
            margin-bottom: 0.5rem;
        }

        .intro {
            background: #f0f4ff;
            padding: 1.5rem;
            border-left: 4px solid #667eea;
            margin-bottom: 2rem;
            border-radius: 5px;
        }

        

        @media (max-width: 768px) {
             h1 {
                font-size: 2rem;
            }

            .content {
                padding: 1.5rem;
                margin: 1.5rem 10px;
            }

            h2 {
                font-size: 1.5rem;
            }

            h3 {
                font-size: 1.2rem;
            }
        }

        @media (max-width: 480px) {
            header h1 {
                font-size: 1.5rem;
            }

            .content {
                padding: 1rem;
            }

            ul {
                margin-left: 1.5rem;
            }
        }
    </style>
</head>
<body>
    <div class="top-bar">
        <div class="top-left">

            <img class="menu-togg menu-toggle" src="image/menu.png" alt="menu" width="16" height="16">
            <a title="Logo" href="main.php"> <img class="main-logo" src="image/policynow-logo.png" alt="Logo"></a>
            <!-- <img id="darkModeToggle" src="image/dark-mode.svg" alt="image" width="15" height="15"> -->
        </div>
        <div class="sidebar-overlay" id="sidebarOverlay"></div>
        <div class="sidebar" id="sidebar">

            <nav class="sidebar-nav">
                <div class="nav-section">
                    <div class="nav-grid">
                        <a title="Politics &amp; Policy" href="./politics-and-policy.php" class="nav-item">Politics &amp; Policy</a>
                        <a title="Business &amp; Economy" href="./business-and-innovation.php" class="nav-item">Business &amp; Economy</a>
                        <a title="Global Affairs" href="./global-affairs.php" class="nav-item">Global Affairs</a>
                        <a title="Technology &amp; Innovation" href="./technology-and-innovation.php" class="nav-item">Technology &amp; Innovation</a>
                        <a title="Finance &amp; Markets" href="./finance-and-markets.php" class="nav-item">Finance &amp; Markets</a>
                        <a title="Authors" href="./author.php" class="nav-item">Authors</a>
                    </div>
                </div>

                <div class="social-section">
                    <div class="social-icons">
                        <a title="facebook" href="#" class="social-icon">
                            <img class="menu-toggle" src="image/facebook.png" alt="facebook" width="16" height="16">
                        </a>
                        <a title="twitter" href="#" class="social-icon">
                            <img class="menu-toggle" src="image/twitter.png" alt="twitter" width="16" height="16">
                        </a>

                        <a title="youtube" href="#" class="social-icon">
                            <img class="menu-toggle" src="image/youtube.png" alt="youtube" width="16" height="16">
                        </a>

                    </div>
                </div>
            </nav>
        </div>

    </div>
     <div class="main-container">
        <div class="date-row">
            <div class="day">
                <strong><?php echo date("l, F j, Y"); ?></strong>
            </div>
            <div class="top-center">
                <a href="main.php"><img src="image/policynow-logo.png" alt="Logo"></a>
            </div>
            <div class="top-right">
                <img src="image/search.png" class="menu-toggle" alt="search" width="16" height="16">
                <div class="search-box" id="searchBox">
                    <input type="text" placeholder="Type & hit enter">
                    <img src="image/search.png" class="menu-toggle1" alt="search" width="16" height="16">
                </div>
                <img class="menu-toggle" src="image/facebook.png" alt="facebook" width="16" height="16">
                <img class="menu-toggle" src="image/twitter.png" alt="twitter" width="16" height="16">
                <img class="menu-toggle" src="image/youtube.png" alt="youtube" width="16" height="16">
            </div>
        </div>
        <nav class="main-nav1">
             <a title="Politics & Policy" class="nav-l" href="politics-and-policy.php">Politics & Policy</a>
            <a title="Business & Economy" class="nav-l" href="business-and-economy.php">Business & Economy</a>
            <a title="Global Affairs" class="nav-l" href="global-affairs.php">Global Affairs</a>
            <a title="Technology & Innovation" class="nav-l" href="technology-and-innovation.php">Technology & Innovation</a>
            <a title="Finance & Markets" class="nav-l" href="finance-and-markets.php">Finance & Markets</a>
            <a title="Featured PR" class="nav-l" href="featured-pr.php">Featured PR</a>
            <a title="Authors" class="nav-l" href="author.php">Authors</a>
        </nav>
             

    <main class="container">
         <h1>Privacy Policy</h1>
        <div class="content">
            <div class="intro">
                <p><strong>Your privacy is important to us.</strong> This Privacy Policy explains how we collect, use, disclose, and safeguard your information when you visit our website or use our services. Please read this privacy policy carefully. If you do not agree with the terms of this privacy policy, please do not access the site.</p>
            </div>

            <h2>1. Information We Collect</h2>
            <h3>Personal Data</h3>
            <p>We may collect personally identifiable information that you voluntarily provide to us when you:</p>
            <ul>
                <li>Register on the website</li>
                <li>Subscribe to our newsletter</li>
                <li>Fill out a contact form</li>
                <li>Make a purchase or transaction</li>
                <li>Participate in surveys or promotions</li>
            </ul>
            <p>This information may include your name, email address, phone number, postal address, payment information, and other details you choose to provide.</p>

            <h3>Automatically Collected Information</h3>
            <p>When you visit our website, we may automatically collect certain information about your device, including:</p>
            <ul>
                <li>IP address and browser type</li>
                <li>Operating system and device information</li>
                <li>Pages visited and time spent on pages</li>
                <li>Referring website addresses</li>
                <li>Clickstream data and cookies</li>
            </ul>

            <h2>2. How We Use Your Information</h2>
            <p>We use the information we collect in the following ways:</p>
            <ul>
                <li>To provide, operate, and maintain our website and services</li>
                <li>To improve, personalize, and expand our services</li>
                <li>To understand and analyze how you use our website</li>
                <li>To develop new products, services, features, and functionality</li>
                <li>To communicate with you for customer service, updates, and marketing</li>
                <li>To process transactions and send related information</li>
                <li>To prevent fraudulent transactions and protect against criminal activity</li>
                <li>To comply with legal obligations and enforce our terms</li>
            </ul>

            <h2>3. Disclosure of Your Information</h2>
            <p>We may share your information in the following situations:</p>
            <ul>
                <li><strong>Service Providers:</strong> With third-party vendors who perform services on our behalf</li>
                <li><strong>Business Transfers:</strong> In connection with mergers, acquisitions, or sale of assets</li>
                <li><strong>Legal Requirements:</strong> When required by law or to protect our rights</li>
                <li><strong>With Your Consent:</strong> When you give us explicit permission to share your data</li>
            </ul>

            <h2>4. Cookies and Tracking Technologies</h2>
            <p>We use cookies and similar tracking technologies to track activity on our website and store certain information. You can instruct your browser to refuse all cookies or to indicate when a cookie is being sent. However, if you do not accept cookies, you may not be able to use some portions of our website.</p>

            <h2>5. Data Security</h2>
            <p>We implement appropriate technical and organizational security measures to protect your personal information. However, no method of transmission over the internet or electronic storage is 100% secure. While we strive to use commercially acceptable means to protect your data, we cannot guarantee its absolute security.</p>

            <h2>6. Your Privacy Rights</h2>
            <p>Depending on your location, you may have the following rights:</p>
            <ul>
                <li><strong>Access:</strong> Request access to your personal data</li>
                <li><strong>Correction:</strong> Request correction of inaccurate data</li>
                <li><strong>Deletion:</strong> Request deletion of your personal data</li>
                <li><strong>Opt-out:</strong> Opt-out of marketing communications</li>
                <li><strong>Data Portability:</strong> Request a copy of your data in a portable format</li>
            </ul>

            <h2>7. Third-Party Links</h2>
            <p>Our website may contain links to third-party websites. We are not responsible for the privacy practices of these external sites. We encourage you to read their privacy policies before providing any personal information.</p>

            <h2>8. Children's Privacy</h2>
            <p>Our services are not directed to individuals under the age of 13. We do not knowingly collect personal information from children. If you become aware that a child has provided us with personal data, please contact us immediately.</p>

            <h2>9. Changes to This Privacy Policy</h2>
            <p>We may update this Privacy Policy from time to time. We will notify you of any changes by posting the new policy on this page and updating the "Last Updated" date. You are advised to review this Privacy Policy periodically for any changes.</p>

          
        </div>
        <footer class="footer-wrapper">
            <div class="footer-grid-layout">

                <!-- Brand & About -->
                <div>
                    <div class="footer-brand-title">
                        <img src="image/policynow-logo.png" width="230" height="26" alt="image">
                    </div>
                    <div class="footer-desc-text">
                        Blending policy analysis + reputation management + PR storytelling — positioning it as a credible publication for thought leaders, policymakers, and business strategists
                    </div>
                   
                </div>

                <!-- Categories -->
                <div>
                    <div class="footer-column-title">CATEGORIES</div>
                    <div class="footer-links">
                        <a title="Politics & Policy" href="politics-and-policy.php">Politics & Policy</a>
                        <a title="Business & Economy" href="business-and-economy.php">Business & Economy</a>
                        <a title="Global Affairs" href="global-affairs.php">Global Affairs</a>
                        <a title="Technology & Innovation" href="technology-and-innovation.php">Technology & Innovation</a>
                        
                    </div>
                </div>

                <!-- Links -->
                <div>
                    <div class="footer-links">
                        <div class="footer-column-title"></div>
                        <a title="Finance & Markets" href="finance-and-markets.php">Finance & Markets</a>
                        <a title="Featured PR" href="featured-pr.php">Featured PR</a>
                        <a title="Authors" href="author.php">Authors</a>
                    </div>
                </div>

                <!-- About Us -->
                <div>
                    <div class="footer-column-title">ABOUT US</div>
                    <div class="footer-links">
                        <a title="Privacy policy" href="privacy-policy.php">Privacy policy</a>
                        <a title="Terms and Conditions" href="terms-and-conditions.php">Terms and Conditions</a>
                    </div>
                </div>

            </div>

            <!-- Bottom Bar -->
            <div class="footer-bottom-bar">
                © 2025 Policynow. All rights reserved.
            </div>
        </footer>
    </main>
    </div>
  
</body>
</html>