<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Regulators struggle to keep up with the fast-moving and complicated landscape of AI therapy apps</title>
    <link rel="stylesheet" href="../css/style.css">
        <meta name="description"
        content="Regulators struggle to keep pace with rapidly evolving AI therapy apps, raising concerns about safety, oversight, and transparency in mental health technology">
    <meta property="og:title" content="Regulators struggle to keep up with the fast-moving and complicated landscape of AI therapy apps">
    <meta property="og:description"
        content="Regulators struggle to keep pace with rapidly evolving AI therapy apps, raising concerns about safety, oversight, and transparency in mental health technology">
    <meta name="keywords" content="AI therapy apps">
    <meta property="og:url" content="https://www.policynow.org/regulators-struggle-to-keep-up-with-the-fast-moving-and-complicated-landscape-of-ai-therapy-apps">
    <meta property="og:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta property="og:site_name" content="">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_US">
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Regulators struggle to keep up with the fast-moving and complicated landscape of AI therapy apps">
    <meta name="twitter:description"
        content="Regulators struggle to keep pace with rapidly evolving AI therapy apps, raising concerns about safety, oversight, and transparency in mental health technology">
    <meta name="twitter:url" content="https://www.policynow.org/regulators-struggle-to-keep-up-with-the-fast-moving-and-complicated-landscape-of-ai-therapy-apps">
    <meta name="twitter:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta name="twitter:site" content="@policynow">
    <meta name="twitter:creator" content="@policynow">
    <link rel="icon" type="image/x-icon" href="https://www.policynow.org/image/favicon.png">
    <link rel="canonical" href="https://www.policynow.org/regulators-struggle-to-keep-up-with-the-fast-moving-and-complicated-landscape-of-ai-therapy-apps">
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "NewsArticle",
  "mainEntityOfPage": {
    "@id": "https://www.policynow.org/regulators-struggle-to-keep-up-with-the-fast-moving-and-complicated-landscape-of-ai-therapy-apps"
  },
  "headline": "Regulators struggle to keep up with the fast-moving and complicated landscape of AI therapy apps",
  "image": [
    "https://www.policynow.org/image/twitter-card.png"
  ],
  "datePublished": "2025-11-17T08:28:00-04:00",
  "dateModified": "2025-11-17T08:28:00-04:00",
  "description": "Regulators struggle to keep pace with rapidly evolving AI therapy apps, raising concerns about safety, oversight, and transparency in mental health technology",
  "author": {
    "@type": "Person",
    "name": "Editorial Board"
  },
  "publisher": {
    "@type": "Organization",
    "name": "policynow",
    "logo": {
      "@type": "ImageObject",
      "url": "https://www.policynow.org/image/policynow-logo.png"
    }
  },
  "keywords": ["AI regulation",
"digital health oversight",
"mental health technology",
"AI safety concerns",
"health app regulation",
"fast-moving AI landscape",
"tech policy",
"AI compliance",
"digital therapy tools"]

}
</script>
</head>

<body class="light-mode">
<?php include '../header.php'; ?>

    <div class="main-container">
        <div class="date-row">
            <div class="day">
                <strong><?php
echo date("l, F j, Y"); 
?></strong>
            </div>

            <div class="top-center">
                <a href="../main.php"><img src="../image/policynow-logo.png"
                    alt="Logo"></a>
            </div>
            <div class="top-right"> 
                <img src="../image/search.png" class="menu-toggle" alt="search" width="16" height="16">
                <div  class="search-box" id="searchBox">
                    <input type="text" placeholder="Type & hit enter">
                     <img  src="../image/search.png" class="menu-toggle1" alt="search" width="16" height="16">
                </div>
                <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                 <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
            </div>
        </div>
        <nav class="main-nav1">
            <a title="Politics & Policy" class="nav-H" href="../politics-and-policy.php">Politics & Policy</a>
            <a title="Business & Economy" class="nav-l" href="../business-and-economy.php">Business & Economy</a>
            <a title="Global Affairs" class="nav-l" href="../global-affairs.php">Global Affairs</a>
            <a title="Technology & Innovation" class="nav-l" href="../technology-and-innovation.php">Technology & Innovation</a>
            <a title="Finance & Markets" class="nav-l" href="../finance-and-markets.php">Finance & Markets</a>
            <a title="Featured PR" class="nav-l" href="../featured-pr.php">Featured PR</a>
            <a title="Author" class="nav-l" href="../author.php">Authors</a>
        </nav>

    </div>
      <div class="main">
          <section class="highlight-news">
            <div class="highlight-category">
                <a title="Politics & Policy" href="#">Politics & Policy</a>
            </div>
            <div class="live-sect">
                <span class="live-status">
                    <span class="dot"></span>

                </span>
                <p> <span class="live-badge">LIVE</span>
                    7 days ago</p>
            </div>
            <h1 class="highlight-title">Regulators struggle to keep up with the fast-moving and complicated landscape of AI therapy apps</h1>
            <p class="content-para">Some states have started to regulate apps that offer AI "therapy" as more and more people turn to AI for mental health advice. This is because there isn't enough federal regulation.</p>

            <div class="highlight-footer">
                <div class="author-blocks">
                    <div class="author-card">
                        <img src="../image/maxine-t-warne.jpg"
                            alt="Maxine T. Warne">
                        <div class="author-info">
                            <a title="Maxine T. Warne" href="author.php">Maxine T. Warne</a>
                            <span>NOVEMBER 04, 2025</span>
                        </div>
                    </div>
                </div>

                <div class="share-block">
                    <span>Share this</span>
                    <div class="share-icons">
                        <a title="facebook" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                        </a>
                        <a title="twitter" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                        </a>

                        <a title="youtube" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
                        </a>
                    </div>
                    <div class="share-single">
                        <button>
                            <a title="more" href="#"><i class="fa-solid fa-share-nodes"></i></a>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <div class="img-section">
            <img src="../image/regulators-struggle-to-keep-up.webp"
                alt="Regulators struggle to keep up">
        </div>


        <div class="second-sec">

<p class="content-para">But the laws, which were all passed this year, don't fully deal with how quickly AI software development is changing. App developers, policymakers, and mental health advocates all agree that the patchwork of state laws that have come about isn't enough to protect users or hold the people who make harmful technology accountable.</p>

<p class="content-para">Karin Andrea Stephan, CEO and co-founder of the mental health chatbot app Earkick, said, "The truth is that millions of people are using these tools and they aren't going back."</p>

<p class="content-para">The laws in each state are different. Illinois and Nevada have made it illegal to use AI to help with mental health. Utah put some rules in place for therapy chatbots, such as making sure they keep users' health information safe and making it clear that the chatbot is not a real person. Along with New York, New Jersey, and California, Pennsylvania is also looking into how to regulate AI therapy.</p>

<p class="content-para">Different users are affected in different ways. Some apps won't let people in states with bans use them. Some people say they won't make any changes until they get more legal information.</p>

<p class="content-para">And a lot of the laws don't apply to generic chatbots like ChatGPT, which aren't marketed as therapy tools but are used for that by a lot of people. In terrible cases, people have sued those bots because they lost touch with reality or killed themselves after using them.</p>

<p class="content-para">Vaile Wright, who is in charge of health care innovation at the American Psychological Association, said that the apps could help meet a need because there aren't enough mental health providers in the country, care is expensive, and insured patients don't always have easy access to it.</p>

<p class="content-para">Wright said that mental health chatbots based on science, made with input from experts, and watched over by people could change the way things are now.</p>

<p class="content-para">"This could be something that helps people before they get to a crisis," she said. "That's not what's for sale on the market right now."</p>

<p class="content-para">She said that is why there needs to be federal regulation and oversight.</p>

<p class="content-para">The Federal Trade Commission said earlier this month that it was looking into seven AI chatbot companies, including the owners of Instagram and Facebook, Google, ChatGPT, Grok (the chatbot on X), Character.AI, and Snapchat. They want to know how these companies "measure, test, and monitor potentially negative impacts of this technology on children and teens." The Food and Drug Administration is also getting together an advisory committee on November 6 to look at mental health devices that use generative AI.</p>

<p class="content-para">Wright said that federal agencies could think about limiting how chatbots are marketed, stopping addictive behaviors, making companies tell users that they are not medical providers, making companies keep track of and report suicidal thoughts, and giving people who report bad company practices legal protections.</p>

<p class="content-para">AI is used in mental health care in a lot of different ways, like "companion apps," "AI therapists," and "mental wellness" apps. It's hard to define and even harder to write laws about.</p>

<p class="content-para">That has caused different ways of regulating things. Some states, for instance, go after companion apps that are only for making friends and don't deal with mental health issues. In Illinois and Nevada, it's against the law for products to say they can treat mental health issues. In Illinois, you could face fines of up to $10,000, and in Nevada, you could face fines of up to $15,000.</p>

<p class="content-para">But it can be hard to put even one app into a category.</p>

<p class="content-para">Stephan from Earkick said that Illinois' law is still "very muddy" in a lot of ways, and the company hasn't limited access there.</p>

<p class="content-para">At first, Stephan and her team didn't want to call their chatbot, which looks like a cartoon panda, a therapist. But when users began using the word in reviews, they embraced the terminology so the app would show up in searches.</p>

<p class="content-para">Last week, they stopped using medical and therapy terms again. Earkick's website used to call its chatbot "Your empathetic AI counselor, equipped to support your mental health journey." Now it calls it a "chatbot for self-care."</p>

<p class="content-para">Stephan still said, "we're not diagnosing."</p>

<p class="content-para">Users can set up a "panic button" to call a trusted loved one if they are in trouble, and the chatbot will "nudge" them to see a therapist if their mental health gets worse. Stephan said that the app was never meant to stop people from killing themselves, and the police would not be called if someone told the bot they were thinking about hurting themselves.</p>

<p class="content-para">Stephan said she's glad that people are being careful with AI, but she's worried that states won't be able to keep up with new technology.</p>

<p class="content-para">She said, "Things are changing at a very fast pace."</p>

          
        </div>
      </div>

    <!-- Blog Section -->
    <section class="latest-blog-wrapper">
        <h2 class="latest-blog-title">LATEST FROM BLOG</h2>

 <div class="latest-blog-grid">
            <!-- Blog Item 1 -->
            <a title="more" href="../politics-and-policy/trump-signs-new-stablecoin-regulations-into-law-a-major-milestone-for-crypto-industry.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/house-republicans-include-ten-year-ban.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">House Republicans include a 10-year ban on US states regulating AI in ‘big, beautiful’ bill</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 2 -->
            <a title="more" href="../politics-and-policy/senate-republicans-revise-ban-on-state-ai-regulations-in-bid-to-preserve-controversial-provision.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/senate-republicans-revise-ban.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Senate Republicans revise ban on state AI regulations in bid to preserve controversial provision</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 3 -->
            <a title="more" href="../politics-and-policy/from-tech-podcasts-to-policy-trumps-new-ai-plan-leans-heavily-on-silicon-valley-industry-ideas.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/from-tech-podcasts-to-policy.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">From tech podcasts to policy: Trump’s new AI plan leans heavily on Silicon Valley industry ideas</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 4 -->
            <a title="more" href="../politics-and-policy/california-gov-gavin-newsom-signs-landmark-bill-creating-ai-safety-measures.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/california-gov-gavin-newsom-signs.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">California Gov. Gavin Newsom signs landmark bill creating AI safety measures</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 5 -->
            <a title="more" href="../politics-and-policy/trump-signs-new-stablecoin-regulations-into-law-a-major-milestone-for-crypto-industry.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/trump-signs-new-stablecoin.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Trump signs new stablecoin regulations into law, a major milestone for crypto industry</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>


        </div>
<?php include '../footer.php'; ?>
    </section>

    <script defer src="../js/style.js" ></script>
</body>

</html>