<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>From tech podcasts to policy: Trump’s new AI plan leans heavily on Silicon Valley industry ideas</title>
    <link rel="stylesheet" href="../css/style.css">
        <meta name="description"
        content="Trump’s new AI plan draws heavily from Silicon Valley’s tech playbook, shaping national policy with industry-driven ideas and innovation priorities">
    <meta property="og:title" content="From tech podcasts to policy: Trump’s new AI plan leans heavily on Silicon Valley industry ideas">
    <meta property="og:description"
        content="Trump’s new AI plan draws heavily from Silicon Valley’s tech playbook, shaping national policy with industry-driven ideas and innovation priorities">
    <meta name="keywords" content="Trump AI plan">
    <meta property="og:url" content="https://www.policynow.org/from-tech-podcasts-to-policy-trumps-new-ai-plan-leans-heavily-on-silicon-valley-industry-ideas">
    <meta property="og:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta property="og:site_name" content="">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_US">
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="From tech podcasts to policy: Trump’s new AI plan leans heavily on Silicon Valley industry ideas">
    <meta name="twitter:description"
        content="Trump’s new AI plan draws heavily from Silicon Valley’s tech playbook, shaping national policy with industry-driven ideas and innovation priorities">
    <meta name="twitter:url" content="https://www.policynow.org/from-tech-podcasts-to-policy-trumps-new-ai-plan-leans-heavily-on-silicon-valley-industry-ideas">
    <meta name="twitter:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta name="twitter:site" content="@policynow">
    <meta name="twitter:creator" content="@policynow">
    <link rel="icon" type="image/x-icon" href="https://www.policynow.org/image/favicon.png">
    <link rel="canonical" href="https://www.policynow.org/from-tech-podcasts-to-policy-trumps-new-ai-plan-leans-heavily-on-silicon-valley-industry-ideas">
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "NewsArticle",
  "mainEntityOfPage": {
    "@id": "https://www.policynow.org/from-tech-podcasts-to-policy-trumps-new-ai-plan-leans-heavily-on-silicon-valley-industry-ideas"
  },
  "headline": "From tech podcasts to policy: Trump’s new AI plan leans heavily on Silicon Valley industry ideas",
  "image": [
    "https://www.policynow.org/image/twitter-card.png"
  ],
  "datePublished": "2025-11-17T08:28:00-04:00",
  "dateModified": "2025-11-17T08:28:00-04:00",
  "description": "Trump’s new AI plan draws heavily from Silicon Valley’s tech playbook, shaping national policy with industry-driven ideas and innovation priorities",
  "author": {
    "@type": "Person",
    "name": "Editorial Board"
  },
  "publisher": {
    "@type": "Organization",
    "name": "policynow",
    "logo": {
      "@type": "ImageObject",
      "url": "https://www.policynow.org/image/policynow-logo.png"
    }
  },
  "keywords": ["Silicon Valley influence", "tech industry policy", "AI policy 2025", "US technology strategy", "AI regulation", "tech-driven governance", "Silicon Valley and Trump", "AI innovation agenda", "national AI strategy"]

}
</script>
</head>

<body class="light-mode">
<?php include '../header.php'; ?>

    <div class="main-container">
        <div class="date-row">
            <div class="day">
                <strong><?php
echo date("l, F j, Y"); 
?></strong>
            </div>

            <div class="top-center">
                <a href="../main.php"><img src="../image/policynow-logo.png"
                    alt="Logo"></a>
            </div>
            <div class="top-right"> 
                <img src="../image/search.png" class="menu-toggle" alt="search" width="16" height="16">
                <div  class="search-box" id="searchBox">
                    <input type="text" placeholder="Type & hit enter">
                     <img  src="../image/search.png" class="menu-toggle1" alt="search" width="16" height="16">
                </div>
                <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                 <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
            </div>
        </div>
        <nav class="main-nav1">
            <a title="Politics & Policy" class="nav-H" href="../politics-and-policy.php">Politics & Policy</a>
            <a title="Business & Economy" class="nav-l" href="../business-and-economy.php">Business & Economy</a>
            <a title="Global Affairs" class="nav-l" href="../global-affairs.php">Global Affairs</a>
            <a title="Technology & Innovation" class="nav-l" href="../technology-and-innovation.php">Technology & Innovation</a>
            <a title="Finance & Markets" class="nav-l" href="../finance-and-markets.php">Finance & Markets</a>
            <a title="Featured PR" class="nav-l" href="../featured-pr.php">Featured PR</a>
            <a title="Author" class="nav-l" href="../author.php">Authors</a>
        </nav>

    </div>
      <div class="main">
          <section class="highlight-news">
            <div class="highlight-category">
                <a title="Politics & Policy" href="#">Politics & Policy</a>
            </div>
            <div class="live-sect">
                <span class="live-status">
                    <span class="dot"></span>

                </span>
                <p> <span class="live-badge">LIVE</span>
                    7 days ago</p>
            </div>
            <h1 class="highlight-title">From tech podcasts to policy: Trump’s new AI plan leans heavily on Silicon Valley industry ideas</h1>
<p class="content-para">President Donald Trump on Wednesday unveiled a sweeping new plan for America’s “global dominance” in artificial intelligence, proposing to cut back environmental regulations to speed up the construction of AI supercomputers while promoting the sale of U.S.-made AI technologies at home and abroad.</p>


            <div class="highlight-footer">
                <div class="author-blocks">
                    <div class="author-card">
                        <img src="../image/maxine-t-warne.jpg"
                            alt="Maxine T. Warne">
                        <div class="author-info">
                            <a title="Maxine T. Warne" href="author.php">MAXINE T. WARNE</a>
                            <span>NOVEMBER 04, 2025</span>
                        </div>
                    </div>
                    
                </div>

                <div class="share-block">
                    <span>Share this</span>
                    <div class="share-icons">
                        <a title="facebook" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                        </a>
                        <a title="twitter" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                        </a>

                        <a title="youtube" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
                        </a>
                    </div>
                    <div class="share-single">
                        <button>
                            <a title="more" href="#"><i class="fa-solid fa-share-nodes"></i></a>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <div class="img-section">
            <img src="../image/from-tech-podcasts-to-policy.webp"
                alt="Image">
        </div>


        <div class="second-sec">

<p class="content-para">The “AI Action Plan” embraces many of the ideas voiced by tech industry lobbyists and the Silicon Valley investors who backed Trump’s election campaign last year.</p>

<p class="content-para">“America must once again be a country where innovators are rewarded with a green light, not strangled with red tape,” Trump said at an unveiling event that was co-hosted by the bipartisan Hill and Valley Forum and the “All-In” podcast, a business and technology show hosted by four tech investors and entrepreneurs, which includes Trump’s AI czar, David Sacks.</p>

<p class="content-para">The plan includes some familiar tech lobby pitches. That includes accelerating the sale of AI technology abroad and making it easier to construct the energy-hungry data center buildings that are needed to form and run AI products. It also includes some AI culture war preoccupations of the circle of venture capitalists who endorsed Trump last year.</p>

<p class="content-para">Trump signed three executive orders Wednesday to deliver on the plan. They seek to fast-track permitting of AI construction projects, expand U.S. tech exports and get rid of “woke” in AI.</p>

<p class="content-para">Trump had given his tech advisers six months to come up with new AI policies after revoking President Joe Biden’s signature AI guardrails on his first day in office. The plan prioritizes AI innovation and adoption, urging the removal of any barriers that could slow down adoption across industries and government. The nation’s policy, Trump said, will be to do “whatever it takes to lead the world in artificial intelligence.”</p>

<p class="content-para">Yet it also seeks to guide the industry’s growth to address a longtime rallying point for the tech industry’s loudest Trump backers: countering the liberal bias they see in AI chatbots such as ChatGPT or Google’s Gemini.</p>

<p class="content-para">Trump’s plan aims to block the government from contracting with tech companies unless they “ensure that their systems are objective and free from top-down ideological bias.” The plan says the nation’s leading AI models should protect free speech and be “founded on American values,” though it doesn’t define which values those should include.</p>

<p class="content-para">Sacks, a former PayPal executive and now Trump’s top AI adviser, has been criticizing “woke AI” for more than a year, fueled by Google’s February 2024 rollout of an AI image generator. When asked to show an American Founding Father, it created pictures of Black, Asian, and Native American men.</p>

<p class="content-para">Google quickly fixed its tool, but the “Black George Washington” moment remained a parable for the problem of AI’s perceived political bias, taken up by X owner Elon Musk, venture capitalist Marc Andreessen, Vice President JD Vance and Republican lawmakers.</p>

<p class="content-para">Chief among the plan’s goals is to speed up permitting and loosen environmental regulation to accelerate construction on new data centers and factories. It condemns “radical climate dogma” and recommends lifting environmental restrictions, including clean air and water laws.</p>

<p class="content-para">Trump has previously paired AI’s need for huge amounts of electricity with his own push to tap into U.S. energy sources, including gas, coal and nuclear.</p>

<p class="content-para">“We will be adding at least as much electric capacity as China,” Trump said at the Wednesday event. “Every company will be given the right to build their own power plant.”</p>

<p class="content-para">Many tech giants are already well on their way toward building new data centers in the U.S. and around the world. OpenAI announced this week that it has switched on the first phase of a massive data center complex in Abilene, Texas, part of an Oracle-backed project known as Stargate that Trump promoted earlier this year. Amazon, Microsoft, Meta and xAI also have major projects underway.</p>

<p class="content-para">The tech industry has pushed for easier permitting rules to get its computing facilities connected to power, but the AI building boom has also contributed to spiking demand for fossil fuel production, which contributes to global warming.</p>

<p class="content-para">United Nations Secretary-General Antonio Guterres on Tuesday called on the world’s major tech firms to power data centers completely with renewables by 2030.</p>

<p class="content-para">The plan includes a strategy to disincentivize states from aggressively regulating AI technology, calling on federal agencies not to provide funding to states with burdensome regulations.</p>

<p class="content-para">“We need one common sense federal standard that supersedes all states, supersedes everybody,” Trump said, “so you don’t end up in litigation with 43 states at one time.”</p>

<p class="content-para">There are sharp debates on how to regulate AI, even among the influential venture capitalists who have been debating it on their favorite medium: the podcast.</p>

<p class="content-para">While some Trump backers, particularly Andreessen, have advocated an “accelerationist” approach that aims to speed up AI advancement with minimal regulation, Sacks has described himself as taking a middle road of techno-realism.</p>

<p class="content-para">“Technology is going to happen. Trying to stop it is like ordering the tides to stop. If we don’t do it, somebody else will,” Sacks said on the “All-In” podcast.</p>

<p class="content-para">On Tuesday, more than 100 groups, including labor unions, parent groups, environmental justice organizations and privacy advocates, signed a resolution opposing Trump’s embrace of industry-driven AI policy and calling for a “People’s AI Action Plan” that would “deliver first and foremost for the American people.”</p>

<p class="content-para">J.B. Branch, Big Tech accountability advocate at the watchdog group Public Citizen, which signed the resolution, called the plan a “sellout.”</p>

<p class="content-para">“Under this plan, tech giants get sweetheart deals while everyday Americans will see their electricity bills rise to subsidize discounted power for massive AI data centers,” Branch said in a statement Wednesday. “Americans deserve an AI future rooted in safety, fairness, and accountability — not a handout to billionaires.”</p>

          
        </div>
      </div>

    <!-- Blog Section -->
    <section class="latest-blog-wrapper">
        <h2 class="latest-blog-title">LATEST FROM BLOG</h2>

 <div class="latest-blog-grid">
            <!-- Blog Item 1 -->
            <a title="more" href="../politics-and-policy/trump-signs-new-stablecoin-regulations-into-law-a-major-milestone-for-crypto-industry.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/house-republicans-include-ten-year-ban.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">House Republicans include a 10-year ban on US states regulating AI in ‘big, beautiful’ bill</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 2 -->
            <a title="more" href="../politics-and-policy/senate-republicans-revise-ban-on-state-ai-regulations-in-bid-to-preserve-controversial-provision.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/senate-republicans-revise-ban.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Senate Republicans revise ban on state AI regulations in bid to preserve controversial provision</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 3 -->
            <a title="more" href="../politics-and-policy/trump-signs-new-stablecoin-regulations-into-law-a-major-milestone-for-crypto-industry.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/trump-signs-new-stablecoin.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Trump signs new stablecoin regulations into law, a major milestone for crypto industry</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 4 -->
            <a title="more" href="../politics-and-policy/california-gov-gavin-newsom-signs-landmark-bill-creating-ai-safety-measures.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/california-gov-gavin-newsom-signs.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">California Gov. Gavin Newsom signs landmark bill creating AI safety measures</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 5 -->
            <a title="more" href="../politics-and-policy/regulators-struggle-to-keep-up-with-the-fast-moving-and-complicated-landscape-of-ai-therapy-apps.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/regulators-struggle-to-keep-up.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Regulators struggle to keep up with the fast-moving and complicated landscape of AI therapy apps</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>


        </div>
<?php include '../footer.php'; ?>
    </section>

    <script defer src="../js/style.js" ></script>
</body>

</html>