<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>California Gov. Gavin Newsom signs landmark bill creating AI safety measures</title>
    <link rel="stylesheet" href="../css/style.css">
        <meta name="description"
        content="California Gov. Gavin Newsom signs a landmark bill establishing new AI safety rules aimed at preventing risks and ensuring responsible technology development">
    <meta property="og:title" content="California Gov. Gavin Newsom signs landmark bill creating AI safety measures">
    <meta property="og:description"
        content="California Gov. Gavin Newsom signs a landmark bill establishing new AI safety rules aimed at preventing risks and ensuring responsible technology development">
    <meta name="keywords" content="California AI law">
    <meta property="og:url" content="https://www.policynow.org/california-gov-gavin-newsom-signs-landmark-bill-creating-ai-safety-measures">
    <meta property="og:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta property="og:site_name" content="">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_US">
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="California Gov. Gavin Newsom signs landmark bill creating AI safety measures">
    <meta name="twitter:description"
        content="California Gov. Gavin Newsom signs a landmark bill establishing new AI safety rules aimed at preventing risks and ensuring responsible technology development">
    <meta name="twitter:url" content="https://www.policynow.org/california-gov-gavin-newsom-signs-landmark-bill-creating-ai-safety-measures">
    <meta name="twitter:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta name="twitter:site" content="@policynow">
    <meta name="twitter:creator" content="@policynow">
    <link rel="icon" type="image/x-icon" href="https://www.policynow.org/image/favicon.png">
    <link rel="canonical" href="https://www.policynow.org/california-gov-gavin-newsom-signs-landmark-bill-creating-ai-safety-measures">
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "NewsArticle",
  "mainEntityOfPage": {
    "@id": "https://www.policynow.org/california-gov-gavin-newsom-signs-landmark-bill-creating-ai-safety-measures"
  },
  "headline": "California Gov. Gavin Newsom signs landmark bill creating AI safety measures",
  "image": [
    "https://www.policynow.org/image/twitter-card.png"
  ],
  "datePublished": "2025-11-17T08:28:00-04:00",
  "dateModified": "2025-11-17T08:28:00-04:00",
  "description": "California Gov. Gavin Newsom signs a landmark bill establishing new AI safety rules aimed at preventing risks and ensuring responsible technology development",
  "author": {
    "@type": "Person",
    "name": "Editorial Board"
  },
  "publisher": {
    "@type": "Organization",
    "name": "policynow",
    "logo": {
      "@type": "ImageObject",
      "url": "https://www.policynow.org/image/policynow-logo.png"
    }
  },
  "keywords": ["Gavin Newsom", "AI safety bill", "AI regulations", "artificial intelligence policy", "tech accountability", "AI governance", "California legislation", "AI transparency rules", "responsible AI"]

}
</script>
</head>

<body class="light-mode">
<?php include '../header.php'; ?>

    <div class="main-container">
        <div class="date-row">
            <div class="day">
                <strong><?php
echo date("l, F j, Y"); 
?></strong>
            </div>

            <div class="top-center">
                <a href="../main.php"><img src="../image/policynow-logo.png"
                    alt="Logo"></a>
            </div>
            <div class="top-right"> 
                <img src="../image/search.png" class="menu-toggle" alt="search" width="16" height="16">
                <div  class="search-box" id="searchBox">
                    <input type="text" placeholder="Type & hit enter">
                     <img  src="../image/search.png" class="menu-toggle1" alt="search" width="16" height="16">
                </div>
                <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                 <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
            </div>
        </div>
        <nav class="main-nav1">
            <a title="Politics & Policy" class="nav-H" href="../politics-and-policy.php">Politics & Policy</a>
            <a title="Business & Economy" class="nav-l" href="../business-and-economy.php">Business & Economy</a>
            <a title="Global Affairs" class="nav-l" href="../global-affairs.php">Global Affairs</a>
            <a title="Technology & Innovation" class="nav-l" href="../technology-and-innovation.php">Technology & Innovation</a>
            <a title="Finance & Markets" class="nav-l" href="../finance-and-markets.php">Finance & Markets</a>
            <a title="Featured PR" class="nav-l" href="../featured-pr.php">Featured PR</a>
            <a title="Author" class="nav-l" href="../author.php">Authors</a>
        </nav>

    </div>
      <div class="main">
          <section class="highlight-news">
            <div class="highlight-category">
                <a title="Politics & Policy" href="#">Politics & Policy</a>
            </div>
            <div class="live-sect">
                <span class="live-status">
                    <span class="dot"></span>

                </span>
                <p> <span class="live-badge">LIVE</span>
                    7 days ago</p>
            </div>
            <h1 class="highlight-title">California Gov. Gavin Newsom signs landmark bill creating AI safety measures</h1>
<p class="content-para">California Gov. Gavin Newsom on Monday signed a law that aims to prevent people from using powerful artificial intelligence models for potentially catastrophic activities like building a bioweapon or shutting down a bank system.</p>


            <div class="highlight-footer">
                <div class="author-blocks">
                    <div class="author-card">
                        <img src="../image/maxine-t-warne.jpg"
                            alt="Maxine T. Warne">
                        <div class="author-info">
                            <a title="Maxine T. Warne" href="author.php">Maxine T. Warne</a>
                            <span>NOVEMBER 04, 2025</span>
                        </div>
                    </div>
                    
                </div>

                <div class="share-block">
                    <span>Share this</span>
                    <div class="share-icons">
                        <a title="facebook" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                        </a>
                        <a title="twitter" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                        </a>

                        <a title="youtube" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
                        </a>
                    </div>
                    <div class="share-single">
                        <button>
                            <a title="more" href="#"><i class="fa-solid fa-share-nodes"></i></a>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <div class="img-section">
            <img src="../image/california-gov-gavin-newsom-signs.webp"
                alt="Image">
        </div>


        <div class="second-sec">

<p class="content-para">The move comes as Newsom touted California as a leader in AI regulation and criticized the inaction at the federal level in a recent conversation with former President Bill Clinton. The new law will establish some of the first-in-the-nation regulations on large-scale AI models without hurting the state’s homegrown industry, Newsom said. Many of the world’s top AI companies are located in California and will have to follow the requirements.</p>

<p class="content-para">“California has proven that we can establish regulations to protect our communities while also ensuring that the growing AI industry continues to thrive. This legislation strikes that balance,” Newsom said in a statement.</p>

<p class="content-para">The legislation requires AI companies to implement and disclose publicly safety protocols to prevent their most advanced models from being used to cause major harm. The rules are designed to cover AI systems if they meet a “frontier” threshold that signals they run on a huge amount of computing power.</p>

<p class="content-para">Such thresholds are based on how many calculations the computers are performing. Those who crafted the regulations have acknowledged the numerical thresholds are an imperfect starting point to distinguish today’s highest-performing generative AI systems from the next generation that could be even more powerful. The existing systems are largely made by California-based companies like Anthropic, Google, Meta Platforms and OpenAI.</p>

<p class="content-para">The legislation defines a catastrophic risk as something that would cause at least $1 billion in damage or more than 50 injuries or deaths. It’s designed to guard against AI being used for activities that could cause mass disruption, such as hacking into a power grid.</p>

<p class="content-para">Companies also have to report to the state any critical safety incidents within 15 days. The law creates whistleblower protections for AI workers and establishes a public cloud for researchers. It includes a fine of $1 million per violation.</p>

<p class="content-para">It drew opposition from some tech companies, which argued that AI legislation should be done at the federal level. But Anthropic said the regulations are “practical safeguards” that make official the safety practices many companies are already doing voluntarily.</p>

<p class="content-para">“While federal standards remain essential to avoid a patchwork of state regulations, California has created a strong framework that balances public safety with continued innovation,” Jack Clark, co-founder and head of policy at Anthropic, said in a statement.</p>

<p class="content-para">The signing comes after Newsom last year vetoed a broader version of the legislation, siding with tech companies that said the requirements were too rigid and would have hampered innovation. Newsom instead asked a group of several industry experts, including AI pioneer Fei-Fei Li, to develop recommendations on guardrails around powerful AI models.</p>

<p class="content-para">The new law incorporates recommendations and feedback from Newsom’s group of AI experts and the industry, supporters said. The legislation also doesn’t put the same level of reporting requirements on startups to avoid hurting innovation, said state Sen. Scott Wiener of San Francisco, the bill’s author.</p>

<p class="content-para">“With this law, California is stepping up, once again, as a global leader on both technology innovation and safety,” Wiener said in a statement.</p>

<p class="content-para">Newsom’s decision comes as President Donald Trump in July announced a plan to eliminate what his administration sees as “onerous” regulations to speed up AI innovation and cement the U.S.’ position as the global AI leader. Republicans in Congress earlier this year unsuccessfully tried to ban states and localities from regulating AI for a decade.</p>

<p class="content-para">Without stronger federal regulations, states across the country have spent the last few years trying to rein in the technology, tackling everything from deepfakes in elections to AI “therapy.” In California, the Legislature this year passed a number of bills to address safety concerns around AI chatbots for children and the use of AI in the workplace.</p>

<p class="content-para">California has also been an early adopter of AI technologies. The state has deployed generative AI tools to spot wildfires and address highway congestion and road safety, among other things.</p>

          
        </div>
      </div>

    <!-- Blog Section -->
    <section class="latest-blog-wrapper">
        <h2 class="latest-blog-title">LATEST FROM BLOG</h2>

 <div class="latest-blog-grid">
            <!-- Blog Item 1 -->
            <a title="more" href="../politics-and-policy/trump-signs-new-stablecoin-regulations-into-law-a-major-milestone-for-crypto-industry.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/house-republicans-include-ten-year-ban.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">House Republicans include a 10-year ban on US states regulating AI in ‘big, beautiful’ bill</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 2 -->
            <a title="more" href="../politics-and-policy/senate-republicans-revise-ban-on-state-ai-regulations-in-bid-to-preserve-controversial-provision.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/senate-republicans-revise-ban.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Senate Republicans revise ban on state AI regulations in bid to preserve controversial provision</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 3 -->
            <a title="more" href="../politics-and-policy/from-tech-podcasts-to-policy-trumps-new-ai-plan-leans-heavily-on-silicon-valley-industry-ideas.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/from-tech-podcasts-to-policy.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">From tech podcasts to policy: Trump’s new AI plan leans heavily on Silicon Valley industry ideas</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 4 -->
            <a title="more" href="../politics-and-policy/trump-signs-new-stablecoin-regulations-into-law-a-major-milestone-for-crypto-industry.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/trump-signs-new-stablecoin.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Trump signs new stablecoin regulations into law, a major milestone for crypto industry</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 5 -->
            <a title="more" href="../politics-and-policy/regulators-struggle-to-keep-up-with-the-fast-moving-and-complicated-landscape-of-ai-therapy-apps.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/regulators-struggle-to-keep-up.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Regulators struggle to keep up with the fast-moving and complicated landscape of AI therapy apps</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>


        </div>
<?php include '../footer.php'; ?>
    </section>

    <script defer src="../js/style.js" ></script>
</body>

</html>