<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>How the US-EU trade deal wards off more escalation but will raise prices and slow growth</title>
    <link rel="stylesheet" href="../css/style.css">
        <meta name="description"
        content="Federal Reserve official cites weak jobs data as support for three upcoming interest rate cuts, signaling a shift toward easing monetary policy">
    <meta property="og:title" content="A top Federal Reserve official says dour jobs data backs the case for 3 rate cuts">
    <meta property="og:description"
        content="Federal Reserve official cites weak jobs data as support for three upcoming interest rate cuts, signaling a shift toward easing monetary policy">
    <meta name="keywords" content="Federal Reserve">
    <meta property="og:url" content="https://www.policynow.org/a-top-federal-reserve-official-says-dour-jobs-data-backs-the-case-for-three-rate-cuts">
    <meta property="og:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta property="og:site_name" content="">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_US">
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="A top Federal Reserve official says dour jobs data backs the case for 3 rate cuts">
    <meta name="twitter:description"
        content="Federal Reserve official cites weak jobs data as support for three upcoming interest rate cuts, signaling a shift toward easing monetary policy">
    <meta name="twitter:url" content="https://www.policynow.org/a-top-federal-reserve-official-says-dour-jobs-data-backs-the-case-for-three-rate-cuts">
    <meta name="twitter:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta name="twitter:site" content="@policynow">
    <meta name="twitter:creator" content="@policynow">
    <link rel="icon" type="image/x-icon" href="https://www.policynow.org/image/favicon.png">
    <link rel="canonical" href="https://www.policynow.org/a-top-federal-reserve-official-says-dour-jobs-data-backs-the-case-for-three-rate-cuts">
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "NewsArticle",
  "mainEntityOfPage": {
    "@id": "https://www.policynow.org/a-top-federal-reserve-official-says-dour-jobs-data-backs-the-case-for-three-rate-cuts"
  },
  "headline": "A top Federal Reserve official says dour jobs data backs the case for 3 rate cuts",
  "image": [
    "https://www.policynow.org/image/twitter-card.png"
  ],
  "datePublished": "2025-11-17T08:28:00-04:00",
  "dateModified": "2025-11-17T08:28:00-04:00",
  "description": "Federal Reserve official cites weak jobs data as support for three upcoming interest rate cuts, signaling a shift toward easing monetary policy",
  "author": {
    "@type": "Person",
    "name": "Editorial Board"
  },
  "publisher": {
    "@type": "Organization",
    "name": "policynow",
    "logo": {
      "@type": "ImageObject",
      "url": "https://www.policynow.org/image/policynow-logo.png"
    }
  },
  "keywords": ["Fed rate cuts", "U.S. jobs data", "interest rates", "monetary policy", "economic slowdown", "inflation", "U.S. economy", "rate cut forecast", "labor market", "central bank", "interest rate decision", "economic outlook", "Federal Reserve official", "job market report"]

}
</script>
</head>

<body class="light-mode">
<?php include '../header.php'; ?>

    <div class="main-container">
        <div class="date-row">
            <div class="day">
                <strong><?php
echo date("l, F j, Y"); 
?></strong>
            </div>

            <div class="top-center">
                <a href="../main.php"><img src="../image/policynow-logo.png"
                    alt="Logo"></a>
            </div>
            <div class="top-right"> 
                <img src="../image/search.png" class="menu-toggle" alt="search" width="16" height="16">
                <div  class="search-box" id="searchBox">
                    <input type="text" placeholder="Type & hit enter">
                     <img  src="../image/search.png" class="menu-toggle1" alt="search" width="16" height="16">
                </div>
                <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                 <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
            </div>
        </div>
        <nav class="main-nav1">
            <a title="Politics & Policy" class="nav-H" href="../politics-and-policy.php">Politics & Policy</a>
            <a title="Business & Economy" class="nav-l" href="../business-and-economy.php">Business & Economy</a>
            <a title="Global Affairs" class="nav-l" href="../global-affairs.php">Global Affairs</a>
            <a title="Technology & Innovation" class="nav-l" href="../technology-and-innovation.php">Technology & Innovation</a>
            <a title="Finance & Markets" class="nav-l" href="../finance-and-markets.php">Finance & Markets</a>
            <a title="Featured PR" class="nav-l" href="../featured-pr.php">Featured PR</a>
            <a title="Author" class="nav-l" href="../author.php">Authors</a>
        </nav>

    </div>
      <div class="main">
          <section class="highlight-news">
            <div class="highlight-category">
                <a title="Global Affairs" href="#">Global Affairs</a>
            </div>
            <div class="live-sect">
                <span class="live-status">
                    <span class="dot"></span>

                </span>
                <p> <span class="live-badge">LIVE</span>
                    7 days ago</p>
            </div>
            <h1 class="highlight-title">How the US-EU trade deal wards off more escalation but will raise prices and slow growth</h1>
<p class="content-para">U.S. President Donald Trump and European Commission President Ursula von der Leyen have announced a sweeping trade deal that imposes 15% tariffs on most European goods, warding off Trump’s threat of a 30% rate if no deal had been reached by Aug. 1.</p>


            <div class="highlight-footer">
                <div class="author-blocks">
                    <div class="author-card">
                        <img src="../image/joel-j-zarate.jpg"
                            alt="Joel J. Zarate">
                        <div class="author-info">
                            <a title="Joel J. Zarate" href="author.php">Joel J. Zarate</a>
                            <span>NOVEMBER 05, 2025</span>
                        </div>
                    </div>
                    
                </div>

                <div class="share-block">
                    <span>Share this</span>
                    <div class="share-icons">
                        <a title="facebook" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                        </a>
                        <a title="twitter" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                        </a>

                        <a title="youtube" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
                        </a>
                    </div>
                    <div class="share-single">
                        <button>
                            <a title="more" href="#"><i class="fa-solid fa-share-nodes"></i></a>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <div class="img-section">
            <img src="../image/how-the-us-eu-trade-deal.webp"
                alt="How the US-EU trade deal">
        </div>


        <div class="second-sec">

       <p>The tariffs, or import taxes, paid when Americans buy European products could raise prices for U.S. consumers and dent profits for European companies and their partners who bring goods into the country. Trump and von der Leyen’s announcement, made during Trump’s visit to one of his golf courses in Scotland, leaves many crucial details to be filled in.</p>

<p class="content-para">The headline figure is a 15% tariff rate on about 70% of European goods brought into the U.S., including cars, computer chips and pharmaceuticals. It’s lower than the 20% that Trump initially proposed, and lower than his threats of 50% and then 30%.</p>

<p class="content-para">The remaining 30% of goods are still open to further decisions and negotiations.</p>

<p class="content-para">Von der Leyen said that the two sides agreed on zero tariffs on both sides for a range of “strategic” goods: Aircraft and aircraft parts, certain chemicals, semiconductor equipment, certain agricultural products and some natural resources and critical raw materials. Specifics were lacking. She said that the two sides “would keep working” to add more products to the list.</p>

<p class="content-para">Additionally, companies in the European Union would purchase what Trump said was $750 billion (638 billion euros) worth of natural gas, oil and nuclear fuel over three years to replace Russian energy supplies that Europe is seeking to exit anyway. Meanwhile, European companies would invest an additional $600 billion (511 billion euros) in the U.S. under a political commitment that isn’t legally binding, officials said.</p>

<p class="content-para">Brussels and Washington will shortly issue a joint statement that frames the deal but isn’t yet legally binding, according to senior officials who weren’t authorized to be publicly named according to European Commission policy.</p>

<p class="content-para">The joint statement will have “some very precise commitments and others which will need to be spelled out in different ways,” a senior European Commission official said.</p>

<p class="content-para">EU officials said that the zero tariff list could include nuts, pet food, dairy products and seafood. Trump said that the 50% U.S. tariff on imported steel would remain. Von der Leyen said that the two sides agreed to further negotiations to fight a global steel glut, reduce tariffs and establish import quotas — that is, set amounts that can be imported, often at a lower rate or tariff-free.</p>

<p class="content-para">Trump said that pharmaceuticals, a major import from the EU to the US, weren’t included in the deal. Von der Leyen said that the pharmaceuticals issue was “on a separate sheet of paper” from Sunday’s deal.</p>

<p class="content-para">And von der Leyen said that when it came to farm products, the EU side made clear that “there were tariffs that could not be lowered,” without specifying which products. The 15% rate removes Trump’s threat of a 30% tariff. But it effectively raises the tariff on EU goods from 1.2% last year to 17% and would reduce the 27-nation bloc’s gross domestic product by 0.5%, said Jack Allen-Reynolds, deputy chief eurozone economist at Capital Economics.</p>

<p class="content-para">Higher tariffs, or import taxes, on European goods mean sellers in the U.S. would have to either increase prices for consumers — risking loss of market share — or swallow the added cost in terms of lower profits. The higher tariffs are expected to hurt export earnings for European firms and slow the economy.</p>

<p class="content-para">Von der Leyen said that the 15% rate was “the best we could do” and credited the deal with maintaining access to the U.S. market, and providing “stability and predictability for companies on both sides.” German Chancellor Friedrich Merz welcomed the deal which avoided “an unnecessary escalation in trans-Atlantic trade relations” and said that “we were able to preserve our core interests,” while adding that “I would have very much wished for further relief in trans-Atlantic trade.”</p>

<p class="content-para">Senior French officials on Monday criticized the accord. Strategy Commissioner Clément Beaune said that the deal failed to reflect the bloc’s economic strength.</p>

<p class="content-para">“This is an unequal and unbalanced agreement,” he said. “Europe didn’t wield its strength. We are the world’s leading trading power.”</p>

<p class="content-para">While the rate is lower than threatened, “the big caveat to today’s deal is that there is nothing on paper, yet,” said Carsten Brzeski, global chief of macro at ING bank.</p>

<p class="content-para">“With this disclaimer in mind and at face value, the agreement would clearly bring an end to the uncertainty of recent months. An escalation of the U.S.-EU trade tensions would have been a severe risk for the global economy,” Brzeski said.</p>

<p class="content-para">“This risk seems to have been avoided.” Asked if European carmakers could still profitably sell cars at 15%, von der Leyen said the rate was much lower than the current 27.5%. That has been the rate under Trump’s 25% tariff on cars from all countries, plus the preexisting U.S. car tariff of 2.5%.</p>

<p class="content-para">The impact is likely to be substantial on some companies, given that automaker Volkswagen said that it suffered a 1.3 billion-euro ($1.5 billion) hit to profits in the first half of the year from the higher tariffs.</p>

<p class="content-para">Mercedes-Benz dealers in the U.S. have said they were holding the line on 2025 model year prices “until further notice.” The German automaker has a partial tariff shield, because it makes 35% of the Mercedes-Benz vehicles sold in the U.S. in Tuscaloosa, Alabama, but the company said that it expects prices to undergo “significant increases” in coming years.</p>

<p class="content-para">The EU also agreed to lower its tariff on cars imported from the U.S. to 2.5% from 10%.</p>

<p class="content-para">Before Trump returned to office, the U.S. and the EU maintained generally low tariff levels in what is the largest bilateral trading relationship in the world, with around 1.7 trillion euros ($2 trillion) in annual trade.</p>

<p class="content-para">Together the U.S. and the EU have 44% of the global economy. The U.S. rate averaged 1.47% for European goods, while the EU has averaged 1.35% for American products, according to the Bruegel think tank in Brussels.</p>

<p class="content-para">Trump has complained about the EU’s 198 billion-euro ($232.5 billion) trade surplus in goods, which shows Americans buy more from European businesses than the other way around, and has said that the European market isn’t open enough for U.S.-made cars.</p>

<p class="content-para">However, American companies fill some of the trade gap by outselling the EU when it comes to services such as cloud computing, travel bookings and legal and financial services. And about 30% of European imports are from American-owned companies, according to the European Central Bank.</p>
        </div>
      </div>

    <!-- Blog Section -->
    <section class="latest-blog-wrapper">
        <h2 class="latest-blog-title">LATEST FROM BLOG</h2>

        <div class="latest-blog-grid">
            <!-- Blog Item 1 -->
            <a title="more" href="../global-affairs/eu-and-japan-agree-to-work-together-to-promote-free-trade-and-economic-security.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/eu-and-japan-agree-to-work-together.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">EU and Japan agree to work together to promote free trade and economic security</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 2 -->
            <a title="more" href="../global-affairs/eu-imposes-new-tariffs-on-23-billion-in-us-goods-in-retaliation-for-trumps-steel-aluminum-tariffs.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/eu-imposes-new-tariffs.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">EU imposes new tariffs on $23 billion in US goods in retaliation for Trump’s steel, aluminum tariffs</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 3 -->
            <a title="more" href="../global-affairs/eu-considers-pooling-demand-from-companies-to-buy-more-us-gas.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/eu-considers-pooling-demand.avif"
                        alt="Image">
                </div>
                <h3 class="blog-heading">EU considers pooling demand from companies to buy more US gas</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 4 -->
            <a title="more" href="../global-affairs/rubio-says-us-and-mexico-will-strengthen-security-collaboration.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/rubio-says-us-and-mexico-will-strengthen.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Rubio says US and Mexico will strengthen security collaboration</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 5 -->
            <a title="more" href="../politics-and-policy/california-gov-gavin-newsom-signs-landmark-bill-creating-ai-safety-measures.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/california-gov-gavin-newsom-signs.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">California Gov. Gavin Newsom signs landmark bill creating AI safety measures</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>


        </div>
<?php include '../footer.php'; ?>
    </section>

    <script defer src="../js/style.js" ></script>
</body>

</html>