<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>EU considers pooling demand from companies to buy more US gas</title>
    <link rel="stylesheet" href="../css/style.css">
        <meta name="description"
        content="Federal Reserve official cites weak jobs data as support for three upcoming interest rate cuts, signaling a shift toward easing monetary policy">
    <meta property="og:title" content="A top Federal Reserve official says dour jobs data backs the case for 3 rate cuts">
    <meta property="og:description"
        content="Federal Reserve official cites weak jobs data as support for three upcoming interest rate cuts, signaling a shift toward easing monetary policy">
    <meta name="keywords" content="Federal Reserve">
    <meta property="og:url" content="https://www.policynow.org/a-top-federal-reserve-official-says-dour-jobs-data-backs-the-case-for-three-rate-cuts">
    <meta property="og:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta property="og:site_name" content="">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_US">
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="A top Federal Reserve official says dour jobs data backs the case for 3 rate cuts">
    <meta name="twitter:description"
        content="Federal Reserve official cites weak jobs data as support for three upcoming interest rate cuts, signaling a shift toward easing monetary policy">
    <meta name="twitter:url" content="https://www.policynow.org/a-top-federal-reserve-official-says-dour-jobs-data-backs-the-case-for-three-rate-cuts">
    <meta name="twitter:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta name="twitter:site" content="@policynow">
    <meta name="twitter:creator" content="@policynow">
    <link rel="icon" type="image/x-icon" href="https://www.policynow.org/image/favicon.png">
    <link rel="canonical" href="https://www.policynow.org/a-top-federal-reserve-official-says-dour-jobs-data-backs-the-case-for-three-rate-cuts">
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "NewsArticle",
  "mainEntityOfPage": {
    "@id": "https://www.policynow.org/a-top-federal-reserve-official-says-dour-jobs-data-backs-the-case-for-three-rate-cuts"
  },
  "headline": "A top Federal Reserve official says dour jobs data backs the case for 3 rate cuts",
  "image": [
    "https://www.policynow.org/image/twitter-card.png"
  ],
  "datePublished": "2025-11-17T08:28:00-04:00",
  "dateModified": "2025-11-17T08:28:00-04:00",
  "description": "Federal Reserve official cites weak jobs data as support for three upcoming interest rate cuts, signaling a shift toward easing monetary policy",
  "author": {
    "@type": "Person",
    "name": "Editorial Board"
  },
  "publisher": {
    "@type": "Organization",
    "name": "policynow",
    "logo": {
      "@type": "ImageObject",
      "url": "https://www.policynow.org/image/policynow-logo.png"
    }
  },
  "keywords": ["Fed rate cuts", "U.S. jobs data", "interest rates", "monetary policy", "economic slowdown", "inflation", "U.S. economy", "rate cut forecast", "labor market", "central bank", "interest rate decision", "economic outlook", "Federal Reserve official", "job market report"]

}
</script>
</head>

<body class="light-mode">
<?php include '../header.php'; ?>

    <div class="main-container">
        <div class="date-row">
            <div class="day">
                <strong><?php
echo date("l, F j, Y"); 
?></strong>
            </div>

            <div class="top-center">
                <a href="../main.php"><img src="../image/policynow-logo.png"
                    alt="Logo"></a>
            </div>
            <div class="top-right"> 
                <img src="../image/search.png" class="menu-toggle" alt="search" width="16" height="16">
                <div  class="search-box" id="searchBox">
                    <input type="text" placeholder="Type & hit enter">
                     <img  src="../image/search.png" class="menu-toggle1" alt="search" width="16" height="16">
                </div>
                <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                 <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
            </div>
        </div>
        <nav class="main-nav1">
            <a title="Politics & Policy" class="nav-H" href="../politics-and-policy.php">Politics & Policy</a>
            <a title="Business & Economy" class="nav-l" href="../business-and-economy.php">Business & Economy</a>
            <a title="Global Affairs" class="nav-l" href="../global-affairs.php">Global Affairs</a>
            <a title="Technology & Innovation" class="nav-l" href="../technology-and-innovation.php">Technology & Innovation</a>
            <a title="Finance & Markets" class="nav-l" href="../finance-and-markets.php">Finance & Markets</a>
            <a title="Featured PR" class="nav-l" href="../featured-pr.php">Featured PR</a>
            <a title="Author" class="nav-l" href="../author.php">Authors</a>
        </nav>

    </div>
      <div class="main">
          <section class="highlight-news">
            <div class="highlight-category">
                <a title="Global Affairs" href="#">Global Affairs</a>
            </div>
            <div class="live-sect">
                <span class="live-status">
                    <span class="dot"></span>

                </span>
                <p> <span class="live-badge">LIVE</span>
                    7 days ago</p>
            </div>
            <h1 class="highlight-title">EU considers pooling demand from companies to buy more US gas</h1>
            <p class="content-para">The European Commission could pool demand from European companies to buy more U.S. liquefied natural gas, as part of its efforts to reach a pledge to buy $250 billion in U.S. energy per year, it said on Thursday.</p>


            <div class="highlight-footer">
                <div class="author-blocks">
                    <div class="author-card">
                        <img src="../image/joel-j-zarate.jpg"
                            alt="Joel J. Zarate">
                        <div class="author-info">
                            <a title="Joel J. Zarate" href="author.php">Joel J. Zarate</a>
                            <span>NOVEMBER 05, 2025</span>
                        </div>
                    </div>
                    
                </div>

                <div class="share-block">
                    <span>Share this</span>
                    <div class="share-icons">
                        <a title="facebook" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                        </a>
                        <a title="twitter" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                        </a>

                        <a title="youtube" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
                        </a>
                    </div>
                    <div class="share-single">
                        <button>
                            <a title="more" href="#"><i class="fa-solid fa-share-nodes"></i></a>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <div class="img-section">
            <img src="../image/eu-considers-pooling-demand.avif"
                alt="How the US-EU trade deal">
        </div>

        <div class="second-sec">

       <p class="content-para">Under a framework trade deal the U.S. and EU agreed on Sunday, the European Union agreed to increase its purchases of U.S. energy to $750 billion over the next three years. Analysts have said that is unrealistically high.</p>

<p class="content-para">The Commission has said it will remain up to private companies to choose where they buy energy, but that it was considering pooling European buyers' demand to match it with U.S. supplies.</p>

<p class="content-para">"We are ready to do that," a Commission spokesperson told reporters on Thursday.</p>

<p class="content-para">"At the moment, we don't have any decision on a dedicated Aggregate, but this can be done very speedily, if there's a need and interest," the spokesperson said.</p>

<p class="content-para">"AggregateEU" is the EU's scheme to pool companies' demand for gas, which it launched in 2022 to attempt to replace Russian fuel with alternative supplies in response to the Ukraine war.</p>

<p class="content-para">A round of this scheme targeting U.S. LNG could be organised as soon as September, if needed, the Commission spokesperson said.</p>

<p class="content-para">The $750 billion energy deal covers EU purchases of U.S. oil, LNG and nuclear fuel and technologies.</p>

<p class="content-para">Analysts said this number was higher than U.S. energy exports would realistically allow - and that the EU's oil and gas demand is expected to decline, as the bloc shifts to clean energy to meet climate targets.</p>

<p class="content-para">The Commission has said the U.S. deal will not undermine its climate targets, which include legally binding commitments to cut emissions by 2030 and 2050.</p>

<p class="content-para">"This will have no impact on our decarbonisation targets, none whatsoever. The agreement is for three years, three years only," the spokesperson said on Thursday.</p>

<p class="content-para">However, the Commission said in a factsheet published on Wednesday that it could match EU companies with U.S. LNG supplies for a longer period - from 2025 until 2050.</p>
        </div>
      </div>

    <!-- Blog Section -->
    <section class="latest-blog-wrapper">
        <h2 class="latest-blog-title">LATEST FROM BLOG</h2>

        <div class="latest-blog-grid">
            <!-- Blog Item 1 -->
            <a title="more" href="../global-affairs/how-the-us-eu-trade-deal-wards-off-more-escalation-but-will-raise-prices-and-slow-growth.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/how-the-us-eu-trade-deal.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">How the US-EU trade deal wards off more escalation but will raise prices and slow growth</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 2 -->
            <a title="more" href="../global-affairs/eu-imposes-new-tariffs-on-23-billion-in-us-goods-in-retaliation-for-trumps-steel-aluminum-tariffs.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/eu-imposes-new-tariffs.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">EU imposes new tariffs on $23 billion in US goods in retaliation for Trump’s steel, aluminum tariffs</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 3 -->
            <a title="more" href="../global-affairs/eu-and-japan-agree-to-work-together-to-promote-free-trade-and-economic-security.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/eu-and-japan-agree-to-work-together.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">EU and Japan agree to work together to promote free trade and economic security</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 4 -->
            <a title="more" href="../global-affairs/rubio-says-us-and-mexico-will-strengthen-security-collaboration.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/rubio-says-us-and-mexico-will-strengthen.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Rubio says US and Mexico will strengthen security collaboration</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 5 -->
            <a title="more" href="../politics-and-policy/california-gov-gavin-newsom-signs-landmark-bill-creating-ai-safety-measures.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/california-gov-gavin-newsom-signs.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">California Gov. Gavin Newsom signs landmark bill creating AI safety measures</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>


        </div>
<?php include '../footer.php'; ?>
    </section>

    <script defer src="../js/style.js" ></script>
</body>

</html>