<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>EU and Japan agree to work together to promote free trade and economic security</title>
    <link rel="stylesheet" href="../css/style.css">
        <meta name="description"
        content="Federal Reserve official cites weak jobs data as support for three upcoming interest rate cuts, signaling a shift toward easing monetary policy">
    <meta property="og:title" content="A top Federal Reserve official says dour jobs data backs the case for 3 rate cuts">
    <meta property="og:description"
        content="Federal Reserve official cites weak jobs data as support for three upcoming interest rate cuts, signaling a shift toward easing monetary policy">
    <meta name="keywords" content="Federal Reserve">
    <meta property="og:url" content="https://www.policynow.org/a-top-federal-reserve-official-says-dour-jobs-data-backs-the-case-for-three-rate-cuts">
    <meta property="og:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta property="og:site_name" content="">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_US">
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="A top Federal Reserve official says dour jobs data backs the case for 3 rate cuts">
    <meta name="twitter:description"
        content="Federal Reserve official cites weak jobs data as support for three upcoming interest rate cuts, signaling a shift toward easing monetary policy">
    <meta name="twitter:url" content="https://www.policynow.org/a-top-federal-reserve-official-says-dour-jobs-data-backs-the-case-for-three-rate-cuts">
    <meta name="twitter:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta name="twitter:site" content="@policynow">
    <meta name="twitter:creator" content="@policynow">
    <link rel="icon" type="image/x-icon" href="https://www.policynow.org/image/favicon.png">
    <link rel="canonical" href="https://www.policynow.org/a-top-federal-reserve-official-says-dour-jobs-data-backs-the-case-for-three-rate-cuts">
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "NewsArticle",
  "mainEntityOfPage": {
    "@id": "https://www.policynow.org/a-top-federal-reserve-official-says-dour-jobs-data-backs-the-case-for-three-rate-cuts"
  },
  "headline": "A top Federal Reserve official says dour jobs data backs the case for 3 rate cuts",
  "image": [
    "https://www.policynow.org/image/twitter-card.png"
  ],
  "datePublished": "2025-11-17T08:28:00-04:00",
  "dateModified": "2025-11-17T08:28:00-04:00",
  "description": "Federal Reserve official cites weak jobs data as support for three upcoming interest rate cuts, signaling a shift toward easing monetary policy",
  "author": {
    "@type": "Person",
    "name": "Editorial Board"
  },
  "publisher": {
    "@type": "Organization",
    "name": "policynow",
    "logo": {
      "@type": "ImageObject",
      "url": "https://www.policynow.org/image/policynow-logo.png"
    }
  },
  "keywords": ["Fed rate cuts", "U.S. jobs data", "interest rates", "monetary policy", "economic slowdown", "inflation", "U.S. economy", "rate cut forecast", "labor market", "central bank", "interest rate decision", "economic outlook", "Federal Reserve official", "job market report"]

}
</script>
</head>

<body class="light-mode">
<?php include '../header.php'; ?>

    <div class="main-container">
        <div class="date-row">
            <div class="day">
                <strong><?php
echo date("l, F j, Y"); 
?></strong>
            </div>

            <div class="top-center">
                <a href="../main.php"><img src="../image/policynow-logo.png"
                    alt="Logo"></a>
            </div>
            <div class="top-right"> 
                <img src="../image/search.png" class="menu-toggle" alt="search" width="16" height="16">
                <div  class="search-box" id="searchBox">
                    <input type="text" placeholder="Type & hit enter">
                     <img  src="../image/search.png" class="menu-toggle1" alt="search" width="16" height="16">
                </div>
                <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                 <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
            </div>
        </div>
        <nav class="main-nav1">
            <a title="Politics & Policy" class="nav-H" href="../politics-and-policy.php">Politics & Policy</a>
            <a title="Business & Economy" class="nav-l" href="../business-and-economy.php">Business & Economy</a>
            <a title="Global Affairs" class="nav-l" href="../global-affairs.php">Global Affairs</a>
            <a title="Technology & Innovation" class="nav-l" href="../technology-and-innovation.php">Technology & Innovation</a>
            <a title="Finance & Markets" class="nav-l" href="../finance-and-markets.php">Finance & Markets</a>
            <a title="Featured PR" class="nav-l" href="../featured-pr.php">Featured PR</a>
            <a title="Author" class="nav-l" href="../author.php">Authors</a>
        </nav>

    </div>
      <div class="main">
          <section class="highlight-news">
            <div class="highlight-category">
                <a title="Global Affairs" href="#">Global Affairs</a>
            </div>
            <div class="live-sect">
                <span class="live-status">
                    <span class="dot"></span>

                </span>
                <p> <span class="live-badge">LIVE</span>
                    7 days ago</p>
            </div>
            <h1 class="highlight-title">EU and Japan agree to work together to promote free trade and economic security</h1>
            <p class="content-para">Leaders of the European Union and Japan launched an alliance Wednesday aimed at boosting economic cooperation, defending free trade and countering unfair trade practices as the two sides face growing challenges from the United States and China.</p>

            <div class="highlight-footer">
                <div class="author-blocks">
                    <div class="author-card">
                        <img src="../image/joel-j-zarate.jpg"
                            alt="Joel J. Zarate">
                        <div class="author-info">
                            <a title="Joel J. Zarate" href="author.php">Joel J. Zarate</a>
                            <span>NOVEMBER 05, 2025</span>
                        </div>
                    </div>
                    
                </div>

                <div class="share-block">
                    <span>Share this</span>
                    <div class="share-icons">
                        <a title="facebook" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                        </a>
                        <a title="twitter" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                        </a>

                        <a title="youtube" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
                        </a>
                    </div>
                    <div class="share-single">
                        <button>
                            <a title="more" href="#"><i class="fa-solid fa-share-nodes"></i></a>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <div class="img-section">
            <img src="../image/eu-and-japan-agree-to-work-together.webp"
                alt="EU and Japan agree to work together">
        </div>

        <div class="second-sec">

       <p class="content-para">The agreement followed a meeting among European Commission President Ursula von der Leyen, European Council President António Costa and Japanese Prime Minister Shigeru Ishiba. It comes just as Tokyo and Washington reached a new trade deal, which places 15% tariffs on Japanese cars and other goods imported into the U.S., down from an initial 25%.</p>

<p class="content-para">The leaders agreed to launch “competitiveness alliance” aimed at stepping up trade, economic security and cooperation in innovation, energy and other areas, according to a joint statement released by the EU.</p>

<p class="content-para">The leaders also supported “a stable and predictable rules-based free and fair economic order,” and reaffirmed the importance of Japan-EU cooperation to uphold multilateral trading system with the World Trade Organization at its core, as well as with other multilateral cooperation efforts.</p>

<p class="content-para">The EU and Japan also agreed to strengthen defense industry cooperation and to start talks on an information security agreement.</p>

<p class="content-para">Japan and the EU have been stepping up their security and defense cooperation amid growing global tensions and conflicts, including Russia’s war on Ukraine, conflicts in the Middle East and increasingly assertive China’s military activity in Asia, recognizing that challenges in Europe and Indo-Pacific are inseparable.</p>
        </div>
      </div>

    <!-- Blog Section -->
    <section class="latest-blog-wrapper">
        <h2 class="latest-blog-title">LATEST FROM BLOG</h2>

        <div class="latest-blog-grid">
            <!-- Blog Item 1 -->
            <a title="more" href="../global-affairs/how-the-us-eu-trade-deal-wards-off-more-escalation-but-will-raise-prices-and-slow-growth.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/how-the-us-eu-trade-deal.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">How the US-EU trade deal wards off more escalation but will raise prices and slow growth</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 2 -->
            <a title="more" href="global-affairs/eu-imposes-new-tariffs-on-23-billion-in-us-goods-in-retaliation-for-trumps-steel-aluminum-tariffs.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/eu-imposes-new-tariffs.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">EU imposes new tariffs on $23 billion in US goods in retaliation for Trump’s steel, aluminum tariffs</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 3 -->
            <a title="more" href="../global-affairs/eu-considers-pooling-demand-from-companies-to-buy-more-us-gas.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/eu-considers-pooling-demand.avif"
                        alt="Image">
                </div>
                <h3 class="blog-heading">EU considers pooling demand from companies to buy more US gas</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 4 -->
            <a title="more" href="../global-affairs/rubio-says-us-and-mexico-will-strengthen-security-collaboration.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/rubio-says-us-and-mexico-will-strengthen.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Rubio says US and Mexico will strengthen security collaboration</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 5 -->
            <a title="more" href="../politics-and-policy/california-gov-gavin-newsom-signs-landmark-bill-creating-ai-safety-measures.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/california-gov-gavin-newsom-signs.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">California Gov. Gavin Newsom signs landmark bill creating AI safety measures</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>


        </div>
<?php include '../footer.php'; ?>
    </section>

    <script defer src="../js/style.js" ></script>
</body>

</html>