<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Treasury recommends exploring creation of a digital dollar</title>
    <link rel="stylesheet" href="../css/style.css">
        <meta name="description"
        content="The U.S. Treasury urges further study of a potential digital dollar, highlighting its benefits, risks, and impact on the nation’s financial system">
    <meta property="og:title" content="Treasury recommends exploring creation of a digital dollar">
    <meta property="og:description"
        content="The U.S. Treasury urges further study of a potential digital dollar, highlighting its benefits, risks, and impact on the nation’s financial system">
    <meta name="keywords" content="digital dollar">
    <meta property="og:url" content="https://www.policynow.org/treasury-recommends-exploring-creation-of-a-digital-dollar">
    <meta property="og:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta property="og:site_name" content="">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_US">
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Treasury recommends exploring creation of a digital dollar">
    <meta name="twitter:description"
        content="The U.S. Treasury urges further study of a potential digital dollar, highlighting its benefits, risks, and impact on the nation’s financial system">
    <meta name="twitter:url" content="https://www.policynow.org/treasury-recommends-exploring-creation-of-a-digital-dollar">
    <meta name="twitter:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta name="twitter:site" content="@policynow">
    <meta name="twitter:creator" content="@policynow">
    <link rel="icon" type="image/x-icon" href="https://www.policynow.org/image/favicon.png">
    <link rel="canonical" href="https://www.policynow.org/treasury-recommends-exploring-creation-of-a-digital-dollar">
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "NewsArticle",
  "mainEntityOfPage": {
    "@id": "https://www.policynow.org/treasury-recommends-exploring-creation-of-a-digital-dollar"
  },
  "headline": "Treasury recommends exploring creation of a digital dollar",
  "image": [
    "https://www.policynow.org/image/twitter-card.png"
  ],
  "datePublished": "2025-11-17T08:28:00-04:00",
  "dateModified": "2025-11-17T08:28:00-04:00",
  "description": "The U.S. Treasury urges further study of a potential digital dollar, highlighting its benefits, risks, and impact on the nation’s financial system",
  "author": {
    "@type": "Person",
    "name": "Editorial Board"
  },
  "publisher": {
    "@type": "Organization",
    "name": "policynow",
    "logo": {
      "@type": "ImageObject",
      "url": "https://www.policynow.org/image/policynow-logo.png"
    }
  },
  "keywords": ["U.S. Treasury", "CBDC", "central bank digital currency", "US financial system", "digital currency study", "digital dollar proposal", "Treasury report", "Federal Reserve digital currency", "U.S. economic policy", "future of money", "digital payments", "government digital currency", "financial innovation US", "digital dollar benefits"]

}
</script>
</head>

<body class="light-mode">
<?php include '../header.php'; ?>

    <div class="main-container">
        <div class="date-row">
            <div class="day">
                <strong><?php
echo date("l, F j, Y"); 
?></strong>
            </div>

            <div class="top-center">
                <a href="../main.php"><img src="../image/policynow-logo.png"
                    alt="Logo"></a>
            </div>
            <div class="top-right"> 
                <img src="../image/search.png" class="menu-toggle" alt="search" width="16" height="16">
                <div  class="search-box" id="searchBox">
                    <input type="text" placeholder="Type & hit enter">
                     <img  src="../image/search.png" class="menu-toggle1" alt="search" width="16" height="16">
                </div>
                <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                 <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
            </div>
        </div>
        <nav class="main-nav1">
            <a title="Politics & Policy" class="nav-H" href="../politics-and-policy.php">Politics & Policy</a>
            <a title="Business & Economy" class="nav-l" href="../business-and-economy.php">Business & Economy</a>
            <a title="Global Affairs" class="nav-l" href="../global-affairs.php">Global Affairs</a>
            <a title="Technology & Innovation" class="nav-l" href="../technology-and-innovation.php">Technology & Innovation</a>
            <a title="Finance & Markets" class="nav-l" href="../finance-and-markets.php">Finance & Markets</a>
            <a title="Featured PR" class="nav-l" href="../featured-pr.php">Featured PR</a>
            <a title="Author" class="nav-l" href="../author.php">Authors</a>
        </nav>

    </div>
      <div class="main">
          <section class="highlight-news">
            <div class="highlight-category">
                <a title="Finance & Markets" href="#">Finance & Markets</a>
            </div>
            <div class="live-sect">
                <span class="live-status">
                    <span class="dot"></span>

                </span>
                <p> <span class="live-badge">LIVE</span>
                    7 days ago</p>
            </div>
            <h1 class="highlight-title">Treasury recommends exploring creation of a digital dollar</h1>
<p class="content-para">The Biden administration is moving one step closer to developing a central bank digital currency, known as the digital dollar, saying it would help reinforce the U.S. role as a leader in the world financial system.</p>


            <div class="highlight-footer">
                <div class="author-blocks">
                    <div class="author-card">
                        <img src="../image/lisa-g-hart.jpg"
                            alt="Lisa G. Hart">
                        <div class="author-info">
                            <a title="Lisa G. Hart" href="author.php">Lisa G. Hart</a>
                            <span>NOVEMBER 06, 2025</span>
                        </div>
                    </div>
                    
                </div>

                <div class="share-block">
                    <span>Share this</span>
                    <div class="share-icons">
                        <a title="facebook" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                        </a>
                        <a title="twitter" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                        </a>

                        <a title="youtube" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
                        </a>
                    </div>
                    <div class="share-single">
                        <button>
                            <a title="more" href="#"><i class="fa-solid fa-share-nodes"></i></a>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <div class="img-section">
            <img src="../image/treasury-recommends-exploring-creation.webp"
                alt="Image">
        </div>


        <div class="second-sec">

<p class="content-para">The White House said on Friday that after President Joe Biden issued an executive order in March calling on a variety of agencies to look at ways to regulate digital assets, the agencies came up with nine reports, covering cryptocurrency impacts on financial markets, the environment, innovation and other elements of the economic system.</p>

<p class="content-para">Treasury Secretary Janet Yellen said one Treasury recommendation is that the U.S. “advance policy and technical work on a potential central bank digital currency, or CBDC, so that the United States is prepared if CBDC is determined to be in the national interest.”</p>

<p class="content-para">“Right now, some aspects of our current payment system are too slow or too expensive,” Yellen said on a Thursday call with reporters laying out some of the findings of the reports. Central bank digital currencies differ from existing digital money available to the general public, such as the balance in a bank account, because they would be a direct liability of the Federal Reserve, not a commercial bank.</p>

<p class="content-para">According to the Atlantic Council nonpartisan think tank, 105 countries representing more than 95% of global gross domestic product already are exploring or have created a central bank digital currency.</p>

<p class="content-para">The council found that the U.S. and the U.K. are far behind in creating a digital dollar or its equivalent.</p>

<p class="content-para">Treasury, the Justice Department, the Consumer Finance Protection Bureau, the Securities and Exchange Commission and other agencies were tasked with contributing to reports that would address various concerns about the risks, development and usage of digital assets. Several reports will come out in the next weeks and months.</p>

<p class="content-para">Eswar Prasad, a trade professor at Cornell who studies the digitization of currencies, said Treasury’s report “takes a positive view about how a digital dollar might play a useful role in increasing payment options for individuals and businesses” while acknowledging the risks of its development.</p>

<p class="content-para">He said the report sets the stage for the creation of agency regulations and legislation “that can improve the benefit-risk tradeoff associated with cryptocurrencies and related technologies.”</p>

<p class="content-para">The Blockchain Association, which lobbies lawmakers on Capitol Hill, said in a statement that the White House reports are “a missed opportunity to cement U.S. crypto leadership.”</p>

<p class="content-para">“These reports focus on risks — not opportunities,” the statement reads, “and omit substantive recommendations on how the United States can promote its burgeoning crypto industry, including job creation, improvements to the financial system, and expanded access for all Americans.”</p>

<p class="content-para">On Capitol Hill, lawmakers have submitted various pieces of legislation to regulate cryptocurrency and other digital assets.</p>

<p class="content-para">Sheila Warren, CEO of the Crypto Council for Innovation, said in an emailed statement that the report “seem to kick the can down the road” she said, “we don’t see clear recommendations.”</p>
        </div>
      </div>

    <!-- Blog Section -->
    <section class="latest-blog-wrapper">
        <h2 class="latest-blog-title">LATEST FROM BLOG</h2>

          <div class="latest-blog-grid">
            <!-- Blog Item 1 -->
            <a title="more" href="../finance-and-markets/house-sends-bill-regulating-stablecoins-a-type-of-cryptocurrency-to-trump.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/house-sends-bill-regulating-stablecoins.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">House sends bill regulating stablecoins, a type of cryptocurrency, to Trump</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 2 -->
            <a title="more" href="../finance-and-markets/tether-unveils-usat-stablecoin-to-boost-us-market-presence.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/tether-unveils-usat-stablecoin.avif"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Tether unveils USAT stablecoin to boost US market presence</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 3 -->
            <a title="more" href="../finance-and-markets/the-crypto-industry-saw-trump-as-a-champion-some-now-fear-hes-putting-personal-profits-first.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/the-crypto-industry-saw.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">The crypto industry saw Trump as a champion. Some now fear he’s putting personal profits first</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 4 -->
            <a title="more" href="../finance-and-markets/senate-passes-crypto-regulations-sends-to-house-without-addressing-trumps-investments.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/senate-passes-crypto-regulations.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Senate passes crypto regulations, sends to House without addressing Trump’s investments</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 5 -->
            <a title="more" href="../finance-and-markets/fed-study-on-digital-currency-leans-toward-role-for-banks.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/fed-study-on-digital-currency.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Fed study on digital currency leans toward role for banks</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>
        </div>
<?php include '../footer.php'; ?>
    </section>

    <script defer src="../js/style.js" ></script>
</body>

</html>