<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>The crypto industry saw Trump as a champion. Some now fear he’s putting personal profits first</title>
    <link rel="stylesheet" href="../css/style.css">
        <meta name="description"
        content="The crypto industry once viewed Trump as a strong supporter, but some now worry he is prioritizing personal financial gain over broader industry interests">
    <meta property="og:title" content="The crypto industry saw Trump as a champion. Some now fear he’s putting personal profits first">
    <meta property="og:description"
        content="The crypto industry once viewed Trump as a strong supporter, but some now worry he is prioritizing personal financial gain over broader industry interests">
    <meta name="keywords" content="crypto industry">
    <meta property="og:url" content="https://www.policynow.org/the-crypto-industry-saw-trump-as-a-champion-some-now-fear-hes-putting-personal-profits-first">
    <meta property="og:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta property="og:site_name" content="">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_US">
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="The crypto industry saw Trump as a champion. Some now fear he’s putting personal profits first">
    <meta name="twitter:description"
        content="The crypto industry once viewed Trump as a strong supporter, but some now worry he is prioritizing personal financial gain over broader industry interests">
    <meta name="twitter:url" content="https://www.policynow.org/the-crypto-industry-saw-trump-as-a-champion-some-now-fear-hes-putting-personal-profits-first">
    <meta name="twitter:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta name="twitter:site" content="@policynow">
    <meta name="twitter:creator" content="@policynow">
    <link rel="icon" type="image/x-icon" href="https://www.policynow.org/image/favicon.png">
    <link rel="canonical" href="https://www.policynow.org/the-crypto-industry-saw-trump-as-a-champion-some-now-fear-hes-putting-personal-profits-first">
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "NewsArticle",
  "mainEntityOfPage": {
    "@id": "https://www.policynow.org/the-crypto-industry-saw-trump-as-a-champion-some-now-fear-hes-putting-personal-profits-first"
  },
  "headline": "The crypto industry saw Trump as a champion. Some now fear he’s putting personal profits first",
  "image": [
    "https://www.policynow.org/image/twitter-card.png"
  ],
  "datePublished": "2025-11-17T08:28:00-04:00",
  "dateModified": "2025-11-17T08:28:00-04:00",
  "description": "The crypto industry once viewed Trump as a strong supporter, but some now worry he is prioritizing personal financial gain over broader industry interests",
  "author": {
    "@type": "Person",
    "name": "Editorial Board"
  },
  "publisher": {
    "@type": "Organization",
    "name": "policynow",
    "logo": {
      "@type": "ImageObject",
      "url": "https://www.policynow.org/image/policynow-logo.png"
    }
  },
  "keywords": ["Donald Trump", "personal profits", "crypto concerns", "industry support", "cryptocurrency", "crypto politics", "financial interests", "crypto regulation", "digital assets", "industry distrust", "crypto community", "U.S. politics", "Trump policies", "crypto market"]

}
</script>
</head>

<body class="light-mode">
<?php include '../header.php'; ?>

    <div class="main-container">
        <div class="date-row">
            <div class="day">
                <strong><?php
echo date("l, F j, Y"); 
?></strong>
            </div>

            <div class="top-center">
                <a href="../main.php"><img src="../image/policynow-logo.png"
                    alt="Logo"></a>
            </div>
            <div class="top-right"> 
                <img src="../image/search.png" class="menu-toggle" alt="search" width="16" height="16">
                <div  class="search-box" id="searchBox">
                    <input type="text" placeholder="Type & hit enter">
                     <img  src="../image/search.png" class="menu-toggle1" alt="search" width="16" height="16">
                </div>
                <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                 <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
            </div>
        </div>
        <nav class="main-nav1">
            <a title="Politics & Policy" class="nav-H" href="../politics-and-policy.php">Politics & Policy</a>
            <a title="Business & Economy" class="nav-l" href="../business-and-economy.php">Business & Economy</a>
            <a title="Global Affairs" class="nav-l" href="../global-affairs.php">Global Affairs</a>
            <a title="Technology & Innovation" class="nav-l" href="../technology-and-innovation.php">Technology & Innovation</a>
            <a title="Finance & Markets" class="nav-l" href="../finance-and-markets.php">Finance & Markets</a>
            <a title="Featured PR" class="nav-l" href="../featured-pr.php">Featured PR</a>
            <a title="Author" class="nav-l" href="../author.php">Authors</a>
        </nav>

    </div>
      <div class="main">
          <section class="highlight-news">
            <div class="highlight-category">
                <a title="Finance & Markets" href="#">Finance & Markets</a>
            </div>
            <div class="live-sect">
                <span class="live-status">
                    <span class="dot"></span>

                </span>
                <p> <span class="live-badge">LIVE</span>
                    7 days ago</p>
            </div>
            <h1 class="highlight-title">The crypto industry saw Trump as a champion. Some now fear he’s putting personal profits first</h1>
<p class="content-para">It seems like a triumph for a cryptocurrency industry that has long sought mainstream acceptance: Top investors in one of President Donald Trump’s crypto projects dining with him at his luxury golf club in Northern Virginia, on the heels of the Senate advancing key pro-crypto legislation and while bitcoin prices soar.</p>


            <div class="highlight-footer">
                <div class="author-blocks">
                    <div class="author-card">
                        <img src="../image/lisa-g-hart.jpg"
                            alt="Lisa G. Hart">
                        <div class="author-info">
                            <a title="Lisa G. Hart" href="author.php">Lisa G. Hart</a>
                            <span>NOVEMBER 07, 2025</span>
                        </div>
                    </div>
                    
                </div>

                <div class="share-block">
                    <span>Share this</span>
                    <div class="share-icons">
                        <a title="facebook" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                        </a>
                        <a title="twitter" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                        </a>

                        <a title="youtube" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
                        </a>
                    </div>
                    <div class="share-single">
                        <button>
                            <a title="more" href="#"><i class="fa-solid fa-share-nodes"></i></a>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <div class="img-section">
            <img src="../image/the-crypto-industry-saw.webp"
                alt="The crypto industry saw">
        </div>

        <div class="second-sec">

       <p class="content-para">But Thursday night’s dinner for the 220 biggest investors in the $TRUMP meme coin has raised uncomfortable questions about potentially shadowy buyers using the anonymity of the internet to buy access to the president.</p>

        <p class="content-para">While critics charge that Trump is using the power of the presidency to boost profits for his family business, even some pro-Trump crypto enthusiasts worry that the president’s push into meme coins isn’t helping their efforts to establish the credibility, stability and legitimacy they had thought his administration would bring to their businesses.</p>

        <p class="content-para">After feeling unfairly targeted by the Biden administration, the industry has quickly become a dominant political force, donating huge sums to help Trump and crypto-friendly lawmakers. But that’s also served to tether the industry — sometimes uncomfortably — to a president who is using crypto as a platform to make money for his brand in unprecedented ways.</p>

        <p class="content-para">“It’s distasteful and an unnecessary distraction,” said Nic Carter, a Trump supporter and partner at the crypto investment firm Castle Island Ventures, who said the president is “hugging us to death” with his private crypto businesses. “We would much rather that he passes common sense legislation and leave it at that.”</p>

        <p class="content-para"><strong>Concerns about Trump’s crypto ventures predate Inauguration Day</strong></p>

        <p class="content-para">At the swanky Crypto Ball held down the street from the White House three days before he took office on Jan. 20, Trump announced the creation of the meme coin $TRUMP as a way for his supporters to “have fun.”</p>

        <p class="content-para">Meme coins are the crypto sector’s black sheep. They are often created as a joke, with no real utility and prone to extremely wild price swings that tend to enrich a small group of insiders at the expense of less sophisticated investors.</p>

        <p class="content-para">The president’s meme coin is different, however, and has a clear utility: access to Trump. The top 25 investors of $TRUMP were invited to a private reception with the president Thursday, with the top four getting $100,000 crypto-themed and Trump-branded watches.</p>

        <p class="content-para">Trump’s meme coin saw an initial spike in value, followed by a steep drop. Its creators, which include an entity controlled by the Trump Organization, have made hundreds of millions of dollars by collecting fees on trades.</p>

        <p class="content-para">First lady Melania Trump has her own meme coin, and Trump’s sons, Eric and Don Jr. — who are running the Trump Organization while their father is president — announced they are partnering with an existing firm to create a crypto mining company.</p>

        <p class="content-para">The Trump family also holds about a 60% stake in World Liberty Financial, a crypto project that provides yet another avenue where investors are buying in and enriching the president’s relatives. World Liberty has launched its own stablecoin, USD1. The project got a boost recently when World Liberty announced an investment fund in the United Arab Emirates would be using $2 billion worth of USD1 to purchase a stake in Binance, the world’s largest cryptocurrency exchange.</p>

        <p class="content-para">Stablecoins have values pegged to fixed assets like the U.S. dollar. Issuers profit by collecting the interest on the Treasury bonds and other assets used to back the stablecoins.</p>

        <p class="content-para">Crypto is now one of the most significant sources of the Trump family’s wealth.</p>

        <p class="content-para">“He’s becoming a salesman-in-chief,” said James Thurber, an American University professor emeritus who has long studied and taught about corruption around the world. “It allows for huge conflicts of interest.”</p>

        <p class="content-para"><strong>How Trump changed his mind on crypto</strong></p>

        <p class="content-para">“I’m a big crypto fan,” Trump told reporters aboard Air Force One during last week’s trip to the Middle East. “I’ve been that from the beginning, right from the campaign.”</p>

        <p class="content-para">That wasn’t always true. During his first term, Trump posted in July 2019 that cryptocurrencies were “not money” and had value that was “highly volatile and based on thin air.”</p>

        <p class="content-para">“Unregulated Crypto Assets can facilitate unlawful behavior, including drug trade,” he added then. Even after leaving office in 2021, Trump told Fox Business Network that bitcoin, the world’s most popular cryptocurrency, “seems like a scam.”</p>

        <p class="content-para">Trump began to shift during a crypto event at his Mar-a-Lago club in Florida in May 2024, receiving assurances that industry backers would spend lavishly to get him reelected. Another major milestone came last June, when Trump attended a high-dollar fundraiser at the San Francisco home of David Sacks.</p>

        <p class="content-para">He further warmed to the industry weeks later, when Trump met at Mar-a-Lago with bitcoin miners. The following month, he addressed a major crypto conference in Nashville, promising to make the U.S. the “crypto capital of the planet.”</p>

        <p class="content-para">Those close to Trump, including his sons and billionaire Elon Musk, helped further push his embrace of the industry. Sacks is now the Trump administration’s crypto czar, and many Cabinet members — including Commerce Secretary Howard Lutnick and Defense Secretary Pete Hegseth — have long been enthusiastic crypto boosters.</p>

        <p class="content-para">“I don’t have faith in the dollar,” Transportation Secretary Sean Duffy said in a 2023 interview. “I’m bullish on bitcoin.”</p>

        <p class="content-para"><strong>Trump + crypto: A political marriage of convenience</strong></p>

        <p class="content-para">Many top crypto backers were naturally wary of traditional politics, but gravitated toward Trump last year. They bristled at Democratic President Joe Biden‘s Securities and Exchange Commission aggressively bringing civil suits against several major crypto companies.</p>

        <p class="content-para">Since Trump took office, many such cases have been dropped or paused, including one alleging that Justin Sun, a China-born crypto entrepreneur, and his company engaged in market manipulation and paid celebrities for undisclosed promotions.</p>

        <p class="content-para">Sun, who once paid $6.2 million for a piece of art involving a banana taped to a wall, and then ate the banana, helped the Trumps start World Liberty Financial with an early $75 million investment.</p>

        <p class="content-para">Sun has disclosed on social media that he is the biggest holder of $TRUMP meme coins and is attending Thursday’s dinner.</p>

        <p class="content-para">“I’m excited to connect with everyone, talk crypto, and discuss the future of our industry,” Sun said.</p>

        <p class="content-para"><strong>Are Trump family profits hurting other crypto investors?</strong></p>

        <p class="content-para">Trump has signed executive orders promoting the industry, including calls to create a government bitcoin reserve. In March, Trump convened the first cryptocurrency summit at the White House.</p>

        <p class="content-para">But some of the industry’s biggest names, often brash and outspoken, have kept mostly mum on Trump’s meme coins and other projects.</p>

        <p class="content-para">“It’s not my place to really comment on President Trump’s activity,” Coinbase CEO Brian Armstrong said at a recent public event.</p>

        <p class="content-para">Meanwhile, a top legislative priority for crypto-backers, a bill clarifying how digital assets are to be regulated, has advanced in the Senate. But some Democrats have tried to stall other pro-crypto legislation over the president’s personal dealings — and see the dinner as a particularly egregious case.</p>

        <p class="content-para">Sen. Richard Blumenthal, a Connecticut Democrat, said the gathering was “in effect, putting a ‘for sale’ sign on the White House.”</p>

        <p class="content-para">“It’s auctioning off access,” Blumenthal said on a Thursday press call.</p>

        <p class="content-para">White House press secretary Karoline Leavitt said the president is attending “in his personal time.” The White House has also said it has nothing to do with Trump’s meme coin.</p>

        <p class="content-para">The president’s comments and activities at the dinner are expected to be in private and away from reporters and no official list of attendees has been released.</p>

        <p class="content-para">Like Sun, however, some of those going have publicized qualifying for the dinner. That includes Sheldon Xia, the founder of a cryptocurrency exchange called BitMart, which is registered in the Cayman Islands.</p>

        <p class="content-para">“Proud to support President Trump’s pro-crypto vision.” Xia wrote in both English and Chinese on social media.</p>

        <p class="content-para">Thurber, the expert on government and ethics, said Trump’s “personal attention to crypto at this dinner helps the crypto industry.”</p>

        <p class="content-para">“But also it’s risky,” he said, “because they could all lose a lot of money.”</p>
        </div>
      </div>

    <!-- Blog Section -->
    <section class="latest-blog-wrapper">
        <h2 class="latest-blog-title">LATEST FROM BLOG</h2>

        <div class="latest-blog-grid">
            <!-- Blog Item 1 -->
            <a title="more" href="../finance-and-markets/house-sends-bill-regulating-stablecoins-a-type-of-cryptocurrency-to-trump.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/house-sends-bill-regulating-stablecoins.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">House sends bill regulating stablecoins, a type of cryptocurrency, to Trump</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 2 -->
            <a title="more" href="../finance-and-markets/tether-unveils-usat-stablecoin-to-boost-us-market-presence.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/tether-unveils-usat-stablecoin.avif"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Tether unveils USAT stablecoin to boost US market presence</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 3 -->
            <a title="more" href="../finance-and-markets/treasury-recommends-exploring-creation-of-a-digital-dollar.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/treasury-recommends-exploring-creation.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Treasury recommends exploring creation of a digital dollar
</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 4 -->
            <a title="more" href="../finance-and-markets/senate-passes-crypto-regulations-sends-to-house-without-addressing-trumps-investments.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/senate-passes-crypto-regulations.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Senate passes crypto regulations, sends to House without addressing Trump’s investments</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 5 -->
            <a title="more" href="../finance-and-markets/fed-study-on-digital-currency-leans-toward-role-for-banks.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/fed-study-on-digital-currency.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Fed study on digital currency leans toward role for banks</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>
        </div>
<?php include '../footer.php'; ?>
    </section>

    <script defer src="../js/style.js" ></script>
</body>

</html>