<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tether unveils USAT stablecoin to boost US market presence</title>
    <link rel="stylesheet" href="../css/style.css">
        <meta name="description"
        content="Tether has introduced its new USAT stablecoin to strengthen its presence in the U.S. market and expand its role in the digital payments ecosystem">
    <meta property="og:title" content="Tether unveils USAT stablecoin to boost US market presence">
    <meta property="og:description"
        content="Tether has introduced its new USAT stablecoin to strengthen its presence in the U.S. market and expand its role in the digital payments ecosystem">
    <meta name="keywords" content="Tether">
    <meta property="og:url" content="https://www.policynow.org/tether-unveils-usat-stablecoin-to-boost-us-market-presence">
    <meta property="og:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta property="og:site_name" content="">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_US">
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Tether unveils USAT stablecoin to boost US market presence">
    <meta name="twitter:description"
        content="Tether has introduced its new USAT stablecoin to strengthen its presence in the U.S. market and expand its role in the digital payments ecosystem">
    <meta name="twitter:url" content="https://www.policynow.org/tether-unveils-usat-stablecoin-to-boost-us-market-presence">
    <meta name="twitter:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta name="twitter:site" content="@policynow">
    <meta name="twitter:creator" content="@policynow">
    <link rel="icon" type="image/x-icon" href="https://www.policynow.org/image/favicon.png">
    <link rel="canonical" href="https://www.policynow.org/tether-unveils-usat-stablecoin-to-boost-us-market-presence">
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "NewsArticle",
  "mainEntityOfPage": {
    "@id": "https://www.policynow.org/tether-unveils-usat-stablecoin-to-boost-us-market-presence"
  },
  "headline": "Tether unveils USAT stablecoin to boost US market presence",
  "image": [
    "https://www.policynow.org/image/twitter-card.png"
  ],
  "datePublished": "2025-11-17T08:28:00-04:00",
  "dateModified": "2025-11-17T08:28:00-04:00",
  "description": "Tether has introduced its new USAT stablecoin to strengthen its presence in the U.S. market and expand its role in the digital payments ecosystem",
  "author": {
    "@type": "Person",
    "name": "Editorial Board"
  },
  "publisher": {
    "@type": "Organization",
    "name": "policynow",
    "logo": {
      "@type": "ImageObject",
      "url": "https://www.policynow.org/image/policynow-logo.png"
    }
  },
  "keywords": ["USAT stablecoin", "stablecoin launch", "U.S. market", "digital payments", "cryptocurrency", "crypto market", "digital currency", "stablecoin expansion", "blockchain", "financial technology", "crypto ecosystem", "payments innovation", "USAT token", "crypto industry"]

}
</script>
</head>

<body class="light-mode">
<?php include '../header.php'; ?>

    <div class="main-container">
        <div class="date-row">
            <div class="day">
                <strong><?php
echo date("l, F j, Y"); 
?></strong>
            </div>

            <div class="top-center">
                <a href="../main.php"><img src="../image/policynow-logo.png"
                    alt="Logo"></a>
            </div>
            <div class="top-right"> 
                <img src="../image/search.png" class="menu-toggle" alt="search" width="16" height="16">
                <div  class="search-box" id="searchBox">
                    <input type="text" placeholder="Type & hit enter">
                     <img  src="../image/search.png" class="menu-toggle1" alt="search" width="16" height="16">
                </div>
                <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                 <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
            </div>
        </div>
        <nav class="main-nav1">
            <a title="Politics & Policy" class="nav-H" href="../politics-and-policy.php">Politics & Policy</a>
            <a title="Business & Economy" class="nav-l" href="../business-and-economy.php">Business & Economy</a>
            <a title="Global Affairs" class="nav-l" href="../global-affairs.php">Global Affairs</a>
            <a title="Technology & Innovation" class="nav-l" href="../technology-and-innovation.php">Technology & Innovation</a>
            <a title="Finance & Markets" class="nav-l" href="../finance-and-markets.php">Finance & Markets</a>
            <a title="Featured PR" class="nav-l" href="../featured-pr.php">Featured PR</a>
            <a title="Author" class="nav-l" href="../author.php">Authors</a>
        </nav>

    </div>
      <div class="main">
          <section class="highlight-news">
            <div class="highlight-category">
                <a title="Finance & Markets" href="#">Finance & Markets</a>
            </div>
            <div class="live-sect">
                <span class="live-status">
                    <span class="dot"></span>

                </span>
                <p> <span class="live-badge">LIVE</span>
                    7 days ago</p>
            </div>
            <h1 class="highlight-title">Tether unveils USAT stablecoin to boost US market presence</h1>
<p class="content-para">Crypto company Tether, the creator of the world's largest stablecoin, plans to launch a U.S.-based stablecoin designed for U.S. residents called USAT, the company's CEO Paolo Ardoino said on Friday.</p>


            <div class="highlight-footer">
                <div class="author-blocks">
                    <div class="author-card">
                        <img src="../image/lisa-g-hart.jpg"
                            alt="Lisa G. Hart">
                        <div class="author-info">
                            <a title="Lisa G. Hart" href="author.php">Lisa G. Hart</a>
                            <span>NOVEMBER 06, 2025</span>
                        </div>
                    </div>
                    
                </div>

                <div class="share-block">
                    <span>Share this</span>
                    <div class="share-icons">
                        <a title="facebook" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                        </a>
                        <a title="twitter" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                        </a>

                        <a title="youtube" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
                        </a>
                    </div>
                    <div class="share-single">
                        <button>
                            <a title="more" href="#"><i class="fa-solid fa-share-nodes"></i></a>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <div class="img-section">
            <img src="../image/tether-unveils-usat-stablecoin.avif"
                alt="Tether unveils USAT stablecoin">
        </div>

        <div class="second-sec">

      <p class="content-para">Former White House official Bo Hines will be the CEO of the new venture, which aims to launch by the end of the year, Ardoino said at a press conference in New York.</p>

<p class="content-para">The move is the latest sign of Tether, which is based in El Salvador, looking to bolster its presence in the U.S., where crypto companies have benefited from U.S. President Donald Trump's pro-crypto stance.</p>

<p class="content-para">“I think it’s a very exciting moment because we were under severe pressure from competitors that want to create a monopolistic environment in the United States,” Ardoino said. “We believe that Tether is the best product in the market."</p>

<p class="content-para">Tether's dollar-pegged cryptocurrency, known as USDT, has a market capitalization of more than $169 billion, according to crypto data provider CoinGecko.</p>

<p class="content-para">Trump in July signed a law dubbed the GENIUS Act to create a regulatory regime for stablecoins, a huge win for crypto supporters who had long lobbied for such a regulatory framework in a bid to gain greater legitimacy.</p>

<p class="content-para">The new law requires stablecoins to be backed by liquid assets - such as U.S. dollars and short-term Treasury bills - and for issuers to disclose publicly the composition of their reserves monthly.</p>

<p class="content-para">USDT still plans to comply with the GENIUS Act and remain a foreign stablecoin issuer, Ardoino said, adding that the law provides a way for foreign stablecoins to receive reciprocity.</p>

<p class="content-para">"We want people to know that Tether is here to participate in the U.S. economy in a huge way," said Hines, who was appointed as a strategic advisor to Tether in August after he departed his position as executive director of the President's Council of Advisers on Digital Assets.</p>

<p class="content-para">"I think our expansion will be exorbitant over the course of the next 12 to 24 months," Hines said.</p>

<p class="content-para">Ardoino said USAT will be issued by Anchorage Digital Bank, which has a national trust bank charter with the U.S. Office of the Comptroller of the Currency.</p>

<p class="content-para">Anchorage will be one of the shareholders of the new venture, Ardoino said, declining to name the other shareholders. Cantor Fitzgerald will serve as USAT's custodian and preferred primary dealer, Tether said in a press release.</p>

<p class="content-para">USAT will be headquartered in Charlotte, North Carolina, Hines said.</p>

<p class="content-para">The move by Tether comes just three months after rival stablecoin firm Circle (CRCL.N), opens new tab went public in the U.S. in a blockbuster IPO raised more than $1 billion. Shares in Circle were last down 5.8%.</p>

<p class="content-para">Tether said it bought more than $33.1 billion of U.S. Treasury bills in 2024, making it the seventh largest buyer of U.S. government debt. In an April research note, JP Morgan analysts estimated that stablecoin issuers could become the third-largest buyer of Treasury bills in the coming years.</p>

<p class="content-para">U.S. Treasury Secretary Scott Bessent had encouraged lawmakers to pass legislation to create federal rules for stablecoins, arguing that it could lead to a surge in demand for U.S. government debt.</p>

<p class="content-para">Tether has previously come under scrutiny in the U.S. The company agreed to publish quarterly reserve reports under a 2021 settlement with the New York Attorney General's office, which accused Tether and its sister company Bitfinex of commingling client and corporate funds to cover up $850 million that went missing.</p>

<p class="content-para">The Wall Street Journal reported last year that U.S. authorities were probing potential violations by the cryptocurrency firm of sanctions or anti-money laundering rules, but Ardoino said he had not seen any indication that Tether was under investigation.</p>
        </div>
      </div>

    <!-- Blog Section -->
    <section class="latest-blog-wrapper">
        <h2 class="latest-blog-title">LATEST FROM BLOG</h2>

        <div class="latest-blog-grid">
            <!-- Blog Item 1 -->
            <a title="more" href="../finance-and-markets/house-sends-bill-regulating-stablecoins-a-type-of-cryptocurrency-to-trump.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/house-sends-bill-regulating-stablecoins.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">House sends bill regulating stablecoins, a type of cryptocurrency, to Trump</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 2 -->
            <a title="more" href="../finance-and-markets/treasury-recommends-exploring-creation-of-a-digital-dollar.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/treasury-recommends-exploring-creation.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Treasury recommends exploring creation of a digital dollar
</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 3 -->
            <a title="more" href="../finance-and-markets/the-crypto-industry-saw-trump-as-a-champion-some-now-fear-hes-putting-personal-profits-first.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/the-crypto-industry-saw.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">The crypto industry saw Trump as a champion. Some now fear he’s putting personal profits first</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 4 -->
            <a title="more" href="../finance-and-markets/senate-passes-crypto-regulations-sends-to-house-without-addressing-trumps-investments.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/senate-passes-crypto-regulations.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Senate passes crypto regulations, sends to House without addressing Trump’s investments</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 5 -->
            <a title="more" href="../finance-and-markets/fed-study-on-digital-currency-leans-toward-role-for-banks.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/fed-study-on-digital-currency.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Fed study on digital currency leans toward role for banks</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>
        </div>
<?php include '../footer.php'; ?>
    </section>

    <script defer src="../js/style.js" ></script>
</body>

</html>