<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Senate passes crypto regulations, sends to House without addressing Trump’s investments</title>
    <link rel="stylesheet" href="../css/style.css">
        <meta name="description"
        content="The Senate has passed a crypto regulation bill and sent it to the House, moving forward without addressing concerns over President Trump’s crypto investments">
    <meta property="og:title" content="Senate passes crypto regulations, sends to House without addressing Trump’s investments">
    <meta property="og:description"
        content="The Senate has passed a crypto regulation bill and sent it to the House, moving forward without addressing concerns over President Trump’s crypto investments">
    <meta name="keywords" content="crypto regulations">
    <meta property="og:url" content="https://www.policynow.org/senate-passes-crypto-regulations-sends-to-house-without-addressing-trumps-investments">
    <meta property="og:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta property="og:site_name" content="">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_US">
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Senate passes crypto regulations, sends to House without addressing Trump’s investments">
    <meta name="twitter:description"
        content="The Senate has passed a crypto regulation bill and sent it to the House, moving forward without addressing concerns over President Trump’s crypto investments">
    <meta name="twitter:url" content="https://www.policynow.org/senate-passes-crypto-regulations-sends-to-house-without-addressing-trumps-investments">
    <meta name="twitter:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta name="twitter:site" content="@policynow">
    <meta name="twitter:creator" content="@policynow">
    <link rel="icon" type="image/x-icon" href="https://www.policynow.org/image/favicon.png">
    <link rel="canonical" href="https://www.policynow.org/senate-passes-crypto-regulations-sends-to-house-without-addressing-trumps-investments">
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "NewsArticle",
  "mainEntityOfPage": {
    "@id": "https://www.policynow.org/senate-passes-crypto-regulations-sends-to-house-without-addressing-trumps-investments"
  },
  "headline": "Senate passes crypto regulations, sends to House without addressing Trump’s investments",
  "image": [
    "https://www.policynow.org/image/twitter-card.png"
  ],
  "datePublished": "2025-11-17T08:28:00-04:00",
  "dateModified": "2025-11-17T08:28:00-04:00",
  "description": "The Senate has passed a crypto regulation bill and sent it to the House, moving forward without addressing concerns over President Trump’s crypto investments",
  "author": {
    "@type": "Person",
    "name": "Editorial Board"
  },
  "publisher": {
    "@type": "Organization",
    "name": "policynow",
    "logo": {
      "@type": "ImageObject",
      "url": "https://www.policynow.org/image/policynow-logo.png"
    }
  },
  "keywords": ["Senate bill", "House review", "Donald Trump", "crypto investments", "cryptocurrency policy", "U.S. Congress", "digital assets", "financial regulation", "crypto oversight", "regulatory legislation", "crypto market", "federal crypto rules", "digital currency regulation", "political controversy"]

}
</script>
</head>

<body class="light-mode">
<?php include '../header.php'; ?>

    <div class="main-container">
        <div class="date-row">
            <div class="day">
                <strong><?php
echo date("l, F j, Y"); 
?></strong>
            </div>

            <div class="top-center">
                <a href="../main.php"><img src="../image/policynow-logo.png"
                    alt="Logo"></a>
            </div>
            <div class="top-right"> 
                <img src="../image/search.png" class="menu-toggle" alt="search" width="16" height="16">
                <div  class="search-box" id="searchBox">
                    <input type="text" placeholder="Type & hit enter">
                     <img  src="../image/search.png" class="menu-toggle1" alt="search" width="16" height="16">
                </div>
                <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                 <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
            </div>
        </div>
        <nav class="main-nav1">
            <a title="Politics & Policy" class="nav-H" href="../politics-and-policy.php">Politics & Policy</a>
            <a title="Business & Economy" class="nav-l" href="../business-and-economy.php">Business & Economy</a>
            <a title="Global Affairs" class="nav-l" href="../global-affairs.php">Global Affairs</a>
            <a title="Technology & Innovation" class="nav-l" href="../technology-and-innovation.php">Technology & Innovation</a>
            <a title="Finance & Markets" class="nav-l" href="../finance-and-markets.php">Finance & Markets</a>
            <a title="Featured PR" class="nav-l" href="../featured-pr.php">Featured PR</a>
            <a title="Author" class="nav-l" href="../author.php">Authors</a>
        </nav>

    </div>
      <div class="main">
          <section class="highlight-news">
            <div class="highlight-category">
                <a title="Finance & Markets" href="#">Finance & Markets</a>
            </div>
            <div class="live-sect">
                <span class="live-status">
                    <span class="dot"></span>

                </span>
                <p> <span class="live-badge">LIVE</span>
                    7 days ago</p>
            </div>
            <h1 class="highlight-title">Senate passes crypto regulations, sends to House without addressing Trump’s investments</h1>
<p class="content-para">The Senate passed legislation Tuesday that would regulate a form of cryptocurrency known as stablecoins, the first of what the industry hopes will be a wave of bills to bolster its legitimacy and reassure consumers.</p>


            <div class="highlight-footer">
                <div class="author-blocks">
                    <div class="author-card">
                        <img src="../image/lisa-g-hart.jpg"
                            alt="Lisa G. Hart">
                        <div class="author-info">
                            <a title="Lisa G. Hart" href="author.php">Lisa G. Hart</a>
                            <span>NOVEMBER 06, 2025</span>
                        </div>
                    </div>
                    
                </div>

                <div class="share-block">
                    <span>Share this</span>
                    <div class="share-icons">
                        <a title="facebook" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                        </a>
                        <a title="twitter" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                        </a>

                        <a title="youtube" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
                        </a>
                    </div>
                    <div class="share-single">
                        <button>
                            <a title="more" href="#"><i class="fa-solid fa-share-nodes"></i></a>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <div class="img-section">
            <img src="../image/senate-passes-crypto-regulations.webp"
                alt="Rubio says US and Mexico will strengthen">
        </div>

        <div class="second-sec">

       <p class="content-para">The fast-moving legislation, which passed by a 68-30 vote and will be sent to the House for potential revisions, comes on the heels of a 2024 campaign cycle in which the crypto industry ranked among the top political spenders in the country, underscoring its growing influence in Washington and beyond.</p>

<p class="content-para">Eighteen Democratic senators crossed the aisle to vote for the legislation on Tuesday, siding with the Republican majority in the 53-47 Senate. Republican Sens. Josh Hawley and Rand Paul were the only members of their party to oppose the measure.</p>

<p class="content-para">It was the second major bipartisan bill to advance through the Senate this year, following the Laken Riley Act on immigration enforcement in January. Still, most Democrats opposed the bill. They raised concerns that the measure does little to address President Donald Trump’s personal financial interests in the crypto space.</p>

<p class="content-para">“We weren’t able to include certainly everything we would have wanted, but it was a good bipartisan effort,” said Sen. Angela Alsobrooks, D-Md., on Monday. Alsobrooks, a co-sponsor of the bill, added, “This is an unregulated area that will now be regulated.”</p>

<p class="content-para">Sen. Bill Hagerty, R-Tenn., the bill’s sponsor, said on the Senate floor ahead of the vote that the legislation will have “far reaching implications” for the financial system — a “paradigm shifting development” that he believes will bring it into the 21st century.</p>

<p class="content-para">“With this bill, the United States is a step closer to being a global leader in crypto,” Hagerty said.</p>

<p class="content-para">Known as the GENIUS Act, the bill would establish guardrails and consumer protections for stablecoins, a type of cryptocurrency typically pegged to the U.S. dollar. The acronym stands for “Guiding and Establishing National Innovation for U.S. Stablecoins.”</p>

<p class="content-para">The bill only needed a simple majority vote to pass Tuesday, after it had already cleared its biggest procedural hurdle last week in a 68-30 vote, with 18 Democrats siding with Republicans. But the bill has faced more resistance than initially expected.</p>

<p class="content-para"><strong>Trump’s stake in crypto</strong></p>

<p class="content-para">There is a provision in the bill that bans members of Congress and their families from profiting off stablecoins. But that prohibition does not extend to the president and his family, even as Trump builds a crypto empire from the White House.</p>

<p class="content-para">Last month, the Republican president hosted a private dinner at his golf club in Virginia with top investors in a Trump-branded meme coin. His family holds a significant stake in World Liberty Financial, a crypto project that launched its own stablecoin, USD1.</p>

<p class="content-para">Trump reported earning $57.35 million from token sales at World Liberty Financial in 2024, according to a public financial disclosure released Friday. A meme coin linked to him has generated an estimated $320 million in fees, though the earnings are split among multiple investors.</p>

<p class="content-para">The administration is broadly supportive of crypto’s growth and its integration into the economy. Ahead of Tuesday’s vote, Treasury Secretary Scott Bessent urged the Senate to pass the bill, saying it could help stablecoins “grow into a $3.7 trillion market by the end of the decade.”</p>

<p class="content-para">Brian Armstrong, CEO of Coinbase — the nation’s largest crypto exchange and a major advocate for the bill — has met with Trump and praised his early moves on crypto. This past weekend, Coinbase was among the more prominent brands that sponsored a parade in Washington commemorating the Army’s 250th anniversary — an event that coincided with Trump’s 79th birthday.</p>

<p class="content-para">But the crypto industry emphasizes that they view the legislative effort as bipartisan, pointing to champions on each side of the aisle.</p>

<p class="content-para">“The GENIUS Act will be the most significant digital assets legislation ever to pass the U.S. Senate,” Senate Banking Committee Chair Tim Scott, R-S.C., said ahead of a key vote last week. “It’s the product of months of bipartisan work.”</p>

<p class="content-para"><strong>Some Democrats object</strong></p>

<p class="content-para">The bill did hit one rough patch in early May, when a bloc of Senate Democrats who had previously supported the bill reversed course and voted to block it from advancing. That prompted new negotiations involving Senate Republicans, Democrats and the White House, which ultimately produced the compromise version that won passage Tuesday.</p>

<p class="content-para">Alsobrooks said “many, many changes” were made during negotiations and “it’s a much better deal because we were all at the table.”</p>

<p class="content-para">Ahead of the vote Tuesday, GOP Wyoming Sen. Cynthia Lummis said that she is “OK” with where the stablecoin legislation has landed after negotiations.</p>

<p class="content-para">“I’m not thrilled with it, but it’s OK,” said Lummis, one of the bill’s co-sponsors.</p>

<p class="content-para">Still, the bill leaves unresolved concerns over presidential conflicts of interest — an issue that remains a source of tension within the Democratic caucus.</p>

<p class="content-para">“Passing the GENIUS Act without strong anti-corruption measures stamps a Congressional seal of approval on President Trump selling access to the government for personal profit,” Democratic Sen. Jeff Merkley said in a statement after the bill’s passage.</p>

<p class="content-para">Sen. Elizabeth Warren, D-Mass., has been among the most outspoken as the ranking member on the Senate Banking Committee, warning that the bill creates a “super highway” for Trump corruption. She has also warned that the bill would allow major technology companies, such as Amazon and Meta, to launch their own stablecoins.</p>

<p class="content-para">Among the Democrats who backed the bill was first-term Sen. Elissa Slotkin, who received $10 million in support from a crypto political action committee during her Michigan race last year. Slotkin acknowledged the bill “wasn’t perfect” but called it a “good-faith, bipartisan start” to regulating stablecoins.</p>

<p class="content-para">The stablecoin legislation still faces several hurdles before reaching the president’s desk. It must clear the narrowly held Republican majority in the House, where lawmakers may try to attach a broader market structure bill — sweeping legislation that could make passage through the Senate more difficult.</p>

<p class="content-para">Trump has said he wants stablecoin legislation on his desk before Congress breaks for its August recess, now just under 50 days away.</p>
        </div>
      </div>

    <!-- Blog Section -->
    <section class="latest-blog-wrapper">
        <h2 class="latest-blog-title">LATEST FROM BLOG</h2>

               <div class="latest-blog-grid">
            <!-- Blog Item 1 -->
            <a title="more" href="../finance-and-markets/house-sends-bill-regulating-stablecoins-a-type-of-cryptocurrency-to-trump.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/house-sends-bill-regulating-stablecoins.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">House sends bill regulating stablecoins, a type of cryptocurrency, to Trump</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 2 -->
            <a title="more" href="../finance-and-markets/tether-unveils-usat-stablecoin-to-boost-us-market-presence.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/tether-unveils-usat-stablecoin.avif"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Tether unveils USAT stablecoin to boost US market presence</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 3 -->
            <a title="more" href="../finance-and-markets/the-crypto-industry-saw-trump-as-a-champion-some-now-fear-hes-putting-personal-profits-first.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/the-crypto-industry-saw.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">The crypto industry saw Trump as a champion. Some now fear he’s putting personal profits first</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 4 -->
            <a title="more" href="../finance-and-markets/treasury-recommends-exploring-creation-of-a-digital-dollar.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/treasury-recommends-exploring-creation.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Treasury recommends exploring creation of a digital dollar</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 5 -->
            <a title="more" href="../finance-and-markets/fed-study-on-digital-currency-leans-toward-role-for-banks.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/fed-study-on-digital-currency.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Fed study on digital currency leans toward role for banks</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>
        </div>
<?php include '../footer.php'; ?>
    </section>

    <script defer src="../js/style.js" ></script>
</body>

</html>