<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Fed study on digital currency leans toward role for banks</title>
    <link rel="stylesheet" href="../css/style.css">
        <meta name="description"
        content="The Federal Reserve’s study on a potential digital dollar suggests banks would play a central role in managing and distributing the currency">
    <meta property="og:title" content="Fed study on digital currency leans toward role for banks">
    <meta property="og:description"
        content="The Federal Reserve’s study on a potential digital dollar suggests banks would play a central role in managing and distributing the currency">
    <meta name="keywords" content="Federal Reserve">
    <meta property="og:url" content="https://www.policynow.org/fed-study-on-digital-currency-leans-toward-role-for-banks">
    <meta property="og:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta property="og:site_name" content="">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_US">
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Fed study on digital currency leans toward role for banks">
    <meta name="twitter:description"
        content="The Federal Reserve’s study on a potential digital dollar suggests banks would play a central role in managing and distributing the currency">
    <meta name="twitter:url" content="https://www.policynow.org/fed-study-on-digital-currency-leans-toward-role-for-banks">
    <meta name="twitter:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta name="twitter:site" content="@policynow">
    <meta name="twitter:creator" content="@policynow">
    <link rel="icon" type="image/x-icon" href="https://www.policynow.org/image/favicon.png">
    <link rel="canonical" href="https://www.policynow.org/fed-study-on-digital-currency-leans-toward-role-for-banks">
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "NewsArticle",
  "mainEntityOfPage": {
    "@id": "https://www.policynow.org/fed-study-on-digital-currency-leans-toward-role-for-banks"
  },
  "headline": "Fed study on digital currency leans toward role for banks",
  "image": [
    "https://www.policynow.org/image/twitter-card.png"
  ],
  "datePublished": "2025-11-17T08:28:00-04:00",
  "dateModified": "2025-11-17T08:28:00-04:00",
  "description": "The Federal Reserve’s study on a potential digital dollar suggests banks would play a central role in managing and distributing the currency",
  "author": {
    "@type": "Person",
    "name": "Editorial Board"
  },
  "publisher": {
    "@type": "Organization",
    "name": "policynow",
    "logo": {
      "@type": "ImageObject",
      "url": "https://www.policynow.org/image/policynow-logo.png"
    }
  },
  "keywords": ["digital currency", "digital dollar", "Central Bank Digital Currency", "banks role", "Fed study", "CBDC", "financial system", "digital payments", "bank-managed currency", "U.S. monetary policy", "financial innovation", "digital finance", "currency distribution", "banking sector"]

}
</script>
</head>

<body class="light-mode">
<?php include '../header.php'; ?>

    <div class="main-container">
        <div class="date-row">
            <div class="day">
                <strong><?php
echo date("l, F j, Y"); 
?></strong>
            </div>

            <div class="top-center">
                <a href="../main.php"><img src="../image/policynow-logo.png"
                    alt="Logo"></a>
            </div>
            <div class="top-right"> 
                <img src="../image/search.png" class="menu-toggle" alt="search" width="16" height="16">
                <div  class="search-box" id="searchBox">
                    <input type="text" placeholder="Type & hit enter">
                     <img  src="../image/search.png" class="menu-toggle1" alt="search" width="16" height="16">
                </div>
                <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                 <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
            </div>
        </div>
        <nav class="main-nav1">
            <a title="Politics & Policy" class="nav-H" href="../politics-and-policy.php">Politics & Policy</a>
            <a title="Business & Economy" class="nav-l" href="../business-and-economy.php">Business & Economy</a>
            <a title="Global Affairs" class="nav-l" href="../global-affairs.php">Global Affairs</a>
            <a title="Technology & Innovation" class="nav-l" href="../technology-and-innovation.php">Technology & Innovation</a>
            <a title="Finance & Markets" class="nav-l" href="../finance-and-markets.php">Finance & Markets</a>
            <a title="Featured PR" class="nav-l" href="../featured-pr.php">Featured PR</a>
            <a title="Author" class="nav-l" href="../author.php">Authors</a>
        </nav>

    </div>
      <div class="main">
          <section class="highlight-news">
            <div class="highlight-category">
                <a title="Finance & Markets" href="#">Finance & Markets</a>
            </div>
            <div class="live-sect">
                <span class="live-status">
                    <span class="dot"></span>
                </span>
                <p> <span class="live-badge">LIVE</span>
                    7 days ago</p>
            </div>
            <h1 class="highlight-title">Fed study on digital currency leans toward role for banks</h1>
            <p class="content-para">The Federal Reserve on Thursday released a highly anticipated report on central bank digital currencies that suggested it is leaning toward having banks and other financial firms, rather than the Fed itself, manage digital accounts for customers.</p>
            <div class="highlight-footer">
                <div class="author-blocks">
                    <div class="author-card">
                        <img src="../image/lisa-g-hart.jpg"
                            alt="Lisa G. Hart">
                        <div class="author-info">
                            <a title="Lisa G. Hart" href="author.php">Lisa G. Hart</a>
                            <span>NOVEMBER 06, 2025</span>
                        </div>
                    </div>
                   
                </div>

                <div class="share-block">
                    <span>Share this</span>
                    <div class="share-icons">
                        <a title="facebook" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                        </a>
                        <a title="twitter" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                        </a>

                        <a title="youtube" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
                        </a>
                    </div>
                    <div class="share-single">
                        <button>
                            <a title="more" href="#"><i class="fa-solid fa-share-nodes"></i></a>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <div class="img-section">
            <img src="../image/fed-study-on-digital-currency.webp"
                alt="Image">
        </div>

        <div class="second-sec">

<p class="content-para">A central bank digital currency would differ in some key ways from the online and digital payments that millions of Americans already conduct. Those transactions are funneled through banks, which wouldn’t be necessary with a digital dollar.</p>

<p class="content-para">The Fed’s paper stressed that no final decisions about a digital currency have been reached. But it suggested that a digital currency that “would best serve the needs” of the nation would follow an “intermediated model” under which banks or payment firms would create accounts or digital wallets.</p>

<p class="content-para">The Fed characterized the potential introduction of a digital currency as a step that could have far-reaching consequences for banks and other financial firms as well as for the central bank itself.</p>

<p class="content-para">“The introduction of a (central bank digital currency) would represent a highly significant innovation in American money,” the study said. The Fed said it “could fundamentally change the structure of the U.S. financial system, altering the roles and responsibilities of the private sector and the central bank.”</p>

<p class="content-para">The report comes at a time when digital money is proliferating in a variety of forms. Millions of people own cryptocurrencies, though they are often used more as investments than as forms of payment. But so-called stablecoins, which are often pegged to the dollar, have also soared in use in the past year, mostly for cryptocurrency transactions.</p>

<p class="content-para">And most central banks around the world are studying government-backed digital currencies. China’s central bank has already tested a digital version of the yuan. The European Central Bank began exploring a digital euro in October and said its “investigation period” would last two years. Some Caribbean nations have already issued digital currencies.</p>

<p class="content-para">China’s action and the explosion of stablecoins, which can be used in place of dollars in international transactions, have raised pressure on the Fed to consider a digital currency. Last March, Chair Jerome Powell said that while the Fed needed to keep pace with financial innovations, it would proceed cautiously.</p>

<p class="content-para">“As the world’s principal reserve currency...we have an obligation to be on the cutting edge of understanding the technological challenges,” Powell said then. “But...we don’t need to rush this project. We don’t need to be first to market.”</p>

<p class="content-para">The Fed is likely years away from actually issuing a digital currency, if it decides to do so. The paper released Thursday kicks off a 120-day comment period, during which the Fed will seek input from the public. The Fed also said it would proceed only with support from Congress, “ideally in the form of a specific authorizing law.”</p>

<p class="content-para">And officials at the central bank aren’t all in agreement about whether a central bank digital currency is needed. Lael Brainard, who serves on the Fed’s Board of Governors and has been nominated by President Joe Biden to be vice chair, has, for example, expressed support for the concept, while Christopher Waller, another board member, has been skeptical.</p>

<p class="content-para">A digital dollar could bring a host of benefits as well as risks. It would be a safer form of digital payment, because the Fed, unlike a bank or the companies issuing stablecoins, can’t go bankrupt. It could be easier and less expensive to access for people without bank accounts.</p>

<p class="content-para">At the same time, a digital currency could pose privacy risks because it would be issued by the government. The Fed’s paper suggests, though, that banks and other third-party firms would shield consumer data from the Fed while also implementing existing rules against money-laundering and other illicit activity.</p>

<p class="content-para">Such a government-issued digital dollar could also have major consequences for commercial banks because many Americans might prefer to hold such currency in a “wallet” issued by a payment provider like PayPal or Venmo, potentially cutting into bank deposits.</p>

<p class="content-para">The Fed could even seek to influence the economy through a digital currency, as it now does by controlling interest rates. It could pay interest on a digital dollar, for example, or even have it decline in value, as a form of a negative interest rate. An interest payment could make a digital dollar more attractive than money in a bank.</p>

<p class="content-para">“This substitution effect could reduce the aggregate amount of deposits in the banking system,” the Fed report said.</p>

<p class="content-para">That hasn’t gone unnoticed by banks. The Bank Policy Institute, a lobbying group, asserted in a blog post last June that the Fed doesn’t have legal authority to pay interest on a digital dollar.</p>
        </div>
      </div>

    <!-- Blog Section -->
    <section class="latest-blog-wrapper">
        <h2 class="latest-blog-title">LATEST FROM BLOG</h2>

        <div class="latest-blog-grid">
            <!-- Blog Item 1 -->
            <a title="more" href="../finance-and-markets/house-sends-bill-regulating-stablecoins-a-type-of-cryptocurrency-to-trump.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/house-sends-bill-regulating-stablecoins.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">House sends bill regulating stablecoins, a type of cryptocurrency, to Trump</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 2 -->
            <a title="more" href="../finance-and-markets/tether-unveils-usat-stablecoin-to-boost-us-market-presence.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/tether-unveils-usat-stablecoin.avif"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Tether unveils USAT stablecoin to boost US market presence</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 3 -->
            <a title="more" href="../finance-and-markets/the-crypto-industry-saw-trump-as-a-champion-some-now-fear-hes-putting-personal-profits-first.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/the-crypto-industry-saw.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">The crypto industry saw Trump as a champion. Some now fear he’s putting personal profits first</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 4 -->
            <a title="more" href="../finance-and-markets/senate-passes-crypto-regulations-sends-to-house-without-addressing-trumps-investments.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/senate-passes-crypto-regulations.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Senate passes crypto regulations, sends to House without addressing Trump’s investments</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 5 -->
            <a title="more" href="../finance-and-markets/fed-study-on-digital-currency-leans-toward-role-for-banks.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/fed-study-on-digital-currency.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Fed study on digital currency leans toward role for banks</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>
        </div>
    <?php include '../footer.php'; ?>
    </section>

    <script defer src="../js/style.js" ></script>
</body>

</html>