<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>tentree Pledges to Plant One Billion Trees by 2030 in Support of 1t.org</title>
    <link rel="stylesheet" href="../css/style.css">
        <meta name="description"
        content="tentree pledges to plant one billion trees by 2030 in support of 1t.org, advancing global reforestation efforts and large-scale climate restoration">
    <meta property="og:title" content="tentree Pledges to Plant One Billion Trees by 2030 in Support of 1t.org">
    <meta property="og:description"
        content="tentree pledges to plant one billion trees by 2030 in support of 1t.org, advancing global reforestation efforts and large-scale climate restoration">
    <meta name="keywords" content="tentree">
    <meta property="og:url" content="https://www.policynow.org/tentree-pledges-to-plant-one-billion-trees-by-2030-in-support-of-1t-org">
    <meta property="og:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta property="og:site_name" content="">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_US">
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="tentree Pledges to Plant One Billion Trees by 2030 in Support of 1t.org">
    <meta name="twitter:description"
        content="tentree pledges to plant one billion trees by 2030 in support of 1t.org, advancing global reforestation efforts and large-scale climate restoration">
    <meta name="twitter:url" content="https://www.policynow.org/tentree-pledges-to-plant-one-billion-trees-by-2030-in-support-of-1t-org">
    <meta name="twitter:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta name="twitter:site" content="@policynow">
    <meta name="twitter:creator" content="@policynow">
    <link rel="icon" type="image/x-icon" href="https://www.policynow.org/image/favicon.png">
    <link rel="canonical" href="https://www.policynow.org/tentree-pledges-to-plant-one-billion-trees-by-2030-in-support-of-1t-org">
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "NewsArticle",
  "mainEntityOfPage": {
    "@id": "https://www.policynow.org/tentree-pledges-to-plant-one-billion-trees-by-2030-in-support-of-1t-org"
  },
  "headline": "tentree Pledges to Plant One Billion Trees by 2030 in Support of 1t.org",
  "image": [
    "https://www.policynow.org/image/twitter-card.png"
  ],
  "datePublished": "2025-11-17T08:28:00-04:00",
  "dateModified": "2025-11-17T08:28:00-04:00",
  "description": "tentree pledges to plant one billion trees by 2030 in support of 1t.org, advancing global reforestation efforts and large-scale climate restoration",
  "author": {
    "@type": "Person",
    "name": "Editorial Board"
  },
  "publisher": {
    "@type": "Organization",
    "name": "policynow",
    "logo": {
      "@type": "ImageObject",
      "url": "https://www.policynow.org/image/policynow-logo.png"
    }
  },
  "keywords": ["one billion trees", "2030 goal", "1t.org", "reforestation", "tree planting", "climate restoration", "environmental commitment", "sustainability", "global reforestation", "forest conservation", "climate action", "eco-friendly initiatives", "carbon reduction", "environmental sustainability"]

}
</script>
</head>

<body class="light-mode">
<?php include '../header.php'; ?>

    <div class="main-container">
        <div class="date-row">
            <div class="day">
                <strong><?php
echo date("l, F j, Y"); 
?></strong>
            </div>

            <div class="top-center">
                <a href="../main.php"><img src="../image/policynow-logo.png"
                    alt="Logo"></a>
            </div>
            <div class="top-right"> 
                <img src="../image/search.png" class="menu-toggle" alt="search" width="16" height="16">
                <div  class="search-box" id="searchBox">
                    <input type="text" placeholder="Type & hit enter">
                     <img  src="../image/search.png" class="menu-toggle1" alt="search" width="16" height="16">
                </div>
                <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                 <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
            </div>
        </div>
        <nav class="main-nav1">
            <a title="Politics & Policy" class="nav-H" href="../politics-and-policy.php">Politics & Policy</a>
            <a title="Business & Economy" class="nav-l" href="../business-and-economy.php">Business & Economy</a>
            <a title="Global Affairs" class="nav-l" href="../global-affairs.php">Global Affairs</a>
            <a title="Technology & Innovation" class="nav-l" href="../technology-and-innovation.php">Technology & Innovation</a>
            <a title="Finance & Markets" class="nav-l" href="../finance-and-markets.php">Finance & Markets</a>
            <a title="Featured PR" class="nav-l" href="../featured-pr.php">Featured PR</a>
            <a title="Author" class="nav-l" href="../author.php">Authors</a>
        </nav>

    </div>
      <div class="main">
          <section class="highlight-news">
            <div class="highlight-category">
                <a title="Featured PR" href="#">Featured PR</a>
            </div>
            <div class="live-sect">
                <span class="live-status">
                    <span class="dot"></span>

                </span>
                <p> <span class="live-badge">LIVE</span>
                    7 days ago</p>
            </div>
            <h1 class="highlight-title">tentree Pledges to Plant One Billion Trees by 2030 in Support of 1t.org</h1>
<p class="content-para">tentree, an earth-first sustainable apparel brand, has committed to planting one billion trees by 2030 to support 1t.org and the global movement to conserve, restore and grow 1 trillion trees by 2030.</p>

            <div class="highlight-footer">
                <div class="author-blocks">
                    <div class="author-card">
                        <img src="../image/lisa-g-hart.jpg"
                            alt="Lisa G. Hart">
                        <div class="author-info">
                            <a title="Lisa G. Hart" href="author.php">Lisa G. Hart</a>
                            <span>NOVEMBER 07, 2025</span>
                        </div>
                    </div>
                    
                </div>

                <div class="share-block">
                    <span>Share this</span>
                    <div class="share-icons">
                        <a title="facebook" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                        </a>
                        <a title="twitter" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                        </a>
                        <a title="youtube" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
                        </a>
                    </div>
                    <div class="share-single">
                        <button>
                            <a title="more" href="#"><i class="fa-solid fa-share-nodes"></i></a>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <div class="img-section">
            <img src="../image/tentree-pledges-to-plant-one-billion-trees.jpg"
                alt="tentree Pledges to Plant One Billion Trees">
        </div>

        <div class="second-sec">

    <p class="content-para">tentree sells sustainable apparel as a vehicle to plant trees, planting 10 trees for every item sold.</p>

<p class="content-para">Their pledge of one billion trees is global in scope and current planting areas include Canada, USA, Nepal, Madagascar, Senegal, and Indonesia.</p>

<p class="content-para">To date, 50 million trees have already been planted, providing over 500 full-time jobs in Madagascar, supporting over 200 farmers in Senegal, providing over 100 jobs in Indonesia, and supporting numerous communities across the globe.</p>

<p class="content-para">Of the total one billion trees pledged, tentree will also support the planting of 20 million trees in the United States. “We are proud to have collaborated with tentree in developing this ground-breaking pledge, helping this proven corporate sustainability leader take its passion for the environment to the next level. This type of leadership is exactly what is needed to help realize the full potential of forests as a climate change solution,” said Jad Daley, co-leader of the 1t.org US chapter and president and CEO of American Forests.</p>

<p class="content-para">This pledge marks one of the largest corporate environmental pledges by a private company to date. tentree hopes to inspire other individuals and companies from across the globe to take action.</p>

<p class="content-para">To provide perspective of tree-planting and its impact, the planting of one billion trees equates to:</p>

<p class="content-para">→ Up to 250 million tons of CO2 removed from the atmosphere<br>
→ 10 million hours of forestry-related work to provide jobs to local communities<br>
→ 100,000 hectares of land reforested (equal to 240,000 football fields)<br>
→ Greater ecosystem health around the world<br>
→ Helping recharge global groundwater, anchor fertile soil and providing flood barriers</p>

<p class="content-para">“We believe in a world where businesses can be pacesetters. Where companies are no longer looked at as the problem and, instead, can lead the conversation on restoring our planet and make it easier for consumers across the globe to take that first step,” said Derrick Emsley, CEO and co-founder of tentree. “1t.org is a global platform that is bringing awareness to a cause that tentree has been actively involved with for almost a decade. We are excited to join their expansive efforts of conservation, restoration and reforestation.”</p>

<p class="content-para">tentree will leverage their Veritree technology to bring more transparency to global efforts, to promote the work of planet-first companies, and to partner with incredible planting organizations from all across the globe.</p>

<p class="content-para">Veritree provides on-the-ground transparency to global reforestation efforts. Through ground level data, the platform digitizes each tree into an “inventory item” that can be treated similar to a physical product. This tool allows the organization to better manage their own inventory, tree projects, and tree allocation while also providing donors with amazing reporting, on-the-ground data attached to their funding, social impact statistics, sustainable development goal information, carbon data, and more. Bringing more transparency and accountability to the space will lift the profile of the entire reforestation space.</p>

<p class="content-para">“That a single company can pledge such a monumental contribution towards the reforestation movement shows the power of the private sector to achieve big ambitions, and serves as an inspiration for the entire sector to contribute to ecosystem restoration and conservation. As we approach the Davos Agenda week, this pledge of 1 Billion trees is a great example of the contribution of nature-based solutions to addressing climate change, sustainable livelihoods, and healthy ecosystems,” says Nicole Schwab, Co-director of 1t.org and the World Economic Forum’s Nature Based Solutions.</p>

<p class="content-para"><strong>ABOUT TENTREE</strong></p>

<p class="content-para">tentree is an earth-first lifestyle apparel brand whose mission is to plant 1 billion trees by 2030 to drastically reduce climate change. Every tentree purchase has a purpose: for each item sold, the company and its partners plant ten trees somewhere around the world. With over 50 million trees planted to date, tentree is becoming the most environmentally progressive sustainable apparel brand on the planet. For more information, visit tentree.com or follow on Instagram @tentree.</p>

<p class="content-para"><strong>ABOUT 1t.org</strong></p>

<p class="content-para">1t.org is the World Economic Forum’s Trillion Tree Platform. 1t.org is a multistakeholder platform serving a global movement to conserve, restore and grow 1 trillion trees by 2030 in support of the UN Decade on Ecosystem Restoration. For more information, visit 1t.org.</p>

        </div>
      </div>

    <!-- Blog Section -->
    <section class="latest-blog-wrapper">
        <h2 class="latest-blog-title">LATEST FROM BLOG</h2>

        <div class="latest-blog-grid">
            <!-- Blog Item 1 -->
            <a title="more" href="../featured-pr/ibm-commits-to-net-zero-greenhouse-gas-emissions-by-2030.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/ibm-commits-to-net-zero-greenhouse-gas.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">IBM Commits To Net Zero Greenhouse Gas Emissions By 2030</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 2 -->
            <a title="more" href="../featured-pr/microsoft-carbon-negative-by-2030-even-for-supply-chain.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/microsoft-pledges-to-become.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Microsoft: carbon-negative by 2030 even for supply chain</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 3 -->
            <a title="more" href="../featured-pr/governors-biden-administration-push-to-quadruple-efficient-heating-ac-units-by-2030.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/governors-biden-administration-push.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Governors, Biden administration push to quadruple efficient heating, AC units by 2030</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 4 -->
            <a title="more" href="../featured-pr/general-mills-to-reduce-absolute-greenhouse-gas-emissions-by-30-percent-across-its-full-value-chain-over-next-decade.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/general-mills-to-reduce-absolute-greenhouse-gas-emissions.avif"
                        alt="Image">
                </div>
                <h3 class="blog-heading">General Mills to Reduce Absolute Greenhouse Gas Emissions by 30% Across its Full Value Chain Over Next Decade</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 5 -->
            <a title="more" href="../featured-pr/mechanical-sails-batteries-shippers-forming-green-corridors-to-fast-track-cleaner-technologies.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/mechanical-sails-batteries-shippers.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Mechanical sails? Batteries? Shippers forming ‘green corridors’ to fast-track cleaner technologies</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>


        </div>
<?php include '../footer.php'; ?>
    </section>

    <script defer src="../js/style.js" ></script>
</body>

</html>