<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Microsoft: carbon-negative by 2030 even for supply chain</title>
    <link rel="stylesheet" href="../css/style.css">
        <meta name="description"
        content="Microsoft aims to become carbon-negative by 2030, including emissions from its entire supply chain, through carbon removal, clean energy, and sustainability efforts">
    <meta property="og:title" content="Microsoft: carbon-negative by 2030 even for supply chain">
    <meta property="og:description"
        content="Microsoft aims to become carbon-negative by 2030, including emissions from its entire supply chain, through carbon removal, clean energy, and sustainability efforts">
    <meta name="keywords" content="Microsoft">
    <meta property="og:url" content="https://www.policynow.org/microsoft-carbon-negative-by-2030-even-for-supply-chain">
    <meta property="og:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta property="og:site_name" content="">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_US">
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Microsoft: carbon-negative by 2030 even for supply chain">
    <meta name="twitter:description"
        content="Microsoft aims to become carbon-negative by 2030, including emissions from its entire supply chain, through carbon removal, clean energy, and sustainability efforts">
    <meta name="twitter:url" content="https://www.policynow.org/microsoft-carbon-negative-by-2030-even-for-supply-chain">
    <meta name="twitter:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta name="twitter:site" content="@policynow">
    <meta name="twitter:creator" content="@policynow">
    <link rel="icon" type="image/x-icon" href="https://www.policynow.org/image/favicon.png">
    <link rel="canonical" href="https://www.policynow.org/microsoft-carbon-negative-by-2030-even-for-supply-chain">
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "NewsArticle",
  "mainEntityOfPage": {
    "@id": "https://www.policynow.org/microsoft-carbon-negative-by-2030-even-for-supply-chain"
  },
  "headline": "Microsoft: carbon-negative by 2030 even for supply chain",
  "image": [
    "https://www.policynow.org/image/twitter-card.png"
  ],
  "datePublished": "2025-11-17T08:28:00-04:00",
  "dateModified": "2025-11-17T08:28:00-04:00",
  "description": "Microsoft aims to become carbon-negative by 2030, including emissions from its entire supply chain, through carbon removal, clean energy, and sustainability efforts",
  "author": {
    "@type": "Person",
    "name": "Editorial Board"
  },
  "publisher": {
    "@type": "Organization",
    "name": "policynow",
    "logo": {
      "@type": "ImageObject",
      "url": "https://www.policynow.org/image/policynow-logo.png"
    }
  },
  "keywords": ["carbon-negative", "2030 climate goal", "supply chain emissions", "carbon removal", "clean energy", "sustainability", "corporate climate action", "carbon footprint", "net negative emissions", "tech industry climate goals", "environmental strategy", "emissions reduction", "renewable energy", "climate commitment"]

}
</script>
</head>

<body class="light-mode">
<?php include '../header.php'; ?>

    <div class="main-container">
        <div class="date-row">
            <div class="day">
                <strong><?php
echo date("l, F j, Y"); 
?></strong>
            </div>

            <div class="top-center">
                <a href="../main.php"><img src="../image/policynow-logo.png"
                    alt="Logo"></a>
            </div>
            <div class="top-right"> 
                <img src="../image/search.png" class="menu-toggle" alt="search" width="16" height="16">
                <div  class="search-box" id="searchBox">
                    <input type="text" placeholder="Type & hit enter">
                     <img  src="../image/search.png" class="menu-toggle1" alt="search" width="16" height="16">
                </div>
                <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                 <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
            </div>
        </div>
        <nav class="main-nav1">
            <a title="Politics & Policy" class="nav-H" href="../politics-and-policy.php">Politics & Policy</a>
            <a title="Business & Economy" class="nav-l" href="../business-and-economy.php">Business & Economy</a>
            <a title="Global Affairs" class="nav-l" href="../global-affairs.php">Global Affairs</a>
            <a title="Technology & Innovation" class="nav-l" href="../technology-and-innovation.php">Technology & Innovation</a>
            <a title="Finance & Markets" class="nav-l" href="../finance-and-markets.php">Finance & Markets</a>
            <a title="Featured PR" class="nav-l" href="../featured-pr.php">Featured PR</a>
            <a title="Author" class="nav-l" href="../author.php">Authors</a>
        </nav>

    </div>
      <div class="main">
          <section class="highlight-news">
            <div class="highlight-category">
                <a title="Featured PR" href="#">Featured PR</a>
            </div>
            <div class="live-sect">
                <span class="live-status">
                    <span class="dot"></span>

                </span>
                <p> <span class="live-badge">LIVE</span>
                    7 days ago</p>
            </div>
            <h1 class="highlight-title">Microsoft: carbon-negative by 2030 even for supply chain</h1>
            <p class="content-para">Microsoft is pledging to become 100% “carbon-negative” by 2030 by removing more carbon from the environment than it emits.</p>

            <div class="highlight-footer">
                <div class="author-blocks">
                    <div class="author-card">
                        <img src="../image/lisa-g-hart.jpg"
                            alt="Lisa G. Hart">
                        <div class="author-info">
                            <a title="Lisa G. Hart" href="author.php">Lisa G. Hart</a>
                            <span>NOVEMBER 07, 2025</span>
                        </div>
                    </div>
                    
                </div>

                <div class="share-block">
                    <span>Share this</span>
                    <div class="share-icons">
                        <a title="facebook" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                        </a>
                        <a title="twitter" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                        </a>

                        <a title="youtube" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
                        </a>
                    </div>
                    <div class="share-single">
                        <button>
                            <a title="more" href="#"><i class="fa-solid fa-share-nodes"></i></a>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <div class="img-section">
            <img src="../image/microsoft-pledges-to-become.webp"
                alt="IBM Commits To Net Zero Greenhouse Gas">
        </div>

        <div class="second-sec">

      <p class="content-para">CEO Satya Nadella said Thursday that the commitment will happen “not just across our direct emissions, but across our supply chain, too.”</p>

<p class="content-para">It’s a major step up from Microsoft’s previous green pledges. The tech company had previously said its data centers would be 60% powered by renewable electricity by the end of last year, but environmental groups have said it has fallen short of such rivals as Google and Apple by relying too much on purchasing renewable energy credits to make up for its carbon emissions.</p>

<p class="content-para">“Microsoft has really been in the middle of the pack,” said Elizabeth Jardim, senior corporate campaigner for Greenpeace USA. “Not an ‘A’ student but clearly not doing nothing.”</p>

<p class="content-para">Jardim said that Thursday’s announcement shows a “more serious and holistic” approach and that Microsoft “understands climate science and the shrinking window for action.”</p>

<p class="content-para">Microsoft had previously set an interim goal of 70% renewable energy by 2023. It now says it will hit 100% renewable for all of its data centers and buildings by 2025 — and will no longer depend on credit-buying to meet its goals. Google and Apple have already said they reached the 100% milestone. Amazon said it would run on 100% renewable energy by 2030.</p>

<p class="content-para">Microsoft’s announcement was timed ahead of next week’s gathering of elites at the World Economic Forum in the Swiss resort of Davos. Catastrophic trends like global warming and the extinction of animal species will be a focus of the conference.</p>

<p class="content-para">Microsoft is responsible for about 16 million metric tons of emissions per year, said Brad Smith, the company’s president and chief legal officer. That estimate includes not just Microsoft’s global network of energy-chugging data centers, but emissions from making electronics components for its devices and from everyone who plugs in its Xbox gaming consoles at home.</p>

<p class="content-para">“When it comes to carbon, neutrality is not enough,” Smith said. “We have to get ourselves to net zero.” That means removing from the atmosphere all the carbon one emits, he said.</p>

<p class="content-para">The pledge to include supply chain emissions follows a similar move by Apple. Microsoft says it will set new procedures next year to push its suppliers to reduce their environmental footprint, in the same way it has required some of them to offer their workers paid time off and parental leave. It’s also expanding the scope of a fee it has had since 2012 charging its own business units for each ton of carbon they emit.</p>

<p class="content-para">Microsoft says that after reaching its 2030 goal, it will, by 2050, remove from the environment all of its historical emissions since the company was founded in 1975.</p>

<p class="content-para">But Jardim said Microsoft is undermining its climate goals by taking the lead among tech firms in partnering with oil and gas companies, providing cloud computing and artificial intelligence that can speed up the extraction of fossil fuels.</p>

<p class="content-para">Microsoft also said Thursday it is starting a $1 billion fund for developing carbon reduction and removal technology.</p>

        </div>
      </div>

    <!-- Blog Section -->
    <section class="latest-blog-wrapper">
        <h2 class="latest-blog-title">LATEST FROM BLOG</h2>

        <div class="latest-blog-grid">
            <!-- Blog Item 1 -->
            <a title="more" href="../featured-pr/ibm-commits-to-net-zero-greenhouse-gas-emissions-by-2030.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/ibm-commits-to-net-zero-greenhouse-gas.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">IBM Commits To Net Zero Greenhouse Gas Emissions By 2030</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 2 -->
            <a title="more" href="../featured-pr/governors-biden-administration-push-to-quadruple-efficient-heating-ac-units-by-2030.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/governors-biden-administration-push.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Governors, Biden administration push to quadruple efficient heating, AC units by 2030</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 3 -->
            <a title="more" href="../featured-pr/tentree-pledges-to-plant-one-billion-trees-by-2030-in-support-of-1t-org.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/tentree-pledges-to-plant-one-billion-trees.jpg"
                        alt="Image">
                </div>
                <h3 class="blog-heading">tentree Pledges to Plant One Billion Trees by 2030 in Support of 1t.org</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 4 -->
            <a title="more" href="../featured-pr/general-mills-to-reduce-absolute-greenhouse-gas-emissions-by-30-percent-across-its-full-value-chain-over-next-decade.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/general-mills-to-reduce-absolute-greenhouse-gas-emissions.avif"
                        alt="Image">
                </div>
                <h3 class="blog-heading">General Mills to Reduce Absolute Greenhouse Gas Emissions by 30% Across its Full Value Chain Over Next Decade</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 5 -->
            <a title="more" href="../featured-pr/mechanical-sails-batteries-shippers-forming-green-corridors-to-fast-track-cleaner-technologies.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/mechanical-sails-batteries-shippers.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Mechanical sails? Batteries? Shippers forming ‘green corridors’ to fast-track cleaner technologies</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>


        </div>
<?php include '../footer.php'; ?>
    </section>

    <script defer src="../js/style.js" ></script>
</body>

</html>