<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mechanical sails? Batteries? Shippers forming ‘green corridors’ to fast-track cleaner technologies</title>
    <link rel="stylesheet" href="../css/style.css">
        <meta name="description"
        content="Mechanical sails and battery systems are being tested as shippers develop “green corridors” to fast-track cleaner technologies and reduce maritime emissions">
    <meta property="og:title" content="Mechanical sails? Batteries? Shippers forming ‘green corridors’ to fast-track cleaner technologies">
    <meta property="og:description"
        content="Mechanical sails and battery systems are being tested as shippers develop “green corridors” to fast-track cleaner technologies and reduce maritime emissions">
    <meta name="keywords" content="mechanical sails">
    <meta property="og:url" content="https://www.policynow.org/a-top-federal-reserve-official-says-dour-jobs-data-backs-the-case-for-three-rate-cuts">
    <meta property="og:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta property="og:site_name" content="">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_US">
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Mechanical sails? Batteries? Shippers forming ‘green corridors’ to fast-track cleaner technologies">
    <meta name="twitter:description"
        content="Mechanical sails and battery systems are being tested as shippers develop “green corridors” to fast-track cleaner technologies and reduce maritime emissions">
    <meta name="twitter:url" content="https://www.policynow.org/a-top-federal-reserve-official-says-dour-jobs-data-backs-the-case-for-three-rate-cuts">
    <meta name="twitter:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta name="twitter:site" content="@policynow">
    <meta name="twitter:creator" content="@policynow">
    <link rel="icon" type="image/x-icon" href="https://www.policynow.org/image/favicon.png">
    <link rel="canonical" href="https://www.policynow.org/a-top-federal-reserve-official-says-dour-jobs-data-backs-the-case-for-three-rate-cuts">
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "NewsArticle",
  "mainEntityOfPage": {
    "@id": "https://www.policynow.org/a-top-federal-reserve-official-says-dour-jobs-data-backs-the-case-for-three-rate-cuts"
  },
  "headline": "Mechanical sails? Batteries? Shippers forming ‘green corridors’ to fast-track cleaner technologies",
  "image": [
    "https://www.policynow.org/image/twitter-card.png"
  ],
  "datePublished": "2025-11-17T08:28:00-04:00",
  "dateModified": "2025-11-17T08:28:00-04:00",
  "description": "Mechanical sails and battery systems are being tested as shippers develop “green corridors” to fast-track cleaner technologies and reduce maritime emissions",
  "author": {
    "@type": "Person",
    "name": "Editorial Board"
  },
  "publisher": {
    "@type": "Organization",
    "name": "policynow",
    "logo": {
      "@type": "ImageObject",
      "url": "https://www.policynow.org/image/policynow-logo.png"
    }
  },
  "keywords": ["battery systems", "green corridors", "cleaner technologies", "maritime emissions", "shipping industry", "sustainable shipping", "green technology", "low-carbon shipping", "maritime innovation", "eco-friendly vessels", "shipping decarbonization", "clean energy solutions", "global shipping", "transport sustainability"]

}
</script>
</head>

<body class="light-mode">
<?php include '../header.php'; ?>

    <div class="main-container">
        <div class="date-row">
            <div class="day">
                <strong><?php
echo date("l, F j, Y"); 
?></strong>
            </div>

            <div class="top-center">
                <a href="../main.php"><img src="../image/policynow-logo.png"
                    alt="Logo"></a>
            </div>
            <div class="top-right"> 
                <img src="../image/search.png" class="menu-toggle" alt="search" width="16" height="16">
                <div  class="search-box" id="searchBox">
                    <input type="text" placeholder="Type & hit enter">
                     <img  src="../image/search.png" class="menu-toggle1" alt="search" width="16" height="16">
                </div>
                <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                 <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
            </div>
        </div>
        <nav class="main-nav1">
            <a title="Politics & Policy" class="nav-H" href="../politics-and-policy.php">Politics & Policy</a>
            <a title="Business & Economy" class="nav-l" href="../business-and-economy.php">Business & Economy</a>
            <a title="Global Affairs" class="nav-l" href="../global-affairs.php">Global Affairs</a>
            <a title="Technology & Innovation" class="nav-l" href="../technology-and-innovation.php">Technology & Innovation</a>
            <a title="Finance & Markets" class="nav-l" href="../finance-and-markets.php">Finance & Markets</a>
            <a title="Featured PR" class="nav-l" href="../featured-pr.php">Featured PR</a>
            <a title="Author" class="nav-l" href="../author.php">Authors</a>
        </nav>

    </div>
      <div class="main">
          <section class="highlight-news">
            <div class="highlight-category">
                <a title="Featured PR" href="#">Featured PR</a>
            </div>
            <div class="live-sect">
                <span class="live-status">
                    <span class="dot"></span>

                </span>
                <p> <span class="live-badge">LIVE</span>
                    7 days ago</p>
            </div>
            <h1 class="highlight-title">Mechanical sails? Batteries? Shippers forming ‘green corridors’ to fast-track cleaner technologies</h1>
            <p class="content-para">It’s among the world’s busiest container shipping routes — a stream of vessels packed with furniture, automobiles, clothing and other goods, traversing the Pacific between Los Angeles and Shanghai.</p>

            <div class="highlight-footer">
                <div class="author-blocks">
                    <div class="author-card">
                        <img src="../image/lisa-g-hart.jpg"
                            alt="Lisa G. Hart">
                        <div class="author-info">
                            <a title="Lisa G. Hart" href="author.php">Lisa G. Hart</a>
                            <span>NOVEMBER 07, 2025</span>
                        </div>
                    </div>
                    
                </div>

                <div class="share-block">
                    <span>Share this</span>
                    <div class="share-icons">
                        <a title="facebook" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                        </a>
                        <a title="twitter" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                        </a>

                        <a title="youtube" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
                        </a>
                    </div>
                    <div class="share-single">
                        <button>
                            <a title="more" href="#"><i class="fa-solid fa-share-nodes"></i></a>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <div class="img-section">
            <img src="../image/mechanical-sails-batteries-shippers.webp"
                alt="Mechanical sails? Batteries? Shippers">
        </div>

        <div class="second-sec">

     <p class="content-para">If plans succeed, this corridor will become a showcase for slashing planet-warming carbon emissions from the shipping industry, which produces nearly 3% of the world’s total. That’s less than from cars, trucks, rail or aviation but still a lot — and it’s rising.</p>

<p class="content-para">The International Maritime Organization, which regulates commercial shipping, wants to halve its greenhouse gas releases by midcentury and may seek deeper cuts this year. “Shipping must embrace decarbonization,” IMO Secretary-General Kitack Lim said in February.</p>

<p class="content-para">Meeting agency targets will require significant vessel and infrastructure changes. That’s inspiring plans for “green shipping corridors” along major routes where new technologies and methods could be fast-tracked and scaled up.</p>

<p class="content-para">More than 20 of these partnerships have been proposed. They’re largely on paper now but are expected to take shape in coming years. The goal: uniting marine fuel producers, vessel owners and operators, cargo owners and ports in a common effort.</p>

<p class="content-para"><strong>FRONT-RUNNERS</strong></p>

<p class="content-para">Los Angeles and Shanghai formed their partnership last year.</p>

<p class="content-para">“The vision is that a container will leave a factory on a zero-emissions truck (in China),” said Gene Seroka, executive director of the Port of Los Angeles.</p>

<p class="content-para">“It will arrive at the port of Shanghai, be loaded onto a ship by a zero-emissions cargo handling equipment unit, and move across the Pacific Ocean on a vessel that emits zero carbon. Once it gets to Los Angeles, the reverse happens,” with carbon-free handling and distribution.</p>

<p class="content-para">Los Angeles entered a second agreement in April with nearby Long Beach and Singapore. Others in the works include the Great Lakes-St. Lawrence River; a Chilean network; and numerous corridors in Asia, North America and Europe.</p>

<p class="content-para">C40 Cities, a global climate action coalition of mayors, advocates green corridors as “tools that can turn ambition into action, bringing together the entire shipping value chain,” said Alisa Kreynes, a deputy director.</p>

<p class="content-para">But Kreynes sounded a note of caution: “I can’t help but wonder how much of it is PR and how much of it is actually going to become practice. It’s going to require a cultural shift in thinking about how we get things from point A to point B.”</p>

<p class="content-para">New approaches developed in green corridors could bring fast results, said John Bradshaw, technical director for environment and safety with the World Shipping Council. “I’m very confident that the industry will deliver zero emissions by 2050.”</p>

<p class="content-para"><strong>PRESSURE BUILDS</strong></p>

<p class="content-para">From tea to tennis shoes, stuff in your pantry and closets likely spent time on a ship.</p>

<p class="content-para">Roughly 90% of traded goods move on water, some in behemoths longer than four football fields, each holding thousands of containers with consumer products. About 58,000 commercial ships ply the seas.</p>

<p class="content-para">Their emissions are less noticeable than onshore haulers such as trucks, although noxious fumes from ships draw complaints in port communities.</p>

<p class="content-para">Maritime trade volumes are expected to triple by 2050, according to the Organization for Economic Cooperation and Development. Studies predict the industry’s share of greenhouse gas emissions could reach 15%.</p>

<p class="content-para">Yet the 2015 Paris climate accord exempts maritime shipping, partly because vessels do business worldwide, while the agreement covers nation-by-nation goals.</p>

<p class="content-para">“No one wants to take responsibility,” said Allyson Browne of Pacific Environment, an advocacy group. “A ship may be flagged in China, but who takes ownership of emissions from that ship when it’s transporting goods to the U.S.?”</p>

<p class="content-para">The IMO responded to mounting pressure with a 2018 plan for a 50% emissions reduction by midcentury from 2008 levels. An update scheduled for July may set more ambitious targets favored by the U.S., Europe and small island nations. Opponents include Brazil, China and India.</p>

<p class="content-para">The Biden administration wants a zero-emission goal, a State Department official told The Associated Press.</p>

<p class="content-para">But fewer than half of large shipping companies have pledged to meet international carbon objectives. And there’s no consensus about how to accomplish them.</p>

<p class="content-para">Proposals range from slowing vessels down to charging them for emissions, as the European Union did last year.</p>

<p class="content-para">“Global shipping is hard to decarbonize ... because of the energy required to cover long distances with heavy cargoes,” said Lee Kindberg, head of environment and sustainability for Maersk North America, part of A.P. Moller-Maersk, which has more than 700 vessels. “It’s a stretch but we consider it doable.”</p>

<p class="content-para"><strong>BUT HOW?</strong></p>

<p class="content-para">Mechanical sails. Batteries. Low- or zero-carbon liquid fuels.</p>

<p class="content-para">They’re among propulsion methods touted as replacements for “bunker fuel” that powers most commercial ships — thick residue from oil refining. It spews greenhouse gases and pollutants that endanger human health: sulfur dioxide, nitrogen oxide, soot.</p>

<p class="content-para">Finding alternatives will be a priority for green shipping corridors.</p>

<p class="content-para">For now, liquid natural gas is the runaway choice. Worldwide, it’s used by 923 of 1,349 commercial vessels not powered by conventional fuels, according to a study last year by DNV, a Norway-based maritime accreditation society. Vessels with batteries or hybrid systems placed a distant second.</p>

<p class="content-para">Many environmentalists oppose LNG because it emits methane, another potent greenhouse gas. Defenders say it’s the quickest and most cost-effective bunker fuel substitute.</p>

<p class="content-para">Of 1,046 alternative-energy ships on order, 534 are powered by LNG while 417 are battery-hybrids, DNV reported. Thirty-five others will use methanol, which analysts consider an up-and-coming cleaner alternative.</p>

<p class="content-para">Moller-Maersk plans to launch 12 cargo vessels next year that will use “green methanol” produced with renewable sources such as plant waste. A biodiesel from used cooking oil fuels some of its ships.</p>

<p class="content-para">The company is collaborating on research that may lead to ammonia- or hydrogen-powered vessels by the mid-2030s.</p>

<p class="content-para">“This is the first step toward the turnover of our fleet into something much more climate-friendly,” Kindberg said.</p>

<p class="content-para">Norsepower offers a new twist on an ancient technology: wind.</p>

<p class="content-para">The Finnish company has developed “rotor sails” — composite cylinders about 33 yards (30 meters) tall that are fitted on ship decks and spin in the breeze. Air pressure differences on opposite sides of the whirring devices help push a vessel forward.</p>

<p class="content-para">An independent analysis found rotor sails installed on a Maersk oil tanker in 2018 produced an 8.2% fuel savings in a year. Norsepower CEO Tuomas Riski said others have saved 5% to 25%, depending on wind conditions, ship type and other factors.</p>

<p class="content-para">Thirteen ships are using the devices or have them on order, Riski said.</p>

<p class="content-para">“Mechanical sails have an essential role in the decarbonization of shipping,” he said. “They can’t do it alone, but they can make a great contribution.”</p>

<p class="content-para">Fleetzero contends electric ships are best suited to wean the industry off carbon. The company was founded two years ago in Alabama to build cargo vessels with rechargeable battery packs.</p>

<p class="content-para">CEO Steven Henderson says it envisions fleets of smaller, nimbler ships than huge container vessels. They would call at ports that have freshly charged batteries to swap for ones running low. Fleetzero’s prototype ship is slated to begin delivering cargo later this year.</p>

<p class="content-para"><strong>WHO GOES FIRST?</strong></p>

<p class="content-para">Before building or buying low-emission vessels, companies want assurances clean fuels will be available and affordable.</p>

<p class="content-para">Companies producing the fuels, meanwhile, want enough ships using them to guarantee strong markets.</p>

<p class="content-para">And both need port infrastructure that accommodates new-generation ships, such as electrical hookups and clean fuel dispensing mechanisms.</p>

<p class="content-para">But ports await demand to justify such expensive upgrades. Switching onshore cargo handling equipment and trucks to zero-emission models will cost the Los Angeles port $20 billion, officials say.</p>

<p class="content-para">“Once you put a (green) corridor on the map,” said Jason Anderson, senior program director for the nonprofit ClimateWorks Foundation, “at least they’re heading in the same direction.”</p>

<p class="content-para">Success will require government regulation and corridor funding, along with support from shipping industry customers, said Jing Sun, a University of Michigan marine engineering professor.</p>

<p class="content-para">“Shipping is the most cost-effective way of moving things around,” Sun said.</p>

<p class="content-para">An organization called Cargo Owners for Zero Emission Vessels pledges to use only zero-emission shipping companies by 2040. Among 19 signatories are Amazon, Michelin and Target.</p>

<p class="content-para">“When big corporate buyers come together and say we need this to happen, the rest of the chain has confidence to make needed investments,” said Ingrid Irigoyen, an assistant director of the nonprofit Aspen Institute, which helped assemble the group.</p>
        </div>
      </div>

    <!-- Blog Section -->
    <section class="latest-blog-wrapper">
        <h2 class="latest-blog-title">LATEST FROM BLOG</h2>

               <div class="latest-blog-grid">
            <!-- Blog Item 1 -->
            <a title="more" href="../featured-pr/ibm-commits-to-net-zero-greenhouse-gas-emissions-by-2030.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/ibm-commits-to-net-zero-greenhouse-gas.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">IBM Commits To Net Zero Greenhouse Gas Emissions By 2030</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 2 -->
            <a title="more" href="../featured-pr/microsoft-carbon-negative-by-2030-even-for-supply-chain.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/microsoft-pledges-to-become.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Microsoft: carbon-negative by 2030 even for supply chain</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 3 -->
            <a title="more" href="../featured-pr/tentree-pledges-to-plant-one-billion-trees-by-2030-in-support-of-1t-org.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/tentree-pledges-to-plant-one-billion-trees.jpg"
                        alt="Image">
                </div>
                <h3 class="blog-heading">tentree Pledges to Plant One Billion Trees by 2030 in Support of 1t.org</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 4 -->
            <a title="more" href="../featured-pr/general-mills-to-reduce-absolute-greenhouse-gas-emissions-by-30-percent-across-its-full-value-chain-over-next-decade.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/general-mills-to-reduce-absolute-greenhouse-gas-emissions.avif"
                        alt="Image">
                </div>
                <h3 class="blog-heading">General Mills to Reduce Absolute Greenhouse Gas Emissions by 30% Across its Full Value Chain Over Next Decade</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 5 -->
            <a title="more" href="../featured-pr/governors-biden-administration-push-to-quadruple-efficient-heating-ac-units-by-2030.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/governors-biden-administration-push.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Governors, Biden administration push to quadruple efficient heating, AC units by 2030</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>


        </div>
<?php include '../footer.php'; ?>
    </section>

    <script defer src="../js/style.js" ></script>
</body>

</html>