<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>IBM Commits To Net Zero Greenhouse Gas Emissions By 2030</title>
    <link rel="stylesheet" href="../css/style.css">
        <meta name="description"
        content="IBM plans to achieve net-zero greenhouse gas emissions by 2030, focusing on renewable energy, efficiency improvements, and science-based climate goals">
    <meta property="og:title" content="IBM Commits To Net Zero Greenhouse Gas Emissions By 2030">
    <meta property="og:description"
        content="IBM plans to achieve net-zero greenhouse gas emissions by 2030, focusing on renewable energy, efficiency improvements, and science-based climate goals">
    <meta name="keywords" content="IBM">
    <meta property="og:url" content="https://www.policynow.org/a-top-federal-reserve-official-says-dour-jobs-data-backs-the-case-for-three-rate-cuts">
    <meta property="og:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta property="og:site_name" content="">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_US">
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="IBM Commits To Net Zero Greenhouse Gas Emissions By 2030">
    <meta name="twitter:description"
        content="IBM plans to achieve net-zero greenhouse gas emissions by 2030, focusing on renewable energy, efficiency improvements, and science-based climate goals">
    <meta name="twitter:url" content="https://www.policynow.org/a-top-federal-reserve-official-says-dour-jobs-data-backs-the-case-for-three-rate-cuts">
    <meta name="twitter:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta name="twitter:site" content="@policynow">
    <meta name="twitter:creator" content="@policynow">
    <link rel="icon" type="image/x-icon" href="https://www.policynow.org/image/favicon.png">
    <link rel="canonical" href="https://www.policynow.org/a-top-federal-reserve-official-says-dour-jobs-data-backs-the-case-for-three-rate-cuts">
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "NewsArticle",
  "mainEntityOfPage": {
    "@id": "https://www.policynow.org/a-top-federal-reserve-official-says-dour-jobs-data-backs-the-case-for-three-rate-cuts"
  },
  "headline": "IBM Commits To Net Zero Greenhouse Gas Emissions By 2030",
  "image": [
    "https://www.policynow.org/image/twitter-card.png"
  ],
  "datePublished": "2025-11-17T08:28:00-04:00",
  "dateModified": "2025-11-17T08:28:00-04:00",
  "description": "IBM plans to achieve net-zero greenhouse gas emissions by 2030, focusing on renewable energy, efficiency improvements, and science-based climate goals",
  "author": {
    "@type": "Person",
    "name": "Editorial Board"
  },
  "publisher": {
    "@type": "Organization",
    "name": "policynow",
    "logo": {
      "@type": "ImageObject",
      "url": "https://www.policynow.org/image/policynow-logo.png"
    }
  },
  "keywords": ["net zero emissions", "greenhouse gas emissions", "2030 climate goals", "renewable energy", "carbon neutrality", "sustainability", "climate commitment", "energy efficiency", "corporate climate action", "GHG reduction", "technology sector", "science-based targets", "clean energy", "environmental strategy"]

}
</script>
</head>

<body class="light-mode">
<?php include '../header.php'; ?>

    <div class="main-container">
        <div class="date-row">
            <div class="day">
                <strong><?php
echo date("l, F j, Y"); 
?></strong>
            </div>

            <div class="top-center">
                <a href="../main.php"><img src="../image/policynow-logo.png"
                    alt="Logo"></a>
            </div>
            <div class="top-right"> 
                <img src="../image/search.png" class="menu-toggle" alt="search" width="16" height="16">
                <div  class="search-box" id="searchBox">
                    <input type="text" placeholder="Type & hit enter">
                     <img  src="../image/search.png" class="menu-toggle1" alt="search" width="16" height="16">
                </div>
                <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                 <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
            </div>
        </div>
        <nav class="main-nav1">
            <a title="Politics & Policy" class="nav-H" href="../politics-and-policy.php">Politics & Policy</a>
            <a title="Business & Economy" class="nav-l" href="../business-and-economy.php">Business & Economy</a>
            <a title="Global Affairs" class="nav-l" href="../global-affairs.php">Global Affairs</a>
            <a title="Technology & Innovation" class="nav-l" href="../technology-and-innovation.php">Technology & Innovation</a>
            <a title="Finance & Markets" class="nav-l" href="../finance-and-markets.php">Finance & Markets</a>
            <a title="Featured PR" class="nav-l" href="../featured-pr.php">Featured PR</a>
            <a title="Author" class="nav-l" href="../author.php">Authors</a>
        </nav>

    </div>
      <div class="main">
          <section class="highlight-news">
            <div class="highlight-category">
                <a title="Featured PR" href="#">Featured PR</a>
            </div>
            <div class="live-sect">
                <span class="live-status">
                    <span class="dot"></span>

                </span>
                <p> <span class="live-badge">LIVE</span>
                    7 days ago</p>
            </div>
            <h1 class="highlight-title">IBM Commits To Net Zero Greenhouse Gas Emissions By 2030</h1>
<p class="content-para">IBM (NYSE: IBM) announced that it will achieve net zero greenhouse gas emissions by 2030 to further its decades-long work to address the global climate crisis. The company will accomplish this goal by prioritizing actual reductions in its emissions, energy efficiency efforts and increased clean energy use across the more than 175 countries where it operates.</p>


            <div class="highlight-footer">
                <div class="author-blocks">
                    <div class="author-card">
                        <img src="../image/lisa-g-hart.jpg"
                            alt="Lisa G. Hart">
                        <div class="author-info">
                            <a title="Lisa G. Hart" href="author.php">Lisa G. Hart</a>
                            <span>NOVEMBER 07, 2025</span>
                        </div>
                    </div>
                    
                </div>

                <div class="share-block">
                    <span>Share this</span>
                    <div class="share-icons">
                        <a title="facebook" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                        </a>
                        <a title="twitter" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                        </a>

                        <a title="youtube" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
                        </a>
                    </div>
                    <div class="share-single">
                        <button>
                            <a title="more" href="#"><i class="fa-solid fa-share-nodes"></i></a>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <div class="img-section">
            <img src="../image/ibm-commits-to-net-zero-greenhouse-gas.webp"
                alt="IBM Commits To Net Zero Greenhouse Gas">
        </div>

        <div class="second-sec">

    <p class="content-para">“I am proud that IBM is leading the way by taking actions to significantly reduce emissions,” said Arvind Krishna, Chairman and Chief Executive Officer, IBM. “The climate crisis is one of the most pressing issues of our time. IBM’s net zero pledge is a bold step forward that strengthens our long-standing climate leadership and positions our company years ahead of the targets set out in the Paris Climate Agreement.”</p>

    <p class="content-para">IBM’s net zero pledge also establishes near-term targets to drive accountability and progress now. It is transparent in terms of how the company calculates and reports renewable energy use. For example, IBM’s target is based on the energy the company can actually consume, not on the purchase of unrelated, unbundled renewable energy certificates.</p>

    <p class="content-para">As part of IBM’s commitment to sustainability and its focus on the application of science and technology to solve major societal challenges, IBM Research has launched a Future of Climate initiative designed to accelerate the discovery of solutions to address the impacts of a changing climate.</p>

    <p class="content-para">Utilizing a combination of artificial intelligence, hybrid cloud and quantum computing, IBM researchers are working with clients and partners to apply science to complex climate-related problems, such as the growing global carbon footprint of cloud workloads and data centers, methods to accurately model and assess the risk of changing environments and climate patterns, and the development of new polymers, membranes and materials that can capture and absorb carbon at the origin of emission.</p>

    <p class="content-para">IBM’s advocacy for environmental sustainability dates back decades, with its first corporate environmental policy statement issued in 1971. Since 1990, IBM has disclosed its performance in managing waste, conserving energy, using renewable electricity, reducing carbon dioxide emissions and developing innovative solutions in an annual Corporate Environmental Report. In 2007, IBM publicly stated its position on climate change, saying that “climate change is a serious concern that warrants meaningful action on a global basis to stabilize the atmospheric concentration of greenhouse gases.” The company supported the Paris Agreement in 2015, and in 2017 publicly reiterated its support for the U.S. to remain a party to it. In 2019, IBM became a Founding Member of the Climate Leadership Council, and fully supports its bipartisan plan for a carbon tax with 100% of the net proceeds paid to citizens as a carbon dividend.</p>
        </div>
      </div>

    <!-- Blog Section -->
    <section class="latest-blog-wrapper">
        <h2 class="latest-blog-title">LATEST FROM BLOG</h2>

               <div class="latest-blog-grid">
            <!-- Blog Item 1 -->
            <a title="more" href="../featured-pr/amazon-google-make-dueling-nuclear-investments-to-power-data-centers-with-clean-energy.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/amazon-google-make-dueling-nuclear-investments.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Amazon, Google make dueling nuclear investments to power data centers with clean energy</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 2 -->
            <a title="more" href="../featured-pr/microsoft-carbon-negative-by-2030-even-for-supply-chain.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/microsoft-pledges-to-become.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Microsoft: carbon-negative by 2030 even for supply chain</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 3 -->
            <a title="more" href="../featured-pr/tentree-pledges-to-plant-one-billion-trees-by-2030-in-support-of-1t-org.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/tentree-pledges-to-plant-one-billion-trees.jpg"
                        alt="Image">
                </div>
                <h3 class="blog-heading">tentree Pledges to Plant One Billion Trees by 2030 in Support of 1t.org</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 4 -->
            <a title="more" href="../featured-pr/general-mills-to-reduce-absolute-greenhouse-gas-emissions-by-30-percent-across-its-full-value-chain-over-next-decade.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/general-mills-to-reduce-absolute-greenhouse-gas-emissions.avif"
                        alt="Image">
                </div>
                <h3 class="blog-heading">General Mills to Reduce Absolute Greenhouse Gas Emissions by 30% Across its Full Value Chain Over Next Decade</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 5 -->
            <a title="more" href="../featured-pr/mechanical-sails-batteries-shippers-forming-green-corridors-to-fast-track-cleaner-technologies.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/mechanical-sails-batteries-shippers.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Mechanical sails? Batteries? Shippers forming ‘green corridors’ to fast-track cleaner technologies</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>


        </div>
<?php include '../footer.php'; ?>
    </section>

    <script defer src="../js/style.js" ></script>
</body>

</html>