<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>General Mills to Reduce Absolute Greenhouse Gas Emissions by 30% Across its Full Value Chain Over Next Decade</title>
    <link rel="stylesheet" href="../css/style.css">
        <meta name="description"
        content="General Mills plans to cut absolute greenhouse gas emissions by 30% across its entire value chain over the next decade as part of its climate goals">
    <meta property="og:title" content="General Mills to Reduce Absolute Greenhouse Gas Emissions by 30% Across its Full Value Chain Over Next Decade">
    <meta property="og:description"
        content="General Mills plans to cut absolute greenhouse gas emissions by 30% across its entire value chain over the next decade as part of its climate goals">
    <meta name="keywords" content="General Mills">
    <meta property="og:url" content="https://www.policynow.org/general-mills-to-reduce-absolute-greenhouse-gas-emissions-by-30-percent-across-its-full-value-chain-over-next-decade">
    <meta property="og:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta property="og:site_name" content="">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_US">
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="General Mills to Reduce Absolute Greenhouse Gas Emissions by 30% Across its Full Value Chain Over Next Decade">
    <meta name="twitter:description"
        content="General Mills plans to cut absolute greenhouse gas emissions by 30% across its entire value chain over the next decade as part of its climate goals">
    <meta name="twitter:url" content="https://www.policynow.org/general-mills-to-reduce-absolute-greenhouse-gas-emissions-by-30-percent-across-its-full-value-chain-over-next-decade">
    <meta name="twitter:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta name="twitter:site" content="@policynow">
    <meta name="twitter:creator" content="@policynow">
    <link rel="icon" type="image/x-icon" href="https://www.policynow.org/image/favicon.png">
    <link rel="canonical" href="https://www.policynow.org/general-mills-to-reduce-absolute-greenhouse-gas-emissions-by-30-percent-across-its-full-value-chain-over-next-decade">
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "NewsArticle",
  "mainEntityOfPage": {
    "@id": "https://www.policynow.org/general-mills-to-reduce-absolute-greenhouse-gas-emissions-by-30-percent-across-its-full-value-chain-over-next-decade"
  },
  "headline": "General Mills to Reduce Absolute Greenhouse Gas Emissions by 30% Across its Full Value Chain Over Next Decade",
  "image": [
    "https://www.policynow.org/image/twitter-card.png"
  ],
  "datePublished": "2025-11-17T08:28:00-04:00",
  "dateModified": "2025-11-17T08:28:00-04:00",
  "description": "General Mills plans to cut absolute greenhouse gas emissions by 30% across its entire value chain over the next decade as part of its climate goals",
  "author": {
    "@type": "Person",
    "name": "Editorial Board"
  },
  "publisher": {
    "@type": "Organization",
    "name": "policynow",
    "logo": {
      "@type": "ImageObject",
      "url": "https://www.policynow.org/image/policynow-logo.png"
    }
  },
  "keywords": ["greenhouse gas emissions", "30% reduction", "value chain", "climate goals", "sustainability", "carbon footprint", "environmental impact", "corporate climate action", "emissions reduction", "food industry", "sustainable operations", "climate strategy", "eco-friendly initiatives", "GHG reduction"]

}
</script>
</head>

<body class="light-mode">
<?php include '../header.php'; ?>

    <div class="main-container">
        <div class="date-row">
            <div class="day">
                <strong><?php
echo date("l, F j, Y"); 
?></strong>
            </div>

            <div class="top-center">
                <a href="../main.php"><img src="../image/policynow-logo.png"
                    alt="Logo"></a>
            </div>
            <div class="top-right"> 
                <img src="../image/search.png" class="menu-toggle" alt="search" width="16" height="16">
                <div  class="search-box" id="searchBox">
                    <input type="text" placeholder="Type & hit enter">
                     <img  src="../image/search.png" class="menu-toggle1" alt="search" width="16" height="16">
                </div>
                <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                 <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
            </div>
        </div>
        <nav class="main-nav1">
            <a title="Politics & Policy" class="nav-H" href="../politics-and-policy.php">Politics & Policy</a>
            <a title="Business & Economy" class="nav-l" href="../business-and-economy.php">Business & Economy</a>
            <a title="Global Affairs" class="nav-l" href="../global-affairs.php">Global Affairs</a>
            <a title="Technology & Innovation" class="nav-l" href="../technology-and-innovation.php">Technology & Innovation</a>
            <a title="Finance & Markets" class="nav-l" href="../finance-and-markets.php">Finance & Markets</a>
            <a title="Featured PR" class="nav-l" href="../featured-pr.php">Featured PR</a>
            <a title="Author" class="nav-l" href="../author.php">Authors</a>
        </nav>

    </div>
      <div class="main">
          <section class="highlight-news">
            <div class="highlight-category">
                <a title="Featured PR" href="#">Featured PR</a>
            </div>
            <div class="live-sect">
                <span class="live-status">
                    <span class="dot"></span>

                </span>
                <p> <span class="live-badge">LIVE</span>
                    7 days ago</p>
            </div>
            <h1 class="highlight-title">General Mills to Reduce Absolute Greenhouse Gas Emissions by 30% Across its Full Value Chain Over Next Decade</h1>

            <div class="highlight-footer">
                <div class="author-blocks">
                    <div class="author-card">
                        <img src="../image/lisa-g-hart.jpg"
                            alt="Lisa G. Hart">
                        <div class="author-info">
                            <a title="Lisa G. Hart" href="author.php">Lisa G. Hart</a>
                            <span>NOVEMBER 07, 2025</span>
                        </div>
                    </div>
                    
                </div>

                <div class="share-block">
                    <span>Share this</span>
                    <div class="share-icons">
                        <a title="facebook" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                        </a>
                        <a title="twitter" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                        </a>

                        <a title="youtube" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
                        </a>
                    </div>
                    <div class="share-single">
                        <button>
                            <a title="more" href="#"><i class="fa-solid fa-share-nodes"></i></a>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <div class="img-section">
            <img src="../image/general-mills-to-reduce-absolute-greenhouse-gas-emissions.avif"
                alt="General Mills to Reduce Absolute Greenhouse Gas Emissions">
        </div>

        <div class="second-sec">
<p class="content-para">General Mills announced a pledge to reduce absolute greenhouse gas emissions by 30 percent across its full value chain – from farm to fork to landfill – over the next 10 years. The company also committed to a long-term goal to achieve net zero emission levels by 2050. The absolute greenhouse gas commitment was calculated using methodologies approved by the Science Based Target Initiative (SBTi) that model a level of emission reductions that science suggests is necessary to sustain the health of the planet. General Mills was the first company to publish a goal approved by the SBTi in 2015.</p>

     <p class="content-para">“We’re proud to be making this ambitious goal which will take strong leadership and collaboration to drive holistic change,” said Jeff Harmening, chairman and CEO of General Mills. “From farmers and suppliers, to where we make our food, to packaging producers and shippers, to retailers, and finally how we get it to our consumers’ tables, each step in our value chain has a critical role to play -- that’s how we’ll tackle this to ensure we are doing more and taking bolder actions.”</p>

<p class="content-para">Each step in the company’s value chain has unique challenges and opportunities. General Mills has four key ambitions guiding its work to accelerate planetary health, healthy living ecosystems, and thriving farmers and communities over the next 10 years, including:</p>

<p class="content-para"><strong>→</strong> Reduce GHG emissions across the full value chain by 30% by 2030 and net zero emissions by 2050 in alignment with the new SBTi 1.5°C guidance;</p>
<p class="content-para"><strong>→</strong> Advance regenerative agriculture across the company’s sourcing footprint on 1 million acres by 2030 and activating programs across the ingredient categories with the largest GHG footprint;</p>
<p class="content-para"><strong>→</strong> Reduce food loss and waste by 50% in the company’s operations; and</p>
<p class="content-para"><strong>→</strong> Advance respect for human rights in the company’s value chain in accordance with the United Nations Guiding Principles on Business and Human Rights.</p>

<p class="content-para">These ambitions all contain bold 2030 targets, existing commitments and strategic partnerships to enable the company to prioritize and create work streams, develop governance policy, and solidify a data governance strategy, systems and processes to track and report progress publicly.</p>

<p class="content-para">“Realigning our commitment to a more aggressive target is consistent with how we have approached our business for over 150 years and lived one of our core values – to do the right thing all the time,” said Mary Jane Melendez, chief sustainability and social impact officer at General Mills. “While our greatest impact is outside our four walls – in agriculture, ingredients and packaging - we know we have a role to play in helping to restore planetary health.”</p>

<p class="content-para"><strong>Agriculture is the starting point</strong></p>

<p class="content-para">Up to one-third of greenhouse gases stem from the food system and an estimated 80% of which comes from agriculture. General Mills works with farmers and suppliers to address key growing dimensions including GHG emission reduction, water management, and soil health in an effort to establish more climate resilient farms.</p>

<p class="content-para">In 2019, General Mills made a commitment to advance regenerative agriculture on 1 million acres of farmland by 2030. The company defines regenerative agriculture as holistic, principles-based farming and ranching that seeks to strengthen ecosystems and community resilience. When implemented together, practices like cover crops, reduced tillage, diverse crops, biodiversity and integrating livestock have the ability to build soil health. Healthy soil can hold more water, increase resilience to floods and droughts, supply more nutrients to plants and purify water. To date, more than 250,000 acres are collectively managed across three pilot programs.</p>

<p class="content-para">In 2013, General Mills made a commitment to sustainably source 100% of its 10 priority ingredients by the end of 2020. In fiscal 2019, the company sustainably sourced 91% of its top 10 ingredients, which represent about 50% of the company’s total raw material purchases and have a significant impact on its total environmental footprint. As part of this commitment, the company works closely with suppliers and farmers to strengthen sustainable farming practices.</p>

<p class="content-para"><strong>Accountability within our operations</strong></p>

<p class="content-para">The company’s focus on reducing greenhouse gas emissions formally began within its direct operations in 2005. Between 2005 and 2015, General Mills reduced its manufacturing GHG emission rate by 23% and its absolute emissions by 11% while net sales rose 57%. The company accomplished this by using energy more efficiently across its owned facilities and by converting to less greenhouse gas-intensive forms of energy. Key projects include consolidation of operations, improvements to common systems like compressed air, lighting and steam/hot water, and application of renewable energy certificates (RECS) from its wind power agreements.</p>

<p class="content-para">Food waste within the company’s owned operations also contribute to the overall footprint. General Mills is committed to reduce food loss and waste by 50% in the company’s operations. Worldwide, at the end of 2019, 12 General Mills production facilities (24% of the global total) met its zero-waste-to-landfill criteria where nothing was sent to landfill or incineration without energy recovery.</p>

<p class="content-para"><strong>Lower Impact Packaging</strong></p>

<p class="content-para">General Mills continually innovates to reduce the environmental impact of packaging through better design – by decreasing materials use, switching to lower impact materials (including renewable and recyclable) and improving truckload packing efficiencies.</p>

<p class="content-para">The company has a target to source 100% of its fiber packaging by the end of 2020 from recycled material or from virgin wood fiber regions that do not contribute to deforestation, and through 2019, had achieved 99.5%. And in early 2019, General Mills announced an ambition that 100% of its packaging be recyclable or reusable by 2030.</p>

<p class="content-para"><strong>Leaning into Climate Action</strong></p>

<p class="content-para">General Mills recently signed on to the Business Ambition for 1.5°C, a global movement of leading companies aligning their business with the most ambitious of the Paris Agreement, to limit global temperature rise to 1.5°C above pre-industrial levels and reach net-zero by 2050 for the best chance of avoiding the worst impacts of climate change. As of September 15, more than 282 visionary corporate leaders have signed the commitment to take action.</p>

<p class="content-para">“The science is clear: in order to limit the catastrophic impacts of climate change, we must ensure warming does not exceed 1.5°C,” said Paul Simpson, CEO of CDP, one of the SBTi partners. “The ambition is high but it’s achievable — and science-based targets give companies a roadmap for getting there. Corporations worldwide have an unprecedented opportunity to be at the very forefront of the transition to a net-zero economy — and there is no time to lose.”</p>

<p class="content-para">In each of the following years, 2017, 2018 and 2019, General Mills was recognized as a global leader in corporate sustainability by environmental impact non-profit CDP, achieving a place on the “A List” for climate change. The company’s transparent actions to cut emissions, assess and mitigate climate risks and contribute to the low-carbon economy were based on the data it submitted through CDP’s annual climate change questionnaires.</p>

<p class="content-para">“While our success depends on our actions, we cannot get there on our own,” added Melendez. “We believe every company, government and individual has a role to play.”</p>

<p class="content-para">Business Ambition for 1.5°C is a campaign led by the Science Based Targets initiative in partnership with the UN Global Compact and the We Mean Business coalition.</p>

<p class="content-para">For more information on General Mills commitments, progress and work underway, visit the company’s 2020 Global Responsibility Report.</p>

<p class="content-para"><strong>About General Mills</strong></p>

<p class="content-para">General Mills is a leading global food company whose purpose is to make food the world loves. Its brands include Cheerios, Annie’s, Yoplait, Nature Valley, Häagen-Dazs, Betty Crocker, Pillsbury, Old El Paso, Wanchai Ferry, Yoki, BLUE and more. Headquartered in Minneapolis, Minnesota, USA, General Mills generated fiscal 2020 net sales of U.S. $17.6 billion. In addition, General Mills’ share of non-consolidated joint venture net sales totaled U.S. $1.0 billion.</p>

        </div>
      </div>

    <!-- Blog Section -->
    <section class="latest-blog-wrapper">
        <h2 class="latest-blog-title">LATEST FROM BLOG</h2>

        <div class="latest-blog-grid">
            <!-- Blog Item 1 -->
            <a title="more" href="../featured-pr/ibm-commits-to-net-zero-greenhouse-gas-emissions-by-2030.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/ibm-commits-to-net-zero-greenhouse-gas.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">IBM Commits To Net Zero Greenhouse Gas Emissions By 2030</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 2 -->
            <a title="more" href="../featured-pr/microsoft-carbon-negative-by-2030-even-for-supply-chain.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/microsoft-pledges-to-become.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Microsoft: carbon-negative by 2030 even for supply chain</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 3 -->
            <a title="more" href="../featured-pr/tentree-pledges-to-plant-one-billion-trees-by-2030-in-support-of-1t-org.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/tentree-pledges-to-plant-one-billion-trees.jpg"
                        alt="Image">
                </div>
                <h3 class="blog-heading">tentree Pledges to Plant One Billion Trees by 2030 in Support of 1t.org</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 4 -->
            <a title="more" href="../featured-pr/governors-biden-administration-push-to-quadruple-efficient-heating-ac-units-by-2030.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/governors-biden-administration-push.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Governors, Biden administration push to quadruple efficient heating, AC units by 2030</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 5 -->
            <a title="more" href="featured-pr/mechanical-sails-batteries-shippers-forming-green-corridors-to-fast-track-cleaner-technologies.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/mechanical-sails-batteries-shippers.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Mechanical sails? Batteries? Shippers forming ‘green corridors’ to fast-track cleaner technologies</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>


        </div>
<?php include '../footer.php'; ?>
    </section>

    <script defer src="../js/style.js" ></script>
</body>

</html>