<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Amazon, Google make dueling nuclear investments to power data centers with clean energy</title>
    <link rel="stylesheet" href="../css/style.css">
        <meta name="description"
        content="Amazon and Google are making competing nuclear energy investments to power their data centers, aiming for cleaner, more reliable long-term energy solutions">
    <meta property="og:title" content="Amazon, Google make dueling nuclear investments to power data centers with clean energy">
    <meta property="og:description"
        content="Amazon and Google are making competing nuclear energy investments to power their data centers, aiming for cleaner, more reliable long-term energy solutions">
    <meta name="keywords" content="Amazon">
    <meta property="og:url" content="https://www.policynow.org/amazon-google-make-dueling-nuclear-investments-to-power-data-centers-with-clean-energy">
    <meta property="og:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta property="og:site_name" content="">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_US">
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Amazon, Google make dueling nuclear investments to power data centers with clean energy">
    <meta name="twitter:description"
        content="Amazon and Google are making competing nuclear energy investments to power their data centers, aiming for cleaner, more reliable long-term energy solutions">
    <meta name="twitter:url" content="https://www.policynow.org/amazon-google-make-dueling-nuclear-investments-to-power-data-centers-with-clean-energy">
    <meta name="twitter:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta name="twitter:site" content="@policynow">
    <meta name="twitter:creator" content="@policynow">
    <link rel="icon" type="image/x-icon" href="https://www.policynow.org/image/favicon.png">
    <link rel="canonical" href="https://www.policynow.org/amazon-google-make-dueling-nuclear-investments-to-power-data-centers-with-clean-energy">
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "NewsArticle",
  "mainEntityOfPage": {
    "@id": "https://www.policynow.org/amazon-google-make-dueling-nuclear-investments-to-power-data-centers-with-clean-energy"
  },
  "headline": "Amazon, Google make dueling nuclear investments to power data centers with clean energy",
  "image": [
    "https://www.policynow.org/image/twitter-card.png"
  ],
  "datePublished": "2025-11-17T08:28:00-04:00",
  "dateModified": "2025-11-17T08:28:00-04:00",
  "description": "Amazon and Google are making competing nuclear energy investments to power their data centers, aiming for cleaner, more reliable long-term energy solutions",
  "author": {
    "@type": "Person",
    "name": "Editorial Board"
  },
  "publisher": {
    "@type": "Organization",
    "name": "policynow",
    "logo": {
      "@type": "ImageObject",
      "url": "https://www.policynow.org/image/policynow-logo.png"
    }
  },
  "keywords": ["Google", "nuclear energy", "data centers", "clean energy", "tech investments", "energy innovation", "sustainable power", "cloud computing", "renewable energy", "nuclear power deals", "technology companies", "energy transition", "carbon-free power", "data center energy"]

}
</script>
</head>

<body class="light-mode">
<?php include '../header.php'; ?>

    <div class="main-container">
        <div class="date-row">
            <div class="day">
                <strong><?php
echo date("l, F j, Y"); 
?></strong>
            </div>

            <div class="top-center">
                <a href="../main.php"><img src="../image/policynow-logo.png"
                    alt="Logo"></a>
            </div>
            <div class="top-right"> 
                <img src="../image/search.png" class="menu-toggle" alt="search" width="16" height="16">
                <div  class="search-box" id="searchBox">
                    <input type="text" placeholder="Type & hit enter">
                     <img  src="../image/search.png" class="menu-toggle1" alt="search" width="16" height="16">
                </div>
                <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                 <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
            </div>
        </div>
        <nav class="main-nav1">
            <a title="Politics & Policy" class="nav-H" href="../politics-and-policy.php">Politics & Policy</a>
            <a title="Business & Economy" class="nav-l" href="../business-and-economy.php">Business & Economy</a>
            <a title="Global Affairs" class="nav-l" href="../global-affairs.php">Global Affairs</a>
            <a title="Technology & Innovation" class="nav-l" href="../technology-and-innovation.php">Technology & Innovation</a>
            <a title="Finance & Markets" class="nav-l" href="../finance-and-markets.php">Finance & Markets</a>
            <a title="Featured PR" class="nav-l" href="../featured-pr.php">Featured PR</a>
            <a title="Author" class="nav-l" href="../author.php">Authors</a>
        </nav>

    </div>
      <div class="main">
          <section class="highlight-news">
            <div class="highlight-category">
                <a title="Featured PR" href="#">Featured PR</a>
            </div>
            <div class="live-sect">
                <span class="live-status">
                    <span class="dot"></span>

                </span>
                <p> <span class="live-badge">LIVE</span>
                    7 days ago</p>
            </div>
            <h1 class="highlight-title">Amazon, Google make dueling nuclear investments to power data centers with clean energy</h1>
<p class="content-para">Amazon on Wednesday said that it was investing in small nuclear reactors, coming just two days after a similar announcement by Google, as both tech giants seek new sources of carbon-free electricity to meet surging demand from data centers and artificial intelligence.</p>


            <div class="highlight-footer">
                <div class="author-blocks">
                    <div class="author-card">
                        <img src="../image/lisa-g-hart.jpg"
                            alt="Lisa G. Hart">
                        <div class="author-info">
                            <a title="Lisa G. Hart" href="author.php">Lisa G. Hart</a>
                            <span>NOVEMBER 07, 2025</span>
                        </div>
                    </div>
                    
                </div>

                <div class="share-block">
                    <span>Share this</span>
                    <div class="share-icons">
                        <a title="facebook" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                        </a>
                        <a title="twitter" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                        </a>

                        <a title="youtube" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
                        </a>
                    </div>
                    <div class="share-single">
                        <button>
                            <a title="more" href="#"><i class="fa-solid fa-share-nodes"></i></a>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <div class="img-section">
            <img src="../image/amazon-google-make-dueling-nuclear-investments.webp"
                alt="Amazon, Google make dueling nuclear investments">
        </div>

        <div class="second-sec">

       <p class="content-para">The plans come as the owner of the shuttered Three Mile Island nuclear power plant said last month it plans to restart the reactor so tech giant Microsoft can buy the power to supply its data centers. All three companies have been investing in solar and wind technologies, which make electricity without producing greenhouse gas emissions. Now they say they need to go further in the search for clean electricity to meet both demand and their own commitments to cut emissions.</p>

<p class="content-para">The International Energy Agency forecasts that data centers’ total electricity consumption could reach more than 1,000 terawatt hours in 2026, more than doubling from 2022. Estimates suggest one terawatt hour can power 70,000 homes for a year.</p>

<p class="content-para">Nuclear energy is a climate solution in that its reactors don’t emit the planet-warming greenhouse gases that come from power plants that burn fossil fuels, such as oil, coal and gas. The demand for power is surging globally as buildings and vehicles electrify. People used more electricity than ever last year, placing strain on electric grids around the world. Much of the demand also comes from data centers and artificial intelligence.</p>

<p class="content-para">“AI is driving a significant increase in the amount of data centers and power that are required on the grid,” Kevin Miller, Amazon Web Services’ vice president of global data centers, told The Associated Press, adding: “We view advanced new nuclear capacity as really key and essential.”</p>

<p class="content-para">Energy Secretary Jennifer Granholm said she’s thrilled Amazon is the latest to “BYOP” or “bring your own power” to the buildout of data centers. Granholm spoke at an event for Wednesday’s announcement at Amazon’s second headquarters in Virginia. Virginia’s governor and two U.S. senators also attended.</p>

<p class="content-para">The United States aims to reach 100% clean electricity by 2035. Granholm said small modular reactors are a “huge piece of how we’re going to solve this puzzle,” a way to phase out fossil fuel power while responding to the increasing electricity demand from data centers and new factories. She said her department will provide $900 million to deploy more of these reactors.</p>

<p class="content-para">Small modular reactors are a type of nuclear reactor that can generate up to roughly one-third the amount of power of a traditional reactor. Developers say small reactors will be built faster and at a lower cost than large power reactors, scaling to fit needs of a particular location. They aim to start spinning up electricity in the early 2030s, if the Nuclear Regulatory Commission gives permission to build and operate their designs and the technology succeeds.</p>

<p class="content-para">If new, clean power isn’t added as data centers are developed, the U.S. runs the risk of “browning the grid,” or including more power that isn’t made from clean sources, said Kathryn Huff, a former U.S. assistant secretary for nuclear energy who is now an associate professor at the University of Illinois Urbana-Champaign.</p>

<p class="content-para">The reactors are currently under development, with none currently providing power to the electric grid in the U.S. Big investors can help change that, and these announcements could be the “inflection point” that makes scaling up this technology truly possible, Huff said.</p>

<p class="content-para">Jacopo Buongiorno, professor of nuclear science and engineering at the Massachusetts Institute of Technology, echoed that, saying the industry needs customers who value the reliability and carbon-free attributes of nuclear and are willing to pay a premium for it at first, until a number of the next-generation reactors are deployed and the cost comes down.</p>

<p class="content-para">On Monday, Google said it was signing a contract to purchase nuclear energy from multiple small modular reactors that Kairos Power, a nuclear technology company, plans to develop.</p>

<p class="content-para">The news highlights “the technologies that we’re going to need to achieve round the clock clean energy, not only for Google but for the world,” Michael Terrell, Google’s senior director of energy and climate, told the AP.</p>

<p class="content-para">With Kairos, Google said it expects to bring the first small modular reactor online by 2030, with more to come through 2035. The deal is projected to bring 500 megawatts of power to the grid. For context, Google consumed more than 24 terawatt hours of electricity last year, according to the company’s annual environmental report. One terawatt is equal to 1,000,000 megawatts.</p>

<p class="content-para">Meanwhile, Amazon’s announcements Wednesday included working with utility Dominion Energy to explore putting a small modular reactor near its existing North Anna nuclear power station in Virginia. It’s investing in reactor developer X-energy for its early development work, and collaborating with regional utility Energy Northwest in central Washington to put four of the X-energy reactors there.</p>

<p class="content-para">Combined, the three announcements could account for more than 5,000 megawatts of power by the late 2030s with the possibility of more. All of that is still likely only a small fraction of the company’s total energy consumption, a figure that Amazon does not report publicly.</p>

<p class="content-para">New reactor designs pair well with industrial applications because they can be built on a small footprint and generate reliable power, with some able to provide high-temperature heat too, at the site, said Doug True, chief nuclear officer at the industry trade association, Nuclear Energy Institute.</p>

<p class="content-para">“It seems like a really good fit to support those facilities, and for a lot of different applications depending upon the amount of power that’s needed by the customer,” he said.</p>

<p class="content-para">Both Amazon and Google have committed to using renewable energy to address climate change. By 2030, Google has pledged to meet net-zero emissions, and run carbon-free energy every hour of every day on every grid where it operates. It says it has already matched 100% of its global electricity consumption with renewable energy purchases on an annual basis. However, the company has fallen short on decreasing its emissions.</p>

<p class="content-para">Amazon has said it would match all of its global electricity consumption with 100% renewable energy by 2030, and recently announced it met that goal early in 2023. Though the company has matched its consumption as far as purchases of an equivalent amount of renewable energy, that does not necessarily mean it is using that to power its operations.</p>

<p class="content-para">Amazon saw its electricity emissions drop 11%, but direct emissions — known as Scope 1 — increased 7%, according to its 2023 sustainability report. The company is also targeting net zero-carbon by 2040.</p>
        </div>
      </div>

    <!-- Blog Section -->
    <section class="latest-blog-wrapper">
        <h2 class="latest-blog-title">LATEST FROM BLOG</h2>

        <div class="latest-blog-grid">
            <!-- Blog Item 1 -->
            <a title="more" href="../featured-pr/ibm-commits-to-net-zero-greenhouse-gas-emissions-by-2030.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/ibm-commits-to-net-zero-greenhouse-gas.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">IBM Commits To Net Zero Greenhouse Gas Emissions By 2030</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 2 -->
            <a title="more" href="../featured-pr/microsoft-carbon-negative-by-2030-even-for-supply-chain.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/microsoft-pledges-to-become.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Microsoft: carbon-negative by 2030 even for supply chain</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 3 -->
            <a title="more" href="../featured-pr/tentree-pledges-to-plant-one-billion-trees-by-2030-in-support-of-1t-org.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/tentree-pledges-to-plant-one-billion-trees.jpg"
                        alt="Image">
                </div>
                <h3 class="blog-heading">tentree Pledges to Plant One Billion Trees by 2030 in Support of 1t.org</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 4 -->
            <a title="more" href="../featured-pr/general-mills-to-reduce-absolute-greenhouse-gas-emissions-by-30-percent-across-its-full-value-chain-over-next-decade.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/general-mills-to-reduce-absolute-greenhouse-gas-emissions.avif"
                        alt="Image">
                </div>
                <h3 class="blog-heading">General Mills to Reduce Absolute Greenhouse Gas Emissions by 30% Across its Full Value Chain Over Next Decade</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 5 -->
            <a title="more" href="featured-pr/mechanical-sails-batteries-shippers-forming-green-corridors-to-fast-track-cleaner-technologies.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/mechanical-sails-batteries-shippers.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Mechanical sails? Batteries? Shippers forming ‘green corridors’ to fast-track cleaner technologies</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>


        </div>
<?php include '../footer.php'; ?>
    </section>

    <script defer src="../js/style.js" ></script>
</body>

</html>