<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>IMF more upbeat about US growth than just months ago, but outlook is dimmer than last year</title>
    <link rel="stylesheet" href="../css/style.css">
        <meta name="description"
        content="The IMF has raised its U.S. growth forecast from earlier this year but says the outlook remains weaker than in 2024 amid global economic challenges">
    <meta property="og:title" content="IMF more upbeat about US growth than just months ago, but outlook is dimmer than last year">
    <meta property="og:description"
        content="The IMF has raised its U.S. growth forecast from earlier this year but says the outlook remains weaker than in 2024 amid global economic challenges">
    <meta name="keywords" content="IMF">
    <meta property="og:url" content="https://www.policynow.org/imf-more-upbeat-about-us-growth-than-just-months-ago-but-outlook-is-dimmer-than-last-year">
    <meta property="og:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta property="og:site_name" content="">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_US">
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="IMF more upbeat about US growth than just months ago, but outlook is dimmer than last year">
    <meta name="twitter:description"
        content="The IMF has raised its U.S. growth forecast from earlier this year but says the outlook remains weaker than in 2024 amid global economic challenges">
    <meta name="twitter:url" content="https://www.policynow.org/imf-more-upbeat-about-us-growth-than-just-months-ago-but-outlook-is-dimmer-than-last-year">
    <meta name="twitter:image" content="https://www.policynow.org/image/twitter-card.png">
    <meta name="twitter:site" content="@policynow">
    <meta name="twitter:creator" content="@policynow">
    <link rel="icon" type="image/x-icon" href="https://www.policynow.org/image/favicon.png">
    <link rel="canonical" href="https://www.policynow.org/imf-more-upbeat-about-us-growth-than-just-months-ago-but-outlook-is-dimmer-than-last-year">
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "NewsArticle",
  "mainEntityOfPage": {
    "@id": "https://www.policynow.org/imf-more-upbeat-about-us-growth-than-just-months-ago-but-outlook-is-dimmer-than-last-year"
  },
  "headline": "IMF more upbeat about US growth than just months ago, but outlook is dimmer than last year",
  "image": [
    "https://www.policynow.org/image/twitter-card.png"
  ],
  "datePublished": "2025-11-17T08:28:00-04:00",
  "dateModified": "2025-11-17T08:28:00-04:00",
  "description": "The IMF has raised its U.S. growth forecast from earlier this year but says the outlook remains weaker than in 2024 amid global economic challenges",
  "author": {
    "@type": "Person",
    "name": "Editorial Board"
  },
  "publisher": {
    "@type": "Organization",
    "name": "policynow",
    "logo": {
      "@type": "ImageObject",
      "url": "https://www.policynow.org/image/policynow-logo.png"
    }
  },
  "keywords": ["U.S. growth forecast", "economic outlook", "U.S. economy", "global economy", "growth projection", "economic slowdown", "IMF report", "GDP growth", "financial outlook", "economic forecast", "U.S. recovery", "economic trends", "international economy", "IMF update"]

}
</script>
</head>

<body class="light-mode">
<?php include '../header.php'; ?>

    <div class="main-container">
        <div class="date-row">
            <div class="day">
                <strong><?php
echo date("l, F j, Y"); 
?></strong>
            </div>

            <div class="top-center">
                <a href="../main.php"><img src="../image/policynow-logo.png"
                    alt="Logo"></a>
            </div>
            <div class="top-right"> 
                <img src="../image/search.png" class="menu-toggle" alt="search" width="16" height="16">
                <div  class="search-box" id="searchBox">
                    <input type="text" placeholder="Type & hit enter">
                     <img  src="../image/search.png" class="menu-toggle1" alt="search" width="16" height="16">
                </div>
                <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                 <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
            </div>
        </div>
        <nav class="main-nav1">
            <a title="Politics & Policy" class="nav-H" href="../politics-and-policy.php">Politics & Policy</a>
            <a title="Business & Economy" class="nav-l" href="../business-and-economy.php">Business & Economy</a>
            <a title="Global Affairs" class="nav-l" href="../global-affairs.php">Global Affairs</a>
            <a title="Technology & Innovation" class="nav-l" href="../technology-and-innovation.php">Technology & Innovation</a>
            <a title="Finance & Markets" class="nav-l" href="../finance-and-markets.php">Finance & Markets</a>
            <a title="Featured PR" class="nav-l" href="../featured-pr.php">Featured PR</a>
            <a title="Author" class="nav-l" href="../author.php">Authors</a>
        </nav>

    </div>
      <div class="main">
          <section class="highlight-news">
            <div class="highlight-category">
                <a title="Business & Economy" href="#">Business & Economy</a>
            </div>
            <div class="live-sect">
                <span class="live-status">
                    <span class="dot"></span>

                </span>
                <p> <span class="live-badge">LIVE</span>
                    7 days ago</p>
            </div>
            <h1 class="highlight-title">IMF more upbeat about US growth than just months ago, but outlook is dimmer than last year</h1>
<p class="content-para">The U.S. and global economies will grow a bit more this year than previously forecast as the Trump administration’s tariffs have so far proved less disruptive than expected, the International Monetary Fund said Tuesday, though the agency also said the extensive duties still pose risks.</p>


            <div class="highlight-footer">
                <div class="author-blocks">
                    <div class="author-card">
                        <img src="../image/maxine-t-warne.jpg"
                            alt="Maxine T. Warne">
                        <div class="author-info">
                            <a title="Maxine T. Warne" href="author.php">Maxine T. Warne</a>
                            <span>NOVEMBER 04, 2025</span>
                        </div>
                    </div>
                    
                </div>

                <div class="share-block">
                    <span>Share this</span>
                    <div class="share-icons">
                        <a title="facebook" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/facebook.png" alt="facebook" width="16" height="16">
                        </a>
                        <a title="twitter" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/twitter.png" alt="twitter" width="16" height="16">
                        </a>

                        <a title="youtube" href="#" class="social-icon">
                            <img class="menu-toggle" src="../image/youtube.png" alt="youtube" width="16" height="16">
                        </a>
                    </div>
                    <div class="share-single">
                        <button>
                            <a title="more" href="#"><i class="fa-solid fa-share-nodes"></i></a>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <div class="img-section">
            <img src="../image/imf-more-upbeat-about-us-growth.webp"
                alt="US and global economic outlook">
        </div>


        <div class="second-sec">

        <p class="content-para">The IMF said that the global economy will grow just 2.8% this year, down from its forecast in January of 3.3%, according to its latest World Economic Outlook. And in 2026, global growth will be 3%, the fund predicts, also below its previous 3.3% estimate.</p>

        <p class="content-para">And the Fund sees the world’s two largest economies, China and the United States, weakening: U.S. economic growth will come in at just 1.8% this year, down sharply from its previous forecast of 2.7% and a full percentage point below its 2024 expansion. The IMF doesn’t expect a U.S. recession, though it has raised its odds of one this year from 25% to about 40%.</p>

        <p class="content-para">China is now projected to expand 4% this year and next, down roughly half a point from its previous forecasts.</p>

        <p class="content-para">“We are entering a new era,” Pierre-Olivier Gourinchas, chief economist at the IMF, said. “This global economic system that has operated for the last eighty years is being reset.”</p>

        <p class="content-para">The forecasts underscore the widespread impact of both the tariffs and the uncertainty they have created. Every country in the world is affected, the IMF said, by hikes in US import taxes that have now lifted average U.S. duties to about 25%, the highest in a century.</p>

        <p class="content-para">The forecasts are largely in line with many private-sector economists’ expectations, though some do fear a recession is increasingly likely. Economists at JPMorgan say the chances of a U.S. recession are now 60%. The Federal Reserve has also forecast that growth will weaken this year, to 1.7%.</p>

        <p class="content-para">The IMF is a 191-nation lending organization that works to promote economic growth and financial stability and to reduce global poverty.</p>

        <p class="content-para">Gourinchas said that the heightened uncertainty around the import taxes led the IMF to take the unusual step of preparing several different scenarios for future growth. Its forecasts were finalized April 4, after the Trump administration announced sweeping tariffs on nearly 60 countries along with nearly-universal 10% duties.</p>

        <p class="content-para">Those duties were paused April 9 for 90 days. Gourinchas said the pause didn’t substantially change the IMF’s forecasts because the U.S. and China have imposed such steep tariffs on each other since then.</p>

        <p class="content-para">The Trump administration has slapped duties on cars, steel, and aluminum, as well as 25% import taxes on most goods from Canada and Mexico. The White House has also imposed 10% tariffs on nearly all imports, and a huge 145% duty on goods from China, though smartphone and computers have been exempted. China has retaliated with 125% duties on US goods.</p>

        <p class="content-para">The uncertainty surrounding the Trump administration’s next moves will also likely weigh heavily on the U.S. and global economies, the IMF said. Most traded goods are parts that feed into finished products, and the tariffs could disrupt supply chains, similar to what occurred during the pandemic, Gourinchas warned in a blog post.</p>

        <p class="content-para">“Companies facing uncertain market access will likely pause in the near term, reduce investment and cut spending,” he wrote.</p>

        <p class="content-para">The U.S. tariffs are also expected to hit less-developed nations, with Mexico’s economy now expected to shrink this year by 0.3%, down from a previous projection of 1.4% growth. South Africa is forecast to grow just 1% this year, down from a 1.5% projection in January.</p>

        <p class="content-para">While the U.S. economy will likely suffer a supply shock, Gourinchas said, China is expected to experience reduced demand as U.S. purchases of its exports fall.</p>

        <p class="content-para">Inflation will likely worsen in the United States, rising to about 3% by the end of this year, while it will be little changed in China, the IMF forecast.</p>

        <p class="content-para">In his blog post, Gourinchas acknowleged that there is an “acute perception that globalization unfairly displaced many domestic manufacturing jobs” and added that “there is some merit to these grievances.”</p>

        <p class="content-para">But he added that the “deeper force behind this decline is technological progress and automation, not globalization.” Gourinchas noted that both Germany, which has a goods trade surplus, and the U.S., which has a deficit, have seen factory output remain relatively level in recent decades even as automation has caused manufacturing employment to decline.</p>

        <p class="content-para">The IMF expects the tariffs to take a big chunk out of China’s economy, but it also forecasts that additional spending by the Chinese government will offset much of the hit.</p>

        <p class="content-para">The European Union is forecast to grow more slowly, but the hit from tariffs is not as large, in part because it is facing lower U.S. duties than China. In addition, some of the hit from tariffs will be offset by stronger government spending by Germany.</p>

        <p class="content-para">The economies of the 27 countries that use the euro are forecast to expand 0.8% this year and 1.2% next year, down just 0.2% in both years from the IMF’s January forecast.</p>

        <p class="content-para">Japan’s growth forecast has been marked down to 0.6% this year and next, 0.5% and 0.2% lower than in January, respectively.</p>

        <p class="content-para">In a separate report Tuesday, the IMF warned that “global financial stability risks have increased significantly,’’ along with the deteriorating economic outlook. The fund noted that some stock and bond prices remained high despite the recent market rout triggered by Trump’s tariffs – which means they are vulnerable to further drops.</p>

        <p class="content-para">The IMF also cautioned that “some financial institutions could come under strain in volatile markets,’’ pointing in particular to heavily indebted hedge funds and asset management companies and the risk that they will be forced to raise cash by selling investments into an already-fragile market.</p>
        </div>
      </div>

    <!-- Blog Section -->
    <section class="latest-blog-wrapper">
        <h2 class="latest-blog-title">LATEST FROM BLOG</h2>

 <div class="latest-blog-grid">
            <!-- Blog Item 1 -->
            <a title="more" href="../business-and-economy/federal-reserve-likely-to-cut-key-rate-wednesday-and-may-signal-another-cut-to-follow.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/federal-reserve-likely-to-cut-key-rate.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Federal Reserve likely to cut key rate Wednesday and may signal another cut to follow</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 2 -->
            <a title="more" href="../business-and-economy/us-and-global-economic-outlook-deteriorates-in-trump-trade-war-imf-says.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/us-and-global-economic-outlook.jpg"
                        alt="Image">
                </div>
                <h3 class="blog-heading">US and global economic outlook deteriorates in Trump trade war, IMF says</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 3 -->
            <a title="more" href="../business-and-economy/powell-signals-federal-reserve-to-move-slowly-on-interest-rate-cuts.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/powell-signals-federal-reserve.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Powell signals Federal Reserve to move slowly on interest rate cuts</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 4 -->
            <a title="more" href="../business-and-economy/the-fed-faces-economic-uncertainty-and-political-pressure-as-it-decides-whether-to-cut-rates.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/the-fed-faces-economic-uncertainty-and-political-pressure.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">The Fed faces economic uncertainty and political pressure as it decides whether to cut rates</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>

            <!-- Blog Item 5 -->
            <a title="more" href="../business-and-economy/most-us-stocks-rise-after-swinging-through-another-erratic-day.php" class="blog-card">
                <div class="blog-thumb">
                    <img src="../image/most-us-stocks-rise.webp"
                        alt="Image">
                </div>
                <h3 class="blog-heading">Most US stocks rise after swinging through another erratic day</h3>
                <p class="blog-author">NOVEMBER 15,2025</p>
            </a>


        </div>
<?php include '../footer.php'; ?>
    </section>

    <script defer src="../js/style.js" ></script>
</body>

</html>