document.addEventListener('DOMContentLoaded', () => {
    const sidebar = document.querySelector('.sidebar');
    const closeBtn = document.querySelector('.close-btn');
    const overlay = document.querySelector('.sidebar-overlay');
    const menuIcons = document.querySelectorAll('.menu-icon');

    const openSidebar = () => {
        sidebar.classList.add('active');
        closeBtn.style.opacity = '1';
        closeBtn.style.visibility = 'visible';
        overlay.style.opacity = '1';
        overlay.style.visibility = 'visible';
    };

    const closeSidebar = () => {
        sidebar.classList.remove('active');
        closeBtn.style.opacity = '0';
        closeBtn.style.visibility = 'hidden';
        overlay.style.opacity = '0';
        overlay.style.visibility = 'hidden';
    };

    // Attach click to all menu icons (normal + sticky)
    menuIcons.forEach(menu => {
        menu.addEventListener('click', (e) => {
            e.stopPropagation(); // prevent document click from closing
            openSidebar();
        });
    });

    // Close sidebar with close button or overlay click
    closeBtn.addEventListener('click', closeSidebar);
    overlay.addEventListener('click', closeSidebar);

    // Close sidebar when clicking outside
    document.addEventListener('click', (e) => {
        if (!sidebar.contains(e.target) && ![...menuIcons].some(icon => icon.contains(e.target)) && e.target !== closeBtn) {
            closeSidebar();
        }
    });

    // Search overlay
    const searchIcons = document.querySelectorAll('.search-icon');
    const searchOverlay = document.querySelector('.search-overlay');
    const searchInput = searchOverlay.querySelector('.search-input');

    searchIcons.forEach(searchBtn => {
        searchBtn.addEventListener('click', () => {
            searchOverlay.classList.add('active');
            searchInput.focus();
        });
    });

    // Close search overlay when clicking outside search box
    searchOverlay.addEventListener('click', (e) => {
        if (!e.target.closest('.search-box')) {
            searchOverlay.classList.remove('active');
        }
    });

    // Close search overlay on ESC key
    document.addEventListener('keydown', (e) => {
        if (e.key === 'Escape') {
            searchOverlay.classList.remove('active');
        }
    });

    // Sticky category header
    const categorySection = document.querySelector('.category-section');
    const stickyCategory = document.querySelector('.category-section-b');

    window.addEventListener('scroll', () => {
        const scrollY = window.scrollY;
        if (scrollY > categorySection.offsetTop + categorySection.offsetHeight) {
            stickyCategory.classList.add('show');
        } else {
            stickyCategory.classList.remove('show');
        }
    });
});



document.querySelectorAll('.share-buttons a').forEach(link => {
  link.addEventListener('click', e => {
    e.preventDefault();

    const platform = link.getAttribute('data-platform');
    const pageUrl = encodeURIComponent(window.location.href);
    const pageTitle = encodeURIComponent(document.title);

    let shareUrl = '';

    switch (platform) {
      case 'facebook':
        shareUrl = `https://www.facebook.com/sharer/sharer.php?u=${pageUrl}`;
        break;
      case 'twitter':
        shareUrl = `https://twitter.com/intent/tweet?url=${pageUrl}&text=${pageTitle}`;
        break;
      case 'linkedin':
        shareUrl = `https://www.linkedin.com/shareArticle?mini=true&url=${pageUrl}&title=${pageTitle}`;
        break;
      case 'pinterest':
        shareUrl = `https://pinterest.com/pin/create/button/?url=${pageUrl}&description=${pageTitle}`;
        break;
    }

    // Open the share window
    if (shareUrl) {
      window.open(shareUrl, '_blank', 'width=600,height=500');
    }
  });
});
