// ========== MOBILE MENU TOGGLE ==========
const toggle = document.querySelector('.menu-toggle');
const navLinks = document.querySelector('.nav-links');
const closeBtn = document.querySelector('.menu-close');

if (toggle && navLinks) {
  toggle.addEventListener('click', () => {
    navLinks.classList.toggle('active');
  });
}

if (closeBtn && navLinks) {
  closeBtn.addEventListener('click', () => {
    navLinks.classList.remove('active');
  });
}

// ========== FEATURED NEWS ROTATION ==========
(function() {
  // Try multiple selectors to find the correct news items
  const newsContainer = document.querySelector('.news-container');
  if (!newsContainer) return;
  
  const newsItems = newsContainer.querySelectorAll('.news-item');
  const featuredImg = document.getElementById('featured-img');
  const featuredCategory = document.getElementById('featured-category');
  const featuredTitle = document.getElementById('featured-title');
  const featuredText = document.getElementById('featured-text');

  if (!newsItems.length || !featuredImg) {
    console.log('Featured news elements not found');
    return;
  }

  let currentIndex = 0;
  const rotationInterval = 5000; // Change story every 5 seconds
  let featuredRotationTimer;

  function updateFeatured(item) {
    // Remove active class
    newsItems.forEach(i => i.classList.remove('active'));
    item.classList.add('active');

    // Update featured content with fade
    featuredImg.style.opacity = 0;
    setTimeout(() => {
      featuredImg.src = item.dataset.img;
      featuredCategory.textContent = item.dataset.category;
      featuredTitle.textContent = item.dataset.title;
      featuredText.textContent = item.dataset.text;
      featuredImg.style.opacity = 1;
    }, 250);
  }

  // Click event
  newsItems.forEach((item, index) => {
    item.addEventListener('click', () => {
      currentIndex = index; // Update current index for auto-rotation
      updateFeatured(item);
      // Reset auto-rotation timer when user manually clicks
      clearInterval(featuredRotationTimer);
      startFeaturedRotation();
    });
  });

  // Auto-rotation
  function startFeaturedRotation() {
    featuredRotationTimer = setInterval(() => {
      currentIndex = (currentIndex + 1) % newsItems.length;
      updateFeatured(newsItems[currentIndex]);
    }, rotationInterval);
  }

  // Initialize first story
  updateFeatured(newsItems[0]);
  startFeaturedRotation();
})();

// ========== BREAKING NEWS SLIDER ==========
(function() {
  const breakingBar = document.getElementById('breakingBar');
  if (!breakingBar) return;

  const breakingItems = breakingBar.querySelectorAll('.news-item');
  const prevBtn = breakingBar.querySelector('.prev');
  const nextBtn = breakingBar.querySelector('.next');

  if (!breakingItems.length || !prevBtn || !nextBtn) return;

  let breakingIndex = 0;
  let isAnimating = false;
  let autoRotateInterval;

  function showBreakingItem(nextIndex) {
    if (isAnimating || nextIndex === breakingIndex) return;
    isAnimating = true;

    const currentItem = breakingItems[breakingIndex];
    const nextItem = breakingItems[nextIndex];

    // Start exit animation for current item
    currentItem.classList.add('exit');

    // Small delay before showing next item
    setTimeout(() => {
      currentItem.classList.remove('active');
      nextItem.classList.add('active');
      
      // Clean up after animation
      setTimeout(() => {
        currentItem.classList.remove('exit');
        breakingIndex = nextIndex;
        isAnimating = false;
      }, 500);
    }, 50);
  }

  nextBtn.addEventListener('click', () => {
    const next = (breakingIndex + 1) % breakingItems.length;
    showBreakingItem(next);
    resetAutoRotate();
  });

  prevBtn.addEventListener('click', () => {
    const prev = (breakingIndex - 1 + breakingItems.length) % breakingItems.length;
    showBreakingItem(prev);
    resetAutoRotate();
  });

  // Auto-rotate with reset capability
  function startAutoRotate() {
    autoRotateInterval = setInterval(() => {
      const next = (breakingIndex + 1) % breakingItems.length;
      showBreakingItem(next);
    }, 6000);
  }

  function resetAutoRotate() {
    clearInterval(autoRotateInterval);
    startAutoRotate();
  }

  // Initialize
  startAutoRotate();
})();

// ========== SEARCH BAR TOGGLE ==========
(function() {
  const searchIcon = document.querySelector('.fj-search-icon');
  const searchBar = document.querySelector('.fj-search-bar');

  if (searchIcon && searchBar) {
    searchIcon.addEventListener('click', () => {
      searchBar.classList.toggle('active');
    });
  }
})();

// ========== SCROLL TO TOP BUTTON ==========
(function() {
  const scrollTopBtn = document.getElementById("scrollTopBtn");
  
  if (!scrollTopBtn) return;

  // Show button after scrolling 70vh
  window.addEventListener("scroll", () => {
    if (window.scrollY > window.innerHeight * 0.7) {
      scrollTopBtn.classList.add("show");
    } else {
      scrollTopBtn.classList.remove("show");
    }
  });

  // Smooth scroll to top when clicked
  scrollTopBtn.addEventListener("click", () => {
    window.scrollTo({
      top: 0,
      behavior: "smooth"
    });
  });
})();