<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
<meta name="robots" content="index, follow, max-image-preview:large">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1">

<title>Author: Noah Grayson – U.S. Daily News Reporter</title>
<meta name="title" content="Author: Noah Grayson – U.S. Daily News Reporter">
<meta name="author" content="Noah Grayson">
<meta name="description"
      content="Discover daily news reports by Noah Grayson, covering breaking events, national updates, public safety alerts, and fast-moving U.S. headline stories.">

<link rel="canonical" href="https://prprimespot.com/author/noah-grayson/">

<meta property="og:title" content="Author: Noah Grayson – U.S. Daily News Reporter">
<meta property="og:description"
      content="Discover daily news reports by Noah Grayson, covering breaking events, national updates, public safety alerts, and fast-moving U.S. headline stories.">
<meta property="og:url" content="https://prprimespot.com/author/noah-grayson/">
<meta property="og:image" content="https://prprimespot.com/uploads/noah-grayson.webp">
<meta property="og:site_name" content="PR Primespot">
<meta property="og:image:width" content="1200">
<meta property="og:image:height" content="630">
<meta property="og:type" content="profile">
<meta property="og:locale" content="en_US">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Author: Noah Grayson – U.S. Daily News Reporter">
<meta name="twitter:description"
      content="Discover daily news reports by Noah Grayson, covering breaking events, national updates, public safety alerts, and fast-moving U.S. headline stories.">
<meta name="twitter:url" content="https://prprimespot.com/author/noah-grayson/">
<meta name="twitter:image" content="https://prprimespot.com/uploads/noah-grayson.webp">
<meta name="twitter:site" content="@prprimespot">
<meta name="twitter:creator" content="@prprimespot">

<link rel="shortcut icon" href="https://prprimespot.com/assets/img/fav-icon.webp" sizes="16x16">

    <!-- css -->
    <link rel="stylesheet" href="../style.css">
    <link rel="stylesheet" href="../responsive.css">
    <link rel="stylesheet" href="../cateagory.css">
    <link rel="stylesheet" href="../author.css">








<!-- Organization Schema -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "NewsMediaOrganization",
  "@id": "https://prprimespot.com/#organization",
  "name": "PR Primespot",
  "alternateName": "The Reporter",
  "url": "https://prprimespot.com/",
  "logo": {
    "@type": "ImageObject",
    "url": "https://prprimespot.com/assets/img/fav-icon.webp",
    "width": 512,
    "height": 512
  },
  "sameAs": [
    "https://www.facebook.com/prprimespot",
    "https://www.pinterest.com",
    "https://www.instagram.com"
  ]
}
</script>

<!-- Website Schema -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "WebSite",
  "@id": "https://prprimespot.com/#website",
  "url": "https://prprimespot.com/",
  "name": "prprimespot – U.S. News, Politics, Business & Daily Updates",
  "publisher": { "@id": "https://prprimespot.com/#organization" },
  "potentialAction": {
    "@type": "SearchAction",
    "target": "https://prprimespot.com/search.php?query={search_term_string}",
    "query-input": "required name=search_term_string"
  }
}
</script>

<!-- Author WebPage Schema -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "WebPage",
  "@id": "https://prprimespot.com/author/noah-grayson/#webpage",
  "url": "https://prprimespot.com/author/noah-grayson/",
  "name": "Author: Noah Grayson – U.S. Daily News Reporter",
  "description": "Discover daily news reports by Noah Grayson, covering breaking events, national updates, public safety alerts, and fast-moving U.S. headline stories.",
  "isPartOf": { "@id": "https://prprimespot.com/#website" },
  "inLanguage": "en-US",
  "primaryImageOfPage": {
    "@type": "ImageObject",
    "url": "https://prprimespot.com/uploads/noah-grayson.webp",
    "width": 600,
    "height": 600
  },
  "about": { "@id": "https://prprimespot.com/author/noah-grayson/#person" }
}
</script>

<!-- Person (Author) Schema -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Person",
  "@id": "https://prprimespot.com/author/noah-grayson/#person",
  "name": "Noah Grayson",
  "image": "https://prprimespot.com/uploads/noah-grayson.webp",
  "url": "https://prprimespot.com/author/noah-grayson/",
  "jobTitle": "U.S. Daily News Reporter",
  "description": "Noah Grayson reports breaking U.S. news, national developments, and fast-moving headline stories with reliable updates on public safety and major events.",
  "worksFor": { "@id": "https://prprimespot.com/#organization" },
  "sameAs": [
    "https://www.facebook.com",
    "https://www.pinterest.com",
    "https://www.instagram.com"
  ]
}
</script>

<!-- Featured Article Schema -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "NewsArticle",
  "@id": "https://prprimespot.com/Dailynews/Longest-us-government-shutdown-ends/#article",
  "headline": "Longest U.S. Government Shutdown Ends After 43 Days",
  "description": "The longest U.S. government shutdown in history ends after 43 days as President Trump signs a funding bill, restoring federal operations and lifting market uncertainty.",
  "image": "https://prprimespot.com/uploads/longest-us-government-shutdown-ends-after-43-days.webp",
  "author": { "@id": "https://prprimespot.com/author/noah-grayson/#person" },
  "publisher": { "@id": "https://prprimespot.com/#organization" },
  "articleSection": "Daily News",
  "datePublished": "2025-11-13",
  "dateModified": "2025-11-13",
  "mainEntityOfPage": {
    "@type": "WebPage",
    "@id": "https://prprimespot.com/Dailynews/Longest-us-government-shutdown-ends.php"
  }
}
</script>














</head>

<body>
    <!-- top-section -->
    <div class="top-section">
        <div class="top-grid-section">
            <p class="top-text b"><a href="#"><img src="../images/telegram.webp" class="top-icon" alt="icon" height="15"
                        width="15">Sign Up for
                    Our
                    Newsletter</a></p>
            <p class="top-text"><span>New York 65 F</span><img src="../images/cloud.webp" class="top-icon"
                        height="15" width="15" alt="icon">overcast clouds</p>
        </div>
    </div>





    <!-- navbar -->
    <?php include '../header.php'; ?>






    <!-- Search Popup Overlay -->
    <div class="search-overlay">
        <button class="close-search">&times;</button>
        <div class="search-popup-box">
            <input type="text" class="search-input" placeholder="Search...">
        </div>
    </div>


    <!-- flash-news section -->
    <div class="news-scroll">
        <div class="news-scroll-container">
            <div class="news-scroll-container-left">
                <p class="flash-news"><img src="../images/bolt.webp" class="flash" alt="icon" height="15" width="15">
                    Newsflash:</p>
                <div class="news-box">
                    <div class="news-box-inner">
                        <p class="news"><a href="#">Julio Rodríguez Can Fly. Will His Bat Ground Him? <span>10:11
                                    am</span></a></p>
                        <p class="news"><a href="#">Julio Rodríguez Can Fly. Will His Bat Ground Him? <span>10:11
                                    am</span></a></p>
                        <p class="news"><a href="#">Tropical Storm Forecasts Show Possible Landfall <span>10:13
                                    am</span></a></p>
                        <p class="news"><a href="#">SpaceX Prepares for next-icon Starship Launch <span>10:14
                                    am</span></a>
                        </p>
                        <p class="news"><a href="#">Julio Rodríguez Can Fly. Will His Bat Ground Him? <span>10:11
                                    am</span></a></p>
                        <p class="news"><a href="#">Tropical Storm Forecasts Show Possible Landfall <span>10:13
                                    am</span></a></p>
                        <p class="news"><a href="#">SpaceX Prepares for next-icon Starship Launch <span>10:14
                                    am</span></a>
                        </p>
                        <p class="news"><a href="#">Julio Rodríguez Can Fly. Will His Bat Ground Him? <span>10:11
                                    am</span></a></p>
                        <p class="news"><a href="#">Julio Rodríguez Can Fly. Will His Bat Ground Him? <span>10:11
                                    am</span></a></p>
                        <p class="news"><a href="#">Tropical Storm Forecasts Show Possible Landfall <span>10:13
                                    am</span></a></p>
                        <p class="news"><a href="#">SpaceX Prepares for next-icon Starship Launch <span>10:14
                                    am</span></a>
                        </p>
                        <p class="news"><a href="#">Julio Rodríguez Can Fly. Will His Bat Ground Him? <span>10:11
                                    am</span></a></p>
                        <p class="news"><a href="#">Tropical Storm Forecasts Show Possible Landfall <span>10:13
                                    am</span></a></p>
                        <p class="news"><a href="#">SpaceX Prepares for next-icon Starship Launch <span>10:14
                                    am</span></a>
                        </p>
                    </div>
                </div>
            </div>
            <div class="news-scroll-container-right">
                <div class="arrow prev" role="button">
                    <svg class="arrow-icon rotate-left" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                        fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                        stroke-linejoin="round">
                        <polyline points="9 18 15 12 9 6"></polyline>
                    </svg>
                </div>
                <div class="arrow next" role="button">
                    <svg class="arrow-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                        stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <polyline points="9 18 15 12 9 6"></polyline>
                    </svg>
                </div>

            </div>
        </div>
    </div>


    <!-- Scroll to top button -->
    <div class="scroll-to-top">
        <a href="#" class="top-arrow">
            <img src="./images/top.webp" alt="icon" width="20" height="20">
        </a>
    </div>


    <!-- Slide-in Sidebar -->
    <div class="sidebar-overlay">
        <div class="sidebar-content">
            <span class="close-btn">&times;</span>
            <ul class="sidebar-menu">
                <li><a href="./index.html">Home</a></li>
                <li class="has-submenu">
                    <a href="#" class="submenu-toggle">Categories <span class="arrow-d">&#9662;</span></a>
                    <ul class="submenu">
                        <li><a href="#">Technology</a></li>
                        <li><a href="#">Health</a></li>
                        <li><a href="#">Lifestyle</a></li>
                    </ul>
                </li>

                <li><a href="./cateagory.html">Business</a></li>
                <li><a href="#">Breaking News</a></li>
                <li><a href="#">Opinion</a></li>
                <li><a href="#">Podcast</a></li>
                <li><a href="#">Video</a></li>
                <li><a href="#">For Subscribers</a></li>
                <li class="sidebar-more"><a href="#">More</a></li>
                <!-- ✅ Demos with dropdown -->
                <li class="has-submenu second-slide-option">
                    <a href="#" class="submenu-toggle">Demos <span class="arrow-d">&#9662;</span></a>
                    <ul class="submenu">
                        <li><a href="#">Home Main</a></li>
                        <li><a href="#">Home Politics</a></li>
                        <li><a href="#">Home Bussiness</a></li>
                        <li><a href="#">Home Culture</a></li>
                        <li><a href="#">Home Sports</a></li>
                        <li><a href="#">Home Tech-Sceince</a></li>
                        <li><a href="#">Home Military</a></li>
                    </ul>
                </li>

                <!-- ✅ Blog Page with dropdown -->
                <li class="has-submenu second-slide-option">
                    <a href="#" class="submenu-toggle">Blog Page <span class="arrow-d">&#9662;</span></a>
                    <ul class="submenu">
                        <li><a href="#">Blog Page 1</a></li>
                        <li><a href="#">Blog Page 2</a></li>
                        <li><a href="#">Blog Page 3</a></li>
                    </ul>
                </li>
                <li class="second-slide-option"><a href="#">Subscribe</a></li>
                <li class="second-slide-option"><a href="#">Shop</a></li>


                <li class="sidebar-more">social media</li>
                <li>
                    <div class="side-social-media">
                        <img src="./images/twitter-icon.webp" class="side-bar-social-media-icon" alt="icon" width="20"
                            height="20">
                        <img src="./images/facebook-icon.webp" class="side-bar-social-media-icon" alt="icon" width="20"
                            height="20">
                        <img src="./images/instagram-icon.webp" class="side-bar-social-media-icon" alt="icon" width="20"
                            height="20">
                    </div>
                </li>


            </ul>
        </div>
    </div>

    <!-- cateagory-body -->
    <div class="cateagory-body">
        <div class="cateagory-top">
            <p class="main-head">Author: Noah Grayson</p>
            <!-- <p class="path">Home <span>> Business</span></p> -->
        </div>
        <hr class="custom-line b">

        <div class="cateagory-body-section">
            <div class="cateagory-body-section-l">
                <div class="author-box">
                    <div class="author-image">
                        <img src="../uploads/noah-grayson.webp" alt="Noah Grayson">
                    </div>

                    <div class="author-details">
                        <h2>Noah Grayson</h2>
                        <p>
                            Noah Grayson writes for a daily news website in the U.S. that covers breaking news,
                             national events, and other items that people are interested in. She rapidly and
                              reliably reports on the most critical U.S. news events, updates on public safety,
                               and national topics that are changing quickly. Most of her reporting is on how 
                               things influence the neighborhood, new social trends, and the news topics that 
                               are making headlines in the US.
                        </p>

                        <div class="author-social">
                            <a href="https://www.facebook.com"><i class="fa-brands fa-facebook-f"></i></a>
                            <a href="https://www.pinterest.com"><i class="fa-brands fa-pinterest-p"></i></a>
                            <a href="https://www.instagram.com"><i class="fa-brands fa-instagram"></i></a>
                        </div>
                    </div>
                </div>


                
                <hr class="custom-line b">
                <div class="third-grid-section b">
                    <div class="third-grid-section-img">
                        <a href="#"><img src="../uploads/longest-us-government-shutdown-ends-after-43-days.webp" class="main-img b" alt="Longest U.S Government Shutdown Ends After 43 Days"
                                width="457" height="293"></a>
                    </div>
                    <div class="third-grid-section-content">
                        <p class="main-head b"><a href="../Dailynews/Longest-us-government-shutdown-ends.php">Longest U.S. Government Shutdown Ends After 43 Days</a></p>
                        <p class="paragraph-cateagory">The longest U.S. government shutdown in history ends after 43 days
                             as President Trump signs a funding bill, restoring federal operations and lifting market
                              uncertainty.</p>
                        <div class="img-option b">
                            <p class="time"><img src="../images/clock.webp" class="clock" alt="icon" width="15"
                                    height="15">Nov 13</p>
                            <p class="by"><span>by</span> Noah Grayson</p>
                        </div>
                    </div>
                </div>

                
                 


            </div>
            <div class="vertical-line"></div>
            <div class="cateagory-body-section-s">
                <div class="newsletter-box">
                    <img src="../images/letter.svg" class="newsletter-icon" alt="news-img" width="46" height="50">
                    <h3 class="newsletter-title">The Reporter<br>Newsletter</h3>
                    <p class="newsletter-subtext">Expert picks and exclusive deals,<br>in your inbox.</p>

                    <input type="email" placeholder="Enter your email*" class="newsletter-input">
                    <button class="newsletter-button">Sign Up</button>
                </div>
            </div>
        </div>
    </div>


        <!--     footer -->
    <?php include '../footer.php'; ?>




    <script src="./script.js" Defer></script>

</body>

</html>