<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
<meta name="robots" content="index, follow, max-image-preview:large">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1">

<title>Author: Morgan Blake – U.S. Investigative Journalist</title>
<!-- <meta name="title" content="Author: Morgan Blake – U.S. Investigative Journalist"> -->
<meta name="author" content="Morgan Blake">
<meta name="description"
      content="Read Morgan Blake’s investigative reporting on government accountability, corporate misconduct, public-interest cases, and federal oversight in the U.S.">

<link rel="canonical" href="https://prprimespot.com/author/morgan-blake/">

<meta property="og:title" content="Author: Morgan Blake – U.S. Investigative Journalist">
<meta property="og:description"
      content="Read Morgan Blake’s investigative reporting on government accountability, corporate misconduct, public-interest cases, and federal oversight in the U.S.">
<meta property="og:url" content="https://prprimespot.com/author/morgan-blake/">
<meta property="og:image" content="https://prprimespot.com/uploads/morgan-blake.webp">
<meta property="og:site_name" content="PR Primespot">
<meta property="og:image:width" content="1200">
<meta property="og:image:height" content="630">
<meta property="og:type" content="profile">
<meta property="profile:username" content="MorganBlake">
<meta property="og:locale" content="en_US">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Author: Morgan Blake – U.S. Investigative Journalist">
<meta name="twitter:description"
      content="Read Morgan Blake’s investigative reporting on government accountability, corporate misconduct, public-interest cases, and federal oversight in the U.S.">
<meta name="twitter:url" content="https://prprimespot.com/author/morgan-blake/">
<meta name="twitter:image" content="https://prprimespot.com/uploads/morgan-blake.webp">
<meta name="twitter:site" content="@prprimespot">
<meta name="twitter:creator" content="@prprimespot">

<link rel="shortcut icon" href="https://prprimespot.com/assets/img/fav-icon.webp" sizes="16x16">

    <!-- css -->
    <link rel="stylesheet" href="../style.css">
    <link rel="stylesheet" href="../responsive.css">
    <link rel="stylesheet" href="../cateagory.css">
    <link rel="stylesheet" href="../author.css">







<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebPage",
      "@id": "https://prprimespot.com/author/morgan-blake/#webpage",
      "name": "Author: Morgan Blake – U.S. Investigative Journalist",
      "url": "https://prprimespot.com/author/morgan-blake/",
      "description": "Read Morgan Blake’s investigative reporting on government accountability, corporate misconduct, public-interest cases, and federal oversight in the U.S.",
      "mainEntity": {
        "@id": "https://prprimespot.com/author/morgan-blake/#person"
      },
      "publisher": {
  "@type": "Organization",
  "name": "PR Primespot",
  "url": "https://prprimespot.com",

  "logo": {
    "@type": "ImageObject",
    "url": "https://prprimespot.com/assets/img/fav-icon.webp"
  }
}

    },

    {
      "@type": "Person",
      "@id": "https://prprimespot.com/author/morgan-blake/#person",
      "name": "Morgan Blake",
      "image": "https://prprimespot.com/uploads/morgan-blake.webp",
      "jobTitle": "U.S. Investigative Journalist",
      "description": "Morgan Blake investigates government accountability, corporate misconduct, taxpayer waste, and federal oversight failures to uncover risks affecting the American public.",
      "url": "https://prprimespot.com/author/morgan-blake/",
      "worksFor": {
  "@type": "Organization",
  "name": "PR Primespot",
  "url": "https://prprimespot.com"
},
 "sameAs": [
    "https://www.facebook.com/Morganblake",
    "https://www.pinterest.com/Morganblake",
    "https://www.instagram.com/Morganblake"
  ],
"knowsAbout": [
  "Investigative Journalism",
  "Government Accountability",
  "Corporate Misconduct",
  "Federal Oversight",
  "Public Interest Reporting"
]

       
      
    },

    {
      "@type": "BreadcrumbList",
      "@id": "https://prprimespot.com/author/morgan-blake/#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://prprimespot.com/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Author: Morgan Blake",
          "item": "https://prprimespot.com/author/morgan-blake/"
        }
      ]
    },

    {
      "@type": "ItemList",
      "@id": "https://prprimespot.com/author/morgan-blake/#articles",
      "name": "Articles by Morgan Blake",
      "itemListElement": [

       {
  "@type": "ListItem",
  "position": 1,
  "item": {
    "@type": "NewsArticle",
    "headline": "Donald Trump orders probe into meat-packers",
    "description":"Federal probe targets major meat-packers over pricing concerns.",
    "articleSection": "Investigation",
    "dateCreated": "2024-11-06",
    "articleBody": "Federal officials launched a probe into major meat-packers after concerns that pricing practices and market consolidation may have raised costs for consumers and livestock producers.",

    "keywords": [
      "Donald Trump",
      "Meat Packers",
      "Federal Probe",
      "Agriculture Industry",
      "Food Supply Chain",
      "Pricing Investigation"
    ],
    "url": "https://prprimespot.com/investigation/donald-trump-orders-probe-into-meat-packers.php",
    "image": {
      "@type": "ImageObject",
      "url": "https://prprimespot.com/uploads/donald-trump-orders-probe-into-meat-packers.webp",
      "width": 1200,
      "height": 630
    },
    "isPartOf": {
  "@id": "https://prprimespot.com/author/morgan-blake/#webpage"
   },

    "author": { "@id": "https://prprimespot.com/author/morgan-blake/#person" },
    "datePublished": "2024-11-06",
    "dateModified": "2024-11-06",
    "publisher": {
      "@type": "Organization",
      "name": "PR Primespot",
      "url": "https://prprimespot.com",

      "logo": {
        "@type": "ImageObject",
        "url": "https://prprimespot.com/assets/img/fav-icon.webp",
        "width": 200,
        "height": 200
      }
    },
    "mainEntityOfPage": {
      "@type": "WebPage",
      "@id": "https://prprimespot.com/investigation/donald-trump-orders-probe-into-meat-packers.php"
    }
  }
},


       {
  "@type": "ListItem",
  "position": 2,
  "item": {
    "@type": "NewsArticle",
    "headline": "Meta Platforms under SEC investigation for scam-ad revenues",
    "description":"SEC probes Meta over revenue from scam ads on its platforms.",
    "articleSection": "Investigation",
    "dateCreated": "2024-11-03",
    "articleBody":"The SEC is investigating Meta over revenue tied to scam ads on Facebook and Instagram and whether the company properly disclosed risks related to fraudulent advertising.",
    "keywords": [
      "Meta Platforms",
      "SEC Investigation",
      "Scam Ads",
      "Facebook Scam Ads",
      "Instagram Fraud",
      "Tech Regulation"
    ],
    "url": "https://prprimespot.com/investigation/meta-platforms-under-sec-investigation.php",
    "image": {
      "@type": "ImageObject",
      "url": "https://prprimespot.com/uploads/meta-platforms-under-sec-investigation-for-scam-ad-revenues.webp",
      "width": 1200,
      "height": 630
    },
    "isPartOf": {
  "@id": "https://prprimespot.com/author/morgan-blake/#webpage"
      },

    "author": { "@id": "https://prprimespot.com/author/morgan-blake/#person" },
    "datePublished": "2024-11-03",
    "dateModified": "2024-11-03",
    "publisher": {
      "@type": "Organization",
      "name": "PR Primespot",
      "url": "https://prprimespot.com",

      "logo": {
        "@type": "ImageObject",
        "url": "https://prprimespot.com/assets/img/fav-icon.webp",
        "width": 200,
        "height": 200
      }
    },
    "mainEntityOfPage": {
      "@type": "WebPage",
      "@id": "https://prprimespot.com/investigation/meta-platforms-under-sec-investigation.php"
    }
  }
},


       {
  "@type": "ListItem",
  "position": 3,
  "item": {
    "@type": "NewsArticle",
    "headline": "U.S arrests in international online-fraud investigation",
    "description":"Federal agents arrest suspects tied to a major international fraud ring.",
    "articleSection": "Investigation",
    "dateCreated": "2024-11-05",
    "articleBody":"Federal agents arrested several suspects accused of running a global online-fraud network responsible for large-scale phishing, identity theft, and financial scams targeting U.S. consumers.",
    "keywords": [
      "Online Fraud",
      "International Fraud Ring",
      "Federal Arrests",
      "Cybercrime",
      "Identity Theft",
      "U.S. Investigation"
    ],
    "url": "https://prprimespot.com/investigation/us-arrests-in-international-online-fraud-investigation.php",
    "image": {
      "@type": "ImageObject",
      "url": "https://prprimespot.com/uploads/us-arrests-in-international-online-fraud-investigation.webp",
      "width": 1200,
      "height": 630
    },
    "isPartOf": {
  "@id": "https://prprimespot.com/author/morgan-blake/#webpage"
    },

    "author": { "@id": "https://prprimespot.com/author/morgan-blake/#person" },
    "datePublished": "2024-11-05",
    "dateModified": "2024-11-05",
    "publisher": {
      "@type": "Organization",
      "name": "PR Primespot",
      "url": "https://prprimespot.com",

      "logo": {
        "@type": "ImageObject",
        "url": "https://prprimespot.com/assets/img/fav-icon.webp",
        "width": 200,
        "height": 200
      }
    },
    "mainEntityOfPage": {
      "@type": "WebPage",
      "@id": "https://prprimespot.com/investigation/us-arrests-in-international-online-fraud-investigation.php"
    }
  }
},


       {
  "@type": "ListItem",
  "position": 4,
  "item": {
    "@type": "NewsArticle",
    "headline": "Federal Bureau of Investigation subpoenas ex-CIA & ex-FBI officials in probe of Trump-Russia case",
    "description":"FBI subpoenas former intelligence officials in Trump-Russia review.",
    "articleSection": "Investigation",
    "dateCreated": "2024-11-03",
    "articleBody":"The FBI issued subpoenas to former intelligence officials as part of a review into how agencies handled early evidence and assessments in the Trump-Russia investigation.",
    "keywords": [
      "FBI Subpoenas",
      "CIA Officials",
      "Trump Russia Probe",
      "Federal Investigation",
      "Intelligence Review",
      "Government Oversight"
    ],
    "url": "https://prprimespot.com/investigation/federal-bureau-of-investigation.php",
    "image": {
      "@type": "ImageObject",
      "url": "https://prprimespot.com/uploads/federal-bureau-of-investigation-subpoenas-ex-cia-and-ex-fbi.webp",
      "width": 1200,
      "height": 630
    },
    "isPartOf": {
  "@id": "https://prprimespot.com/author/morgan-blake/#webpage"
   },

    "author": { "@id": "https://prprimespot.com/author/morgan-blake/#person" },
    "datePublished": "2024-11-03",
    "dateModified": "2024-11-03",
    "publisher": {
      "@type": "Organization",
      "name": "PR Primespot",
      "url": "https://prprimespot.com",

      "logo": {
        "@type": "ImageObject",
        "url": "https://prprimespot.com/assets/img/fav-icon.webp",
        "width": 200,
        "height": 200
      }
    },
    "mainEntityOfPage": {
      "@type": "WebPage",
      "@id": "https://prprimespot.com/investigation/federal-bureau-of-investigation.php"
    }
  }
}


      ]
    }

  ]
}
</script>















</head>

<body>
    <!-- top-section -->
    <div class="top-section">
        <div class="top-grid-section">
            <p class="top-text b"><a href="#"><img src="../images/telegram.webp" class="top-icon" alt="icon" height="15"
                        width="15">Sign Up for
                    Our
                    Newsletter</a></p>
            <p class="top-text"><span>New York 65 F</span><img src="../images/cloud.webp" class="top-icon"
                        height="15" width="15" alt="icon">overcast clouds</p>
        </div>
    </div>





    <!-- navbar -->
    <?php include '../header.php'; ?>






    <!-- Search Popup Overlay -->
    <div class="search-overlay">
        <button class="close-search">&times;</button>
        <div class="search-popup-box">
            <input type="text" class="search-input" placeholder="Search...">
        </div>
    </div>


    <!-- flash-news section -->
    <div class="news-scroll">
        <div class="news-scroll-container">
            <div class="news-scroll-container-left">
                <p class="flash-news"><img src="../images/bolt.webp" class="flash" alt="icon" height="15" width="15">
                    Newsflash:</p>
                <div class="news-box">
                    <div class="news-box-inner">
                        <p class="news"><a href="#">Julio Rodríguez Can Fly. Will His Bat Ground Him? <span>10:11
                                    am</span></a></p>
                        <p class="news"><a href="#">Julio Rodríguez Can Fly. Will His Bat Ground Him? <span>10:11
                                    am</span></a></p>
                        <p class="news"><a href="#">Tropical Storm Forecasts Show Possible Landfall <span>10:13
                                    am</span></a></p>
                        <p class="news"><a href="#">SpaceX Prepares for next-icon Starship Launch <span>10:14
                                    am</span></a>
                        </p>
                        <p class="news"><a href="#">Julio Rodríguez Can Fly. Will His Bat Ground Him? <span>10:11
                                    am</span></a></p>
                        <p class="news"><a href="#">Tropical Storm Forecasts Show Possible Landfall <span>10:13
                                    am</span></a></p>
                        <p class="news"><a href="#">SpaceX Prepares for next-icon Starship Launch <span>10:14
                                    am</span></a>
                        </p>
                        <p class="news"><a href="#">Julio Rodríguez Can Fly. Will His Bat Ground Him? <span>10:11
                                    am</span></a></p>
                        <p class="news"><a href="#">Julio Rodríguez Can Fly. Will His Bat Ground Him? <span>10:11
                                    am</span></a></p>
                        <p class="news"><a href="#">Tropical Storm Forecasts Show Possible Landfall <span>10:13
                                    am</span></a></p>
                        <p class="news"><a href="#">SpaceX Prepares for next-icon Starship Launch <span>10:14
                                    am</span></a>
                        </p>
                        <p class="news"><a href="#">Julio Rodríguez Can Fly. Will His Bat Ground Him? <span>10:11
                                    am</span></a></p>
                        <p class="news"><a href="#">Tropical Storm Forecasts Show Possible Landfall <span>10:13
                                    am</span></a></p>
                        <p class="news"><a href="#">SpaceX Prepares for next-icon Starship Launch <span>10:14
                                    am</span></a>
                        </p>
                    </div>
                </div>
            </div>
            <div class="news-scroll-container-right">
                <div class="arrow prev" role="button">
                    <svg class="arrow-icon rotate-left" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                        fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                        stroke-linejoin="round">
                        <polyline points="9 18 15 12 9 6"></polyline>
                    </svg>
                </div>
                <div class="arrow next" role="button">
                    <svg class="arrow-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                        stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <polyline points="9 18 15 12 9 6"></polyline>
                    </svg>
                </div>

            </div>
        </div>
    </div>


    <!-- Scroll to top button -->
    <div class="scroll-to-top">
        <a href="#" class="top-arrow">
            <img src="./images/top.webp" alt="icon" width="20" height="20">
        </a>
    </div>


    <!-- Slide-in Sidebar -->
    <div class="sidebar-overlay">
        <div class="sidebar-content">
            <span class="close-btn">&times;</span>
            <ul class="sidebar-menu">
                <li><a href="./index.html">Home</a></li>
                <li class="has-submenu">
                    <a href="#" class="submenu-toggle">Categories <span class="arrow-d">&#9662;</span></a>
                    <ul class="submenu">
                        <li><a href="#">Technology</a></li>
                        <li><a href="#">Health</a></li>
                        <li><a href="#">Lifestyle</a></li>
                    </ul>
                </li>

                <li><a href="./cateagory.html">Business</a></li>
                <li><a href="#">Breaking News</a></li>
                <li><a href="#">Opinion</a></li>
                <li><a href="#">Podcast</a></li>
                <li><a href="#">Video</a></li>
                <li><a href="#">For Subscribers</a></li>
                <li class="sidebar-more"><a href="#">More</a></li>
                <!-- ✅ Demos with dropdown -->
                <li class="has-submenu second-slide-option">
                    <a href="#" class="submenu-toggle">Demos <span class="arrow-d">&#9662;</span></a>
                    <ul class="submenu">
                        <li><a href="#">Home Main</a></li>
                        <li><a href="#">Home Politics</a></li>
                        <li><a href="#">Home Bussiness</a></li>
                        <li><a href="#">Home Culture</a></li>
                        <li><a href="#">Home Sports</a></li>
                        <li><a href="#">Home Tech-Sceince</a></li>
                        <li><a href="#">Home Military</a></li>
                    </ul>
                </li>

                <!-- ✅ Blog Page with dropdown -->
                <li class="has-submenu second-slide-option">
                    <a href="#" class="submenu-toggle">Blog Page <span class="arrow-d">&#9662;</span></a>
                    <ul class="submenu">
                        <li><a href="#">Blog Page 1</a></li>
                        <li><a href="#">Blog Page 2</a></li>
                        <li><a href="#">Blog Page 3</a></li>
                    </ul>
                </li>
                <li class="second-slide-option"><a href="#">Subscribe</a></li>
                <li class="second-slide-option"><a href="#">Shop</a></li>


                <li class="sidebar-more">social media</li>
                <li>
                    <div class="side-social-media">
                        <img src="./images/twitter-icon.webp" class="side-bar-social-media-icon" alt="icon" width="20"
                            height="20">
                        <img src="./images/facebook-icon.webp" class="side-bar-social-media-icon" alt="icon" width="20"
                            height="20">
                        <img src="./images/instagram-icon.webp" class="side-bar-social-media-icon" alt="icon" width="20"
                            height="20">
                    </div>
                </li>


            </ul>
        </div>
    </div>

    <!-- cateagory-body -->
    <div class="cateagory-body">
        <div class="cateagory-top">
            <h1 class="main-head">Author: Morgan Blake</h1>
            <!-- <p class="path">Home <span>> Business</span></p> -->
        </div>
        <hr class="custom-line b">

        <div class="cateagory-body-section">
            <div class="cateagory-body-section-l">
                <div class="author-box">
                    <div class="author-image">
                        <img src="../uploads/morgan-blake.webp" alt="Morgan Blake" loading="lazy">
                    </div>

                    <div class="author-details">
                        <h2>Morgan Blake</h2>
                        <p>
                            Morgan Blake is an investigative journalist in the U.S. who focuses on holding the government
                             and businesses accountable and reporting on issues that affect the public. He works to bring
                              to light hidden risks, waste of taxpayer money, and abuse of power by both federal and state 
                              agencies. His investigations show how corporate misconduct and government lack of openness
                               affect people in the real world.
                        </p>
                        <div class="author-social">
                            <a href="https://www.facebook.com/Morganblake"><i class="fa-brands fa-facebook-f"></i></a>
                            <a href="https://www.pinterest.com/Morganblake"><i class="fa-brands fa-pinterest-p"></i></a>
                            <a href="https://www.instagram.com/Morganblake"><i class="fa-brands fa-instagram"></i></a>
                        </div>

                    </div>
                </div>
                <hr class="custom-line b">
                <div class="third-grid-section b">
                    <div class="third-grid-section-img">
                        <a href="#"><img src="../uploads/donald-trump-orders-probe-into-meat-packers.webp" class="main-img b" alt="Donald Trump orders probe into meat-packers investigation" loading="lazy"

                                width="457" height="293"></a>
                    </div>
                    <div class="third-grid-section-content">
                        <p class="main-head b"><a href="../investigation/donald-trump-orders-probe-into-meat-packers.php">Donald Trump orders probe into meat-packers</a></p>
                        <p class="paragraph-cateagory">Donald Trump orders a federal probe into major meat-packers over 
                    pricing and competition concerns, raising scrutiny across agriculture, retail, and food supply
                     chains.</p>
                        <div class="img-option b">
                            <p class="time"><img src="../images/clock.webp" class="clock" alt="icon" width="15"
                                    height="15">Nov 6</p>
                            <p class="by"><span>by</span> Morgan Blake</p>
                        </div>
                    </div>
                </div>
                <hr class="custom-line b">
                <div class="third-grid-section b">
                    <div class="third-grid-section-img">
                        <a href="#"><img src="../uploads/meta-platforms-under-sec-investigation-for-scam-ad-revenues.webp" class="main-img b" alt="Meta Platforms under SEC investigation for scam-ad revenues" loading="lazy"
                                width="457" height="293"></a>
                    </div>
                    <div class="third-grid-section-content">
                        <p class="main-head b"><a href="../investigation/meta-platforms-under-sec-investigation.php">Meta Platforms under SEC investigation for scam-ad revenues</a></p>
                        <p class="paragraph-cateagory">The SEC is looking into Meta Platforms because they think they made 
                    money from fake ads on Facebook and Instagram. Regulators are looking at whether Meta did a good job 
                    of telling people about the hazards of fake ads and harm to users</p>
                        <div class="img-option b">
                            <p class="time"><img src="../images/clock.webp" class="clock" alt="icon" width="15"
                                    height="15">Nov 3</p>
                            <p class="by"><span>by</span> Morgan Blake</p>
                        </div>
                    </div>
                </div>
                <hr class="custom-line b">
                <div class="third-grid-section b">
                    <div class="third-grid-section-img">
                        <a href="#"><img src="../uploads/us-arrests-in-international-online-fraud-investigation.webp" class="main-img b" alt="U.S arrests in international online fraud investigation" loading="lazy"
                                width="457" height="293"></a>
                    </div>
                    <div class="third-grid-section-content">
                        <p class="main-head b"><a href="../investigation/us-arrests-in-international-online-fraud-investigation.php">U.S arrests in international online-fraud investigation</a></p>
                        <p class="paragraph-cateagory">U.S. authorities have made multiple arrests in a large-scale international
                     online-fraud investigation involving millions in losses. Federal agents say the suspects operated global
                      schemes targeting American consumers with phishing campaigns, fake investment offers, and identity-theft
                       networks.</p>
                        <div class="img-option b">
                            <p class="time"><img src="../images/clock.webp" class="clock" alt="icon" width="15"
                                    height="15">Nov 5</p>
                            <p class="by"><span>by</span> Morgan Blake</p>
                        </div>
                    </div>
                </div>
                <hr class="custom-line b">
                <div class="third-grid-section b">
                    <div class="third-grid-section-img">
                        <a href="#"><img src="../uploads/federal-bureau-of-investigation-subpoenas-ex-cia-and-ex-fbi.webp" class="main-img b" alt="Federal bureau of investigation subpoenas ex-CIA & ex-FBI officials in probe of Trump-Russia case" loading="lazy"
                                width="457" height="293"></a>
                    </div>
                    <div class="third-grid-section-content">
                        <p class="main-head b"><a href="../investigation/federal-bureau-of-investigation.php">Federal Bureau of Investigation subpoenas ex-CIA & ex-FBI officials in probe of Trump-Russia case.</a></p>
                        <p class="paragraph-cateagory">The FBI has issued subpoenas to former CIA and FBI officials as part of a 
                    renewed inquiry into the origins of the Trump-Russia investigation.Federal authorities are reviewing 
                    prior intelligence assessments and decision-making tied to early Russia-interference findings.</p>
                        <div class="img-option b">
                            <p class="time"><img src="../images/clock.webp" class="clock" alt="icon" width="15"
                                    height="15">Nov 3</p>
                            <p class="by"><span>by</span> Morgan Blake</p>
                        </div>
                    </div>
                </div>
                  

                 


            </div>
            <div class="vertical-line"></div>
            <div class="cateagory-body-section-s">
                <div class="newsletter-box">
                    <img src="../images/letter.svg" class="newsletter-icon" alt="news-img" width="46" height="50">
                    <h3 class="newsletter-title">The Reporter<br>Newsletter</h3>
                    <p class="newsletter-subtext">Expert picks and exclusive deals,<br>in your inbox.</p>

                    <input type="email" placeholder="Enter your email*" class="newsletter-input">
                    <button class="newsletter-button">Sign Up</button>
                </div>
            </div>
        </div>
    </div>


        <!--     footer -->
    <?php include '../footer.php'; ?>




    <script src="./script.js" Defer></script>

</body>

</html>